# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .tipos_geral_mdfe_v3_00 import TCODUFIBGE_EX

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Descrição do Evento - “Encerramento”"
EVENCMDFE_DESCEVENTO = [
    ("Encerramento", "Encerramento"),
]


class EvEncMdfe(models.AbstractModel):
    """Schema XML de validação do evento do encerramento
    110112"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.evencmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "EvEncMdfe"

    mdfe30_descEvento = fields.Selection(
        EVENCMDFE_DESCEVENTO,
        string="Descrição do Evento - “Encerramento”",
        xsd_required=True,
    )

    mdfe30_nProt = fields.Char(
        string="Número do Protocolo de Status do MDF-e",
        xsd_required=True,
        xsd_type="TProt",
        help=(
            "Número do Protocolo de Status do MDF-e. \n1 posição tipo de "
            "autorizador (9 - SEFAZ Nacional ); \n2 posições ano;\n10 "
            "seqüencial no ano."
        ),
    )

    mdfe30_dtEnc = fields.Date(
        string="Data que o Manifesto foi encerrado", xsd_required=True, xsd_type="TData"
    )

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE_EX,
        string="UF de encerramento do Manifesto",
        xsd_required=True,
        xsd_type="TCodUfIBGE_EX",
    )

    mdfe30_cMun = fields.Char(
        string="Código do Município de Encerramento",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help="Código do Município de Encerramento do manifesto",
    )
