# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

PROCEVENTOMDFE_VERSAO = [
    ("1.00", "1.00"),
    ("3.00", "3.00"),
]

PROTMDFE_VERSAO = [
    ("1.00", "1.00"),
    ("3.00", "3.00"),
]


class TconsSitMdfe(models.AbstractModel):
    "Tipo Pedido de Consulta da Situação Atual do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tconssitmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TconsSitMdfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    mdfe30_chMDFe = fields.Char(
        string="Chaves de acesso do MDF-e",
        xsd_required=True,
        xsd_type="TChNFe",
        help=(
            "Chaves de acesso do MDF-e, compostas por: UF do emitente, AAMM da"
            " emissão do MDF-e, CNPJ do emitente, modelo, série, tipo de "
            "emissão e número do MDF-e e código numérico + DV."
        ),
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True)


class TretConsSitMdfe(models.AbstractModel):
    "Tipo Retorno de Pedido de Consulta da Situação Atual do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretconssitmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsSitMdfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o MDF-e",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_protMDFe = fields.Many2one(
        comodel_name="mdfe.30.protmdfe", string="protMDFe"
    )

    mdfe30_procEventoMDFe = fields.One2many(
        "mdfe.30.tretconssitmdfe_proceventomdfe",
        "mdfe30_procEventoMDFe_TRetConsSitMDFe_id",
        string="procEventoMDFe",
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True)


class ProtMdfe(models.AbstractModel):
    _description = "protMDFe"
    _name = "mdfe.30.protmdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsSitMdfe.ProtMdfe"

    mdfe30_versao = fields.Selection(
        PROTMDFE_VERSAO, string="versao", xsd_required=True
    )


class TretConsSitMdfeProcEventoMdfe(models.AbstractModel):
    _description = "procEventoMDFe"
    _name = "mdfe.30.tretconssitmdfe_proceventomdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsSitMdfe.ProcEventoMdfe"

    mdfe30_procEventoMDFe_TRetConsSitMDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tretconssitmdfe", xsd_implicit=True, ondelete="cascade"
    )

    mdfe30_versao = fields.Selection(
        PROCEVENTOMDFE_VERSAO,
        string="versao",
        xsd_required=True,
        xsd_type="TVerMDFeConsultaDFe",
    )
