# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .cte_tipos_basico_v4_00 import (
    Tcte,
    TprotCte,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"


class CteProc(models.AbstractModel):
    "CT-e processado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.cteproc"
    _inherit = "spec.mixin.cte"
    _binding_type = "CteProc"

    cte40_CTe = fields.Many2one(
        comodel_name="cte.40.tcte", string="CTe", xsd_required=True, xsd_type="TCTe"
    )

    cte40_protCTe = fields.Many2one(
        comodel_name="cte.40.tprotcte",
        string="protCTe",
        xsd_required=True,
        xsd_type="TProtCTe",
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerCTe")

    cte40_ipTransmissor = fields.Char(
        string="IP do transmissor",
        xsd_type="TIPv4",
        help=("IP do transmissor do documento fiscal para o ambiente autorizador"),
    )

    cte40_nPortaCon = fields.Char(
        string="Porta de origem utilizada na conexão",
        help="Porta de origem utilizada na conexão (De 0 a 65535)",
    )

    cte40_dhConexao = fields.Datetime(
        string="Data e Hora da Conexão de Origem", xsd_type="TDateTimeUTC"
    )
