# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_cte_v4_00 import (
    TAMB,
    TCODUFIBGE,
    TMODCT_CARGA_OS,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"


class TinutCte(models.AbstractModel):
    """Tipo Pedido de Inutilização de Numeração do Conhecimento de Transporte
    eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tinutcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TinutCte"

    cte40_infInut = fields.Many2one(
        comodel_name="cte.40.tinutcte_infinut",
        string="Dados do Pedido de Inutilização",
        xsd_required=True,
        help=(
            "Dados do Pedido de Inutilização de Numeração do Conhecimento de "
            "Transporte eletrônico"
        ),
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TinutCteInfInut(models.AbstractModel):
    """Dados do Pedido de Inutilização de Numeração do Conhecimento de
    Transporte eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tinutcte_infinut"
    _inherit = "spec.mixin.cte"
    _binding_type = "TinutCte.InfInut"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF solicitada",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_ano = fields.Char(
        string="Ano de inutilização da numeração", xsd_required=True
    )

    cte40_CNPJ = fields.Char(
        string="CNPJ do emitente", xsd_required=True, xsd_type="TCnpj"
    )

    cte40_mod = fields.Selection(
        TMODCT_CARGA_OS,
        string="Modelo da CT-e (57 ou 67)",
        xsd_required=True,
        xsd_type="TModCT_Carga_OS",
    )

    cte40_serie = fields.Char(
        string="Série da CT-e", xsd_required=True, xsd_type="TSerie"
    )

    cte40_nCTIni = fields.Char(
        string="Número da CT-e inicial", xsd_required=True, xsd_type="TNF"
    )

    cte40_nCTFin = fields.Char(
        string="Número da CT-e final", xsd_required=True, xsd_type="TNF"
    )

    cte40_xJust = fields.Char(
        string="Justificativa do pedido de inutilização",
        xsd_required=True,
        xsd_type="TJust",
    )

    cte40_Id = fields.Char(string="Id", xsd_required=True)


class TretInutCte(models.AbstractModel):
    """Tipo retorno do Pedido de Inutilização de Numeração do Conhecimento de
    Transporte eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretinutcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretInutCte"

    cte40_infInut = fields.Many2one(
        comodel_name="cte.40.tretinutcte_infinut",
        string="Dados do Retorno do Pedido",
        xsd_required=True,
        help=(
            "Dados do Retorno do Pedido de Inutilização de Numeração do "
            "Conhecimento de Transporte eletrônico"
        ),
    )

    cte40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerInutCTe"
    )


class TretInutCteInfInut(models.AbstractModel):
    """Dados do Pedido de Inutilização de Numeração do Conhecimento de
    Transporte eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretinutcte_infinut"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretInutCte.InfInut"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a CT-e",
    )

    cte40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        help="Descrição literal do status do serviço solicitado.",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF solicitada",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_ano = fields.Char(string="Ano de inutilização da numeração")

    cte40_CNPJ = fields.Char(string="CNPJ do emitente", xsd_type="TCnpj")

    cte40_mod = fields.Selection(
        TMODCT_CARGA_OS, string="Modelo da CT-e (57 ou 67)", xsd_type="TModCT_Carga_OS"
    )

    cte40_serie = fields.Char(string="Série da CT-e", xsd_type="TSerie")

    cte40_nCTIni = fields.Char(string="Número da CT-e inicial", xsd_type="TNF")

    cte40_nCTFin = fields.Char(string="Número da CT-e final", xsd_type="TNF")

    cte40_dhRecbto = fields.Datetime(
        string="Data e hora de recebimento",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora de recebimento, no formato AAAA-MM-DDTHH:MM:SS TZD. "
            "Deve ser preenchida com data e hora da gravação no Banco em caso "
            "de Confirmação. Em caso de Rejeição, com data e hora do "
            "recebimento do Pedido de Inutilização."
        ),
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de Status do CT-e",
        xsd_type="TProt",
        help=(
            "Número do Protocolo de Status do CT-e. 1 posição (1 – Secretaria "
            "de Fazenda Estadual , 3 - SEFAZ Virtual RS, 5 - SEFAZ Virtual "
            "SP); 2 - código da UF - 2 posições ano; 10 seqüencial no ano."
        ),
    )

    cte40_Id = fields.Char(string="Id")


class TprocInutCte(models.AbstractModel):
    "Tipo Pedido de inutilzação de númeração de CT-e processado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprocinutcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprocInutCte"

    cte40_inutCTe = fields.Many2one(
        comodel_name="cte.40.tinutcte",
        string="inutCTe",
        xsd_required=True,
        xsd_type="TInutCTe",
    )

    cte40_retInutCTe = fields.Many2one(
        comodel_name="cte.40.tretinutcte",
        string="retInutCTe",
        xsd_required=True,
        xsd_type="TRetInutCTe",
    )

    cte40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerInutCTe"
    )

    cte40_ipTransmissor = fields.Char(
        string="IP do transmissor",
        xsd_type="TIPv4",
        help=("IP do transmissor do documento fiscal para o ambiente autorizador"),
    )

    cte40_nPortaCon = fields.Char(
        string="Porta de origem utilizada na conexão",
        help="Porta de origem utilizada na conexão (De 0 a 65535)",
    )

    cte40_dhConexao = fields.Datetime(
        string="Data e Hora da Conexão de Origem", xsd_type="TDateTimeUTC"
    )
