# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .cte_tipos_basico_v4_00 import TOMA4_TOMA

from .evento_cte_tipos_basico_v4_00 import TMODTRANSP

from .tipos_geral_cte_v4_00 import TUF

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Descrição do Evento - “EPEC”"
EVEPECCTE_DESCEVENTO = [
    ("EPEC", "EPEC"),
]

"Tipo do CT-e"
EVEPECCTE_TPCTE = [
    ("0", "CT-e Normal"),
]


class EvEpeccte(models.AbstractModel):
    """Schema XML de validação do evento de emissão prévia de emissão em
    contingência
    110113"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evepeccte"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvEpeccte"

    cte40_descEvento = fields.Selection(
        EVEPECCTE_DESCEVENTO, string="Descrição do Evento - “EPEC”", xsd_required=True
    )

    cte40_xJust = fields.Char(
        string="Justificativa da Entrada em Contingencia",
        xsd_required=True,
        xsd_type="TJust",
    )

    cte40_vICMS = fields.Monetary(
        string="Valor do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vICMSST = fields.Monetary(
        string="Valor do ICMS ST",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vTPrest = fields.Monetary(
        string="Valor Total da Prestação do Serviço",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total da Prestação do Serviço\nPode conter zeros quando o "
            "CT-e for de complemento de ICMS"
        ),
    )

    cte40_vCarga = fields.Monetary(
        string="Valor total da carga",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total da carga\nDever ser informado para todos os modais, "
            "com exceção para o Dutoviário."
        ),
    )

    cte40_toma4 = fields.Many2one(
        comodel_name="cte.40.evepeccte_toma4",
        string="Indicador do 'papel' do tomador",
        xsd_required=True,
        help="Indicador do 'papel' do tomador do serviço no CT-e",
    )

    cte40_modal = fields.Selection(
        TMODTRANSP,
        string="Modal",
        xsd_required=True,
        xsd_type="TModTransp",
        help=(
            "Modal\nPreencher com:\n\n01-Rodoviário;\n\n02-Aéreo;\n03-"
            "Aquaviário;\n\n04-Ferroviário;\n\n05-Dutoviário;\n06-Multimodal;"
        ),
    )

    cte40_UFIni = fields.Selection(
        TUF,
        string="UF do início da prestação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "UF do início da prestação\nInformar 'EX' para operações com o " "exterior."
        ),
    )

    cte40_UFFim = fields.Selection(
        TUF,
        string="UF do término da prestação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "UF do término da prestação\nInformar 'EX' para operações com o "
            "exterior."
        ),
    )

    cte40_tpCTe = fields.Selection(
        EVEPECCTE_TPCTE,
        string="Tipo do CT-e",
        xsd_required=True,
        help=(
            "Tipo do CT-e - Aceitar apenas Tipo Normal = 0\nPreencher "
            "com:\n\t0 - CT-e Normal;\n 1 - CT-e de Complemento de Valores;\t2"
            " - CT-e de Anulação;\n 3 - CT-e Substituto"
        ),
    )

    cte40_dhEmi = fields.Char(
        string="Data e hora de emissão do CT-e",
        xsd_required=True,
        help=("Data e hora de emissão do CT-e\nFormato AAAA-MM-DDTHH:MM:DD TZD"),
    )


class EvEpeccteToma4(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no CT-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evepeccte_toma4"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvEpeccte.Toma4"

    cte40_toma = fields.Selection(
        TOMA4_TOMA,
        string="Tomador do Serviço",
        xsd_required=True,
        help=(
            "Tomador do Serviço\nPreencher com: "
            "\n0-Remetente;\n1-Expedidor;2-Recebedor;3-Destinatário\n;4 - "
            "Outros"
        ),
    )

    cte40_UF = fields.Selection(
        TUF,
        string="UF do tomador do serviço",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "UF do tomador do serviço\nInformar 'EX' para operações com o " "exterior."
        ),
    )

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="toma4",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="toma4",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        xsd_type="TIeDest",
        help=(
            "Inscrição Estadual\nInformar a IE do tomador ou ISENTO se tomador"
            " é contribuinte do ICMS isento de inscrição no cadastro de "
            "contribuintes do ICMS. Caso o tomador não seja contribuinte do "
            "ICMS não informar o conteúdo."
        ),
    )
