# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Descrição do Evento - “Comprovante de Entrega do CT-e”"
EVCECTE_DESCEVENTO = [
    ("Comprovante de Entrega do CT-e", "Comprovante de Entrega do CT-e"),
]


class EvCecte(models.AbstractModel):
    """Schema XML de validação do evento comprovante de entrega eletrônico do
    CT-e
    110180"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evcecte"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvCecte"

    cte40_descEvento = fields.Selection(
        EVCECTE_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Comprovante de Entrega do CT-e”",
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de autorização",
        xsd_required=True,
        xsd_type="TProt",
        help="Número do Protocolo de autorização do CT-e",
    )

    cte40_dhEntrega = fields.Char(
        string="Data e hora de conclusão da entrega",
        xsd_required=True,
        help=(
            "Data e hora de conclusão da entrega da NF-e\nFormato AAAA-MM-"
            "DDTHH:MM:DD TZD"
        ),
    )

    cte40_nDoc = fields.Char(
        string="Número do Documento de identificação",
        xsd_required=True,
        help=(
            "Número do Documento de identificação da pessoa que recebeu a " "entrega"
        ),
    )

    cte40_xNome = fields.Char(
        string="Nome da pessoa que recebeu a entrega", xsd_required=True
    )

    cte40_latitude = fields.Char(
        string="Latitude do ponto de entrega", xsd_type="TLatitude"
    )

    cte40_longitude = fields.Char(
        string="Longitude do ponto de entrega", xsd_type="TLongitude"
    )

    cte40_hashEntrega = fields.Char(
        string="Hash",
        xsd_required=True,
        help=(
            "Hash (SHA1) no formato Base64 resultante da concatenação: Chave "
            "de acesso do CT-e + Base64 da imagem capturada da entrega "
            "(Exemplo: imagem capturada da assinatura eletrônica, digital do "
            "recebedor, foto, etc)\nO hashCSRT é o resultado das funções SHA-1"
            " e base64 do token CSRT fornecido pelo fisco + chave de acesso do"
            " DF-e. (Implementação em futura NT)\nObservação: 28 caracteres "
            "são representados no schema como 20 bytes do tipo base64Binary"
        ),
    )

    cte40_dhHashEntrega = fields.Char(
        string="Data e hora de geração do hash entrega",
        xsd_required=True,
        help=(
            "Data e hora de geração do hash entrega\nFormato AAAA-MM-" "DDTHH:MM:DD TZD"
        ),
    )

    cte40_infEntrega = fields.One2many(
        "cte.40.evcecte_infentrega",
        "cte40_infEntrega_evCECTe_id",
        string="Grupo de informações das NF-e",
        help=(
            "Grupo de informações das NF-e que foram entregues ao "
            "Destinatário\nInformar o grupo apenas para CT-e com tipo de "
            "serviço Normal"
        ),
    )


class EvCecteInfEntrega(models.AbstractModel):
    """Grupo de informações das NF-e que foram entregues ao Destinatário
    Informar o grupo apenas para CT-e com tipo de serviço Normal"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evcecte_infentrega"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvCecte.InfEntrega"

    cte40_infEntrega_evCECTe_id = fields.Many2one(
        comodel_name="cte.40.evcecte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chNFe = fields.Char(
        string="Chave de acesso da NF-e entregue", xsd_required=True, xsd_type="TChDFe"
    )
