# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Descrição do Evento - “Carta de Correção”"
EVCCECTE_DESCEVENTO = [
    ("Carta de Correção", "Carta de Correção"),
    ("Carta de Correcao", "Carta de Correcao"),
]

"""Condições de uso da Carta de Correção,
    informar a literal :Condições de uso da Carta de Correção, informar a literal:
    “A Carta de Correção é disciplinada pelo Art. 58-B do CONVÊNIO/SINIEF 06/89:
    Fica permitida a utilização de carta de correção, para regularização de
    erro ocorrido na emissão de documentos fiscais relativos à prestação de
    serviço de transporte, desde que o erro não esteja relacionado com: I - as
    variáveis que determinam o valor do imposto tais como: base de cálculo,
    alíquota, diferença de preço, quantidade, valor da prestação;II - a
    correção de dados cadastrais que implique mudança do emitente, tomador,
    remetente ou do destinatário;III - a data de emissão ou de saída.” (texto
    com acentuação) ou “A Carta de Correcao e disciplinada pelo Art. 58-B do
    CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de correcao,
    para regularizacao de erro ocorrido na emissao de documentos fiscais
    relativos a prestacao de servico de transporte, desde que o erro nao esteja
    relacionado com: I - as variaveis que determinam o valor do imposto tais
    como: base de calculo, aliquota, diferenca de preco, quantidade, valor da
    prestacao;II - a correcao de dados cadastrais que implique mudança do
    emitente, tomador, remetente ou do destinatario;III - a data de emissao ou
    de saida.” (texto sem acentuação)"""
EVCCECTE_XCONDUSO = [
    (
        "A Carta de Correção é disciplinada pelo Art. 58-B do CONVÊNIO/SINIEF 06/89: Fica permitida a utilização de carta de correção, para regularização de erro ocorrido na emissão de documentos fiscais relativos à prestação de serviço de transporte, desde que o erro não esteja relacionado com: I - as variáveis que determinam o valor do imposto tais como: base de cálculo, alíquota, diferença de preço, quantidade, valor da prestação;II - a correção de dados cadastrais que implique mudança do emitente, tomador, remetente ou do destinatário;III - a data de emissão ou de saída.",
        "A Carta de Correção é disciplinada pelo Art. 58-B do CONVÊNIO/SINIEF 06/89: Fica permitida a utilização de carta de correção, para regularização de erro ocorrido na emissão de documentos fiscais relativos à prestação de serviço de transporte, desde que o erro não esteja relacionado com: I - as variáveis que determinam o valor do imposto tais como: base de cálculo, alíquota, diferença de preço, quantidade, valor da prestação;II - a correção de dados cadastrais que implique mudança do emitente, tomador, remetente ou do destinatário;III - a data de emissão ou de saída.",
    ),
    (
        "A Carta de Correcao e disciplinada pelo Art. 58-B do CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de correcao, para regularizacao de erro ocorrido na emissao de documentos fiscais relativos a prestacao de servico de transporte, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da prestacao;II - a correcao de dados cadastrais que implique mudanca do emitente, tomador, remetente ou do destinatario;III - a data de emissao ou de saida.",
        "A Carta de Correcao e disciplinada pelo Art. 58-B do CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de correcao, para regularizacao de erro ocorrido na emissao de documentos fiscais relativos a prestacao de servico de transporte, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da prestacao;II - a correcao de dados cadastrais que implique mudanca do emitente, tomador, remetente ou do destinatario;III - a data de emissao ou de saida.",
    ),
]


class EvCceCte(models.AbstractModel):
    """Schema XML de validação do evento carta de correção
    110110"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.evccecte"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvCceCte"

    cte40_descEvento = fields.Selection(
        EVCCECTE_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Carta de Correção”",
    )

    cte40_infCorrecao = fields.One2many(
        "cte.40.infcorrecao",
        "cte40_infCorrecao_evCCeCTe_id",
        string="Grupo de Informações de Correção",
    )

    cte40_xCondUso = fields.Selection(
        EVCCECTE_XCONDUSO,
        string="Condições de uso da Carta de Correção",
        xsd_required=True,
        help=(
            "Condições de uso da Carta de Correção,\ninformar a literal "
            ":Condições de uso da Carta de Correção, informar a literal:\n“A "
            "Carta de Correção é disciplinada pelo Art. 58-B do "
            "CONVÊNIO/SINIEF 06/89: Fica permitida a utilização de carta de "
            "correção, para regularização de erro ocorrido na emissão de "
            "documentos fiscais relativos à prestação de serviço de "
            "transporte, desde que o erro não esteja relacionado com: I - as "
            "variáveis que determinam o valor do imposto tais como: base de "
            "cálculo, alíquota, diferença de preço, quantidade, valor da "
            "prestação;II - a correção de dados cadastrais que implique "
            "mudança do emitente, tomador, remetente ou do destinatário;III - "
            "a data de emissão ou de saída.” (texto com acentuação)  ou “A "
            "Carta de Correcao e disciplinada pelo Art. 58-B do "
            "CONVENIO/SINIEF 06/89: Fica permitida a utilizacao de carta de "
            "correcao, para regularizacao de erro ocorrido na emissao de "
            "documentos fiscais relativos a prestacao de servico de "
            "transporte, desde que o erro nao esteja relacionado com: I - as "
            "variaveis que determinam o valor do imposto tais como: base de "
            "calculo, aliquota, diferenca de preco, quantidade, valor da "
            "prestacao;II - a correcao de dados cadastrais que implique "
            "mudança do emitente, tomador, remetente ou do destinatario;III - "
            "a data de emissao ou de saida.” (texto sem acentuação)"
        ),
    )


class InfCorrecao(models.AbstractModel):
    "Grupo de Informações de Correção"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infcorrecao"
    _inherit = "spec.mixin.cte"
    _binding_type = "EvCceCte.InfCorrecao"

    cte40_infCorrecao_evCCeCTe_id = fields.Many2one(
        comodel_name="cte.40.evccecte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_grupoAlterado = fields.Char(
        string="Indicar o grupo de informações",
        xsd_required=True,
        help=(
            "Indicar o grupo de informações que pertence o campoAlterado. Ex: " "ide"
        ),
    )

    cte40_campoAlterado = fields.Char(
        string="Nome do campo modificado",
        xsd_required=True,
        help="Nome do campo modificado do CT-e Original.",
    )

    cte40_valorAlterado = fields.Char(
        string="Valor correspondente à alteração", xsd_required=True
    )

    cte40_nroItemAlterado = fields.Char(
        string="o indice do item alterado caso",
        help=(
            "o indice do item alterado caso a alteração ocorra em uma lista. "
            "\nOBS: O indice inicia sempre  em 1"
        ),
    )
