# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .evento_cte_tipos_basico_v4_00 import TMODTRANSP
from .tipos_geral_cte_v4_00 import (
    TAMB,
    TCODUFIBGE,
    TMODCT,
    TMODCTOS,
    TMODGTVE,
    TMODNF,
    TrsakeyValueType,
    TUF_SEM_EX,
    TUF,
    TTIPOUNIDCARGA,
    TTIPOUNIDTRANSP,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Tipo do Componente"
COMP_TPCOMP = [
    ("1", "Custodia"),
    ("2", "Embarque"),
    ("3", "Tempo de espera"),
    ("4", "Malote"),
    ("5", "Ad Valorem"),
    ("6", "Outros"),
]

"classificação Tributária do Serviço"
ICMS00_CST = [
    ("00", "tributação normal ICMS"),
]

"Classificação Tributária do serviço"
ICMS20_CST = [
    ("20", "tributação com BC reduzida do ICMS"),
]

"Classificação Tributária do Serviço"
ICMS45_CST = [
    ("40", "ICMS isenção"),
    ("41", "ICMS não tributada"),
    ("51", "ICMS diferido"),
]

"Classificação Tributária do Serviço"
ICMS60_CST = [
    ("60", "ICMS cobrado por substituição tributária"),
]

"Classificação Tributária do Serviço"
ICMS90_CST = [
    ("90", "ICMS outros"),
]

"Classificação Tributária do Serviço"
ICMSOUTRAUF_CST = [
    ("90", "ICMS Outra UF"),
]

"Classificação Tributária do Serviço"
ICMSSN_CST = [
    ("90", "ICMS Simples Nacional"),
]

"Indica se o contribuinte é Simples Nacional 1=Sim"
ICMSSN_INDSN = [
    ("1", "1"),
]

"Tipo Código Regime Tributário"
TCRT = [
    ("1", "1"),
    ("2", "2"),
    ("3", "3"),
    ("4", "4"),
]

"Tipo Documento Associado"
TDOCASSOC = [
    ("07", "07"),
    ("08", "08"),
    ("09", "09"),
    ("10", "10"),
    ("11", "11"),
    ("12", "12"),
    ("13", "13"),
]

"Tipo Finalidade da CT-e"
TFINCTE = [
    ("0", "0"),
    ("1", "1"),
    ("3", "3"),
]

"Tipo Finalidade da GTV-e"
TFINGTVE = [
    ("4", "4"),
]

"Tipo Modal transporte Outros Serviços"
TMODTRANSPOS = [
    ("01", "01"),
    ("02", "02"),
    ("03", "03"),
    ("04", "04"),
]

"Tipo processo de emissão do CT-e"
TPROCEMI = [
    ("0", "0"),
    ("3", "3"),
]

"Tipo de data/período programado para entrega"
COMDATA_TPPER = [
    ("1", "Na data"),
    ("2", "Até a data"),
    ("3", "A partir da data"),
]

"Tipo de hora"
COMHORA_TPHOR = [
    ("1", "No horário"),
    ("2", "Até o horário"),
    ("3", "A partir do horário."),
]

"""Indicador de CT-e Globalizado
    Informar valor 1 quando for Globalizado e não informar a tag quando não tratar
    de CT-e Globalizado"""
IDE_INDGLOBALIZADO = [
    ("1", "1"),
]

"Indicador da IE do tomador"
IDE_INDIETOMA = [
    ("1", "Contribuinte ICMS"),
    ("2", "Contribuinte isento de inscrição"),
    ("9", "Não Contribuinte"),
]

"Modal do CT-e OS"
IDE_MODAL = [
    ("01", "Rodoviário"),
    ("06", "06"),
]

"Indicador se o Recebedor retira no Aeroporto"
IDE_RETIRA = [
    ("0", "sim"),
    ("1", "não"),
]

"Forma de emissão do CT-e"
IDE_TPEMIS = [
    ("1", "Normal"),
    ("2", "2"),
    ("7", "Autorização pela SVC-RS"),
    ("8", "Autorização pela SVC-SP"),
]

"Formato de impressão do DACTE OS"
IDE_TPIMP = [
    ("1", "Retrato"),
    ("2", "Paisagem."),
]

"Tipo do Serviço"
IDE_TPSERV = [
    ("9", "9"),
]

"Indicador de CT-e Alteração de Tomador"
INFCTESUB_INDALTERATOMA = [
    ("1", "1"),
]

"Tipo da Espécie"
INFESPECIE_TPESPECIE = [
    ("1", "Numerário"),
    ("2", "Cheque"),
    ("3", "Moeda"),
    ("4", "Outros"),
]

"Nacionalidade do Numerário"
INFESPECIE_TPNUMERARIO = [
    ("1", "Nacional"),
    ("2", "Estrangeiro"),
]

"Tipo de documento originário"
INFOUTROS_TPDOC = [
    ("00", "Declaração"),
    ("10", "Dutoviário"),
    ("59", "CF-e SAT"),
    ("65", "NFC-e"),
    ("99", "Outros"),
]

"Código da Unidade de Medida"
INFQ_CUNID = [
    ("00", "M3"),
    ("01", "KG"),
    ("02", "TON"),
    ("03", "UNIDADE"),
    ("04", "LITROS"),
    ("05", "MMBTU"),
]

"Tipo de hora"
NOINTER_TPHOR = [
    ("4", "No intervalo de tempo"),
]

"Tipo período"
NOPERIODO_TPPER = [
    ("4", "no período"),
]

"Responsável pelo seguro"
SEG_RESPSEG = [
    ("4", "Emitente do CT-e"),
    ("5", "Tomador de Serviço."),
]

"Tipo de data/período programado para entrega"
SEMDATA_TPPER = [
    ("0", " Sem data definida"),
]

"Tipo de hora"
SEMHORA_TPHOR = [
    ("0", " Sem hora definida"),
]

"Tomador do Serviço"
TOMA3_TOMA = [
    ("0", "Remetente"),
    ("1", "Expedidor"),
    ("2", "Recebedor"),
    ("3", "Destinatário"),
]

"Tomador do Serviço"
TOMA4_TOMA = [
    ("4", "Outros"),
]

"Tomador do Serviço"
TOMATERCEIRO_TOMA = [
    ("4", "Outros"),
]

"Tomador do Serviço"
TOMA_TOMA = [
    ("0", "Remetente"),
    ("1", "Destinatário"),
]


class TrespTec(models.AbstractModel):
    "Tipo Dados da Responsável Técnico"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tresptec"
    _inherit = "spec.mixin.cte"
    _binding_type = "TrespTec"

    cte40_CNPJ = fields.Char(
        string="CNPJ",
        xsd_required=True,
        xsd_type="TCnpj",
        help=(
            "CNPJ da pessoa jurídica responsável técnica pelo sistema "
            "utilizado na emissão do documento fiscal eletrônico\nInformar o "
            "CNPJ da pessoa jurídica desenvolvedora do sistema utilizado na "
            "emissão do documento fiscal eletrônico."
        ),
    )

    cte40_xContato = fields.Char(
        string="Nome da pessoa a ser contatada",
        xsd_required=True,
        help=(
            "Nome da pessoa a ser contatada\nInformar o nome da pessoa a ser "
            "contatada na empresa desenvolvedora do sistema utilizado na "
            "emissão do documento fiscal eletrônico. No caso de pessoa física,"
            " informar o respectivo nome."
        ),
    )

    cte40_email = fields.Char(
        string="Email da pessoa jurídica a ser contatada",
        xsd_required=True,
        xsd_type="TEmail",
    )

    cte40_fone = fields.Char(
        string="Telefone da pessoa jurídica",
        xsd_required=True,
        help=(
            "Telefone da pessoa jurídica a ser contatada\nPreencher com o "
            "Código DDD + número do telefone."
        ),
    )

    cte40_idCSRT = fields.Char(
        string="Identificador do código de segurança",
        help=(
            "Identificador do código de segurança do responsável "
            "técnico\nIdentificador do CSRT utilizado para geração do hash"
        ),
    )

    cte40_hashCSRT = fields.Char(
        string="Hash do token do código de segurança",
        help=(
            "Hash do token do código de segurança do responsável técnico\nO "
            "hashCSRT é o resultado das funções SHA-1 e base64 do token CSRT "
            "fornecido pelo fisco + chave de acesso do DF-e. (Implementação em"
            " futura NT)\n\nObservação: 28 caracteres são representados no "
            "schema como 20 bytes do tipo base64Binary"
        ),
    )


class TendOrg(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tendorg"
    _inherit = "spec.mixin.cte"
    _binding_type = "TendOrg"

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número", xsd_required=True)

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    cte40_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=("Nome do município\nInformar EXTERIOR para operações com o " "exterior."),
    )

    cte40_CEP = fields.Char(string="CEP")

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )

    cte40_cPais = fields.Char(string="Código do país")

    cte40_xPais = fields.Char(string="Nome do país")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")


class TendReEnt(models.AbstractModel):
    "Tipo Dados do Local de Retirada ou Entrega"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tendreent"
    _inherit = "spec.mixin.cte"
    _binding_type = "TendReEnt"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="tendreent",
        xsd_choice_required=True,
        xsd_type="TCnpj",
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="tendreent",
        xsd_choice_required=True,
        xsd_type="TCpf",
    )

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número", xsd_required=True)

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE)\nInformar 9999999"
            " para operações com o exterior."
        ),
    )

    cte40_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=("Nome do município\nInformar EXTERIOR para operações com o " "exterior."),
    )

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )


class TendeEmi(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tendeemi"
    _inherit = "spec.mixin.cte"
    _binding_type = "TendeEmi"

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número", xsd_required=True)

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help="Código do município (utilizar a tabela do IBGE)",
    )

    cte40_xMun = fields.Char(string="Nome do município", xsd_required=True)

    cte40_CEP = fields.Char(string="CEP", help="CEP\nInformar zeros não significativos")

    cte40_UF = fields.Selection(
        TUF_SEM_EX, string="Sigla da UF", xsd_required=True, xsd_type="TUF_sem_EX"
    )

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")


class Tendereco(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tendereco"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tendereco"

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número", xsd_required=True)

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE)\nInformar 9999999"
            " para operações com o exterior."
        ),
    )

    cte40_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=("Nome do município\nInformar EXTERIOR para operações com o " "exterior."),
    )

    cte40_CEP = fields.Char(
        string="CEP", help="CEP\nInformar os zeros não significativos"
    )

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )

    cte40_cPais = fields.Char(
        string="Código do país", help="Código do país\nUtilizar a tabela do BACEN"
    )

    cte40_xPais = fields.Char(string="Nome do país")


class Tendernac(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tendernac"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tendernac"

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número", xsd_required=True)

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro", xsd_required=True)

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município (utilizar a tabela do IBGE), informar 9999999"
            " para operações com o exterior."
        ),
    )

    cte40_xMun = fields.Char(
        string="Nome do município, ",
        xsd_required=True,
        help=(
            "Nome do município, , informar EXTERIOR para operações com o " "exterior."
        ),
    )

    cte40_CEP = fields.Char(string="CEP")

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )


class Timp(models.AbstractModel):
    "Tipo Dados do Imposto CT-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.timp"
    _inherit = "spec.mixin.cte"
    _binding_type = "Timp"


class TimpOs(models.AbstractModel):
    "Tipo Dados do Imposto para CT-e OS"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.timpos"
    _inherit = "spec.mixin.cte"
    _binding_type = "TimpOs"


class Tlocal(models.AbstractModel):
    "Tipo Dados do Local de Origem ou Destino"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tlocal"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tlocal"

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help="Código do município (utilizar a tabela do IBGE)",
    )

    cte40_xMun = fields.Char(string="Nome do município", xsd_required=True)

    cte40_UF = fields.Selection(
        TUF, string="Sigla da UF", xsd_required=True, xsd_type="TUf"
    )


class TprotCte(models.AbstractModel):
    "Tipo Protocolo de status resultado do processamento da CT-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCte"

    cte40_infProt = fields.Many2one(
        comodel_name="cte.40.tprotcte_infprot",
        string="Dados do protocolo de status",
        xsd_required=True,
    )

    cte40_infFisco = fields.Many2one(
        comodel_name="cte.40.tprotcte_inffisco", string="Mensagem do Fisco"
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TprotCteInfProt(models.AbstractModel):
    "Dados do protocolo de status"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcte_infprot"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCte.InfProt"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o CT-e",
    )

    cte40_chCTe = fields.Char(
        string="Chaves de acesso da CT-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=("Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SS TZD."),
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de Status do CT-e", xsd_type="TProt"
    )

    cte40_digVal = fields.Char(
        string="Digest Value da CT-e processado",
        xsd_type="ds:DigestValueType",
        help=(
            "Digest Value da CT-e processado. Utilizado para conferir a "
            "integridade do CT-e original."
        ),
    )

    cte40_cStat = fields.Char(string="Código do status do CT-e", xsd_required=True)

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status do CT-e",
        xsd_required=True,
        xsd_type="TMotivo",
    )

    cte40_Id = fields.Char(string="Id", xsd_type="xs:ID")


class TprotCteInfFisco(models.AbstractModel):
    "Mensagem do Fisco"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcte_inffisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCte.InfFisco"

    cte40_cMsg = fields.Char(
        string="Código do status da mensagem do fisco", xsd_required=True
    )

    cte40_xMsg = fields.Char(
        string="Mensagem do Fisco", xsd_required=True, xsd_type="TMotivo"
    )


class TprotCteOs(models.AbstractModel):
    """Tipo Protocolo de status resultado do processamento do CT-e OS (Modelo
    67)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcteos"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCteOs"

    cte40_infProt = fields.Many2one(
        comodel_name="cte.40.tprotcteos_infprot",
        string="Dados do protocolo de status",
        xsd_required=True,
    )

    cte40_infFisco = fields.Many2one(
        comodel_name="cte.40.tprotcteos_inffisco", string="Mensagem do Fisco"
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TprotCteOsInfProt(models.AbstractModel):
    "Dados do protocolo de status"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcteos_infprot"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCteOs.InfProt"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o CT-e",
    )

    cte40_chCTe = fields.Char(
        string="Chaves de acesso da CT-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=("Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SS TZD."),
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de Status do CT-e", xsd_type="TProt"
    )

    cte40_digVal = fields.Char(
        string="Digest Value da CT-e processado",
        xsd_type="ds:DigestValueType",
        help=(
            "Digest Value da CT-e processado. Utilizado para conferir a "
            "integridade do CT-e original."
        ),
    )

    cte40_cStat = fields.Char(string="Código do status do CT-e", xsd_required=True)

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status do CT-e",
        xsd_required=True,
        xsd_type="TMotivo",
    )

    cte40_Id = fields.Char(string="Id", xsd_type="xs:ID")


class TprotCteOsInfFisco(models.AbstractModel):
    "Mensagem do Fisco"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotcteos_inffisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotCteOs.InfFisco"

    cte40_cMsg = fields.Char(
        string="Código do status da mensagem do fisco", xsd_required=True
    )

    cte40_xMsg = fields.Char(
        string="Mensagem do Fisco", xsd_required=True, xsd_type="TMotivo"
    )


class TprotGtve(models.AbstractModel):
    """Tipo Protocolo de status resultado do processamento da GTV-e (Modelo
    64)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotgtve"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotGtve"

    cte40_infProt = fields.Many2one(
        comodel_name="cte.40.tprotgtve_infprot",
        string="Dados do protocolo de status",
        xsd_required=True,
    )

    cte40_infFisco = fields.Many2one(
        comodel_name="cte.40.tprotgtve_inffisco", string="Mensagem do Fisco"
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TprotGtveInfProt(models.AbstractModel):
    "Dados do protocolo de status"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotgtve_infprot"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotGtve.InfProt"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a GTV-e",
    )

    cte40_chCTe = fields.Char(
        string="Chaves de acesso da CT-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_dhRecbto = fields.Datetime(
        string="Data e hora de processamento",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=("Data e hora de processamento, no formato AAAA-MM-DDTHH:MM:SS TZD."),
    )

    cte40_nProt = fields.Char(
        string="Número do Protocolo de Status da GTV-e", xsd_type="TProt"
    )

    cte40_digVal = fields.Char(
        string="Digest Value da GTV-e processado",
        xsd_type="ds:DigestValueType",
        help=(
            "Digest Value da GTV-e processado. Utilizado para conferir a "
            "integridade da GTV-e original."
        ),
    )

    cte40_cStat = fields.Char(string="Código do status da GTV-e", xsd_required=True)

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status da GTV-e",
        xsd_required=True,
        xsd_type="TMotivo",
    )

    cte40_Id = fields.Char(string="Id", xsd_type="xs:ID")


class TprotGtveInfFisco(models.AbstractModel):
    "Mensagem do Fisco"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tprotgtve_inffisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "TprotGtve.InfFisco"

    cte40_cMsg = fields.Char(
        string="Código do status da mensagem do fisco", xsd_required=True
    )

    cte40_xMsg = fields.Char(
        string="Mensagem do Fisco", xsd_required=True, xsd_type="TMotivo"
    )


class TunidCarga(models.AbstractModel):
    "Tipo Dados Unidade de Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tunidcarga"
    _inherit = "spec.mixin.cte"
    _binding_type = "TunidCarga"

    cte40_infUnidCarga_infNF_id = fields.Many2one(
        comodel_name="cte.40.tcte_infnf", xsd_implicit=True, ondelete="cascade"
    )
    cte40_infUnidCarga_infNFe_id = fields.Many2one(
        comodel_name="cte.40.tcte_infnfe", xsd_implicit=True, ondelete="cascade"
    )
    cte40_infUnidCarga_infOutros_id = fields.Many2one(
        comodel_name="cte.40.infoutros", xsd_implicit=True, ondelete="cascade"
    )
    cte40_infUnidCarga_TUnidadeTransp_id = fields.Many2one(
        comodel_name="cte.40.tunidadetransp", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpUnidCarga = fields.Selection(
        TTIPOUNIDCARGA,
        string="Tipo da Unidade de Carga",
        xsd_required=True,
        xsd_type="TtipoUnidCarga",
        help=(
            "Tipo da Unidade de Carga\n1 - Container\n2 - ULD\n3 - Pallet\n4 -"
            " Outros"
        ),
    )

    cte40_idUnidCarga = fields.Char(
        string="Identificação da Unidade de Carga",
        xsd_required=True,
        xsd_type="TContainer",
        help=(
            "Identificação da Unidade de Carga\nInformar a identificação da "
            "unidade de carga, por exemplo: número do container."
        ),
    )

    cte40_lacUnidCarga = fields.One2many(
        "cte.40.lacunidcarga",
        "cte40_lacUnidCarga_TUnidCarga_id",
        string="Lacres das Unidades de Carga",
    )

    cte40_qtdRat = fields.Monetary(
        string="Quantidade rateada (Peso,Volume)",
        xsd_type="TDec_0302_0303",
        currency_field="brl_currency_id",
    )


class LacUnidCarga(models.AbstractModel):
    "Lacres das Unidades de Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.lacunidcarga"
    _inherit = "spec.mixin.cte"
    _binding_type = "TunidCarga.LacUnidCarga"

    cte40_lacUnidCarga_TUnidCarga_id = fields.Many2one(
        comodel_name="cte.40.tunidcarga", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nLacre = fields.Char(string="Número do lacre", xsd_required=True)


class TcteOs(models.AbstractModel):
    """Tipo Conhecimento de Transporte Eletrônico Outros Serviços (Modelo
    67)"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs"

    cte40_infCte = fields.Many2one(
        comodel_name="cte.40.tcteos_infcte",
        string="Informações do CT-e Outros Serviços",
        xsd_required=True,
    )

    cte40_infCTeSupl = fields.Many2one(
        comodel_name="cte.40.tcteos_infctesupl",
        string="Informações suplementares do CT-e",
    )

    cte40_versao = fields.Char(string="Versão do leiaute", xsd_required=True)


class TcteOsInfCte(models.AbstractModel):
    "Informações do CT-e do tipo GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte"

    cte40_ide = fields.Many2one(
        comodel_name="cte.40.tcteos_ide",
        string="Identificação do CT-e Outros Serviços",
        xsd_required=True,
    )

    cte40_compl = fields.Many2one(
        comodel_name="cte.40.tcteos_compl",
        string="Dados complementares do CT-e",
        help=("Dados complementares do CT-e para fins operacionais ou comerciais"),
    )

    cte40_emit = fields.Many2one(
        comodel_name="cte.40.tcteos_emit",
        string="Identificação do Emitente do CT-e OS",
        xsd_required=True,
    )

    cte40_toma = fields.Many2one(
        comodel_name="cte.40.tcteos_toma",
        string="Informações do Tomador/Usuário",
        choice="infcte",
        xsd_choice_required=True,
        help=(
            "Informações do Tomador/Usuário do Serviço\nOpcional para Excesso "
            "de Bagagem"
        ),
    )

    cte40_vPrest = fields.Many2one(
        comodel_name="cte.40.tcteos_vprest",
        string="Valores da Prestação de Serviço",
        xsd_required=True,
    )

    cte40_imp = fields.Many2one(
        comodel_name="cte.40.tcteos_imp",
        string="Informações relativas aos Impostos",
        xsd_required=True,
    )

    cte40_infCTeNorm = fields.Many2one(
        comodel_name="cte.40.tcteos_infctenorm",
        string="Grupo de informações do CT-e OS Normal",
        choice="infcte",
        xsd_choice_required=True,
    )

    cte40_infCteComp = fields.One2many(
        "cte.40.tcteos_infctecomp",
        "cte40_infCteComp_infCte_id",
        string="Detalhamento do CT-e complementado",
        choice="infcte",
        xsd_choice_required=True,
    )

    cte40_autXML = fields.One2many(
        "cte.40.tcteos_autxml",
        "cte40_autXML_infCte_id",
        string="Autorizados para download do XML do DF-e",
        help=(
            "Autorizados para download do XML do DF-e\nInformar CNPJ ou CPF. "
            "Preencher os zeros não significativos."
        ),
    )

    cte40_infRespTec = fields.Many2one(
        comodel_name="cte.40.tresptec",
        string="Informações do Responsável Técnico",
        xsd_type="TRespTec",
        help="Informações do Responsável Técnico pela emissão do DF-e",
    )

    cte40_versao = fields.Char(
        string="Versão do leiaute",
        xsd_required=True,
        help="Versão do leiaute\nEx: '4.00'",
    )

    cte40_Id = fields.Char(
        string="Identificador da tag a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da tag a ser assinada\nInformar a chave de acesso "
            "do CT-e OS e precedida do literal 'CTe'"
        ),
    )


class TcteOsIde(models.AbstractModel):
    "Identificação da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_ide"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Ide"

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente do CT-e",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=("Código da UF do emitente do CT-e.\nUtilizar a Tabela do IBGE."),
    )

    cte40_cCT = fields.Char(
        string="Código numérico que compõe a Chave",
        xsd_required=True,
        help=(
            "Código numérico que compõe a Chave de Acesso.\nNúmero aleatório "
            "gerado pelo emitente para cada CT-e, com o objetivo de evitar "
            "acessos indevidos ao documento."
        ),
    )

    cte40_CFOP = fields.Char(
        string="Código Fiscal de Operações e Prestações",
        xsd_required=True,
        xsd_type="TCfop",
    )

    cte40_natOp = fields.Char(string="Natureza da Operação", xsd_required=True)

    cte40_mod = fields.Selection(
        TMODCTOS,
        string="Modelo do documento fiscal",
        xsd_required=True,
        xsd_type="TModGTVe",
        help=(
            "Modelo do documento fiscal\nUtilizar o código 67 para "
            "identificação do CT-e Outros Serviços, emitido em substituição a "
            "Nota Fiscal Modelo 7 para transporte de pessoas, valores e "
            "excesso de bagagem."
        ),
    )

    cte40_serie = fields.Char(
        string="Série do CT-e OS",
        xsd_required=True,
        help="Série do CT-e OS\nPreencher com '0' no caso de série única",
    )

    cte40_nCT = fields.Char(
        string="Número do CT-e OS", xsd_required=True, xsd_type="TNF"
    )

    cte40_dhEmi = fields.Char(
        string="Data e hora de emissão do CT-e OS",
        xsd_required=True,
        help=("Data e hora de emissão do CT-e OS\nFormato AAAA-MM-DDTHH:MM:DD " "TZD"),
    )

    cte40_tpImp = fields.Selection(
        IDE_TPIMP,
        string="Formato de impressão do DACTE OS",
        xsd_required=True,
        help=(
            "Formato de impressão do DACTE OS\nPreencher com: 1 - Retrato; 2 -"
            " Paisagem."
        ),
    )

    cte40_tpEmis = fields.Selection(
        IDE_TPEMIS,
        string="Forma de emissão do CT-e",
        xsd_required=True,
        help=(
            "Forma de emissão do CT-e\nPreencher com:\n1 - Normal;\n 5 - "
            "Contingência FSDA;\n7 - Autorização pela SVC-RS;\n 8 - "
            "Autorização pela SVC-SP"
        ),
    )

    cte40_cDV = fields.Char(
        string="Digito Verificador da chave de acesso",
        xsd_required=True,
        help=(
            "Digito Verificador da chave de acesso do CT-e\nInformar o dígito"
            "  de controle da chave de acesso do CT-e, que deve ser calculado "
            "com a aplicação do algoritmo módulo 11 (base 2,9) da chave de "
            "acesso."
        ),
    )

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Tipo do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help=("Tipo do Ambiente\nPreencher com:1 - Produção; 2 - Homologação"),
    )

    cte40_tpCTe = fields.Selection(
        TFINCTE,
        string="Tipo do CT-e OS",
        xsd_required=True,
        help=(
            "Tipo do CT-e OS\nPreencher com:\n0 - CT-e Normal; \n1 - CT-e "
            "Complementar; \n\n3 - CT-e de Substituição."
        ),
    )

    cte40_procEmi = fields.Selection(
        TPROCEMI,
        string="Identificador do processo de emissão",
        xsd_required=True,
        xsd_type="TProcEmi",
        help=(
            "Identificador do processo de emissão do CT-e OS\nPreencher com: "
            "\n\t\t\t\t\t\t\t\t\t\t\t0 - emissão de CT-e com aplicativo do "
            "contribuinte;\n\t\t\t\t\t\t\t\t\t\t\t3- emissão CT-e pelo "
            "contribuinte com aplicativo fornecido pelo Fisco."
        ),
    )

    cte40_verProc = fields.Char(
        string="Versão do processo de emissão",
        xsd_required=True,
        help=(
            "Versão do processo de emissão\nIinformar a versão do aplicativo "
            "emissor de CT-e."
        ),
    )

    cte40_cMunEnv = fields.Char(
        string="Código do Município de envio do CT-e",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de envio do CT-e (de onde o documento foi "
            "transmitido)\nUtilizar a tabela do IBGE. Informar 9999999 para as"
            " operações com o exterior."
        ),
    )

    cte40_xMunEnv = fields.Char(
        string="Nome do Município de envio do CT-e",
        xsd_required=True,
        help=(
            "Nome do Município de envio do CT-e (de onde o documento foi "
            "transmitido)\nInformar PAIS/Municipio para as operações com o "
            "exterior."
        ),
    )

    cte40_UFEnv = fields.Selection(
        TUF,
        string="Sigla da UF de envio do CT-e",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF de envio do CT-e (de onde o documento foi "
            "transmitido)\nInformar 'EX' para operações com o exterior."
        ),
    )

    cte40_modal = fields.Selection(
        TMODTRANSPOS,
        string="Modal do CT-e OS",
        xsd_required=True,
        help=(
            "Modal do CT-e OS\nPreencher com:\n01-Rodoviário;\n02- Aéreo;\n03 "
            "- Aquaviário;\n04 - Ferroviário."
        ),
    )

    cte40_tpServ = fields.Selection(
        IDE_TPSERV,
        string="Tipo do Serviço",
        xsd_required=True,
        help=(
            "Tipo do Serviço\nPreencher com: \n\n6 - Transporte de Pessoas;\n7"
            " - Transporte de Valores;\n8 - Excesso de Bagagem."
        ),
    )

    cte40_indIEToma = fields.Selection(
        IDE_INDIETOMA,
        string="Indicador da IE do tomador",
        xsd_required=True,
        help=(
            "Indicador da IE do tomador:\n1 – Contribuinte ICMS;\n2 – "
            "Contribuinte isento de inscrição;\n9 – Não Contribuinte\nAplica-"
            "se ao tomador que for indicado no toma3 ou toma4"
        ),
    )

    cte40_cMunIni = fields.Char(
        string="Código do Município de início",
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de início da prestação\nUtilizar a tabela do "
            "IBGE. Informar 9999999 para operações com o exterior."
        ),
    )

    cte40_xMunIni = fields.Char(
        string="Nome do Município do início da prestação",
        help=(
            "Nome do Município do início da prestação\nInformar 'EXTERIOR' "
            "para operações com o exterior."
        ),
    )

    cte40_UFIni = fields.Selection(
        TUF,
        string="UF do início da prestação",
        xsd_type="TUf",
        help=(
            "UF do início da prestação\nInformar 'EX' para operações com o " "exterior."
        ),
    )

    cte40_cMunFim = fields.Char(
        string="Código do Município de término",
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de término da prestação\nUtilizar a tabela do"
            " IBGE. Informar 9999999 para operações com o exterior."
        ),
    )

    cte40_xMunFim = fields.Char(
        string="Nome do Município do término",
        help=(
            "Nome do Município do término da prestação\nInformar 'EXTERIOR' "
            "para operações com o exterior."
        ),
    )

    cte40_UFFim = fields.Selection(
        TUF,
        string="UF do término da prestação",
        xsd_type="TUf",
        help=(
            "UF do término da prestação\nInformar 'EX' para operações com o "
            "exterior."
        ),
    )

    cte40_infPercurso = fields.One2many(
        "cte.40.infpercurso",
        "cte40_infPercurso_ide_id",
        string="Informações do Percurso",
        help="Informações do Percurso do CT-e Outros Serviços",
    )

    cte40_dhCont = fields.Datetime(
        string="Data e Hora da entrada em contingência",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora da entrada em contingência\nInformar a data e hora no"
            " formato AAAA-MM-DDTHH:MM:SS"
        ),
    )

    cte40_xJust = fields.Char(string="Justificativa da entrada em contingência")


class InfPercurso(models.AbstractModel):
    "Informações do Percurso do CT-e Outros Serviços"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infpercurso"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Ide.InfPercurso"

    cte40_infPercurso_ide_id = fields.Many2one(
        comodel_name="cte.40.tcteos_ide", xsd_implicit=True, ondelete="cascade"
    )
    cte40_UFPer = fields.Selection(
        TUF,
        string="Sigla das Unidades da Federação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla das Unidades da Federação do percurso do veículo.\nNão é "
            "necessário repetir as UF de Início e Fim"
        ),
    )


class TcteOsCompl(models.AbstractModel):
    "Dados complementares da GTV-e para fins operacionais ou comerciais"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_compl"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Compl"

    cte40_xCaracAd = fields.Char(
        string="Característica adicional do transporte",
        help=(
            "Característica adicional do transporte\nTexto livre:\nREENTREGA; "
            "DEVOLUÇÃO; REFATURAMENTO; etc"
        ),
    )

    cte40_xCaracSer = fields.Char(
        string="Característica adicional do serviço",
        help=(
            "Característica adicional do serviço\nTexto "
            "livre:\n\t\t\t\t\t\t\t\t\t\t\tENTREGA EXPRESSA; LOGÍSTICA "
            "REVERSA; CONVENCIONAL; EMERGENCIAL; etc"
        ),
    )

    cte40_xEmi = fields.Char(string="Funcionário emissor do CTe")

    cte40_xObs = fields.Char(string="Observações Gerais")

    cte40_obsCont = fields.One2many(
        "cte.40.tcteos_obscont",
        "cte40_ObsCont_compl_id",
        string="Campo de uso livre do contribuinte",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )

    cte40_obsFisco = fields.One2many(
        "cte.40.tcteos_obsfisco",
        "cte40_ObsFisco_compl_id",
        string="ObsFisco",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )


class TcteOsObsCont(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_obscont"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Compl.ObsCont"

    cte40_ObsCont_compl_id = fields.Many2one(
        comodel_name="cte.40.tcteos_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TcteOsObsFisco(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_obsfisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Compl.ObsFisco"

    cte40_ObsFisco_compl_id = fields.Many2one(
        comodel_name="cte.40.tcteos_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TcteOsEmit(models.AbstractModel):
    "Identificação do Emitente da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_emit"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Emit"

    cte40_CNPJ = fields.Char(
        string="CNPJ do emitente",
        xsd_required=True,
        xsd_type="TCnpj",
        help="CNPJ do emitente\nInformar zeros não significativos",
    )

    cte40_IE = fields.Char(string="Inscrição Estadual do Emitente", xsd_required=True)

    cte40_IEST = fields.Char(
        string="Inscrição Estadual", help="Inscrição Estadual do Substituto Tributário"
    )

    cte40_xNome = fields.Char(
        string="Razão social ou Nome do emitente", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_enderEmit = fields.Many2one(
        comodel_name="cte.40.tendeemi",
        string="Endereço do emitente",
        xsd_required=True,
        xsd_type="TEndeEmi",
    )

    cte40_CRT = fields.Selection(
        TCRT,
        string="Código do Regime Tributário",
        xsd_required=True,
        xsd_type="TCRT",
        help=(
            "Código do Regime Tributário\nInformar: 1=Simples Nacional; "
            "\n2=Simples Nacional, excesso sublimite de receita "
            "bruta;\n3=Regime Normal;\n4=Simples Nacional - Microempreendedor "
            "Individual – MEI."
        ),
    )


class TcteOsToma(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no GT-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_toma"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Toma"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="toma",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="toma",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do tomador ou ISENTO se tomador"
            " é contribuinte do ICMS isento de inscrição no cadastro de "
            "contribuintes do ICMS. Caso o tomador não seja contribuinte do "
            "ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão social ou nome do tomador", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderToma = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email")


class TcteOsVPrest(models.AbstractModel):
    "Valores da Prestação de Serviço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_vprest"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.VPrest"

    cte40_vTPrest = fields.Monetary(
        string="Valor Total da Prestação do Serviço",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total da Prestação do Serviço\nPode conter zeros quando o "
            "CT-e for de complemento de ICMS"
        ),
    )

    cte40_vRec = fields.Monetary(
        string="Valor a Receber",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_comp = fields.One2many(
        "cte.40.tcteos_vprest_comp",
        "cte40_Comp_vPrest_id",
        string="Componentes do Valor da Prestação",
    )


class TcteOsVPrestComp(models.AbstractModel):
    "Componentes do Valor da Prestação"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_vprest_comp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.VPrest.Comp"

    cte40_Comp_vPrest_id = fields.Many2one(
        comodel_name="cte.40.tcteos_vprest", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xNome = fields.Char(
        string="Nome do componente",
        xsd_required=True,
        help=(
            "Nome do componente\nExxemplos: FRETE PESO, FRETE VALOR, SEC/CAT, "
            "ADEME, AGENDAMENTO, etc"
        ),
    )

    cte40_vComp = fields.Monetary(
        string="Valor do componente",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class TcteOsImp(models.AbstractModel):
    "Informações relativas aos Impostos"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_imp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Imp"

    cte40_ICMS = fields.Many2one(
        comodel_name="cte.40.timpos",
        string="Informações relativas ao ICMS",
        xsd_required=True,
        xsd_type="TImp",
    )

    cte40_vTotTrib = fields.Monetary(
        string="Valor Total dos Tributos",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_infAdFisco = fields.Char(
        string="Informações adicionais de interesse",
        help=(
            "Informações adicionais de interesse do Fisco\nNorma referenciada,"
            " informações complementares, etc"
        ),
    )

    cte40_infTribFed = fields.Many2one(
        comodel_name="cte.40.inftribfed",
        string="Informações dos tributos federais",
        help=(
            "Informações dos tributos federais\nGrupo a ser informado nas "
            "prestações interestaduais para consumidor final, não contribuinte"
            " do ICMS"
        ),
    )


class InfTribFed(models.AbstractModel):
    """Informações dos tributos federais
    Grupo a ser informado nas prestações interestaduais para consumidor final, não
    contribuinte do ICMS"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.inftribfed"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.Imp.InfTribFed"

    cte40_vPIS = fields.Monetary(
        string="Valor do PIS", xsd_type="TDec_1302", currency_field="brl_currency_id"
    )

    cte40_vCOFINS = fields.Monetary(
        string="Valor COFINS", xsd_type="TDec_1302", currency_field="brl_currency_id"
    )

    cte40_vIR = fields.Monetary(
        string="Valor de Imposto de Renda",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vINSS = fields.Monetary(
        string="Valor do INSS", xsd_type="TDec_1302", currency_field="brl_currency_id"
    )

    cte40_vCSLL = fields.Monetary(
        string="Valor do CSLL", xsd_type="TDec_1302", currency_field="brl_currency_id"
    )


class TcteOsAutXml(models.AbstractModel):
    """Autorizados para download do XML do DF-e
    Informar CNPJ ou CPF. Preencher os zeros não significativos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_autxml"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.AutXml"

    cte40_autXML_infCte_id = fields.Many2one(
        comodel_name="cte.40.tcteos_infcte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_CNPJ = fields.Char(
        string="CNPJ do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do autorizado\nInformar zeros não significativos",
    )

    cte40_CPF = fields.Char(
        string="CPF do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="CPF do autorizado\nInformar zeros não significativos",
    )


class TcteOsInfCteNorm(models.AbstractModel):
    "Grupo de informações do CT-e Normal e Substituto"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infctenorm"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm"

    cte40_infServico = fields.Many2one(
        comodel_name="cte.40.infservico",
        string="Informações da Prestação do Serviço",
        xsd_required=True,
    )

    cte40_infDocRef = fields.One2many(
        "cte.40.infdocref",
        "cte40_infDocRef_infCTeNorm_id",
        string="Informações dos documentos referenciados",
    )

    cte40_seg = fields.One2many(
        "cte.40.tcteos_seg",
        "cte40_seg_infCTeNorm_id",
        string="Informações de Seguro da Carga",
    )

    cte40_infModal = fields.Many2one(
        comodel_name="cte.40.tcteos_infmodal",
        string="Informações do modal",
        help="Informações do modal\nObrigatório para Pessoas e Bagagem",
    )

    cte40_infCteSub = fields.Many2one(
        comodel_name="cte.40.tcteos_infctesub",
        string="Informações do CT-e de substituição",
    )

    cte40_refCTeCanc = fields.Char(
        string="Chave de acesso do CT-e Cancelado",
        help=(
            "Chave de acesso do CT-e Cancelado\nSomente para Transporte de " "Valores"
        ),
    )

    cte40_cobr = fields.Many2one(
        comodel_name="cte.40.tcteos_cobr", string="Dados da cobrança do CT-e"
    )

    cte40_infGTVe = fields.One2many(
        "cte.40.infgtve",
        "cte40_infGTVe_infCTeNorm_id",
        string="Informações das GTV-e relacionadas",
        help="Informações das GTV-e relacionadas ao CT-e OS",
    )


class InfServico(models.AbstractModel):
    "Informações da Prestação do Serviço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infservico"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfServico"

    cte40_xDescServ = fields.Char(
        string="Descrição do Serviço prestado", xsd_required=True
    )

    cte40_infQ = fields.Many2one(
        comodel_name="cte.40.tcteos_infq",
        string="Informações de quantidades da Carga",
        help=(
            "Informações de quantidades da Carga do CT-e\nPara Transporte de "
            "Pessoas indicar número de passageiros, para excesso de bagagem e "
            "transporte de valores indicar número de Volumes/Malotes"
        ),
    )


class TcteOsInfQ(models.AbstractModel):
    """Informações de quantidades da Carga do CT-e
    Para o Aéreo é obrigatório o preenchimento desse campo da seguinte forma.
    1 - Peso Bruto, sempre em quilogramas (obrigatório);
    2 - Peso Cubado; sempre em quilogramas;
    3 - Quantidade de volumes, sempre em unidades (obrigatório);
    4 - Cubagem, sempre em metros cúbicos (obrigatório apenas quando for impossível
    preencher as dimensões da(s) embalagem(ens) na tag xDime do leiaute do
    Aéreo)."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infq"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfServico.InfQ"

    cte40_qCarga = fields.Float(
        string="Quantidade",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )


class InfDocRef(models.AbstractModel):
    "Informações dos documentos referenciados"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infdocref"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfDocRef"

    cte40_infDocRef_infCTeNorm_id = fields.Many2one(
        comodel_name="cte.40.tcteos_infctenorm", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nDoc = fields.Char(
        string="Número", choice="infdocref", xsd_choice_required=True
    )

    cte40_serie = fields.Char(
        string="Série", choice="infdocref", xsd_choice_required=True
    )

    cte40_subserie = fields.Char(
        string="Subsérie", choice="infdocref", xsd_choice_required=True
    )

    cte40_dEmi = fields.Date(
        string="Data de Emissão",
        choice="infdocref",
        xsd_choice_required=True,
        xsd_type="TData",
        help="Data de Emissão\nFormato AAAA-MM-DD",
    )

    cte40_vDoc = fields.Monetary(
        string="Valor Transportado",
        choice="infdocref",
        xsd_choice_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_chBPe = fields.Char(
        string="Chave de acesso do BP-e",
        choice="infdocref",
        xsd_choice_required=True,
        help=("Chave de acesso do BP-e que possui eventos excesso de bagagem"),
    )


class TcteOsSeg(models.AbstractModel):
    "Informações de Seguro da Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_seg"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.Seg"

    cte40_seg_infCTeNorm_id = fields.Many2one(
        comodel_name="cte.40.tcteos_infctenorm", xsd_implicit=True, ondelete="cascade"
    )
    cte40_respSeg = fields.Selection(
        SEG_RESPSEG,
        string="Responsável pelo seguro",
        xsd_required=True,
        help=(
            "Responsável pelo seguro\nPreencher com:\n\n4 - Emitente do "
            "CT-e;\n\n5 - Tomador de Serviço."
        ),
    )

    cte40_xSeg = fields.Char(string="Nome da Seguradora")

    cte40_nApol = fields.Char(
        string="Número da Apólice",
        help="Número da Apólice\nObrigatório pela lei 11.442/07 (RCTRC)",
    )


class TcteOsInfModal(models.AbstractModel):
    "Informações do modal"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infmodal"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfModal"

    cte40_versaoModal = fields.Char(
        string="Versão do leiaute específico",
        xsd_required=True,
        help="Versão do leiaute específico para o Modal",
    )


class TcteOsInfCteSub(models.AbstractModel):
    "Informações do CT-e de substituição"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infctesub"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfCteSub"

    cte40_chCte = fields.Char(
        string="Chave de acesso do CT-e",
        xsd_required=True,
        help="Chave de acesso do CT-e a ser substituído (original)",
    )


class TcteOsCobr(models.AbstractModel):
    "Dados da cobrança do CT-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_cobr"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.Cobr"

    cte40_fat = fields.Many2one(
        comodel_name="cte.40.tcteos_fat", string="Dados da fatura"
    )

    cte40_dup = fields.One2many(
        "cte.40.tcteos_dup", "cte40_dup_cobr_id", string="Dados das duplicatas"
    )


class TcteOsFat(models.AbstractModel):
    "Dados da fatura"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_fat"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.Cobr.Fat"

    cte40_nFat = fields.Char(string="Número da fatura")

    cte40_vOrig = fields.Monetary(
        string="Valor original da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    cte40_vDesc = fields.Monetary(
        string="Valor do desconto da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    cte40_vLiq = fields.Monetary(
        string="Valor líquido da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class TcteOsDup(models.AbstractModel):
    "Dados das duplicatas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_dup"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.Cobr.Dup"

    cte40_dup_cobr_id = fields.Many2one(
        comodel_name="cte.40.tcteos_cobr", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nDup = fields.Char(string="Número da duplicata")

    cte40_dVenc = fields.Date(
        string="Data de vencimento da duplicata",
        xsd_type="TData",
        help="Data de vencimento da duplicata (AAAA-MM-DD)",
    )

    cte40_vDup = fields.Monetary(
        string="Valor da duplicata",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class InfGtve(models.AbstractModel):
    "Informações das GTV-e relacionadas ao CT-e OS"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infgtve"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfGtve"

    cte40_infGTVe_infCTeNorm_id = fields.Many2one(
        comodel_name="cte.40.tcteos_infctenorm", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chCTe = fields.Char(string="Chave de acesso da GTV-e", xsd_required=True)

    cte40_comp = fields.One2many(
        "cte.40.tcteos_infctenorm_comp",
        "cte40_Comp_infGTVe_id",
        string="Componentes do Valor da GTVe",
    )


class TcteOsInfCteNormComp(models.AbstractModel):
    "Componentes do Valor da Prestação"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infctenorm_comp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteNorm.InfGtve.Comp"

    cte40_Comp_infGTVe_id = fields.Many2one(
        comodel_name="cte.40.infgtve", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpComp = fields.Selection(
        COMP_TPCOMP,
        string="Tipo do Componente",
        xsd_required=True,
        help=(
            "Tipo do Componente\n1-Custodia\n2-Embarque\n3-Tempo de "
            "espera\n4-Malote\n5-Ad Valorem\n6-Outros"
        ),
    )

    cte40_vComp = fields.Monetary(
        string="Valor do componente",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_xComp = fields.Char(
        string="Nome do componente",
        help=(
            "Nome do componente (informar apenas para outros)\nExemplos: FRETE"
            " PESO, FRETE VALOR, SEC/CAT, ADEME, AGENDAMENTO, etc"
        ),
    )


class TcteOsInfCteComp(models.AbstractModel):
    "Detalhamento do CT-e complementado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infctecomp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCte.InfCteComp"

    cte40_infCteComp_infCte_id = fields.Many2one(
        comodel_name="cte.40.tcteos_infcte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chCTe = fields.Char(
        string="Chave do CT-e complementado", xsd_required=True, xsd_type="TChDFe"
    )


class TcteOsInfCteSupl(models.AbstractModel):
    "Informações suplementares da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcteos_infctesupl"
    _inherit = "spec.mixin.cte"
    _binding_type = "TcteOs.InfCteSupl"

    cte40_qrCodCTe = fields.Char(
        string="Texto com o QR-Code impresso no DACTE", xsd_required=True
    )


class Tgtve(models.AbstractModel):
    "Tipo Guia de Transporte de Valores Eletrônica (Modelo 64)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve"

    cte40_infCte = fields.Many2one(
        comodel_name="cte.40.tgtve_infcte",
        string="Informações do CT-e do tipo GTV-e",
        xsd_required=True,
    )

    cte40_infCTeSupl = fields.Many2one(
        comodel_name="cte.40.tgtve_infctesupl",
        string="Informações suplementares da GTV-e",
    )

    cte40_versao = fields.Char(string="Versão do leiaute", xsd_required=True)


class TgtveInfCte(models.AbstractModel):
    "Informações do CT-e do tipo GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_infcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte"

    cte40_ide = fields.Many2one(
        comodel_name="cte.40.tgtve_ide",
        string="Identificação da GTV-e",
        xsd_required=True,
    )

    cte40_compl = fields.Many2one(
        comodel_name="cte.40.tgtve_compl",
        string="Dados complementares da GTV-e",
        help=("Dados complementares da GTV-e para fins operacionais ou " "comerciais"),
    )

    cte40_emit = fields.Many2one(
        comodel_name="cte.40.tgtve_emit",
        string="Identificação do Emitente da GTV-e",
        xsd_required=True,
    )

    cte40_rem = fields.Many2one(
        comodel_name="cte.40.tgtve_rem",
        string="Informações do Remetente",
        xsd_required=True,
        help=(
            "Informações do Remetente\nPoderá não ser informado para os CT-e "
            "de redespacho intermediário e serviço vinculado a multimodal. Nos"
            " demais casos deverá sempre ser informado."
        ),
    )

    cte40_dest = fields.Many2one(
        comodel_name="cte.40.tgtve_dest",
        string="Informações do Destinatário",
        xsd_required=True,
        help=(
            "Informações do Destinatário\nPoderá não ser informado para os "
            "CT-e de redespacho intermediário e serviço vinculado a "
            "multimodal. Nos demais casos deverá sempre ser informado."
        ),
    )

    cte40_origem = fields.Many2one(
        comodel_name="cte.40.tendeemi",
        string="Informações do endereço da origem",
        xsd_type="TEndeEmi",
        help="Informações do endereço da origem do serviço",
    )

    cte40_destino = fields.Many2one(
        comodel_name="cte.40.tendeemi",
        string="Informações do endereço do destino",
        xsd_type="TEndeEmi",
        help="Informações do endereço do destino do serviço",
    )

    cte40_detGTV = fields.Many2one(
        comodel_name="cte.40.detgtv",
        string="Grupo de informações detalhadas da GTV-e",
        xsd_required=True,
    )

    cte40_autXML = fields.One2many(
        "cte.40.tgtve_autxml",
        "cte40_autXML_infCte_id",
        string="Autorizados para download do XML do DF-e",
        help=(
            "Autorizados para download do XML do DF-e\nInformar CNPJ ou CPF. "
            "Preencher os zeros não significativos."
        ),
    )

    cte40_infRespTec = fields.Many2one(
        comodel_name="cte.40.tresptec",
        string="Informações do Responsável Técnico",
        xsd_type="TRespTec",
        help="Informações do Responsável Técnico pela emissão do DF-e",
    )

    cte40_versao = fields.Char(
        string="Versão do leiaute",
        xsd_required=True,
        help="Versão do leiaute\nEx: '4.00'",
    )

    cte40_Id = fields.Char(
        string="Identificador da tag a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da tag a ser assinada\nInformar a chave de acesso "
            "do CT-e OS e precedida do literal 'CTe'"
        ),
    )


class TgtveIde(models.AbstractModel):
    "Identificação da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_ide"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Ide"

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente da GTV-e",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=("Código da UF do emitente da GTV-e.\nUtilizar a Tabela do IBGE."),
    )

    cte40_cCT = fields.Char(
        string="Código numérico que compõe a Chave",
        xsd_required=True,
        help=(
            "Código numérico que compõe a Chave de Acesso.\nNúmero aleatório "
            "gerado pelo emitente para cada CT-e, com o objetivo de evitar "
            "acessos indevidos ao documento."
        ),
    )

    cte40_CFOP = fields.Char(
        string="Código Fiscal de Operações e Prestações",
        xsd_required=True,
        xsd_type="TCfop",
    )

    cte40_natOp = fields.Char(string="Natureza da Operação", xsd_required=True)

    cte40_mod = fields.Selection(
        TMODGTVE,
        string="Modelo do documento fiscal",
        xsd_required=True,
        xsd_type="TModGTVe",
        help=(
            "Modelo do documento fiscal\nUtilizar o código 64 para "
            "identificação do CT-e Guia de Transporte de Valores"
        ),
    )

    cte40_serie = fields.Char(
        string="Série da GTV-e",
        xsd_required=True,
        help="Série da GTV-e\nPreencher com '0' no caso de série única",
    )

    cte40_nCT = fields.Char(string="Número da GTV-e", xsd_required=True, xsd_type="TNF")

    cte40_dhEmi = fields.Char(
        string="Data e hora de emissão da GTV-e",
        xsd_required=True,
        help=("Data e hora de emissão da GTV-e\nFormato AAAA-MM-DDTHH:MM:DD TZD"),
    )

    cte40_tpImp = fields.Selection(
        IDE_TPIMP,
        string="Formato de impressão do DACTE",
        xsd_required=True,
        help=(
            "Formato de impressão do DACTE\nPreencher com: 1 - Retrato; 2 - "
            "Paisagem."
        ),
    )

    cte40_tpEmis = fields.Selection(
        IDE_TPEMIS,
        string="Forma de emissão da GTV-e",
        xsd_required=True,
        help=(
            "Forma de emissão da GTV-e\nPreencher com:\n1 - Normal;\n 2- "
            "Contingencia offline \n7 - Autorização pela SVC-RS;\n 8 - "
            "Autorização pela SVC-SP"
        ),
    )

    cte40_cDV = fields.Char(
        string="Digito Verificador da chave de acesso",
        xsd_required=True,
        help=(
            "Digito Verificador da chave de acesso da GTV-e\nInformar o dígito"
            "  de controle da chave de acesso do CT-e, que deve ser calculado "
            "com a aplicação do algoritmo módulo 11 (base 2,9) da chave de "
            "acesso."
        ),
    )

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Tipo do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help=("Tipo do Ambiente\nPreencher com:1 - Produção; 2 - Homologação"),
    )

    cte40_tpCTe = fields.Selection(
        TFINGTVE,
        string="Tipo da GTV-e",
        xsd_required=True,
        help="Tipo da GTV-e\nPreencher com:\n 4 - GTV-e",
    )

    cte40_verProc = fields.Char(
        string="Versão do processo de emissão",
        xsd_required=True,
        help=(
            "Versão do processo de emissão\nIinformar a versão do aplicativo "
            "emissor de CT-e."
        ),
    )

    cte40_cMunEnv = fields.Char(
        string="Código do Município de envio da GTV-e",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de envio da GTV-e (de onde o documento foi "
            "transmitido)\nUtilizar a tabela do IBGE. Informar 9999999 para as"
            " operações com o exterior."
        ),
    )

    cte40_xMunEnv = fields.Char(
        string="Nome do Município de envio da GTV-e",
        xsd_required=True,
        help=(
            "Nome do Município de envio da GTV-e (de onde o documento foi "
            "transmitido)\nInformar PAIS/Municipio para as operações com o "
            "exterior."
        ),
    )

    cte40_UFEnv = fields.Selection(
        TUF,
        string="Sigla da UF de envio da GTV-e",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF de envio da GTV-e (de onde o documento foi "
            "transmitido)\nInformar 'EX' para operações com o exterior."
        ),
    )

    cte40_modal = fields.Selection(
        IDE_MODAL,
        string="Modal da GTV-e",
        xsd_required=True,
        help=("Modal da GTV-e\nPreencher com:\n01-Rodoviário \n06-Multimodal"),
    )

    cte40_tpServ = fields.Selection(
        IDE_TPSERV,
        string="Tipo do Serviço",
        xsd_required=True,
        help="Tipo do Serviço\nPreencher com: \n\n9 - GTV",
    )

    cte40_indIEToma = fields.Selection(
        IDE_INDIETOMA,
        string="Indicador da IE do tomador",
        xsd_required=True,
        help=(
            "Indicador da IE do tomador:\n1 – Contribuinte ICMS;\n2 – "
            "Contribuinte isento de inscrição;\n9 – Não Contribuinte\nAplica-"
            "se ao tomador que for indicado no toma3 ou toma4"
        ),
    )

    cte40_dhSaidaOrig = fields.Char(
        string="Data e hora de saida da origem",
        xsd_required=True,
        help=("Data e hora de saida da origem\nFormato AAAA-MM-DDTHH:MM:DD TZD"),
    )

    cte40_dhChegadaDest = fields.Char(
        string="Data e hora de chegada no destino",
        xsd_required=True,
        help=("Data e hora de chegada no destino\nFormato AAAA-MM-DDTHH:MM:DD " "TZD"),
    )

    cte40_toma = fields.Many2one(
        comodel_name="cte.40.tgtve_toma",
        string="Indicador do 'papel' do tomador",
        choice="ide",
        xsd_choice_required=True,
        help="Indicador do 'papel' do tomador do serviço no GT-e",
    )

    cte40_tomaTerceiro = fields.Many2one(
        comodel_name="cte.40.tomaterceiro",
        string="tomaTerceiro",
        choice="ide",
        xsd_choice_required=True,
        help="Indicador do 'papel' do tomador do serviço no CTV-e",
    )

    cte40_dhCont = fields.Datetime(
        string="Data e Hora da entrada em contingência",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora da entrada em contingência\nInformar a data e hora no"
            " formato AAAA-MM-DDTHH:MM:SS"
        ),
    )

    cte40_xJust = fields.Char(string="Justificativa da entrada em contingência")


class TgtveToma(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no GT-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_toma"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Ide.Toma"

    cte40_toma = fields.Selection(
        TOMA_TOMA,
        string="Tomador do Serviço",
        xsd_required=True,
        help=(
            "Tomador do Serviço\nPreencher com:\n               0-Remetente;\n"
            "               1-Destinatário"
        ),
    )


class TomaTerceiro(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no CTV-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tomaterceiro"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Ide.TomaTerceiro"

    cte40_toma = fields.Selection(
        TOMATERCEIRO_TOMA,
        string="Tomador do Serviço",
        xsd_required=True,
        help=(
            "Tomador do Serviço\nPreencher com: \n               4 - Outros\n"
            "               Obs: Informar os dados cadastrais do tomador do "
            "serviço"
        ),
    )

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="tomaterceiro",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="tomaterceiro",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do tomador ou ISENTO se tomador"
            " é contribuinte do ICMS isento de inscrição no cadastro de "
            "contribuintes do ICMS. Caso o tomador não seja contribuinte do "
            "ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_xFant = fields.Char(string="Nome Fantasia")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderToma = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class TgtveCompl(models.AbstractModel):
    "Dados complementares da GTV-e para fins operacionais ou comerciais"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_compl"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Compl"

    cte40_xCaracAd = fields.Char(
        string="Característica adicional do transporte",
        help=(
            "Característica adicional do transporte\nTexto livre:\nREENTREGA; "
            "DEVOLUÇÃO; REFATURAMENTO; etc"
        ),
    )

    cte40_xCaracSer = fields.Char(
        string="Característica adicional do serviço",
        help=(
            "Característica adicional do serviço\nTexto "
            "livre:\n\t\t\t\t\t\t\t\t\t\t\tENTREGA EXPRESSA; LOGÍSTICA "
            "REVERSA; CONVENCIONAL; EMERGENCIAL; etc"
        ),
    )

    cte40_xEmi = fields.Char(string="Funcionário emissor da GTV-e")

    cte40_xObs = fields.Char(string="Observações Gerais")

    cte40_obsCont = fields.One2many(
        "cte.40.tgtve_obscont",
        "cte40_ObsCont_compl_id",
        string="Campo de uso livre do contribuinte",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )

    cte40_obsFisco = fields.One2many(
        "cte.40.tgtve_obsfisco",
        "cte40_ObsFisco_compl_id",
        string="ObsFisco",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )


class TgtveObsCont(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_obscont"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Compl.ObsCont"

    cte40_ObsCont_compl_id = fields.Many2one(
        comodel_name="cte.40.tgtve_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TgtveObsFisco(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_obsfisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Compl.ObsFisco"

    cte40_ObsFisco_compl_id = fields.Many2one(
        comodel_name="cte.40.tgtve_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TgtveEmit(models.AbstractModel):
    "Identificação do Emitente da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_emit"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Emit"

    cte40_CNPJ = fields.Char(
        string="CNPJ do emitente",
        xsd_required=True,
        xsd_type="TCnpj",
        help="CNPJ do emitente\nInformar zeros não significativos",
    )

    cte40_IE = fields.Char(string="Inscrição Estadual do Emitente", xsd_required=True)

    cte40_IEST = fields.Char(
        string="Inscrição Estadual", help="Inscrição Estadual do Substituto Tributário"
    )

    cte40_xNome = fields.Char(
        string="Razão social ou Nome do emitente", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_enderEmit = fields.Many2one(
        comodel_name="cte.40.tendeemi",
        string="Endereço do emitente",
        xsd_required=True,
        xsd_type="TEndeEmi",
    )


class TgtveRem(models.AbstractModel):
    """Informações do Remetente
    Poderá não ser informado para os CT-e de redespacho intermediário e serviço
    vinculado a multimodal. Nos demais casos deverá sempre ser informado."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_rem"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Rem"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do remetente ou ISENTO se "
            "remetente é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o remetente não seja contribuinte "
            "do ICMS não informar a tag."
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão social ou nome do remetente", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderReme = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email")


class TgtveDest(models.AbstractModel):
    """Informações do Destinatário
    Poderá não ser informado para os CT-e de redespacho intermediário e serviço
    vinculado a multimodal. Nos demais casos deverá sempre ser informado."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_dest"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.Dest"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do destinatário ou ISENTO se "
            "destinatário é contribuinte do ICMS isento de inscrição no "
            "cadastro de contribuintes do ICMS. Caso o destinatário não seja "
            "contribuinte do ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão Social ou Nome do destinatário", xsd_required=True
    )

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_ISUF = fields.Char(
        string="Inscrição na SUFRAMA",
        help=(
            "Inscrição na SUFRAMA\n(Obrigatório nas operações com as áreas com"
            " benefícios de incentivos fiscais sob controle da SUFRAMA)"
        ),
    )

    cte40_enderDest = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class DetGtv(models.AbstractModel):
    "Grupo de informações detalhadas da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.detgtv"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.DetGtv"

    cte40_infEspecie = fields.One2many(
        "cte.40.tgtve_infespecie",
        "cte40_infEspecie_detGTV_id",
        string="Informações das Espécies transportadas",
    )

    cte40_qCarga = fields.Float(
        string="Quantidade de volumes/malotes",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )

    cte40_infVeiculo = fields.One2many(
        "cte.40.infveiculo",
        "cte40_infVeiculo_detGTV_id",
        string="Grupo de informações",
        help=(
            "Grupo de informações dos veículos utilizados no transporte de " "valores"
        ),
    )


class TgtveInfEspecie(models.AbstractModel):
    "Informações das Espécies transportadas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_infespecie"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.DetGtv.InfEspecie"

    cte40_infEspecie_detGTV_id = fields.Many2one(
        comodel_name="cte.40.detgtv", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpEspecie = fields.Selection(
        INFESPECIE_TPESPECIE,
        string="Tipo da Espécie",
        xsd_required=True,
        help=("Tipo da Espécie\n1 - Cédula\n2 - Cheque\n3 - Moeda\n4 - Outros"),
    )

    cte40_vEspecie = fields.Monetary(
        string="Valor Transportada em Espécie indicada",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_tpNumerario = fields.Selection(
        INFESPECIE_TPNUMERARIO,
        string="Nacionalidade do Numerário",
        xsd_required=True,
        help="Nacionalidade do Numerário\n1 - Nacional\n2 - Estrangeiro",
    )

    cte40_xMoedaEstr = fields.Char(
        string="Nome da Moeda",
        help=(
            "Nome da Moeda\nInformar somente se tipo de numerário for 2 - "
            "Estrangeiro"
        ),
    )


class InfVeiculo(models.AbstractModel):
    """Grupo de informações dos veículos utilizados no transporte de valores"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infveiculo"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.DetGtv.InfVeiculo"

    cte40_infVeiculo_detGTV_id = fields.Many2one(
        comodel_name="cte.40.detgtv", xsd_implicit=True, ondelete="cascade"
    )
    cte40_placa = fields.Char(
        string="Placa do veículo", xsd_required=True, xsd_type="TPlaca"
    )

    cte40_UF = fields.Selection(
        TUF,
        string="UF em que veículo está licenciado",
        xsd_type="TUf",
        help=(
            "UF em que veículo está licenciado\nSigla da UF de licenciamento "
            "do veículo."
        ),
    )

    cte40_RNTRC = fields.Char(string="RNTRC do transportador")


class TgtveAutXml(models.AbstractModel):
    """Autorizados para download do XML do DF-e
    Informar CNPJ ou CPF. Preencher os zeros não significativos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_autxml"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCte.AutXml"

    cte40_autXML_infCte_id = fields.Many2one(
        comodel_name="cte.40.tgtve_infcte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_CNPJ = fields.Char(
        string="CNPJ do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do autorizado\nInformar zeros não significativos",
    )

    cte40_CPF = fields.Char(
        string="CPF do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="CPF do autorizado\nInformar zeros não significativos",
    )


class TgtveInfCteSupl(models.AbstractModel):
    "Informações suplementares da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tgtve_infctesupl"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tgtve.InfCteSupl"

    cte40_qrCodCTe = fields.Char(
        string="Texto com o QR-Code impresso no DACTE", xsd_required=True
    )


class TretCte(models.AbstractModel):
    "Tipo Retorno do Pedido de Autorização de CT-e (Modelo 57)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretCte"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Identificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a CT-e",
    )

    cte40_cStat = fields.Char(
        string="código do status do retorno da consulta",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do do retorno da consulta.",
    )

    cte40_protCTe = fields.Many2one(
        comodel_name="cte.40.tprotcte",
        string="Reposta ao processamento do CT-e",
        xsd_type="TProtCTe",
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerCTe")


class TretCteOs(models.AbstractModel):
    "Tipo Retorno do Pedido de Autorização de CT-e OS (Modelo 67)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretcteos"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretCteOs"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Identificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a CT-e",
    )

    cte40_cStat = fields.Char(
        string="código do status do retorno da consulta",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do do retorno da consulta.",
    )

    cte40_protCTe = fields.Many2one(
        comodel_name="cte.40.tprotcteos",
        string="Reposta ao processamento do CT-e",
        xsd_type="TProtCTeOS",
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerCTe")


class TretGtve(models.AbstractModel):
    "Tipo Retorno do Pedido de Autorização de GTV-e (Modelo 64)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretgtve"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretGtve"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Identificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a GTV-e",
    )

    cte40_cStat = fields.Char(
        string="código do status do retorno da consulta",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do do retorno da consulta.",
    )

    cte40_protCTe = fields.Many2one(
        comodel_name="cte.40.tprotgtve",
        string="Reposta ao processamento do CT-e",
        xsd_type="TProtGTVe",
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerCTe")


class TunidadeTransp(models.AbstractModel):
    "Tipo Dados Unidade de Transporte"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tunidadetransp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TunidadeTransp"

    cte40_infUnidTransp_infNF_id = fields.Many2one(
        comodel_name="cte.40.tcte_infnf", xsd_implicit=True, ondelete="cascade"
    )
    cte40_infUnidTransp_infNFe_id = fields.Many2one(
        comodel_name="cte.40.tcte_infnfe", xsd_implicit=True, ondelete="cascade"
    )
    cte40_infUnidTransp_infOutros_id = fields.Many2one(
        comodel_name="cte.40.infoutros", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpUnidTransp = fields.Selection(
        TTIPOUNIDTRANSP,
        string="Tipo da Unidade de Transporte",
        xsd_required=True,
        xsd_type="TtipoUnidTransp",
        help=(
            "Tipo da Unidade de Transporte\n1 - Rodoviário Tração\n2 - "
            "Rodoviário Reboque\n3 - Navio\n4 - Balsa\n5 - Aeronave\n6 - "
            "Vagão\n7 - Outros"
        ),
    )

    cte40_idUnidTransp = fields.Char(
        string="Identificação da Unidade de Transporte",
        xsd_required=True,
        xsd_type="TContainer",
        help=(
            "Identificação da Unidade de Transporte\nInformar a identificação "
            "conforme o tipo de unidade de transporte.\nPor exemplo: para "
            "rodoviário tração ou reboque deverá preencher com a placa do "
            "veículo."
        ),
    )

    cte40_lacUnidTransp = fields.One2many(
        "cte.40.lacunidtransp",
        "cte40_lacUnidTransp_TUnidadeTransp_id",
        string="Lacres das Unidades de Transporte",
    )

    cte40_infUnidCarga = fields.One2many(
        "cte.40.tunidcarga",
        "cte40_infUnidCarga_TUnidadeTransp_id",
        string="Informações das Unidades de Carga",
        xsd_type="TUnidCarga",
        help=(
            "Informações das Unidades de Carga "
            "(Containeres/ULD/Outros)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    cte40_qtdRat = fields.Monetary(
        string="Quantidade rateada (Peso,Volume)",
        xsd_type="TDec_0302_0303",
        currency_field="brl_currency_id",
    )


class LacUnidTransp(models.AbstractModel):
    "Lacres das Unidades de Transporte"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.lacunidtransp"
    _inherit = "spec.mixin.cte"
    _binding_type = "TunidadeTransp.LacUnidTransp"

    cte40_lacUnidTransp_TUnidadeTransp_id = fields.Many2one(
        comodel_name="cte.40.tunidadetransp", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nLacre = fields.Char(string="Número do lacre", xsd_required=True)


class Tcte(models.AbstractModel):
    "Tipo Conhecimento de Transporte Eletrônico (Modelo 57)"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte"

    cte40_infCte = fields.Many2one(
        comodel_name="cte.40.tcte_infcte",
        string="Informações do CT-e",
        xsd_required=True,
    )

    cte40_infCTeSupl = fields.Many2one(
        comodel_name="cte.40.tcte_infctesupl",
        string="Informações suplementares do CT-e",
    )


class TcteInfCte(models.AbstractModel):
    "Informações do CT-e do tipo GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte"

    cte40_ide = fields.Many2one(
        comodel_name="cte.40.tcte_ide",
        string="Identificação do CT-e",
        xsd_required=True,
    )

    cte40_compl = fields.Many2one(
        comodel_name="cte.40.tcte_compl",
        string="Dados complementares do CT-e",
        help=("Dados complementares do CT-e para fins operacionais ou comerciais"),
    )

    cte40_emit = fields.Many2one(
        comodel_name="cte.40.tcte_emit",
        string="Identificação do Emitente do CT-e",
        xsd_required=True,
    )

    cte40_rem = fields.Many2one(
        comodel_name="cte.40.tcte_rem",
        string="Informações do Remetente",
        help=(
            "Informações do Remetente das mercadorias transportadas pelo "
            "CT-e\nPoderá não ser informado para os CT-e de redespacho "
            "intermediário e serviço vinculado a multimodal. Nos demais casos "
            "deverá sempre ser informado."
        ),
    )

    cte40_exped = fields.Many2one(
        comodel_name="cte.40.exped", string="Informações do Expedidor da Carga"
    )

    cte40_receb = fields.Many2one(
        comodel_name="cte.40.receb", string="Informações do Recebedor da Carga"
    )

    cte40_dest = fields.Many2one(
        comodel_name="cte.40.tcte_dest",
        string="Informações do Destinatário do CT-e",
        help=(
            "Informações do Destinatário do CT-e\nPoderá não ser informado "
            "para os CT-e de redespacho intermediário e serviço vinculado a "
            "multimodal. Nos demais casos deverá sempre ser informado."
        ),
    )

    cte40_vPrest = fields.Many2one(
        comodel_name="cte.40.tcte_vprest",
        string="Valores da Prestação de Serviço",
        xsd_required=True,
    )

    cte40_imp = fields.Many2one(
        comodel_name="cte.40.tcte_imp",
        string="Informações relativas aos Impostos",
        xsd_required=True,
    )

    cte40_infCTeNorm = fields.Many2one(
        comodel_name="cte.40.tcte_infctenorm",
        string="Grupo de informações do CT-e Normal",
        choice="infcte",
        xsd_choice_required=True,
        help="Grupo de informações do CT-e Normal e Substituto",
    )

    cte40_infCteComp = fields.One2many(
        "cte.40.tcte_infctecomp",
        "cte40_infCteComp_infCte_id",
        string="Detalhamento do CT-e complementado",
        choice="infcte",
        xsd_choice_required=True,
    )

    cte40_autXML = fields.One2many(
        "cte.40.tcte_autxml",
        "cte40_autXML_infCte_id",
        string="Autorizados para download do XML do DF-e",
        help=(
            "Autorizados para download do XML do DF-e\nInformar CNPJ ou CPF. "
            "Preencher os zeros não significativos."
        ),
    )

    cte40_infRespTec = fields.Many2one(
        comodel_name="cte.40.tresptec",
        string="Informações do Responsável Técnico",
        xsd_type="TRespTec",
        help="Informações do Responsável Técnico pela emissão do DF-e",
    )

    cte40_infSolicNFF = fields.Many2one(
        comodel_name="cte.40.tcte_infsolicnff",
        string="Grupo de informações do pedido",
        help=("Grupo de informações do pedido de emissão da Nota Fiscal Fácil"),
    )

    cte40_infPAA = fields.Many2one(
        comodel_name="cte.40.tcte_infpaa",
        string="Grupo de Informação do Provedor",
        help="Grupo de Informação do Provedor de Assinatura e Autorização",
    )

    cte40_versao = fields.Char(
        string="Versão do leiaute",
        xsd_required=True,
        help="Versão do leiaute\nEx: '4.00'",
    )

    cte40_Id = fields.Char(
        string="Identificador da tag a ser assinada",
        xsd_required=True,
        help=(
            "Identificador da tag a ser assinada\nInformar a chave de acesso "
            "do CT-e e precedida do literal 'CTe'"
        ),
    )


class TcteIde(models.AbstractModel):
    "Identificação da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_ide"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Ide"

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF do emitente do CT-e",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
        help=("Código da UF do emitente do CT-e.\nUtilizar a Tabela do IBGE."),
    )

    cte40_cCT = fields.Char(
        string="Código numérico que compõe a Chave",
        xsd_required=True,
        help=(
            "Código numérico que compõe a Chave de Acesso.\nNúmero aleatório "
            "gerado pelo emitente para cada CT-e, com o objetivo de evitar "
            "acessos indevidos ao documento."
        ),
    )

    cte40_CFOP = fields.Char(
        string="Código Fiscal de Operações e Prestações",
        xsd_required=True,
        xsd_type="TCfop",
    )

    cte40_natOp = fields.Char(string="Natureza da Operação", xsd_required=True)

    cte40_mod = fields.Selection(
        TMODCT,
        string="Modelo do documento fiscal",
        xsd_required=True,
        xsd_type="TModGTVe",
        help=(
            "Modelo do documento fiscal\nUtilizar o código 57 para "
            "identificação do CT-e, emitido em substituição aos modelos de "
            "conhecimentos em papel."
        ),
    )

    cte40_serie = fields.Char(
        string="Série do CT-e",
        xsd_required=True,
        help="Série do CT-e\nPreencher com '0' no caso de série única",
    )

    cte40_nCT = fields.Char(string="Número do CT-e", xsd_required=True, xsd_type="TNF")

    cte40_dhEmi = fields.Char(
        string="Data e hora de emissão do CT-e",
        xsd_required=True,
        help=("Data e hora de emissão do CT-e\nFormato AAAA-MM-DDTHH:MM:DD TZD"),
    )

    cte40_tpImp = fields.Selection(
        IDE_TPIMP,
        string="Formato de impressão do DACTE",
        xsd_required=True,
        help=(
            "Formato de impressão do DACTE\nPreencher com: 1 - Retrato; 2 - "
            "Paisagem."
        ),
    )

    cte40_tpEmis = fields.Selection(
        IDE_TPEMIS,
        string="Forma de emissão do CT-e",
        xsd_required=True,
        help=(
            "Forma de emissão do CT-e\nPreencher com:\n1 - Normal;\n 3-Regime "
            "Especial NFF;  4-EPEC pela SVC; 5 - Contingência FSDA;\n\t7 - "
            "Autorização pela SVC-RS;\n  8 - Autorização pela SVC-SP"
        ),
    )

    cte40_cDV = fields.Char(
        string="Digito Verificador da chave de acesso",
        xsd_required=True,
        help=(
            "Digito Verificador da chave de acesso do CT-e\nInformar o dígito"
            "  de controle da chave de acesso do CT-e, que deve ser calculado "
            "com a aplicação do algoritmo módulo 11 (base 2,9) da chave de "
            "acesso."
        ),
    )

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Tipo do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help=("Tipo do Ambiente\nPreencher com:1 - Produção; 2 - Homologação."),
    )

    cte40_tpCTe = fields.Selection(
        TFINCTE,
        string="Tipo do CT-e",
        xsd_required=True,
        help=(
            "Tipo do CT-e\nPreencher com:\n\t0 - CT-e Normal;\n 1 - CT-e de "
            "Complemento de Valores;\n 3 - CT-e de Substituição"
        ),
    )

    cte40_procEmi = fields.Selection(
        TPROCEMI,
        string="Identificador do processo de emissão",
        xsd_required=True,
        xsd_type="TProcEmi",
        help=(
            "Identificador do processo de emissão do CT-e\nPreencher com: "
            "\n\t\t\t\t\t\t\t\t\t\t\t0 - emissão de CT-e com aplicativo do "
            "contribuinte;\n\t\t\t\t\t\t\t\t\t\t\t3- emissão CT-e pelo "
            "contribuinte com aplicativo fornecido pelo SEBRAE."
        ),
    )

    cte40_verProc = fields.Char(
        string="Versão do processo de emissão",
        xsd_required=True,
        help=(
            "Versão do processo de emissão\nIinformar a versão do aplicativo "
            "emissor de CT-e."
        ),
    )

    cte40_indGlobalizado = fields.Selection(
        IDE_INDGLOBALIZADO,
        string="Indicador de CT-e Globalizado",
        help=(
            "Indicador de CT-e Globalizado\nInformar valor 1 quando for "
            "Globalizado e não informar a tag quando não tratar de CT-e "
            "Globalizado"
        ),
    )

    cte40_cMunEnv = fields.Char(
        string="Código do Município de envio do CT-e",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de envio do CT-e (de onde o documento foi "
            "transmitido)\nUtilizar a tabela do IBGE. Informar 9999999 para as"
            " operações com o exterior."
        ),
    )

    cte40_xMunEnv = fields.Char(
        string="Nome do Município de envio do CT-e",
        xsd_required=True,
        help=(
            "Nome do Município de envio do CT-e (de onde o documento foi "
            "transmitido)\nInformar PAIS/Municipio para as operações com o "
            "exterior."
        ),
    )

    cte40_UFEnv = fields.Selection(
        TUF,
        string="Sigla da UF de envio do CT-e",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "Sigla da UF de envio do CT-e (de onde o documento foi "
            "transmitido)\nInformar 'EX' para operações com o exterior."
        ),
    )

    cte40_modal = fields.Selection(
        TMODTRANSP,
        string="Modal",
        xsd_required=True,
        help=(
            "Modal\nPreencher com:01-Rodoviário;\n02-Aéreo;03-Aquaviário;04-"
            "Ferroviário;05-Dutoviário;06-Multimodal;"
        ),
    )

    cte40_tpServ = fields.Selection(
        IDE_TPSERV,
        string="Tipo do Serviço",
        xsd_required=True,
        help=(
            "Tipo do Serviço\nPreencher com: \n0 - Normal;1 - "
            "Subcontratação;\n2 - Redespacho;3 - Redespacho Intermediário; 4 -"
            " Serviço Vinculado a Multimodal"
        ),
    )

    cte40_cMunIni = fields.Char(
        string="Código do Município de início",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de início da prestação\nUtilizar a tabela do "
            "IBGE. Informar 9999999 para operações com o exterior."
        ),
    )

    cte40_xMunIni = fields.Char(
        string="Nome do Município do início da prestação",
        xsd_required=True,
        help=(
            "Nome do Município do início da prestação\nInformar 'EXTERIOR' "
            "para operações com o exterior."
        ),
    )

    cte40_UFIni = fields.Selection(
        TUF,
        string="UF do início da prestação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "UF do início da prestação\nInformar 'EX' para operações com o " "exterior."
        ),
    )

    cte40_cMunFim = fields.Char(
        string="Código do Município de término",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do Município de término da prestação\nUtilizar a tabela do"
            " IBGE. Informar 9999999 para operações com o exterior."
        ),
    )

    cte40_xMunFim = fields.Char(
        string="Nome do Município do término",
        xsd_required=True,
        help=(
            "Nome do Município do término da prestação\nInformar 'EXTERIOR' "
            "para operações com o exterior."
        ),
    )

    cte40_UFFim = fields.Selection(
        TUF,
        string="UF do término da prestação",
        xsd_required=True,
        xsd_type="TUf",
        help=(
            "UF do término da prestação\nInformar 'EX' para operações com o "
            "exterior."
        ),
    )

    cte40_retira = fields.Selection(
        IDE_RETIRA,
        string="Indicador se o Recebedor retira",
        xsd_required=True,
        help=(
            "Indicador se o Recebedor retira no Aeroporto, Filial, Porto ou "
            "Estação de Destino?\nPreencher com: 0 - sim; 1 - não"
        ),
    )

    cte40_xDetRetira = fields.Char(string="Detalhes do retira")

    cte40_indIEToma = fields.Selection(
        IDE_INDIETOMA,
        string="Indicador do papel do tomador",
        xsd_required=True,
        help=(
            "Indicador do papel do tomador na prestação do serviço:\n1 – "
            "Contribuinte ICMS;\n2 – Contribuinte isento de inscrição;\n9 – "
            "Não Contribuinte\nAplica-se ao tomador que for indicado no toma3 "
            "ou toma4"
        ),
    )

    cte40_toma3 = fields.Many2one(
        comodel_name="cte.40.toma3",
        string="Indicador do 'papel' do tomador",
        choice="ide",
        xsd_choice_required=True,
        help="Indicador do 'papel' do tomador do serviço no CT-e",
    )

    cte40_toma4 = fields.Many2one(
        comodel_name="cte.40.tcte_toma4",
        string="Indicador do 'papel' do tomador (toma4)",
        choice="ide",
        xsd_choice_required=True,
        help="Indicador do 'papel' do tomador do serviço no CT-e",
    )

    cte40_dhCont = fields.Datetime(
        string="Data e Hora da entrada em contingência",
        xsd_type="TDateTimeUTC",
        help=(
            "Data e Hora da entrada em contingência\nInformar a data e hora no"
            " formato AAAA-MM-DDTHH:MM:SS"
        ),
    )

    cte40_xJust = fields.Char(string="Justificativa da entrada em contingência")


class Toma3(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no CT-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.toma3"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Ide.Toma3"

    cte40_toma = fields.Selection(
        TOMA3_TOMA,
        string="Tomador do Serviço",
        xsd_required=True,
        help=(
            "Tomador do Serviço\nPreencher com:\n               0-Remetente;\n"
            "               1-Expedidor;\n               2-Recebedor;\n"
            "               3-Destinatário\n               Serão utilizadas as"
            " informações contidas no respectivo grupo, conforme indicado pelo"
            " conteúdo deste campo"
        ),
    )


class TcteToma4(models.AbstractModel):
    """Indicador do "papel" do tomador do serviço no CT-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_toma4"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Ide.Toma4"

    cte40_toma = fields.Selection(
        TOMA4_TOMA,
        string="Tomador do Serviço",
        xsd_required=True,
        help=(
            "Tomador do Serviço\nPreencher com: \n               4 - Outros\n"
            "               Obs: Informar os dados cadastrais do tomador do "
            "serviço"
        ),
    )

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="toma4",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="toma4",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        xsd_type="TIeDest",
        help=(
            "Inscrição Estadual\nInformar a IE do tomador ou ISENTO se tomador"
            " é contribuinte do ICMS isento de inscrição no cadastro de "
            "contribuintes do ICMS. Caso o tomador não seja contribuinte do "
            "ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_xFant = fields.Char(string="Nome Fantasia")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderToma = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class TcteCompl(models.AbstractModel):
    "Dados complementares da GTV-e para fins operacionais ou comerciais"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_compl"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl"

    cte40_xCaracAd = fields.Char(
        string="Característica adicional do transporte",
        help=(
            "Característica adicional do transporte\nTexto livre:\nREENTREGA; "
            "DEVOLUÇÃO; REFATURAMENTO; etc"
        ),
    )

    cte40_xCaracSer = fields.Char(
        string="Característica adicional do serviço",
        help=(
            "Característica adicional do serviço\nTexto "
            "livre:\n\t\t\t\t\t\t\t\t\t\t\tENTREGA EXPRESSA; LOGÍSTICA "
            "REVERSA; CONVENCIONAL; EMERGENCIAL; etc"
        ),
    )

    cte40_xEmi = fields.Char(string="Funcionário emissor do CTe")

    cte40_fluxo = fields.Many2one(
        comodel_name="cte.40.fluxo",
        string="Previsão do fluxo da carga",
        help=(
            "Previsão do fluxo da carga\nPreenchimento obrigatório para o "
            "modal aéreo."
        ),
    )

    cte40_entrega = fields.Many2one(
        comodel_name="cte.40.entrega",
        string="Informações ref",
        help="Informações ref. a previsão de entrega",
    )

    cte40_origCalc = fields.Char(
        string="Município de origem para efeito",
        help="Município de origem para efeito de cálculo do frete",
    )

    cte40_destCalc = fields.Char(
        string="Município de destino para efeito",
        help="Município de destino para efeito de cálculo do frete",
    )

    cte40_xObs = fields.Char(string="Observações Gerais")

    cte40_obsCont = fields.One2many(
        "cte.40.tcte_obscont",
        "cte40_ObsCont_compl_id",
        string="Campo de uso livre do contribuinte",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )

    cte40_obsFisco = fields.One2many(
        "cte.40.tcte_obsfisco",
        "cte40_ObsFisco_compl_id",
        string="ObsFisco",
        help=(
            "Campo de uso livre do contribuinte\nInformar o nome do campo no "
            "atributo xCampo e o conteúdo do campo no XTexto"
        ),
    )


class Fluxo(models.AbstractModel):
    """Previsão do fluxo da carga
    Preenchimento obrigatório para o modal aéreo."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.fluxo"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Fluxo"

    cte40_xOrig = fields.Char(
        string="Sigla ou código interno",
        help=(
            "Sigla ou código interno da Filial/Porto/Estação/ Aeroporto de "
            "Origem\nObservações para o modal "
            "aéreo:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t- Preenchimento obrigatório "
            "para o modal aéreo.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t- O código de "
            "três letras IATA do aeroporto de partida deverá ser incluído como"
            " primeira anotação. Quando não for possível, utilizar a sigla "
            "OACI."
        ),
    )

    cte40_pass = fields.One2many("cte.40.pass", "cte40_pass_fluxo_id", string="pass")

    cte40_xDest = fields.Char(
        string="Sigla ou código interno (xDest)",
        help=(
            "Sigla ou código interno da Filial/Porto/Estação/Aeroporto de "
            "Destino\nObservações para o modal "
            "aéreo:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t- Preenchimento obrigatório "
            "para o modal aéreo.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t- Deverá ser "
            "incluído o código de três letras IATA do aeroporto de destino. "
            "Quando não for possível, utilizar a sigla OACI."
        ),
    )

    cte40_xRota = fields.Char(string="Código da Rota de Entrega")


class Pass(models.AbstractModel):
    _description = "pass"
    _name = "cte.40.pass"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Fluxo.Pass"

    cte40_pass_fluxo_id = fields.Many2one(
        comodel_name="cte.40.fluxo", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xPass = fields.Char(
        string="Sigla ou código interno",
        help=(
            "Sigla ou código interno da Filial/Porto/Estação/Aeroporto de "
            "Passagem\nObservação para o modal "
            "aéreo:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t- O código de três "
            "letras IATA, referente ao aeroporto de transferência, deverá ser "
            "incluído, quando for o caso. Quando não for possível,  utilizar a"
            " sigla OACI. Qualquer solicitação de itinerário deverá ser "
            "incluída."
        ),
    )


class Entrega(models.AbstractModel):
    "Informações ref. a previsão de entrega"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.entrega"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega"

    cte40_semData = fields.Many2one(
        comodel_name="cte.40.semdata",
        string="Entrega sem data definida",
        choice="entrega",
        xsd_choice_required=True,
        help=(
            "Entrega sem data definida\nEsta opção é proibida para o modal " "aéreo."
        ),
    )

    cte40_comData = fields.Many2one(
        comodel_name="cte.40.comdata",
        string="Entrega com data definida",
        choice="entrega",
        xsd_choice_required=True,
    )

    cte40_noPeriodo = fields.Many2one(
        comodel_name="cte.40.noperiodo",
        string="Entrega no período definido",
        choice="entrega",
        xsd_choice_required=True,
    )

    cte40_semHora = fields.Many2one(
        comodel_name="cte.40.semhora",
        string="Entrega sem hora definida",
        choice="entrega",
        xsd_choice_required=True,
    )

    cte40_comHora = fields.Many2one(
        comodel_name="cte.40.comhora",
        string="Entrega com hora definida",
        choice="entrega",
        xsd_choice_required=True,
    )

    cte40_noInter = fields.Many2one(
        comodel_name="cte.40.nointer",
        string="Entrega no intervalo de horário definido",
        choice="entrega",
        xsd_choice_required=True,
    )


class SemData(models.AbstractModel):
    """Entrega sem data definida
    Esta opção é proibida para o modal aéreo."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.semdata"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.SemData"

    cte40_tpPer = fields.Selection(
        SEMDATA_TPPER,
        string="Tipo de data/período programado",
        xsd_required=True,
        help=("Tipo de data/período programado para entrega\n0- Sem data " "definida"),
    )


class ComData(models.AbstractModel):
    "Entrega com data definida"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.comdata"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.ComData"

    cte40_tpPer = fields.Selection(
        COMDATA_TPPER,
        string="Tipo de data/período programado",
        xsd_required=True,
        help=(
            "Tipo de data/período programado para entrega\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1-Na "
            "data;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t2-Até a "
            "data;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t3-A partir da data"
        ),
    )

    cte40_dProg = fields.Date(
        string="Data programada",
        xsd_required=True,
        xsd_type="TData",
        help="Data programada\nFormato AAAA-MM-DD",
    )


class NoPeriodo(models.AbstractModel):
    "Entrega no período definido"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.noperiodo"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.NoPeriodo"

    cte40_tpPer = fields.Selection(
        NOPERIODO_TPPER,
        string="Tipo período",
        xsd_required=True,
        help="Tipo período\n4-no período",
    )

    cte40_dIni = fields.Date(
        string="Data inicial",
        xsd_required=True,
        xsd_type="TData",
        help="Data inicial\nFormato AAAA-MM-DD",
    )

    cte40_dFim = fields.Date(
        string="Data final",
        xsd_required=True,
        xsd_type="TData",
        help="Data final\nFormato AAAA-MM-DD",
    )


class SemHora(models.AbstractModel):
    "Entrega sem hora definida"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.semhora"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.SemHora"

    cte40_tpHor = fields.Selection(
        SEMHORA_TPHOR,
        string="Tipo de hora",
        xsd_required=True,
        help="Tipo de hora\n0- Sem hora definida",
    )


class ComHora(models.AbstractModel):
    "Entrega com hora definida"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.comhora"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.ComHora"

    cte40_tpHor = fields.Selection(
        COMHORA_TPHOR,
        string="Tipo de hora",
        xsd_required=True,
        help=(
            "Tipo de hora\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1 - No "
            "horário;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t2 - Até o "
            "horário;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t3 - A partir do "
            "horário."
        ),
    )

    cte40_hProg = fields.Char(
        string="Hora programada",
        xsd_required=True,
        xsd_type="TTime",
        help="Hora programada\nFormato HH:MM:SS",
    )


class NoInter(models.AbstractModel):
    "Entrega no intervalo de horário definido"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.nointer"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.Entrega.NoInter"

    cte40_tpHor = fields.Selection(
        NOINTER_TPHOR,
        string="Tipo de hora",
        xsd_required=True,
        help="Tipo de hora\n4 - No intervalo de tempo",
    )

    cte40_hIni = fields.Char(
        string="Hora inicial",
        xsd_required=True,
        xsd_type="TTime",
        help="Hora inicial\nFormato HH:MM:SS",
    )

    cte40_hFim = fields.Char(
        string="Hora final",
        xsd_required=True,
        xsd_type="TTime",
        help="Hora final\nFormato HH:MM:SS",
    )


class TcteObsCont(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_obscont"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.ObsCont"

    cte40_ObsCont_compl_id = fields.Many2one(
        comodel_name="cte.40.tcte_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TcteObsFisco(models.AbstractModel):
    """Campo de uso livre do contribuinte
    Informar o nome do campo no atributo xCampo e o conteúdo do campo no XTexto"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_obsfisco"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Compl.ObsFisco"

    cte40_ObsFisco_compl_id = fields.Many2one(
        comodel_name="cte.40.tcte_compl", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xTexto = fields.Char(string="Conteúdo do campo", xsd_required=True)

    cte40_xCampo = fields.Char(string="Identificação do campo", xsd_required=True)


class TcteEmit(models.AbstractModel):
    "Identificação do Emitente da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_emit"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Emit"

    cte40_CNPJ = fields.Char(
        string="CNPJ do emitente",
        xsd_type="TCnpj",
        help="CNPJ do emitente\nInformar zeros não significativos",
    )

    cte40_CPF = fields.Char(
        string="CPF do emitente",
        choice="emit",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help=(
            "CPF do emitente\nInformar zeros não significativos.\n\nUsar com "
            "série específica 920-969 para emitente pessoa física com "
            "inscrição estadual"
        ),
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual do Emitente",
        help=(
            "Inscrição Estadual do Emitente\nA IE do emitente somente ficará "
            "sem informação para o caso do Regime Especial da NFF (tpEmis=3)"
        ),
    )

    cte40_IEST = fields.Char(
        string="Inscrição Estadual", help="Inscrição Estadual do Substituto Tributário"
    )

    cte40_xNome = fields.Char(
        string="Razão social ou Nome do emitente", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_enderEmit = fields.Many2one(
        comodel_name="cte.40.tendeemi",
        string="Endereço do emitente",
        xsd_required=True,
        xsd_type="TEndeEmi",
    )

    cte40_CRT = fields.Selection(
        TCRT,
        string="Código do Regime Tributário",
        xsd_required=True,
        xsd_type="TCRT",
        help=(
            "Código do Regime Tributário\nInformar: 1=Simples Nacional; "
            "\n2=Simples Nacional, excesso sublimite de receita "
            "bruta;\n3=Regime Normal. \n4=Simples Nacional - Microempreendedor"
            " Individual – MEI."
        ),
    )


class TcteRem(models.AbstractModel):
    """Informações do Remetente
    Poderá não ser informado para os CT-e de redespacho intermediário e serviço
    vinculado a multimodal. Nos demais casos deverá sempre ser informado."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_rem"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Rem"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="rem",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do remetente ou ISENTO se "
            "remetente é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o remetente não seja contribuinte "
            "do ICMS não informar a tag."
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão social ou nome do remetente", xsd_required=True
    )

    cte40_xFant = fields.Char(string="Nome fantasia")

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderReme = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email")


class Exped(models.AbstractModel):
    "Informações do Expedidor da Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.exped"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Exped"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="exped",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="exped",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do expedidor ou ISENTO se "
            "expedidor é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o expedidor não seja contribuinte "
            "do ICMS não informar a tag."
        ),
    )

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderExped = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class Receb(models.AbstractModel):
    "Informações do Recebedor da Carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.receb"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Receb"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="receb",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="receb",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do recebedor ou ISENTO se "
            "recebedor é contribuinte do ICMS isento de inscrição no cadastro "
            "de contribuintes do ICMS. Caso o recebedor não seja contribuinte "
            "do ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_enderReceb = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class TcteDest(models.AbstractModel):
    """Informações do Destinatário
    Poderá não ser informado para os CT-e de redespacho intermediário e serviço
    vinculado a multimodal. Nos demais casos deverá sempre ser informado."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_dest"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Dest"

    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros não "
            "significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="dest",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(
        string="Inscrição Estadual",
        help=(
            "Inscrição Estadual\nInformar a IE do destinatário ou ISENTO se "
            "destinatário é contribuinte do ICMS isento de inscrição no "
            "cadastro de contribuintes do ICMS. Caso o destinatário não seja "
            "contribuinte do ICMS não informar o conteúdo."
        ),
    )

    cte40_xNome = fields.Char(
        string="Razão Social ou Nome do destinatário", xsd_required=True
    )

    cte40_fone = fields.Char(string="Telefone", xsd_type="TFone")

    cte40_ISUF = fields.Char(
        string="Inscrição na SUFRAMA",
        help=(
            "Inscrição na SUFRAMA\n(Obrigatório nas operações com as áreas com"
            " benefícios de incentivos fiscais sob controle da SUFRAMA)"
        ),
    )

    cte40_enderDest = fields.Many2one(
        comodel_name="cte.40.tendereco",
        string="Dados do endereço",
        xsd_required=True,
        xsd_type="TEndereco",
    )

    cte40_email = fields.Char(string="Endereço de email", xsd_type="TEmail")


class TcteVPrest(models.AbstractModel):
    "Valores da Prestação de Serviço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_vprest"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.VPrest"

    cte40_vTPrest = fields.Monetary(
        string="Valor Total da Prestação do Serviço",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor Total da Prestação do Serviço\nPode conter zeros quando o "
            "CT-e for de complemento de ICMS"
        ),
    )

    cte40_vRec = fields.Monetary(
        string="Valor a Receber",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_comp = fields.One2many(
        "cte.40.tcte_vprest_comp",
        "cte40_Comp_vPrest_id",
        string="Componentes do Valor da Prestação",
    )


class TcteVPrestComp(models.AbstractModel):
    "Componentes do Valor da Prestação"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_vprest_comp"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.VPrest.Comp"

    cte40_Comp_vPrest_id = fields.Many2one(
        comodel_name="cte.40.tcte_vprest", xsd_implicit=True, ondelete="cascade"
    )
    cte40_xNome = fields.Char(
        string="Nome do componente",
        xsd_required=True,
        help=(
            "Nome do componente\nExxemplos: FRETE PESO, FRETE VALOR, SEC/CAT, "
            "ADEME, AGENDAMENTO, etc"
        ),
    )

    cte40_vComp = fields.Monetary(
        string="Valor do componente",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class TcteImp(models.AbstractModel):
    "Informações relativas aos Impostos"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_imp"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.Imp"

    cte40_ICMS = fields.Many2one(
        comodel_name="cte.40.timp",
        string="Informações relativas ao ICMS",
        xsd_required=True,
        xsd_type="TImp",
    )

    cte40_vTotTrib = fields.Monetary(
        string="Valor Total dos Tributos",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_infAdFisco = fields.Char(
        string="Informações adicionais de interesse",
        help=(
            "Informações adicionais de interesse do Fisco\nNorma referenciada,"
            " informações complementares, etc"
        ),
    )


class TcteAutXml(models.AbstractModel):
    """Autorizados para download do XML do DF-e
    Informar CNPJ ou CPF. Preencher os zeros não significativos."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_autxml"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.AutXml"

    cte40_autXML_infCte_id = fields.Many2one(
        comodel_name="cte.40.tcte_infcte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_CNPJ = fields.Char(
        string="CNPJ do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCnpj",
        help="CNPJ do autorizado\nInformar zeros não significativos",
    )

    cte40_CPF = fields.Char(
        string="CPF do autorizado",
        choice="autxml",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="CPF do autorizado\nInformar zeros não significativos",
    )


class TcteInfSolicNff(models.AbstractModel):
    "Grupo de informações do pedido de emissão da Nota Fiscal Fácil"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infsolicnff"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfSolicNff"

    cte40_xSolic = fields.Char(
        string="Solicitação do pedido de emissão da NFF",
        xsd_required=True,
        help=(
            "Solicitação do pedido de emissão da NFF.\nSerá preenchido com a "
            "totalidade de campos informados no aplicativo emissor "
            "serializado."
        ),
    )


class TcteInfPaa(models.AbstractModel):
    "Grupo de Informação do Provedor de Assinatura e Autorização"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infpaa"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfPaa"

    cte40_CNPJPAA = fields.Char(
        string="CNPJ do Provedor de Assinatura",
        xsd_required=True,
        xsd_type="TCnpj",
        help="CNPJ do Provedor de Assinatura e Autorização",
    )

    cte40_PAASignature = fields.Many2one(
        comodel_name="cte.40.tcte_paasignature",
        string="Assinatura RSA do Emitente",
        xsd_required=True,
        help="Assinatura RSA do Emitente para DFe gerados por PAA",
    )


class TctePaasignature(models.AbstractModel):
    "Assinatura RSA do Emitente para DFe gerados por PAA"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_paasignature"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfPaa.Paasignature"

    cte40_signatureValue = fields.Char(
        string="Assinatura digital padrão RSA",
        xsd_required=True,
        xsd_type="xs:base64Binary",
        help=(
            "Assinatura digital padrão RSA\nConverter o atributo Id do DFe "
            "para array de bytes e assinar com a chave privada do RSA com "
            "algoritmo SHA1 gerando um valor no formato base64."
        ),
    )

    cte40_RSAKeyValue = fields.Many2one(
        comodel_name="cte.40.trsakeyvaluetype",
        string="Chave Publica no padrão XML RSA Key",
        xsd_required=True,
        xsd_type="TRSAKeyValueType",
    )


class TcteInfCteNorm(models.AbstractModel):
    "Grupo de informações do CT-e Normal e Substituto"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infctenorm"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm"

    cte40_infCarga = fields.Many2one(
        comodel_name="cte.40.infcarga",
        string="Informações da Carga do CT-e",
        xsd_required=True,
    )

    cte40_infDoc = fields.Many2one(
        comodel_name="cte.40.tcte_infdoc",
        string="Informações dos documentos transportados",
        help=(
            "Informações dos documentos transportados pelo CT-e\nOpcional para"
            " Redespacho Intermediario e Serviço vinculado a "
            "multimodal.\nPoderá não ser informado para os CT-e de redespacho "
            "intermediário e serviço vinculado a multimodal. Nos demais casos "
            "deverá sempre ser informado."
        ),
    )

    cte40_docAnt = fields.Many2one(
        comodel_name="cte.40.docant", string="Documentos de Transporte Anterior"
    )

    cte40_infModal = fields.Many2one(
        comodel_name="cte.40.tcte_infmodal",
        string="Informações do modal",
        xsd_required=True,
    )

    cte40_veicNovos = fields.One2many(
        "cte.40.veicnovos",
        "cte40_veicNovos_infCTeNorm_id",
        string="informações dos veículos transportados",
    )

    cte40_cobr = fields.Many2one(
        comodel_name="cte.40.tcte_cobr", string="Dados da cobrança do CT-e"
    )

    cte40_infCteSub = fields.Many2one(
        comodel_name="cte.40.tcte_infctesub",
        string="Informações do CT-e de substituição",
    )

    cte40_infGlobalizado = fields.Many2one(
        comodel_name="cte.40.infglobalizado", string="Informações do CT-e Globalizado"
    )

    cte40_infServVinc = fields.Many2one(
        comodel_name="cte.40.infservvinc",
        string="Informações do Serviço Vinculado",
        help="Informações do Serviço Vinculado a Multimodal",
    )


class InfCarga(models.AbstractModel):
    "Informações da Carga do CT-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infcarga"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfCarga"

    cte40_vCarga = fields.Monetary(
        string="Valor total da carga",
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help=(
            "Valor total da carga\nDever ser informado para todos os modais, "
            "com exceção para o Dutoviário."
        ),
    )

    cte40_proPred = fields.Char(
        string="Produto predominante",
        xsd_required=True,
        help=("Produto predominante\nInformar a descrição do produto " "predominante"),
    )

    cte40_xOutCat = fields.Char(
        string="Outras características da carga",
        help=(
            "Outras características da carga\n'FRIA', 'GRANEL', 'REFRIGERADA',"
            " 'Medidas: 12X12X12'"
        ),
    )

    cte40_infQ = fields.One2many(
        "cte.40.tcte_infq",
        "cte40_infQ_infCarga_id",
        string="Informações de quantidades da Carga",
        help=(
            "Informações de quantidades da Carga do CT-e\nPara o Aéreo é "
            "obrigatório o preenchimento desse campo da seguinte forma.\n1 - "
            "Peso Bruto, sempre em quilogramas (obrigatório);\n2 - Peso "
            "Cubado; sempre em quilogramas;\n3 - Quantidade de volumes, sempre"
            " em unidades (obrigatório);\n4 - Cubagem, sempre em metros "
            "cúbicos (obrigatório apenas quando for impossível preencher as "
            "dimensões da(s) embalagem(ens) na tag xDime do leiaute do Aéreo)."
        ),
    )

    cte40_vCargaAverb = fields.Monetary(
        string="Valor da Carga para efeito de averbação",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
        help=(
            "Valor da Carga para efeito de averbação\nNormalmente igual ao "
            "valor declarado da mercadoria, diferente por exemplo, quando a "
            "mercadoria transportada é isenta de tributos nacionais para "
            "exportação, onde é preciso averbar um valor maior, pois no caso "
            "de indenização, o valor a ser pago será maior"
        ),
    )


class TcteInfQ(models.AbstractModel):
    """Informações de quantidades da Carga do CT-e
    Para o Aéreo é obrigatório o preenchimento desse campo da seguinte forma.
    1 - Peso Bruto, sempre em quilogramas (obrigatório);
    2 - Peso Cubado; sempre em quilogramas;
    3 - Quantidade de volumes, sempre em unidades (obrigatório);
    4 - Cubagem, sempre em metros cúbicos (obrigatório apenas quando for impossível
    preencher as dimensões da(s) embalagem(ens) na tag xDime do leiaute do
    Aéreo)."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infq"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfCarga.InfQ"

    cte40_infQ_infCarga_id = fields.Many2one(
        comodel_name="cte.40.infcarga", xsd_implicit=True, ondelete="cascade"
    )
    cte40_cUnid = fields.Selection(
        INFQ_CUNID,
        string="Código da Unidade de Medida",
        xsd_required=True,
        help=(
            "Código da Unidade de Medida\nPreencher com:\n\t\t\t\t\t\t\t\t\t\t"
            "\t\t\t\t\t\t\t\t00-M3;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t01-"
            "KG;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t02-"
            "TON;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t03-"
            "UNIDADE;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t04-"
            "LITROS;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t05-MMBTU"
        ),
    )

    cte40_tpMed = fields.Char(
        string="Tipo da Medida",
        xsd_required=True,
        help=(
            "Tipo da Medida\nExemplos:\nPESO BRUTO, PESO DECLARADO, PESO "
            "CUBADO, PESO AFORADO, PESO AFERIDO, PESO BASE DE CÁLCULO, "
            "LITRAGEM, CAIXAS e etc"
        ),
    )

    cte40_qCarga = fields.Float(
        string="Quantidade",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
    )


class TcteInfDoc(models.AbstractModel):
    """Informações dos documentos transportados pelo CT-e
    Opcional para Redespacho Intermediario e Serviço vinculado a multimodal.
    Poderá não ser informado para os CT-e de redespacho intermediário e serviço
    vinculado a multimodal. Nos demais casos deverá sempre ser informado."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infdoc"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfDoc"

    cte40_infNF = fields.One2many(
        "cte.40.tcte_infnf",
        "cte40_infNF_infDoc_id",
        string="Informações das NF",
        choice="infdoc",
        xsd_choice_required=True,
        help=(
            "Informações das NF\nEste grupo deve ser informado quando o "
            "documento originário for NF"
        ),
    )

    cte40_infNFe = fields.One2many(
        "cte.40.tcte_infnfe",
        "cte40_infNFe_infDoc_id",
        string="Informações das NF-e",
        choice="infdoc",
        xsd_choice_required=True,
    )

    cte40_infOutros = fields.One2many(
        "cte.40.infoutros",
        "cte40_infOutros_infDoc_id",
        string="Informações dos demais documentos",
        choice="infdoc",
        xsd_choice_required=True,
    )


class TcteInfNf(models.AbstractModel):
    """Informações das NF
    Este grupo deve ser informado quando o documento originário for NF"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infnf"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfDoc.InfNf"

    cte40_infNF_infDoc_id = fields.Many2one(
        comodel_name="cte.40.tcte_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nRoma = fields.Char(string="Número do Romaneio da NF")

    cte40_nPed = fields.Char(string="Número do Pedido da NF")

    cte40_mod = fields.Selection(
        TMODNF,
        string="Modelo da Nota Fiscal",
        xsd_required=True,
        xsd_type="TModNF",
        help=(
            "Modelo da Nota Fiscal\nPreencher com: \n01 - NF Modelo 01/1A e "
            "Avulsa; \n04 - NF de Produtor"
        ),
    )

    cte40_serie = fields.Char(string="Série", xsd_required=True)

    cte40_nDoc = fields.Char(string="Número", xsd_required=True)

    cte40_dEmi = fields.Date(
        string="Data de Emissão",
        xsd_required=True,
        xsd_type="TData",
        help="Data de Emissão\nFormato AAAA-MM-DD",
    )

    cte40_vBC = fields.Monetary(
        string="Valor da Base de Cálculo do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vICMS = fields.Monetary(
        string="Valor Total do ICMS",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vBCST = fields.Monetary(
        string="Valor da Base de Cálculo do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vST = fields.Monetary(
        string="Valor Total do ICMS ST",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vProd = fields.Monetary(
        string="Valor Total dos Produtos",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vNF = fields.Monetary(
        string="Valor Total da NF",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_nCFOP = fields.Char(
        string="CFOP Predominante",
        xsd_required=True,
        xsd_type="TCfop",
        help=(
            "CFOP Predominante\nCFOP da NF ou, na existência de mais de um, "
            "predominância pelo critério de valor econômico."
        ),
    )

    cte40_nPeso = fields.Float(
        string="Peso total em Kg",
        xsd_type="TDec_1203Opc",
        digits=(
            12,
            3,
        ),
    )

    cte40_PIN = fields.Char(
        string="PIN SUFRAMA",
        help="PIN SUFRAMA\nPIN atribuído pela SUFRAMA para a operação.",
    )

    cte40_dPrev = fields.Date(
        string="Data prevista de entrega",
        xsd_type="TData",
        help="Data prevista de entrega\nFormato AAAA-MM-DD",
    )

    cte40_infUnidCarga = fields.One2many(
        "cte.40.tunidcarga",
        "cte40_infUnidCarga_infNF_id",
        string="Informações das Unidades de Carga",
        choice="infnf",
        xsd_choice_required=True,
        xsd_type="TUnidCarga",
        help=(
            "Informações das Unidades de Carga "
            "(Containeres/ULD/Outros)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    cte40_infUnidTransp = fields.One2many(
        "cte.40.tunidadetransp",
        "cte40_infUnidTransp_infNF_id",
        string="Informações das Unidades de Transporte",
        choice="infnf",
        xsd_choice_required=True,
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDeve ser preenchido com as informações "
            "das unidades de transporte utilizadas."
        ),
    )


class TcteInfNfe(models.AbstractModel):
    "Informações das NF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infnfe"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfDoc.InfNfe"

    cte40_infNFe_infDoc_id = fields.Many2one(
        comodel_name="cte.40.tcte_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chave = fields.Char(
        string="Chave de acesso da NF-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_PIN = fields.Char(
        string="PIN SUFRAMA",
        help="PIN SUFRAMA\nPIN atribuído pela SUFRAMA para a operação.",
    )

    cte40_dPrev = fields.Date(
        string="Data prevista de entrega",
        xsd_type="TData",
        help="Data prevista de entrega\nFormato AAAA-MM-DD",
    )

    cte40_infUnidCarga = fields.One2many(
        "cte.40.tunidcarga",
        "cte40_infUnidCarga_infNFe_id",
        string="Informações das Unidades de Carga",
        choice="infnfe",
        xsd_choice_required=True,
        xsd_type="TUnidCarga",
        help=(
            "Informações das Unidades de Carga "
            "(Containeres/ULD/Outros)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    cte40_infUnidTransp = fields.One2many(
        "cte.40.tunidadetransp",
        "cte40_infUnidTransp_infNFe_id",
        string="Informações das Unidades de Transporte",
        choice="infnfe",
        xsd_choice_required=True,
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDeve ser preenchido com as informações "
            "das unidades de transporte utilizadas."
        ),
    )


class InfOutros(models.AbstractModel):
    "Informações dos demais documentos"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infoutros"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfDoc.InfOutros"

    cte40_infOutros_infDoc_id = fields.Many2one(
        comodel_name="cte.40.tcte_infdoc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpDoc = fields.Selection(
        INFOUTROS_TPDOC,
        string="Tipo de documento originário",
        xsd_required=True,
        help=(
            "Tipo de documento originário\nPreencher "
            "com:\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t00 - "
            "Declaração;\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t10 - "
            "Dutoviário;\n\n\n59 - CF-e SAT;\n\n65 - "
            "NFC-e;\n\t\t\t\t\t\t\t\t99 - Outros"
        ),
    )

    cte40_descOutros = fields.Char(string="Descrição do documento")

    cte40_nDoc = fields.Char(string="Número")

    cte40_dEmi = fields.Date(
        string="Data de Emissão",
        xsd_type="TData",
        help="Data de Emissão\nFormato AAAA-MM-DD",
    )

    cte40_vDocFisc = fields.Monetary(
        string="Valor do documento",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    cte40_dPrev = fields.Date(
        string="Data prevista de entrega",
        xsd_type="TData",
        help="Data prevista de entrega\nFormato AAAA-MM-DD",
    )

    cte40_infUnidCarga = fields.One2many(
        "cte.40.tunidcarga",
        "cte40_infUnidCarga_infOutros_id",
        string="Informações das Unidades de Carga",
        choice="infoutros",
        xsd_choice_required=True,
        xsd_type="TUnidCarga",
        help=(
            "Informações das Unidades de Carga "
            "(Containeres/ULD/Outros)\nDispositivo de carga utilizada (Unit "
            "Load Device - ULD) significa todo tipo de contêiner de carga, "
            "vagão, contêiner de avião, palete de aeronave com rede ou palete "
            "de aeronave com rede sobre um iglu."
        ),
    )

    cte40_infUnidTransp = fields.One2many(
        "cte.40.tunidadetransp",
        "cte40_infUnidTransp_infOutros_id",
        string="Informações das Unidades de Transporte",
        choice="infoutros",
        xsd_choice_required=True,
        xsd_type="TUnidadeTransp",
        help=(
            "Informações das Unidades de Transporte "
            "(Carreta/Reboque/Vagão)\nDeve ser preenchido com as informações "
            "das unidades de transporte utilizadas."
        ),
    )


class DocAnt(models.AbstractModel):
    "Documentos de Transporte Anterior"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.docant"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.DocAnt"

    cte40_emiDocAnt = fields.One2many(
        "cte.40.emidocant",
        "cte40_emiDocAnt_docAnt_id",
        string="Emissor do documento anterior",
    )


class EmiDocAnt(models.AbstractModel):
    "Emissor do documento anterior"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.emidocant"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.DocAnt.EmiDocAnt"

    cte40_emiDocAnt_docAnt_id = fields.Many2one(
        comodel_name="cte.40.docant", xsd_implicit=True, ondelete="cascade"
    )
    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        choice="emidocant",
        xsd_choice_required=True,
        xsd_type="TCnpjOpc",
        help=(
            "Número do CNPJ\nEm caso de empresa não estabelecida no Brasil, "
            "será informado o CNPJ com "
            "zeros.\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tInformar os zeros "
            "não significativos."
        ),
    )

    cte40_CPF = fields.Char(
        string="Número do CPF",
        choice="emidocant",
        xsd_choice_required=True,
        xsd_type="TCpf",
        help="Número do CPF\nInformar os zeros não significativos.",
    )

    cte40_IE = fields.Char(string="Inscrição Estadual", xsd_type="TIe")

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )

    cte40_xNome = fields.Char(
        string="Razão Social ou Nome do expedidor", xsd_required=True
    )

    cte40_idDocAnt = fields.One2many(
        "cte.40.iddocant",
        "cte40_idDocAnt_emiDocAnt_id",
        string="Informações de identificação",
        help=("Informações de identificação dos documentos de Transporte " "Anterior"),
    )


class IdDocAnt(models.AbstractModel):
    "Informações de identificação dos documentos de Transporte Anterior"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.iddocant"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.DocAnt.EmiDocAnt.IdDocAnt"

    cte40_idDocAnt_emiDocAnt_id = fields.Many2one(
        comodel_name="cte.40.emidocant", xsd_implicit=True, ondelete="cascade"
    )
    cte40_idDocAntPap = fields.One2many(
        "cte.40.iddocantpap",
        "cte40_idDocAntPap_idDocAnt_id",
        string="Documentos de transporte anterior",
        choice="iddocant",
        xsd_choice_required=True,
        help="Documentos de transporte anterior em papel",
    )

    cte40_idDocAntEle = fields.One2many(
        "cte.40.iddocantele",
        "cte40_idDocAntEle_idDocAnt_id",
        string="Documentos",
        choice="iddocant",
        xsd_choice_required=True,
        help="Documentos de transporte anterior eletrônicos",
    )


class IdDocAntPap(models.AbstractModel):
    "Documentos de transporte anterior em papel"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.iddocantpap"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntPap"

    cte40_idDocAntPap_idDocAnt_id = fields.Many2one(
        comodel_name="cte.40.iddocant", xsd_implicit=True, ondelete="cascade"
    )
    cte40_tpDoc = fields.Selection(
        TDOCASSOC,
        string="Tipo do Documento de Transporte Anterior",
        xsd_required=True,
        help=(
            "Tipo do Documento de Transporte Anterior\nPreencher "
            "com:\n07-ATRE;\t\t\t\t\t\t\t\n08-DTA (Despacho de Transito "
            "Aduaneiro);\n09-Conhecimento Aéreo Internacional;\n10 – "
            "Conhecimento - Carta de Porte Internacional;\n11 – Conhecimento "
            "Avulso;\n12-TIF (Transporte Internacional Ferroviário); 13-BL "
            "(Bill of Lading)"
        ),
    )

    cte40_serie = fields.Char(string="Série do Documento Fiscal", xsd_required=True)

    cte40_subser = fields.Char(string="Série do Documento Fiscal (subser)")

    cte40_nDoc = fields.Char(string="Número do Documento Fiscal", xsd_required=True)

    cte40_dEmi = fields.Date(
        string="Data de emissão (AAAA-MM-DD)", xsd_required=True, xsd_type="TData"
    )


class IdDocAntEle(models.AbstractModel):
    "Documentos de transporte anterior eletrônicos"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.iddocantele"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.DocAnt.EmiDocAnt.IdDocAnt.IdDocAntEle"

    cte40_idDocAntEle_idDocAnt_id = fields.Many2one(
        comodel_name="cte.40.iddocant", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chCTe = fields.Char(
        string="Chave de acesso do CT-e", xsd_required=True, xsd_type="TChDFe"
    )


class TcteInfModal(models.AbstractModel):
    "Informações do modal"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infmodal"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfModal"

    cte40_versaoModal = fields.Char(
        string="Versão do leiaute específico",
        xsd_required=True,
        help="Versão do leiaute específico para o Modal",
    )


class VeicNovos(models.AbstractModel):
    "informações dos veículos transportados"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.veicnovos"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.VeicNovos"

    cte40_veicNovos_infCTeNorm_id = fields.Many2one(
        comodel_name="cte.40.tcte_infctenorm", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chassi = fields.Char(string="Chassi do veículo", xsd_required=True)

    cte40_cCor = fields.Char(
        string="Cor do veículo",
        xsd_required=True,
        help="Cor do veículo\nCódigo de cada montadora",
    )

    cte40_xCor = fields.Char(string="Descrição da cor", xsd_required=True)

    cte40_cMod = fields.Char(
        string="Código Marca Modelo",
        xsd_required=True,
        help="Código Marca Modelo\nUtilizar tabela RENAVAM",
    )

    cte40_vUnit = fields.Monetary(
        string="Valor Unitário do Veículo",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_vFrete = fields.Monetary(
        string="Frete Unitário",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )


class TcteCobr(models.AbstractModel):
    "Dados da cobrança do CT-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_cobr"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.Cobr"

    cte40_fat = fields.Many2one(
        comodel_name="cte.40.tcte_fat", string="Dados da fatura"
    )

    cte40_dup = fields.One2many(
        "cte.40.tcte_dup", "cte40_dup_cobr_id", string="Dados das duplicatas"
    )


class TcteFat(models.AbstractModel):
    "Dados da fatura"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_fat"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.Cobr.Fat"

    cte40_nFat = fields.Char(string="Número da fatura")

    cte40_vOrig = fields.Monetary(
        string="Valor original da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    cte40_vDesc = fields.Monetary(
        string="Valor do desconto da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )

    cte40_vLiq = fields.Monetary(
        string="Valor líquido da fatura",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class TcteDup(models.AbstractModel):
    "Dados das duplicatas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_dup"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.Cobr.Dup"

    cte40_dup_cobr_id = fields.Many2one(
        comodel_name="cte.40.tcte_cobr", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nDup = fields.Char(string="Número da duplicata")

    cte40_dVenc = fields.Date(
        string="Data de vencimento da duplicata",
        xsd_type="TData",
        help="Data de vencimento da duplicata (AAAA-MM-DD)",
    )

    cte40_vDup = fields.Monetary(
        string="Valor da duplicata",
        xsd_type="TDec_1302Opc",
        currency_field="brl_currency_id",
    )


class TcteInfCteSub(models.AbstractModel):
    "Informações do CT-e de substituição"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infctesub"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfCteSub"

    cte40_chCte = fields.Char(
        string="Chave de acesso do CT-e",
        xsd_required=True,
        help="Chave de acesso do CT-e a ser substituído (original)",
    )

    cte40_indAlteraToma = fields.Selection(
        INFCTESUB_INDALTERATOMA, string="Indicador de CT-e Alteração de Tomador"
    )


class InfGlobalizado(models.AbstractModel):
    "Informações do CT-e Globalizado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infglobalizado"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfGlobalizado"

    cte40_xObs = fields.Char(
        string="informações adicionais",
        xsd_required=True,
        help="informações adicionais, legislação do regime especial, etc",
    )


class InfServVinc(models.AbstractModel):
    "Informações do Serviço Vinculado a Multimodal"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infservvinc"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfServVinc"

    cte40_infCTeMultimodal = fields.One2many(
        "cte.40.infctemultimodal",
        "cte40_infCTeMultimodal_infServVinc_id",
        string="informações do CT-e multimodal vinculado",
    )


class InfCteMultimodal(models.AbstractModel):
    "informações do CT-e multimodal vinculado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.infctemultimodal"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteNorm.InfServVinc.InfCteMultimodal"

    cte40_infCTeMultimodal_infServVinc_id = fields.Many2one(
        comodel_name="cte.40.infservvinc", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chCTeMultimodal = fields.Char(
        string="Chave de acesso do CT-e Multimodal",
        xsd_required=True,
        xsd_type="TChDFe",
    )


class TcteInfCteComp(models.AbstractModel):
    "Detalhamento do CT-e complementado"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infctecomp"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCte.InfCteComp"

    cte40_infCteComp_infCte_id = fields.Many2one(
        comodel_name="cte.40.tcte_infcte", xsd_implicit=True, ondelete="cascade"
    )
    cte40_chCTe = fields.Char(
        string="Chave do CT-e complementado", xsd_required=True, xsd_type="TChDFe"
    )


class TcteInfCteSupl(models.AbstractModel):
    "Informações suplementares da GTV-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tcte_infctesupl"
    _inherit = "spec.mixin.cte"
    _binding_type = "Tcte.InfCteSupl"

    cte40_qrCodCTe = fields.Char(
        string="Texto com o QR-Code impresso no DACTE", xsd_required=True
    )
