# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Unidade de medida"
INFTOTAP_UNIAP = [
    ("1", "KG"),
    ("2", "KG G (quilograma bruto)"),
    ("3", "LITROS"),
    ("4", "TI (índice de transporte para radioativos)"),
    (
        "5",
        " Unidades (apenas para artigos perigosos medidos em unidades que não se enquadram nos itens acima. Exemplo: baterias, celulares, equipamentos, veículos, dentre outros)",
    ),
]

"Informações de manuseio"
NATCARGA_CINFMANU = [
    ("01", "certificado do expedidor para embarque de animal vivo"),
    ("02", "artigo perigoso conforme Declaração do Expedidor anexa"),
    ("03", "somente em aeronave cargueira"),
    ("04", "artigo perigoso - declaração do expedidor não requerida"),
    ("05", "artigo perigoso em quantidade isenta"),
    (
        "06",
        "gelo seco para refrigeração (especificar no campo observações a quantidade)",
    ),
    ("07", "não restrito (especificar a Disposição Especial no campo observações)"),
    (
        "08",
        "artigo perigoso em carga consolidada (especificar a quantidade no campo observações)",
    ),
    (
        "09",
        "autorização da autoridade governamental anexa (especificar no campo observações)",
    ),
    ("10", "baterias de íons de lítio em conformidade com a Seção II da PI965 – CAO"),
    ("11", "baterias de íons de lítio em conformidade com a Seção II da PI966"),
    ("12", "baterias de íons de lítio em conformidade com a Seção II da PI967"),
    ("13", "baterias de metal lítio em conformidade com a Seção II da PI968 — CAO"),
    ("14", "baterias de metal lítio em conformidade com a Seção II da PI969"),
    ("15", "baterias de metal lítio em conformidade com a Seção II da PI970"),
    ("99", "outro (especificar no campo observações)"),
]


class Aereo(models.AbstractModel):
    "Informações do modal Aéreo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.aereo"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aereo"

    cte40_nMinu = fields.Char(
        string="Número da Minuta",
        help=(
            "Número da Minuta\nDocumento que precede o CT-e, assinado pelo "
            "expedidor, espécie de pedido de serviço"
        ),
    )

    cte40_nOCA = fields.Char(
        string="Número Operacional do Conhecimento Aéreo",
        help=(
            "Número Operacional do Conhecimento Aéreo\nRepresenta o número de "
            "controle comumente utilizado pelo conhecimento aéreo composto por"
            " uma sequência numérica de onze dígitos. Os três primeiros "
            "dígitos representam um código que os operadores de transporte "
            "aéreo associados à IATA possuem. Em seguida um número de série de"
            " sete dígitos determinados pelo operador de transporte aéreo. "
            "Para finalizar, um dígito verificador, que é um sistema de módulo"
            " sete imponderado o qual divide o número de série do conhecimento"
            " aéreo por sete e usa o resto como dígito de verificação."
        ),
    )

    cte40_dPrevAereo = fields.Date(
        string="Data prevista da entrega",
        xsd_required=True,
        xsd_type="TData",
        help="Data prevista da entrega\nFormato AAAA-MM-DD",
    )

    cte40_natCarga = fields.Many2one(
        comodel_name="cte.40.natcarga", string="Natureza da carga", xsd_required=True
    )

    cte40_tarifa = fields.Many2one(
        comodel_name="cte.40.tarifa", string="Informações de tarifa", xsd_required=True
    )

    cte40_peri = fields.One2many(
        "cte.40.peri",
        "cte40_peri_aereo_id",
        string="Preenchido quando for transporte",
        help=(
            "Preenchido quando for  transporte de produtos classificados pela "
            "ONU como perigosos.\nO preenchimento desses campos não desobriga "
            "a empresa aérea de emitir os demais documentos que constam na "
            "legislação vigente."
        ),
    )


class NatCarga(models.AbstractModel):
    "Natureza da carga"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.natcarga"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aereo.NatCarga"

    cte40_xDime = fields.Char(
        string="Dimensão",
        help=(
            "Dimensão\nFormato:1234X1234X1234 (cm). Esse campo deve sempre que"
            " possível ser preenchido. Entretanto, quando for impossível o "
            "preenchimento das dimensões, fica obrigatório o preenchimento da "
            "cubagem em metro cúbico do leiaute do CT-e da estrutura genérica "
            "(infQ)."
        ),
    )

    cte40_cInfManu = fields.One2many(
        "cte.40.natcargacinfmanu",
        "cte40_cInfManu_natCarga_id",
        string="Informações de manuseio",
        help=(
            "Informações de manuseio\n01 - certificado do expedidor para "
            "embarque de animal vivo;\n\n02 - artigo perigoso conforme "
            "Declaração do Expedidor anexa;\n\n03 - somente em aeronave "
            "cargueira; \n\n04 - artigo perigoso - declaração do expedidor não"
            " requerida; \n\n05 - artigo perigoso em quantidade isenta;\n\n06 "
            "- gelo seco para refrigeração (especificar no campo observações a"
            " quantidade); \n\n07 - não restrito (especificar a Disposição "
            "Especial no campo observações);\n\n08 - artigo perigoso em carga "
            "consolidada (especificar a quantidade no campo "
            "observações)\n;\n09 - autorização da autoridade governamental "
            "anexa (especificar no campo observações); \n\n10 – baterias de "
            "íons de lítio em conformidade com a Seção II da PI965 – CAO\n; "
            "\n11 - baterias de íons de lítio em conformidade com a Seção II "
            "da PI966\n; \n12 - baterias de íons de lítio em conformidade com "
            "a Seção II da PI967\n; \n13 – baterias de metal lítio em "
            "conformidade com a Seção II da PI968 — CAO; \n\n14 - baterias de "
            "metal lítio em conformidade com a Seção II da PI969; \n\n15 - "
            "baterias de metal lítio em conformidade com a Seção II da "
            "PI970\n; \n99 - outro (especificar no campo observações)\n."
        ),
    )


class Tarifa(models.AbstractModel):
    "Informações de tarifa"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tarifa"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aereo.Tarifa"

    cte40_CL = fields.Char(
        string="Classe",
        xsd_required=True,
        help=(
            "Classe\nPreencher com:\n\t\t\t\t\t\t\t\t\tM - Tarifa "
            "Mínima;\n\t\t\t\t\t\t\t\t\tG - Tarifa Geral;\n\t\t\t\t\t\t\t\t\tE"
            " - Tarifa Específica"
        ),
    )

    cte40_cTar = fields.Char(
        string="Código da Tarifa",
        help=(
            "Código da Tarifa\nDeverão ser incluídos os códigos de três "
            "dígitos, correspondentes à tarifa."
        ),
    )

    cte40_vTar = fields.Monetary(
        string="Valor da Tarifa",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
        help="Valor da Tarifa\nValor da tarifa por kg quando for o caso.",
    )


class Peri(models.AbstractModel):
    """Preenchido quando for transporte de produtos classificados pela ONU como
    perigosos.
    O preenchimento desses campos não desobriga a empresa aérea de emitir os demais
    documentos que constam na legislação vigente."""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.peri"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aereo.Peri"

    cte40_peri_aereo_id = fields.Many2one(
        comodel_name="cte.40.aereo", xsd_implicit=True, ondelete="cascade"
    )
    cte40_nONU = fields.Char(
        string="Número ONU/UN",
        xsd_required=True,
        help=(
            "Número ONU/UN\nVer a legislação de transporte de produtos "
            "perigosos aplicadas ao modal"
        ),
    )

    cte40_qTotEmb = fields.Char(
        string="Quantidade total",
        xsd_required=True,
        help=(
            "Quantidade total de volumes contendo artigos perigosos\nPreencher"
            " com o número de volumes (unidades) de artigos perigosos, ou "
            "seja, cada embalagem devidamente marcada e etiquetada (por ex.: "
            "número de caixas, de tambores, de bombonas, dentre outros). Não "
            "deve ser preenchido com o número de ULD, pallets ou containers."
        ),
    )

    cte40_infTotAP = fields.Many2one(
        comodel_name="cte.40.inftotap",
        string="Grupo de informações",
        xsd_required=True,
        help=(
            "Grupo de informações das quantidades totais de artigos "
            "perigosos\nPreencher conforme a legislação de transporte de "
            "produtos perigosos aplicada ao modal"
        ),
    )


class InfTotAp(models.AbstractModel):
    """Grupo de informações das quantidades totais de artigos perigosos
    Preencher conforme a legislação de transporte de produtos perigosos aplicada ao
    modal"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.inftotap"
    _inherit = "spec.mixin.cte"
    _binding_type = "Aereo.Peri.InfTotAp"

    cte40_qTotProd = fields.Float(
        string="Quantidade total de artigos perigosos",
        xsd_required=True,
        xsd_type="TDec_1104",
        digits=(
            11,
            4,
        ),
        help=(
            "Quantidade total de artigos perigosos\n15 posições, sendo 11 "
            "inteiras e 4 decimais. \nDeve indicar a quantidade total do "
            "artigo perigoso, tendo como base a unidade referenciada na Tabela"
            " 3-1 do Doc 9284, por exemplo: litros; quilogramas; quilograma "
            "bruto etc. O preenchimento não deve, entretanto, incluir a "
            "unidade de medida. No caso de transporte de material radioativo, "
            "deve-se indicar o somatório dos Índices de Transporte (TI). Não "
            "indicar a quantidade do artigo perigoso por embalagem."
        ),
    )

    cte40_uniAP = fields.Selection(
        INFTOTAP_UNIAP,
        string="Unidade de medida",
        xsd_required=True,
        help=(
            "Unidade de medida\n1 – KG; \n2 – KG G (quilograma bruto);\n3 – "
            "LITROS;\n4 – TI (índice de transporte para radioativos); 5- "
            "Unidades (apenas para artigos perigosos medidos em unidades que "
            "não se enquadram nos itens acima. Exemplo: baterias, celulares, "
            "equipamentos, veículos, dentre outros)"
        ),
    )
