/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./node/playwright-wrapper/index.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node/playwright-wrapper/browser-control.ts":
/*!****************************************************!*\
  !*** ./node/playwright-wrapper/browser-control.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setTimeout = exports.takeScreenshot = exports.goForward = exports.goBack = exports.goTo = void 0;
var playwirght_util_1 = __webpack_require__(/*! ./playwirght-util */ "./node/playwright-wrapper/playwirght-util.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function goTo(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    url = call.request.getUrl();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'goto', url)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog("Succesfully opened URL " + url));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goTo = goTo;
function goBack(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'goBack')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Did Go Back'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goBack = goBack;
function goForward(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'goForward')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Did Go Forward'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goForward = goForward;
function takeScreenshot(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var path;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    path = call.request.getPath() + '.png';
                    return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'screenshot', { path: path })];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.stringResponse(path));
                    return [2 /*return*/];
            }
        });
    });
}
exports.takeScreenshot = takeScreenshot;
function setTimeout(call, callback, context) {
    playwirght_util_1.exists(context, callback, 'Tried to set timeout, no open browser');
    var timeout = call.request.getTimeout();
    context.setDefaultTimeout(timeout);
    callback(null, response_util_1.emptyWithLog("Set timeout to: " + timeout));
}
exports.setTimeout = setTimeout;


/***/ }),

/***/ "./node/playwright-wrapper/browser-state.ts":
/*!**************************************************!*\
  !*** ./node/playwright-wrapper/browser-state.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchBrowser = exports.switchContext = exports.switchPage = exports.autoActivatePages = exports.createBrowser = exports.createContext = exports.createPage = exports.closeBrowser = exports.BrowserState = void 0;
var playwright_1 = __webpack_require__(/*! playwright */ "playwright");
var playwirght_util_1 = __webpack_require__(/*! ./playwirght-util */ "./node/playwright-wrapper/playwirght-util.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function _newBrowser(browserType, headless, options) {
    return __awaiter(this, void 0, void 0, function () {
        var browser;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    browserType = browserType || 'chromium';
                    headless = headless || true;
                    if (!(browserType === 'firefox')) return [3 /*break*/, 2];
                    return [4 /*yield*/, playwright_1.firefox.launch(__assign({ headless: headless }, options))];
                case 1:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 2:
                    if (!(browserType === 'chromium')) return [3 /*break*/, 4];
                    return [4 /*yield*/, playwright_1.chromium.launch(__assign({ headless: headless }, options))];
                case 3:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 4:
                    if (!(browserType === 'webkit')) return [3 /*break*/, 6];
                    return [4 /*yield*/, playwright_1.webkit.launch(__assign({ headless: headless }, options))];
                case 5:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 6: throw new Error('unsupported browser');
                case 7: return [2 /*return*/, [browserType, browser]];
            }
        });
    });
}
function _newBrowserContext(browser, hideRfBrowser) {
    return __awaiter(this, void 0, void 0, function () {
        var context;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, browser.newContext()];
                case 1:
                    context = _a.sent();
                    if (!hideRfBrowser) {
                        context.addInitScript(function () {
                            window.__SET_RFBROWSER_STATE__ = function (state) {
                                window.__RFBROWSER__ = state;
                                return state;
                            };
                        });
                    }
                    context.setDefaultTimeout(parseFloat(process.env.TIMEOUT || '10000'));
                    return [2 /*return*/, context];
            }
        });
    });
}
function initializeBrowser(browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, name_1, browser;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!browserState.browser) return [3 /*break*/, 1];
                    return [2 /*return*/, browserState.browser];
                case 1: return [4 /*yield*/, _newBrowser()];
                case 2:
                    _a = _b.sent(), name_1 = _a[0], browser = _a[1];
                    browserState.browser = browser;
                    browserState.name = name_1;
                    return [2 /*return*/, browser];
            }
        });
    });
}
function initializeContext(browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var browser, context;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(browserState === null || browserState === void 0 ? void 0 : browserState.context)) return [3 /*break*/, 1];
                    return [2 /*return*/, browserState.context];
                case 1:
                    if (!!(browserState === null || browserState === void 0 ? void 0 : browserState.browser)) return [3 /*break*/, 3];
                    return [4 /*yield*/, initializeBrowser(browserState)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    browser = browserState.browser;
                    return [4 /*yield*/, _newBrowserContext(browser)];
                case 4:
                    context = _a.sent();
                    browserState.context = context;
                    return [2 /*return*/, context];
            }
        });
    });
}
var BrowserState = /** @class */ (function () {
    function BrowserState(browser, context, page, name) {
        this.browser = browser;
        this.context = context;
        this.page = page;
        this.name = name;
    }
    return BrowserState;
}());
exports.BrowserState = BrowserState;
function closeBrowser(callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    playwirght_util_1.exists(browserState === null || browserState === void 0 ? void 0 : browserState.browser, callback, 'Tried to close browser but none was open');
                    return [4 /*yield*/, browserState.browser.close()];
                case 1:
                    _a.sent();
                    browserState.context = undefined;
                    browserState.page = undefined;
                    return [2 /*return*/];
            }
        });
    });
}
exports.closeBrowser = closeBrowser;
function createPage(call, callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var context, page, url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, initializeContext(browserState)];
                case 1:
                    context = _a.sent();
                    return [4 /*yield*/, (context === null || context === void 0 ? void 0 : context.newPage())];
                case 2:
                    page = _a.sent();
                    browserState.page = page;
                    url = call.request.getUrl() || 'about:blank';
                    return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'goto', url, { timeout: 10000 })];
                case 3:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Succesfully initialized new page object and opened url'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.createPage = createPage;
function createContext(call, callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var browser, options, _a, error_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, initializeBrowser(browserState)];
                case 1:
                    browser = _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    options = JSON.parse(call.request.getRawoptions());
                    _a = browserState;
                    return [4 /*yield*/, _newBrowserContext(browser)];
                case 3:
                    _a.context = _b.sent();
                    callback(null, response_util_1.emptyWithLog("Succesfully created context with options " + options));
                    return [3 /*break*/, 5];
                case 4:
                    error_1 = _b.sent();
                    callback(error_1, null);
                    return [2 /*return*/];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.createContext = createContext;
function createBrowser(call, callback, browsers, setBrowser) {
    return __awaiter(this, void 0, void 0, function () {
        var browserType, headless, options, _a, name_2, browser, browserState, error_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    browserType = call.request.getBrowser();
                    headless = call.request.getHeadless();
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    options = JSON.parse(call.request.getRawoptions());
                    return [4 /*yield*/, _newBrowser(browserType, headless, options)];
                case 2:
                    _a = _b.sent(), name_2 = _a[0], browser = _a[1];
                    browserState = new BrowserState();
                    browserState.name = name_2;
                    browserState.browser = browser;
                    if (browsers[0].browser)
                        browsers.push(browserState);
                    else
                        browsers[0] = browserState;
                    setBrowser(browserState);
                    callback(null, response_util_1.emptyWithLog("Succesfully created browser " + browserType + " with options " + options));
                    return [3 /*break*/, 4];
                case 3:
                    error_2 = _b.sent();
                    callback(error_2, null);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.createBrowser = createBrowser;
function autoActivatePages(call, callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            playwirght_util_1.exists(browserState === null || browserState === void 0 ? void 0 : browserState.context, callback, 'Tried to focus next opened page');
            browserState.context.on('page', function (page) {
                browserState.page = page;
                console.log('Changed active page');
            });
            callback(null, response_util_1.emptyWithLog('Will focus future ``pages`` in this context'));
            return [2 /*return*/];
        });
    });
}
exports.autoActivatePages = autoActivatePages;
function _switchPage(index, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var context, pages, page, pwError_1, mapped, message, error;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    context = browserState.context;
                    if (!context)
                        throw new Error('Tried to switch page, no open context');
                    pages = context.pages();
                    if (!pages[index]) return [3 /*break*/, 1];
                    browserState.page = pages[index];
                    return [2 /*return*/];
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    console.log('Started waiting for a page to pop up');
                    return [4 /*yield*/, context.waitForEvent('page', { timeout: 10000 })];
                case 2:
                    page = _a.sent();
                    browserState.page = page;
                    return [2 /*return*/];
                case 3:
                    pwError_1 = _a.sent();
                    console.log('Wait was not fulfilled');
                    console.log(pwError_1);
                    mapped = pages === null || pages === void 0 ? void 0 : pages.map(function (p) { return p.url(); }).join(',');
                    message = "No page for index " + index + ". Open pages: " + mapped;
                    error = new Error(message);
                    throw error;
                case 4: return [2 /*return*/];
            }
        });
    });
}
function _switchContext(index, browserState) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var contexts, mapped, message, error;
        return __generator(this, function (_b) {
            contexts = (_a = browserState.browser) === null || _a === void 0 ? void 0 : _a.contexts();
            if (contexts && contexts[index]) {
                browserState.context = contexts[index];
                return [2 /*return*/];
            }
            else {
                mapped = contexts === null || contexts === void 0 ? void 0 : contexts.map(function (c) { return c.pages(); }).reduce(function (acc, val) { return acc.concat(val); }, []).map(function (p) { return p.url(); });
                message = "No context for index " + index + ". Open contexts: " + mapped;
                error = new Error(message);
                throw error;
            }
            return [2 /*return*/];
        });
    });
}
function switchPage(call, callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var index;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log('Changing current active page');
                    index = call.request.getIndex();
                    return [4 /*yield*/, _switchPage(index, browserState)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Succesfully changed active page'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchPage = switchPage;
function switchContext(call, callback, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var index;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    playwirght_util_1.exists(browserState.browser, callback, "Tried to switch active context but browser wasn't open");
                    index = call.request.getIndex();
                    return [4 /*yield*/, _switchContext(index, browserState).catch(function (error) { return callback(error, null); })];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, _switchPage(0, browserState).catch(console.log)];
                case 2:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Succesfully changed active context'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchContext = switchContext;
function switchBrowser(call, callback, browsers, setBrowser) {
    return __awaiter(this, void 0, void 0, function () {
        var index, newState, mapped, message, error, pwError_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    index = call.request.getIndex();
                    newState = browsers[index];
                    if (newState) {
                        setBrowser(newState);
                    }
                    else {
                        mapped = browsers.map(function (browserState) { return browserState.name; });
                        message = "No browser for index " + index + ". Open browsers: " + mapped;
                        error = new Error(message);
                        callback(error, null);
                    }
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, , 5]);
                    // Try to switch to page and context in target browser
                    return [4 /*yield*/, _switchContext(0, newState)];
                case 2:
                    // Try to switch to page and context in target browser
                    _a.sent();
                    return [4 /*yield*/, _switchPage(0, newState)];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 5];
                case 4:
                    pwError_2 = _a.sent();
                    console.log(pwError_2);
                    return [3 /*break*/, 5];
                case 5:
                    callback(null, response_util_1.emptyWithLog('Succesfully changed active browser'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchBrowser = switchBrowser;


/***/ }),

/***/ "./node/playwright-wrapper/evaluation.ts":
/*!***********************************************!*\
  !*** ./node/playwright-wrapper/evaluation.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.highlightElements = exports.addStyleTag = exports.waitForElementState = exports.getPageState = exports.executeJavascriptOnPage = void 0;
var playwirght_util_1 = __webpack_require__(/*! ./playwirght-util */ "./node/playwright-wrapper/playwirght-util.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function executeJavascriptOnPage(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'evaluate', call.request.getScript())];
                case 1:
                    result = _a.sent();
                    callback(null, response_util_1.jsResponse(result));
                    return [2 /*return*/];
            }
        });
    });
}
exports.executeJavascriptOnPage = executeJavascriptOnPage;
function getPageState(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'evaluate', function () { return window.__RFBROWSER__; })];
                case 1:
                    result = _a.sent();
                    callback(null, response_util_1.jsResponse(result));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getPageState = getPageState;
function waitForElementState(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, options;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    options = JSON.parse(call.request.getOptions());
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'waitForSelector', selector, options)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Wait for Element with selector: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.waitForElementState = waitForElementState;
function addStyleTag(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    content = call.request.getContent();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'addStyleTag', { content: content })];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('added Style: ' + content));
                    return [2 /*return*/];
            }
        });
    });
}
exports.addStyleTag = addStyleTag;
function highlightElements(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, duration, highlighter;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    duration = call.request.getDuration();
                    highlighter = function (elements, duration) {
                        elements.forEach(function (e) {
                            var d = document.createElement('div');
                            d.appendChild(document.createTextNode(''));
                            d.style.position = 'fixed';
                            var rect = e.getBoundingClientRect();
                            d.style.top = '' + rect.top + 'px';
                            d.style.left = '' + rect.left + 'px';
                            d.style.width = '' + rect.width + 'px';
                            d.style.height = '' + rect.height + 'px';
                            d.style.border = '1px solid red';
                            document.body.appendChild(d);
                            setTimeout(function () {
                                d.remove();
                            }, duration);
                        });
                    };
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, '$$eval', selector, highlighter, duration)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.highlightElements = highlightElements;


/***/ }),

/***/ "./node/playwright-wrapper/generated/playwright_grpc_pb.js":
/*!*****************************************************************!*\
  !*** ./node/playwright-wrapper/generated/playwright_grpc_pb.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// GENERATED CODE -- DO NOT EDIT!


var grpc = __webpack_require__(/*! grpc */ "grpc");
var playwright_pb = __webpack_require__(/*! ./playwright_pb.js */ "./node/playwright-wrapper/generated/playwright_pb.js");

function serialize_Request_Browser(arg) {
  if (!(arg instanceof playwright_pb.Request.Browser)) {
    throw new Error('Expected argument of type Request.Browser');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Browser(buffer_arg) {
  return playwright_pb.Request.Browser.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ClearText(arg) {
  if (!(arg instanceof playwright_pb.Request.ClearText)) {
    throw new Error('Expected argument of type Request.ClearText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ClearText(buffer_arg) {
  return playwright_pb.Request.ClearText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Context(arg) {
  if (!(arg instanceof playwright_pb.Request.Context)) {
    throw new Error('Expected argument of type Request.Context');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Context(buffer_arg) {
  return playwright_pb.Request.Context.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementProperty(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementProperty)) {
    throw new Error('Expected argument of type Request.ElementProperty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementProperty(buffer_arg) {
  return playwright_pb.Request.ElementProperty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelector(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelector)) {
    throw new Error('Expected argument of type Request.ElementSelector');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelector(buffer_arg) {
  return playwright_pb.Request.ElementSelector.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelectorWithDuration(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelectorWithDuration)) {
    throw new Error('Expected argument of type Request.ElementSelectorWithDuration');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelectorWithDuration(buffer_arg) {
  return playwright_pb.Request.ElementSelectorWithDuration.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelectorWithOptions(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelectorWithOptions)) {
    throw new Error('Expected argument of type Request.ElementSelectorWithOptions');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelectorWithOptions(buffer_arg) {
  return playwright_pb.Request.ElementSelectorWithOptions.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Empty(arg) {
  if (!(arg instanceof playwright_pb.Request.Empty)) {
    throw new Error('Expected argument of type Request.Empty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Empty(buffer_arg) {
  return playwright_pb.Request.Empty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_FillText(arg) {
  if (!(arg instanceof playwright_pb.Request.FillText)) {
    throw new Error('Expected argument of type Request.FillText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_FillText(buffer_arg) {
  return playwright_pb.Request.FillText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Index(arg) {
  if (!(arg instanceof playwright_pb.Request.Index)) {
    throw new Error('Expected argument of type Request.Index');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Index(buffer_arg) {
  return playwright_pb.Request.Index.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_JavascriptCode(arg) {
  if (!(arg instanceof playwright_pb.Request.JavascriptCode)) {
    throw new Error('Expected argument of type Request.JavascriptCode');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_JavascriptCode(buffer_arg) {
  return playwright_pb.Request.JavascriptCode.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_PressKeys(arg) {
  if (!(arg instanceof playwright_pb.Request.PressKeys)) {
    throw new Error('Expected argument of type Request.PressKeys');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_PressKeys(buffer_arg) {
  return playwright_pb.Request.PressKeys.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ScreenshotPath(arg) {
  if (!(arg instanceof playwright_pb.Request.ScreenshotPath)) {
    throw new Error('Expected argument of type Request.ScreenshotPath');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ScreenshotPath(buffer_arg) {
  return playwright_pb.Request.ScreenshotPath.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_SelectElementSelector(arg) {
  if (!(arg instanceof playwright_pb.Request.SelectElementSelector)) {
    throw new Error('Expected argument of type Request.SelectElementSelector');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_SelectElementSelector(buffer_arg) {
  return playwright_pb.Request.SelectElementSelector.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_StyleTag(arg) {
  if (!(arg instanceof playwright_pb.Request.StyleTag)) {
    throw new Error('Expected argument of type Request.StyleTag');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_StyleTag(buffer_arg) {
  return playwright_pb.Request.StyleTag.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_TextInput(arg) {
  if (!(arg instanceof playwright_pb.Request.TextInput)) {
    throw new Error('Expected argument of type Request.TextInput');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_TextInput(buffer_arg) {
  return playwright_pb.Request.TextInput.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Timeout(arg) {
  if (!(arg instanceof playwright_pb.Request.Timeout)) {
    throw new Error('Expected argument of type Request.Timeout');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Timeout(buffer_arg) {
  return playwright_pb.Request.Timeout.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_TypeText(arg) {
  if (!(arg instanceof playwright_pb.Request.TypeText)) {
    throw new Error('Expected argument of type Request.TypeText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_TypeText(buffer_arg) {
  return playwright_pb.Request.TypeText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Url(arg) {
  if (!(arg instanceof playwright_pb.Request.Url)) {
    throw new Error('Expected argument of type Request.Url');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Url(buffer_arg) {
  return playwright_pb.Request.Url.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Bool(arg) {
  if (!(arg instanceof playwright_pb.Response.Bool)) {
    throw new Error('Expected argument of type Response.Bool');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Bool(buffer_arg) {
  return playwright_pb.Response.Bool.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Empty(arg) {
  if (!(arg instanceof playwright_pb.Response.Empty)) {
    throw new Error('Expected argument of type Response.Empty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Empty(buffer_arg) {
  return playwright_pb.Response.Empty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Int(arg) {
  if (!(arg instanceof playwright_pb.Response.Int)) {
    throw new Error('Expected argument of type Response.Int');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Int(buffer_arg) {
  return playwright_pb.Response.Int.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_JavascriptExecutionResult(arg) {
  if (!(arg instanceof playwright_pb.Response.JavascriptExecutionResult)) {
    throw new Error('Expected argument of type Response.JavascriptExecutionResult');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_JavascriptExecutionResult(buffer_arg) {
  return playwright_pb.Response.JavascriptExecutionResult.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Select(arg) {
  if (!(arg instanceof playwright_pb.Response.Select)) {
    throw new Error('Expected argument of type Response.Select');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Select(buffer_arg) {
  return playwright_pb.Response.Select.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_String(arg) {
  if (!(arg instanceof playwright_pb.Response.String)) {
    throw new Error('Expected argument of type Response.String');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_String(buffer_arg) {
  return playwright_pb.Response.String.deserializeBinary(new Uint8Array(buffer_arg));
}


var PlaywrightService = exports.PlaywrightService = {
  takeScreenshot: {
    path: '/Playwright/TakeScreenshot',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ScreenshotPath,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ScreenshotPath,
    requestDeserialize: deserialize_Request_ScreenshotPath,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  closeBrowser: {
    path: '/Playwright/CloseBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Opens the url in currently open Playwright page 
goTo: {
    path: '/Playwright/GoTo',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Navigate to the next page in history 
goBack: {
    path: '/Playwright/GoBack',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Navigate to the previous page in history. 
goForward: {
    path: '/Playwright/GoForward',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets title of currently open Playwright page 
getTitle: {
    path: '/Playwright/GetTitle',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Returns the count of elements found with selector 
getElementCount: {
    path: '/Playwright/GetElementCount',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  // Wraps playwrights page.fill to input text into input specified with selector 
inputText: {
    path: '/Playwright/InputText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.TextInput,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_TextInput,
    requestDeserialize: deserialize_Request_TextInput,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.type to type text into input specified with selector 
typeText: {
    path: '/Playwright/TypeText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.TypeText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_TypeText,
    requestDeserialize: deserialize_Request_TypeText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.fill to fill text of input specified with selector 
fillText: {
    path: '/Playwright/FillText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.FillText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_FillText,
    requestDeserialize: deserialize_Request_FillText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.fill with empty text to clear input specified with selector 
clearText: {
    path: '/Playwright/ClearText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ClearText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ClearText,
    requestDeserialize: deserialize_Request_ClearText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets the DOM property 'property' of selector specified element 
getDomProperty: {
    path: '/Playwright/GetDomProperty',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementProperty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ElementProperty,
    requestDeserialize: deserialize_Request_ElementProperty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Gets the boolean DOM property 'property' of selector specified element 
getBoolProperty: {
    path: '/Playwright/GetBoolProperty',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementProperty,
    responseType: playwright_pb.Response.Bool,
    requestSerialize: serialize_Request_ElementProperty,
    requestDeserialize: deserialize_Request_ElementProperty,
    responseSerialize: serialize_Response_Bool,
    responseDeserialize: deserialize_Response_Bool,
  },
  // Wraps playwrights page.textContent, returns textcontent of element by selector 
getTextContent: {
    path: '/Playwright/GetTextContent',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // *Returns current playwright page url
getUrl: {
    path: '/Playwright/GetUrl',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Clicks element specified by selector 
click: {
    path: '/Playwright/Click',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Inputs a list of keypresses to element specified by selector 
press: {
    path: '/Playwright/Press',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.PressKeys,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_PressKeys,
    requestDeserialize: deserialize_Request_PressKeys,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets the Select element specified by selector and returns the contents 
getSelectContent: {
    path: '/Playwright/GetSelectContent',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Select,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Select,
    responseDeserialize: deserialize_Response_Select,
  },
  // Selects option matching matcher in Select element matching selector 
selectOption: {
    path: '/Playwright/SelectOption',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.SelectElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_SelectElementSelector,
    requestDeserialize: deserialize_Request_SelectElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Deselects options in Select element matching selector 
deselectOption: {
    path: '/Playwright/DeselectOption',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Checks checkbox specified by selector 
checkCheckbox: {
    path: '/Playwright/CheckCheckbox',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Unchecks checkbox specified by selector 
uncheckCheckbox: {
    path: '/Playwright/UncheckCheckbox',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Health check endpoint for the service 
health: {
    path: '/Playwright/Health',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Set's  playwright timeout 
setTimeout: {
    path: '/Playwright/SetTimeout',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Timeout,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Timeout,
    requestDeserialize: deserialize_Request_Timeout,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Adds a <style> to head of site. 
addStyleTag: {
    path: '/Playwright/AddStyleTag',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.StyleTag,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_StyleTag,
    requestDeserialize: deserialize_Request_StyleTag,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Highlights elements matching selector for duration 
highlightElements: {
    path: '/Playwright/HighlightElements',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithDuration,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithDuration,
    requestDeserialize: deserialize_Request_ElementSelectorWithDuration,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Clicks element specified by selector and options 
clickWithOptions: {
    path: '/Playwright/ClickWithOptions',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithOptions,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithOptions,
    requestDeserialize: deserialize_Request_ElementSelectorWithOptions,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Focuses element specified by selector 
focus: {
    path: '/Playwright/Focus',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Waits for element be in a specific state
waitForElementsState: {
    path: '/Playwright/WaitForElementsState',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithOptions,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithOptions,
    requestDeserialize: deserialize_Request_ElementSelectorWithOptions,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Executes javascript on the active page 
executeJavascriptOnPage: {
    path: '/Playwright/ExecuteJavascriptOnPage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.JavascriptCode,
    responseType: playwright_pb.Response.JavascriptExecutionResult,
    requestSerialize: serialize_Request_JavascriptCode,
    requestDeserialize: deserialize_Request_JavascriptCode,
    responseSerialize: serialize_Response_JavascriptExecutionResult,
    responseDeserialize: deserialize_Response_JavascriptExecutionResult,
  },
  // Get Page State JSON 
getPageState: {
    path: '/Playwright/GetPageState',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.JavascriptExecutionResult,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_JavascriptExecutionResult,
    responseDeserialize: deserialize_Response_JavascriptExecutionResult,
  },
  autoActivatePages: {
    path: '/Playwright/AutoActivatePages',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  switchPage: {
    path: '/Playwright/SwitchPage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  switchContext: {
    path: '/Playwright/SwitchContext',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  switchBrowser: {
    path: '/Playwright/SwitchBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  createPage: {
    path: '/Playwright/CreatePage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  createContext: {
    path: '/Playwright/CreateContext',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Context,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Context,
    requestDeserialize: deserialize_Request_Context,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  createBrowser: {
    path: '/Playwright/CreateBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Browser,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Browser,
    requestDeserialize: deserialize_Request_Browser,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
};

exports.PlaywrightClient = grpc.makeGenericClientConstructor(PlaywrightService);


/***/ }),

/***/ "./node/playwright-wrapper/generated/playwright_pb.js":
/*!************************************************************!*\
  !*** ./node/playwright-wrapper/generated/playwright_pb.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// source: playwright.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = __webpack_require__(/*! google-protobuf */ "./node_modules/google-protobuf/google-protobuf.js");
var goog = jspb;
var global = Function('return this')();

goog.exportSymbol('proto.Request', null, global);
goog.exportSymbol('proto.Request.Browser', null, global);
goog.exportSymbol('proto.Request.ClearText', null, global);
goog.exportSymbol('proto.Request.Context', null, global);
goog.exportSymbol('proto.Request.ElementProperty', null, global);
goog.exportSymbol('proto.Request.ElementSelector', null, global);
goog.exportSymbol('proto.Request.ElementSelectorWithDuration', null, global);
goog.exportSymbol('proto.Request.ElementSelectorWithOptions', null, global);
goog.exportSymbol('proto.Request.Empty', null, global);
goog.exportSymbol('proto.Request.FillText', null, global);
goog.exportSymbol('proto.Request.Index', null, global);
goog.exportSymbol('proto.Request.JavascriptCode', null, global);
goog.exportSymbol('proto.Request.PressKeys', null, global);
goog.exportSymbol('proto.Request.RawJson', null, global);
goog.exportSymbol('proto.Request.ScreenshotPath', null, global);
goog.exportSymbol('proto.Request.SelectElementSelector', null, global);
goog.exportSymbol('proto.Request.StyleTag', null, global);
goog.exportSymbol('proto.Request.TextInput', null, global);
goog.exportSymbol('proto.Request.Timeout', null, global);
goog.exportSymbol('proto.Request.TypeText', null, global);
goog.exportSymbol('proto.Request.Url', null, global);
goog.exportSymbol('proto.Response', null, global);
goog.exportSymbol('proto.Response.Bool', null, global);
goog.exportSymbol('proto.Response.Empty', null, global);
goog.exportSymbol('proto.Response.Int', null, global);
goog.exportSymbol('proto.Response.JavascriptExecutionResult', null, global);
goog.exportSymbol('proto.Response.Select', null, global);
goog.exportSymbol('proto.Response.String', null, global);
goog.exportSymbol('proto.SelectEntry', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.displayName = 'proto.Request';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Empty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Empty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Empty.displayName = 'proto.Request.Empty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ScreenshotPath = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ScreenshotPath, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ScreenshotPath.displayName = 'proto.Request.ScreenshotPath';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Browser = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Browser, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Browser.displayName = 'proto.Request.Browser';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Context = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Context, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Context.displayName = 'proto.Request.Context';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Url = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Url, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Url.displayName = 'proto.Request.Url';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.TextInput = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.TextInput, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.TextInput.displayName = 'proto.Request.TextInput';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementProperty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementProperty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementProperty.displayName = 'proto.Request.ElementProperty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.TypeText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.TypeText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.TypeText.displayName = 'proto.Request.TypeText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.FillText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.FillText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.FillText.displayName = 'proto.Request.FillText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ClearText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ClearText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ClearText.displayName = 'proto.Request.ClearText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.PressKeys = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Request.PressKeys.repeatedFields_, null);
};
goog.inherits(proto.Request.PressKeys, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.PressKeys.displayName = 'proto.Request.PressKeys';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelector = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelector, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelector.displayName = 'proto.Request.ElementSelector';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Timeout = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Timeout, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Timeout.displayName = 'proto.Request.Timeout';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Index = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Index, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Index.displayName = 'proto.Request.Index';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.StyleTag = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.StyleTag, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.StyleTag.displayName = 'proto.Request.StyleTag';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelectorWithOptions = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelectorWithOptions, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelectorWithOptions.displayName = 'proto.Request.ElementSelectorWithOptions';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelectorWithDuration = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelectorWithDuration, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelectorWithDuration.displayName = 'proto.Request.ElementSelectorWithDuration';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.SelectElementSelector = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.SelectElementSelector, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.SelectElementSelector.displayName = 'proto.Request.SelectElementSelector';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.JavascriptCode = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.JavascriptCode, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.JavascriptCode.displayName = 'proto.Request.JavascriptCode';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.RawJson = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.RawJson, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.RawJson.displayName = 'proto.Request.RawJson';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.SelectEntry = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.SelectEntry, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.SelectEntry.displayName = 'proto.SelectEntry';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.displayName = 'proto.Response';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Empty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Empty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Empty.displayName = 'proto.Response.Empty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.String = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.String, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.String.displayName = 'proto.Response.String';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Bool = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Bool, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Bool.displayName = 'proto.Response.Bool';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Int = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Int, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Int.displayName = 'proto.Response.Int';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Select = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Response.Select.repeatedFields_, null);
};
goog.inherits(proto.Response.Select, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Select.displayName = 'proto.Response.Select';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.JavascriptExecutionResult = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.JavascriptExecutionResult, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.JavascriptExecutionResult.displayName = 'proto.Response.JavascriptExecutionResult';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request}
 */
proto.Request.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request;
  return proto.Request.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request}
 */
proto.Request.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Empty.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Empty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Empty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Empty.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Empty}
 */
proto.Request.Empty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Empty;
  return proto.Request.Empty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Empty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Empty}
 */
proto.Request.Empty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Empty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Empty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Empty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Empty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ScreenshotPath.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ScreenshotPath.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ScreenshotPath} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ScreenshotPath.toObject = function(includeInstance, msg) {
  var f, obj = {
    path: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ScreenshotPath}
 */
proto.Request.ScreenshotPath.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ScreenshotPath;
  return proto.Request.ScreenshotPath.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ScreenshotPath} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ScreenshotPath}
 */
proto.Request.ScreenshotPath.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setPath(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ScreenshotPath.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ScreenshotPath.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ScreenshotPath} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ScreenshotPath.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPath();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string path = 1;
 * @return {string}
 */
proto.Request.ScreenshotPath.prototype.getPath = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ScreenshotPath} returns this
 */
proto.Request.ScreenshotPath.prototype.setPath = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Browser.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Browser.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Browser} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Browser.toObject = function(includeInstance, msg) {
  var f, obj = {
    browser: jspb.Message.getFieldWithDefault(msg, 1, ""),
    headless: jspb.Message.getBooleanFieldWithDefault(msg, 2, false),
    rawoptions: jspb.Message.getFieldWithDefault(msg, 3, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Browser}
 */
proto.Request.Browser.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Browser;
  return proto.Request.Browser.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Browser} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Browser}
 */
proto.Request.Browser.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setBrowser(value);
      break;
    case 2:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setHeadless(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setRawoptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Browser.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Browser.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Browser} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Browser.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getBrowser();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getHeadless();
  if (f) {
    writer.writeBool(
      2,
      f
    );
  }
  f = message.getRawoptions();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
};


/**
 * optional string browser = 1;
 * @return {string}
 */
proto.Request.Browser.prototype.getBrowser = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setBrowser = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional bool headless = 2;
 * @return {boolean}
 */
proto.Request.Browser.prototype.getHeadless = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 2, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setHeadless = function(value) {
  return jspb.Message.setProto3BooleanField(this, 2, value);
};


/**
 * optional string rawOptions = 3;
 * @return {string}
 */
proto.Request.Browser.prototype.getRawoptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setRawoptions = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Context.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Context.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Context} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Context.toObject = function(includeInstance, msg) {
  var f, obj = {
    rawoptions: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Context}
 */
proto.Request.Context.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Context;
  return proto.Request.Context.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Context} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Context}
 */
proto.Request.Context.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setRawoptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Context.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Context.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Context} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Context.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getRawoptions();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string rawOptions = 1;
 * @return {string}
 */
proto.Request.Context.prototype.getRawoptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Context} returns this
 */
proto.Request.Context.prototype.setRawoptions = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Url.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Url.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Url} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Url.toObject = function(includeInstance, msg) {
  var f, obj = {
    url: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Url}
 */
proto.Request.Url.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Url;
  return proto.Request.Url.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Url} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Url}
 */
proto.Request.Url.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Url.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Url.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Url} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Url.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string url = 1;
 * @return {string}
 */
proto.Request.Url.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Url} returns this
 */
proto.Request.Url.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.TextInput.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.TextInput.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.TextInput} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TextInput.toObject = function(includeInstance, msg) {
  var f, obj = {
    input: jspb.Message.getFieldWithDefault(msg, 1, ""),
    selector: jspb.Message.getFieldWithDefault(msg, 2, ""),
    type: jspb.Message.getBooleanFieldWithDefault(msg, 3, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.TextInput}
 */
proto.Request.TextInput.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.TextInput;
  return proto.Request.TextInput.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.TextInput} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.TextInput}
 */
proto.Request.TextInput.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setInput(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 3:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.TextInput.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.TextInput.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.TextInput} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TextInput.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getInput();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getType();
  if (f) {
    writer.writeBool(
      3,
      f
    );
  }
};


/**
 * optional string input = 1;
 * @return {string}
 */
proto.Request.TextInput.prototype.getInput = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setInput = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string selector = 2;
 * @return {string}
 */
proto.Request.TextInput.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional bool type = 3;
 * @return {boolean}
 */
proto.Request.TextInput.prototype.getType = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 3, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setType = function(value) {
  return jspb.Message.setProto3BooleanField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementProperty.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementProperty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementProperty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementProperty.toObject = function(includeInstance, msg) {
  var f, obj = {
    property: jspb.Message.getFieldWithDefault(msg, 1, ""),
    selector: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementProperty}
 */
proto.Request.ElementProperty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementProperty;
  return proto.Request.ElementProperty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementProperty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementProperty}
 */
proto.Request.ElementProperty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setProperty(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementProperty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementProperty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementProperty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementProperty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getProperty();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string property = 1;
 * @return {string}
 */
proto.Request.ElementProperty.prototype.getProperty = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementProperty} returns this
 */
proto.Request.ElementProperty.prototype.setProperty = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string selector = 2;
 * @return {string}
 */
proto.Request.ElementProperty.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementProperty} returns this
 */
proto.Request.ElementProperty.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.TypeText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.TypeText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.TypeText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TypeText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    text: jspb.Message.getFieldWithDefault(msg, 2, ""),
    delay: jspb.Message.getFieldWithDefault(msg, 3, 0),
    clear: jspb.Message.getBooleanFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.TypeText}
 */
proto.Request.TypeText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.TypeText;
  return proto.Request.TypeText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.TypeText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.TypeText}
 */
proto.Request.TypeText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setText(value);
      break;
    case 3:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setDelay(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setClear(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.TypeText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.TypeText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.TypeText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TypeText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getText();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getDelay();
  if (f !== 0) {
    writer.writeInt32(
      3,
      f
    );
  }
  f = message.getClear();
  if (f) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.TypeText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string text = 2;
 * @return {string}
 */
proto.Request.TypeText.prototype.getText = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setText = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional int32 delay = 3;
 * @return {number}
 */
proto.Request.TypeText.prototype.getDelay = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setDelay = function(value) {
  return jspb.Message.setProto3IntField(this, 3, value);
};


/**
 * optional bool clear = 4;
 * @return {boolean}
 */
proto.Request.TypeText.prototype.getClear = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 4, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setClear = function(value) {
  return jspb.Message.setProto3BooleanField(this, 4, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.FillText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.FillText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.FillText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.FillText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    text: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.FillText}
 */
proto.Request.FillText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.FillText;
  return proto.Request.FillText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.FillText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.FillText}
 */
proto.Request.FillText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setText(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.FillText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.FillText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.FillText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.FillText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getText();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.FillText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.FillText} returns this
 */
proto.Request.FillText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string text = 2;
 * @return {string}
 */
proto.Request.FillText.prototype.getText = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.FillText} returns this
 */
proto.Request.FillText.prototype.setText = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ClearText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ClearText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ClearText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ClearText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ClearText}
 */
proto.Request.ClearText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ClearText;
  return proto.Request.ClearText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ClearText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ClearText}
 */
proto.Request.ClearText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ClearText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ClearText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ClearText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ClearText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ClearText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ClearText} returns this
 */
proto.Request.ClearText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Request.PressKeys.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.PressKeys.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.PressKeys.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.PressKeys} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PressKeys.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    keyList: (f = jspb.Message.getRepeatedField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.PressKeys}
 */
proto.Request.PressKeys.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.PressKeys;
  return proto.Request.PressKeys.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.PressKeys} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.PressKeys}
 */
proto.Request.PressKeys.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.addKey(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.PressKeys.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.PressKeys.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.PressKeys} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PressKeys.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getKeyList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.PressKeys.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated string key = 2;
 * @return {!Array<string>}
 */
proto.Request.PressKeys.prototype.getKeyList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 2));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.setKeyList = function(value) {
  return jspb.Message.setField(this, 2, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.addKey = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 2, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.clearKeyList = function() {
  return this.setKeyList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelector.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelector.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelector} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelector.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelector}
 */
proto.Request.ElementSelector.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelector;
  return proto.Request.ElementSelector.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelector} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelector}
 */
proto.Request.ElementSelector.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelector.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelector.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelector} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelector.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelector.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelector} returns this
 */
proto.Request.ElementSelector.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Timeout.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Timeout.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Timeout} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Timeout.toObject = function(includeInstance, msg) {
  var f, obj = {
    timeout: jspb.Message.getFloatingPointFieldWithDefault(msg, 1, 0.0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Timeout}
 */
proto.Request.Timeout.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Timeout;
  return proto.Request.Timeout.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Timeout} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Timeout}
 */
proto.Request.Timeout.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readFloat());
      msg.setTimeout(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Timeout.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Timeout.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Timeout} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Timeout.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTimeout();
  if (f !== 0.0) {
    writer.writeFloat(
      1,
      f
    );
  }
};


/**
 * optional float timeout = 1;
 * @return {number}
 */
proto.Request.Timeout.prototype.getTimeout = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 1, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Timeout} returns this
 */
proto.Request.Timeout.prototype.setTimeout = function(value) {
  return jspb.Message.setProto3FloatField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Index.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Index.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Index} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Index.toObject = function(includeInstance, msg) {
  var f, obj = {
    index: jspb.Message.getFieldWithDefault(msg, 1, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Index}
 */
proto.Request.Index.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Index;
  return proto.Request.Index.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Index} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Index}
 */
proto.Request.Index.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setIndex(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Index.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Index.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Index} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Index.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getIndex();
  if (f !== 0) {
    writer.writeInt32(
      1,
      f
    );
  }
};


/**
 * optional int32 index = 1;
 * @return {number}
 */
proto.Request.Index.prototype.getIndex = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Index} returns this
 */
proto.Request.Index.prototype.setIndex = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.StyleTag.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.StyleTag.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.StyleTag} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.StyleTag.toObject = function(includeInstance, msg) {
  var f, obj = {
    content: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.StyleTag}
 */
proto.Request.StyleTag.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.StyleTag;
  return proto.Request.StyleTag.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.StyleTag} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.StyleTag}
 */
proto.Request.StyleTag.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setContent(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.StyleTag.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.StyleTag.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.StyleTag} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.StyleTag.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getContent();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string content = 1;
 * @return {string}
 */
proto.Request.StyleTag.prototype.getContent = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.StyleTag} returns this
 */
proto.Request.StyleTag.prototype.setContent = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelectorWithOptions.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelectorWithOptions.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelectorWithOptions} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithOptions.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    options: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelectorWithOptions}
 */
proto.Request.ElementSelectorWithOptions.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelectorWithOptions;
  return proto.Request.ElementSelectorWithOptions.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelectorWithOptions} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelectorWithOptions}
 */
proto.Request.ElementSelectorWithOptions.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setOptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelectorWithOptions.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelectorWithOptions.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelectorWithOptions} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithOptions.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getOptions();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelectorWithOptions.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithOptions} returns this
 */
proto.Request.ElementSelectorWithOptions.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string options = 2;
 * @return {string}
 */
proto.Request.ElementSelectorWithOptions.prototype.getOptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithOptions} returns this
 */
proto.Request.ElementSelectorWithOptions.prototype.setOptions = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelectorWithDuration.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelectorWithDuration.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelectorWithDuration} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithDuration.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    duration: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelectorWithDuration}
 */
proto.Request.ElementSelectorWithDuration.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelectorWithDuration;
  return proto.Request.ElementSelectorWithDuration.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelectorWithDuration} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelectorWithDuration}
 */
proto.Request.ElementSelectorWithDuration.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setDuration(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelectorWithDuration.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelectorWithDuration.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelectorWithDuration} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithDuration.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getDuration();
  if (f !== 0) {
    writer.writeInt32(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelectorWithDuration.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithDuration} returns this
 */
proto.Request.ElementSelectorWithDuration.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int32 duration = 2;
 * @return {number}
 */
proto.Request.ElementSelectorWithDuration.prototype.getDuration = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.ElementSelectorWithDuration} returns this
 */
proto.Request.ElementSelectorWithDuration.prototype.setDuration = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.SelectElementSelector.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.SelectElementSelector.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.SelectElementSelector} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.SelectElementSelector.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    matcherjson: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.SelectElementSelector}
 */
proto.Request.SelectElementSelector.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.SelectElementSelector;
  return proto.Request.SelectElementSelector.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.SelectElementSelector} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.SelectElementSelector}
 */
proto.Request.SelectElementSelector.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setMatcherjson(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.SelectElementSelector.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.SelectElementSelector.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.SelectElementSelector} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.SelectElementSelector.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getMatcherjson();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.SelectElementSelector.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.SelectElementSelector} returns this
 */
proto.Request.SelectElementSelector.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string matcherJson = 2;
 * @return {string}
 */
proto.Request.SelectElementSelector.prototype.getMatcherjson = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.SelectElementSelector} returns this
 */
proto.Request.SelectElementSelector.prototype.setMatcherjson = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.JavascriptCode.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.JavascriptCode.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.JavascriptCode} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.JavascriptCode.toObject = function(includeInstance, msg) {
  var f, obj = {
    script: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.JavascriptCode}
 */
proto.Request.JavascriptCode.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.JavascriptCode;
  return proto.Request.JavascriptCode.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.JavascriptCode} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.JavascriptCode}
 */
proto.Request.JavascriptCode.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setScript(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.JavascriptCode.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.JavascriptCode.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.JavascriptCode} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.JavascriptCode.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getScript();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string script = 1;
 * @return {string}
 */
proto.Request.JavascriptCode.prototype.getScript = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.JavascriptCode} returns this
 */
proto.Request.JavascriptCode.prototype.setScript = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.RawJson.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.RawJson.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.RawJson} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.RawJson.toObject = function(includeInstance, msg) {
  var f, obj = {
    script: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.RawJson}
 */
proto.Request.RawJson.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.RawJson;
  return proto.Request.RawJson.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.RawJson} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.RawJson}
 */
proto.Request.RawJson.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setScript(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.RawJson.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.RawJson.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.RawJson} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.RawJson.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getScript();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string script = 1;
 * @return {string}
 */
proto.Request.RawJson.prototype.getScript = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.RawJson} returns this
 */
proto.Request.RawJson.prototype.setScript = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.SelectEntry.prototype.toObject = function(opt_includeInstance) {
  return proto.SelectEntry.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.SelectEntry} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.SelectEntry.toObject = function(includeInstance, msg) {
  var f, obj = {
    value: jspb.Message.getFieldWithDefault(msg, 2, ""),
    label: jspb.Message.getFieldWithDefault(msg, 3, ""),
    selected: jspb.Message.getBooleanFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.SelectEntry}
 */
proto.SelectEntry.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.SelectEntry;
  return proto.SelectEntry.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.SelectEntry} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.SelectEntry}
 */
proto.SelectEntry.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setValue(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setLabel(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setSelected(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.SelectEntry.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.SelectEntry.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.SelectEntry} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.SelectEntry.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValue();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getLabel();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getSelected();
  if (f) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional string value = 2;
 * @return {string}
 */
proto.SelectEntry.prototype.getValue = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.SelectEntry} returns this
 */
proto.SelectEntry.prototype.setValue = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string label = 3;
 * @return {string}
 */
proto.SelectEntry.prototype.getLabel = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.SelectEntry} returns this
 */
proto.SelectEntry.prototype.setLabel = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional bool selected = 4;
 * @return {boolean}
 */
proto.SelectEntry.prototype.getSelected = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 4, false));
};


/**
 * @param {boolean} value
 * @return {!proto.SelectEntry} returns this
 */
proto.SelectEntry.prototype.setSelected = function(value) {
  return jspb.Message.setProto3BooleanField(this, 4, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response}
 */
proto.Response.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response;
  return proto.Response.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response}
 */
proto.Response.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Empty.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Empty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Empty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Empty.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Empty}
 */
proto.Response.Empty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Empty;
  return proto.Response.Empty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Empty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Empty}
 */
proto.Response.Empty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Empty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Empty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Empty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Empty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Empty.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Empty} returns this
 */
proto.Response.Empty.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.String.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.String.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.String} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.String.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.String}
 */
proto.Response.String.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.String;
  return proto.Response.String.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.String} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.String}
 */
proto.Response.String.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.String.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.String.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.String} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.String.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.String.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.String} returns this
 */
proto.Response.String.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string body = 2;
 * @return {string}
 */
proto.Response.String.prototype.getBody = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.String} returns this
 */
proto.Response.String.prototype.setBody = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Bool.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Bool.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Bool} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Bool.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getBooleanFieldWithDefault(msg, 2, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Bool}
 */
proto.Response.Bool.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Bool;
  return proto.Response.Bool.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Bool} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Bool}
 */
proto.Response.Bool.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Bool.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Bool.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Bool} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Bool.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f) {
    writer.writeBool(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Bool.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Bool} returns this
 */
proto.Response.Bool.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional bool body = 2;
 * @return {boolean}
 */
proto.Response.Bool.prototype.getBody = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 2, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Response.Bool} returns this
 */
proto.Response.Bool.prototype.setBody = function(value) {
  return jspb.Message.setProto3BooleanField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Int.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Int.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Int} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Int.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Int}
 */
proto.Response.Int.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Int;
  return proto.Response.Int.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Int} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Int}
 */
proto.Response.Int.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Int.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Int.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Int} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Int.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f !== 0) {
    writer.writeInt32(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Int.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Int} returns this
 */
proto.Response.Int.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int32 body = 2;
 * @return {number}
 */
proto.Response.Int.prototype.getBody = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Response.Int} returns this
 */
proto.Response.Int.prototype.setBody = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Response.Select.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Select.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Select.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Select} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Select.toObject = function(includeInstance, msg) {
  var f, obj = {
    entryList: jspb.Message.toObjectList(msg.getEntryList(),
    proto.SelectEntry.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Select}
 */
proto.Response.Select.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Select;
  return proto.Response.Select.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Select} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Select}
 */
proto.Response.Select.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.SelectEntry;
      reader.readMessage(value,proto.SelectEntry.deserializeBinaryFromReader);
      msg.addEntry(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Select.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Select.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Select} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Select.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getEntryList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.SelectEntry.serializeBinaryToWriter
    );
  }
};


/**
 * repeated SelectEntry entry = 1;
 * @return {!Array<!proto.SelectEntry>}
 */
proto.Response.Select.prototype.getEntryList = function() {
  return /** @type{!Array<!proto.SelectEntry>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.SelectEntry, 1));
};


/**
 * @param {!Array<!proto.SelectEntry>} value
 * @return {!proto.Response.Select} returns this
*/
proto.Response.Select.prototype.setEntryList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.SelectEntry=} opt_value
 * @param {number=} opt_index
 * @return {!proto.SelectEntry}
 */
proto.Response.Select.prototype.addEntry = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.SelectEntry, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Response.Select} returns this
 */
proto.Response.Select.prototype.clearEntryList = function() {
  return this.setEntryList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.JavascriptExecutionResult.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.JavascriptExecutionResult.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.JavascriptExecutionResult} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.JavascriptExecutionResult.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    result: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.JavascriptExecutionResult}
 */
proto.Response.JavascriptExecutionResult.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.JavascriptExecutionResult;
  return proto.Response.JavascriptExecutionResult.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.JavascriptExecutionResult} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.JavascriptExecutionResult}
 */
proto.Response.JavascriptExecutionResult.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setResult(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.JavascriptExecutionResult.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.JavascriptExecutionResult.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.JavascriptExecutionResult} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.JavascriptExecutionResult.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getResult();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.JavascriptExecutionResult.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.JavascriptExecutionResult} returns this
 */
proto.Response.JavascriptExecutionResult.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string result = 2;
 * @return {string}
 */
proto.Response.JavascriptExecutionResult.prototype.getResult = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.JavascriptExecutionResult} returns this
 */
proto.Response.JavascriptExecutionResult.prototype.setResult = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


goog.object.extend(exports, proto);


/***/ }),

/***/ "./node/playwright-wrapper/getters.ts":
/*!********************************************!*\
  !*** ./node/playwright-wrapper/getters.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBoolProperty = exports.getDomProperty = exports.getSelectContent = exports.getElementCount = exports.getTextContent = exports.getUrl = exports.getTitle = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
var playwirght_util_1 = __webpack_require__(/*! ./playwirght-util */ "./node/playwright-wrapper/playwirght-util.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function getTitle(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var title;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'title')];
                case 1:
                    title = _a.sent();
                    callback(null, response_util_1.stringResponse(title));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getTitle = getTitle;
function getUrl(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_util_1.invokeOnPage(page, callback, 'url')];
                case 1:
                    url = _a.sent();
                    callback(null, response_util_1.stringResponse(url));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getUrl = getUrl;
function getTextContent(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, content;
        return __generator(this, function (_a) {
            selector = call.request.getSelector();
            content = playwirght_util_1.invokeOnPageWithSelector(page, callback, 'textContent', selector);
            callback(null, response_util_1.stringResponse((content === null || content === void 0 ? void 0 : content.toString()) || ''));
            return [2 /*return*/];
        });
    });
}
exports.getTextContent = getTextContent;
function getElementCount(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, '$$', selector)];
                case 1:
                    response = _a.sent();
                    callback(null, response_util_1.intResponse(response.length));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getElementCount = getElementCount;
function getSelectContent(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, content, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.waitUntilElementExists(page, callback, selector)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, '$$eval', selector + ' option', function (elements) { return elements.map(function (elem) { return [elem.label, elem.value, elem.selected]; }); })];
                case 2:
                    content = _a.sent();
                    response = new playwright_pb_1.Response.Select();
                    content.forEach(function (option) {
                        var _a = [option[0], option[1], option[2]], label = _a[0], value = _a[1], selected = _a[2];
                        var entry = new playwright_pb_1.SelectEntry();
                        entry.setLabel(label);
                        entry.setValue(value);
                        entry.setSelected(selected);
                        response.addEntry(entry);
                    });
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.getSelectContent = getSelectContent;
function getDomProperty(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getProperty(call, callback, page)];
                case 1:
                    content = _a.sent();
                    callback(null, response_util_1.stringResponse(content));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getDomProperty = getDomProperty;
function getBoolProperty(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getProperty(call, callback, page)];
                case 1:
                    content = _a.sent();
                    callback(null, response_util_1.boolResponse(content || false));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getBoolProperty = getBoolProperty;
function getProperty(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, element, propertyName, property, content, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.waitUntilElementExists(page, callback, selector)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, '$', selector)];
                case 2:
                    element = _a.sent();
                    _a.label = 3;
                case 3:
                    _a.trys.push([3, 6, , 7]);
                    propertyName = call.request.getProperty();
                    return [4 /*yield*/, element.getProperty(propertyName)];
                case 4:
                    property = _a.sent();
                    return [4 /*yield*/, property.jsonValue()];
                case 5:
                    content = _a.sent();
                    console.log("Retrieved dom property for element " + selector + " containing " + content);
                    return [2 /*return*/, content];
                case 6:
                    e_1 = _a.sent();
                    callback(e_1, null);
                    return [3 /*break*/, 7];
                case 7: return [2 /*return*/];
            }
        });
    });
}


/***/ }),

/***/ "./node/playwright-wrapper/index.ts":
/*!******************************************!*\
  !*** ./node/playwright-wrapper/index.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var grpc_1 = __webpack_require__(/*! grpc */ "grpc");
var playwright_grpc_pb_1 = __webpack_require__(/*! ./generated/playwright_grpc_pb */ "./node/playwright-wrapper/generated/playwright_grpc_pb.js");
var server_1 = __webpack_require__(/*! ./server */ "./node/playwright-wrapper/server.ts");
var server = new grpc_1.Server();
server.addService(playwright_grpc_pb_1.PlaywrightService, new server_1.PlaywrightServer());
var port = process.env.PORT || '0';
server.bind("localhost:" + port, grpc_1.ServerCredentials.createInsecure());
console.log("Listening on " + port);
server.start();


/***/ }),

/***/ "./node/playwright-wrapper/interaction.ts":
/*!************************************************!*\
  !*** ./node/playwright-wrapper/interaction.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uncheckCheckbox = exports.checkCheckbox = exports.focus = exports.clickWithOptions = exports.click = exports.press = exports.clearText = exports.fillText = exports.typeText = exports.inputText = exports.deSelectOption = exports.selectOption = void 0;
var playwirght_util_1 = __webpack_require__(/*! ./playwirght-util */ "./node/playwright-wrapper/playwirght-util.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function selectOption(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, matcher, result, error, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    matcher = JSON.parse(call.request.getMatcherjson());
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'selectOption', selector, matcher)];
                case 1:
                    result = _a.sent();
                    if (result.length == 0) {
                        console.log("Couldn't select any options");
                        error = new Error("No options matched " + matcher);
                        callback(error, null);
                    }
                    response = response_util_1.emptyWithLog("Selected options " + result + " in element " + selector);
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.selectOption = selectOption;
function deSelectOption(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'selectOption', selector, [])];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog("Deselected options in element " + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.deSelectOption = deSelectOption;
function inputText(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var inputText, selector, type, methodName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    inputText = call.request.getInput();
                    selector = call.request.getSelector();
                    type = call.request.getType();
                    methodName = type ? 'type' : 'fill';
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, methodName, selector, inputText)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Input text: ' + inputText));
                    return [2 /*return*/];
            }
        });
    });
}
exports.inputText = inputText;
function typeText(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, text, delay, clear;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    text = call.request.getText();
                    delay = call.request.getDelay();
                    clear = call.request.getClear();
                    if (!clear) return [3 /*break*/, 2];
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'fill', selector, '')];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2: return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'type', selector, text, { delay: delay })];
                case 3:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Typed text: ' + text));
                    return [2 /*return*/];
            }
        });
    });
}
exports.typeText = typeText;
function fillText(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, text;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    text = call.request.getText();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'fill', selector, text)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Fill text: ' + text));
                    return [2 /*return*/];
            }
        });
    });
}
exports.fillText = fillText;
function clearText(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'fill', selector, '')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Text field cleared.'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.clearText = clearText;
function press(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, keyList, _i, keyList_1, i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    keyList = call.request.getKeyList();
                    _i = 0, keyList_1 = keyList;
                    _a.label = 1;
                case 1:
                    if (!(_i < keyList_1.length)) return [3 /*break*/, 4];
                    i = keyList_1[_i];
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'press', selector, i)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4:
                    callback(null, response_util_1.emptyWithLog('Pressed keys: ' + keyList));
                    return [2 /*return*/];
            }
        });
    });
}
exports.press = press;
function click(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'click', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Clicked element: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.click = click;
function clickWithOptions(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, options;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    options = call.request.getOptions();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'click', selector, JSON.parse(options))];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Clicked element: ' + selector + ' \nWith options: ' + options));
                    return [2 /*return*/];
            }
        });
    });
}
exports.clickWithOptions = clickWithOptions;
function focus(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'focus', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Focused element: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.focus = focus;
function checkCheckbox(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'check', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Checked checkbox: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.checkCheckbox = checkCheckbox;
function uncheckCheckbox(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_util_1.invokeOnPageWithSelector(page, callback, 'uncheck', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Unchecked checkbox: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.uncheckCheckbox = uncheckCheckbox;


/***/ }),

/***/ "./node/playwright-wrapper/playwirght-util.ts":
/*!****************************************************!*\
  !*** ./node/playwright-wrapper/playwirght-util.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.exists = exports.invokeOnPageWithSelector = exports.invokeOnPage = exports.waitUntilElementExists = void 0;
var grpc_1 = __webpack_require__(/*! grpc */ "grpc");
var playwright_1 = __webpack_require__(/*! playwright */ "playwright");
function waitUntilElementExists(page, callback, selector) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, invokeOnPageWithSelector(page, callback, 'waitForSelector', selector, { state: 'attached' })];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.waitUntilElementExists = waitUntilElementExists;
function invokeOnPage(page, callback, methodName) {
    var args = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        args[_i - 3] = arguments[_i];
    }
    return __awaiter(this, void 0, void 0, function () {
        var fn, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exists(page, callback, "Tried to do playwright action '" + methodName + "', but no open page.");
                    fn = page[methodName].bind(page);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, fn.apply(void 0, args)];
                case 2: return [2 /*return*/, _a.sent()];
                case 3:
                    e_1 = _a.sent();
                    console.log("Error invoking Playwright action '" + methodName + "': " + e_1);
                    callback(e_1, null);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.invokeOnPage = invokeOnPage;
/**
 * Resolve the playwright method on page or frame and invoke it.
 * With a normal selector, invokes the `methodName` on the given `page`.
 * If the selector is a frame piercing selector, first find the corresponding
 * frame on the `page`, and then invoke the `methodName` on the resolved frame.
 *
 * @param page Existing Playwright Page object.
 * @param callback GRPC callback to make response.
 * @param methodName Which Playwright method to invoke.
 * @param selector Selector of the element to operate on,
 *  or a frame piercing selector in format `<frame selector> >>> <element selector>
 * @param args Additional args to the Playwirght method.
 */
function invokeOnPageWithSelector(page, callback, methodName, selector) {
    var args = [];
    for (var _i = 4; _i < arguments.length; _i++) {
        args[_i - 4] = arguments[_i];
    }
    return __awaiter(this, void 0, void 0, function () {
        var _a, elementSelector, fn, e_2, errorMetadata;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    exists(page, callback, "Tried to do playwright action '" + methodName + "', but no open browser.");
                    return [4 /*yield*/, determineFunctionAndSelector(page, methodName, selector, callback)];
                case 1:
                    _a = _b.sent(), elementSelector = _a.elementSelector, fn = _a.fn;
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, fn.apply(void 0, __spreadArrays([elementSelector], args))];
                case 3: return [2 /*return*/, _b.sent()];
                case 4:
                    e_2 = _b.sent();
                    if (e_2 instanceof playwright_1.errors.TimeoutError) {
                        errorMetadata = new grpc_1.Metadata();
                        errorMetadata.add('reason', "Could not find element with selector `" + selector + "` within timeout.");
                        callback({
                            code: grpc_1.status.INVALID_ARGUMENT,
                            name: e_2.name,
                            message: '',
                            details: "Error invoking Playwright action " + methodName + ":\n" + e_2.toString(),
                            metadata: errorMetadata,
                        }, null);
                    }
                    return [3 /*break*/, 5];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.invokeOnPageWithSelector = invokeOnPageWithSelector;
function determineFunctionAndSelector(page, methodName, selector, callback) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, frameSelector, elementSelector, frame, fn;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!isFramePiercingSelector(selector)) return [3 /*break*/, 2];
                    _a = splitFrameAndElementSelector(selector), frameSelector = _a.frameSelector, elementSelector = _a.elementSelector;
                    return [4 /*yield*/, findFrame(page, frameSelector, callback)];
                case 1:
                    frame = _b.sent();
                    fn = frame[methodName].bind(frame);
                    return [2 /*return*/, { elementSelector: elementSelector, fn: fn }];
                case 2: return [2 /*return*/, { elementSelector: selector, fn: page[methodName].bind(page) }];
            }
        });
    });
}
function isFramePiercingSelector(selector) {
    return selector.match('>>>');
}
function splitFrameAndElementSelector(selector) {
    var parts = selector.split('>>>');
    return {
        frameSelector: parts[0].trim(),
        elementSelector: parts[1].trim(),
    };
}
function findFrame(page, frameSelector, callback) {
    return __awaiter(this, void 0, void 0, function () {
        var frameHandle;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, page.$(frameSelector)];
                case 1:
                    frameHandle = _a.sent();
                    exists(frameHandle, callback, "Could not find frame with selector " + frameSelector);
                    return [4 /*yield*/, frameHandle.contentFrame()];
                case 2: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
// This is necessary for improved typescript inference
/*
 * If obj is not trueish call callback with new Error containing message
 */
function exists(obj, callback, message) {
    if (!obj) {
        callback(new Error(message), null);
    }
}
exports.exists = exists;


/***/ }),

/***/ "./node/playwright-wrapper/response-util.ts":
/*!**************************************************!*\
  !*** ./node/playwright-wrapper/response-util.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.jsResponse = exports.boolResponse = exports.intResponse = exports.stringResponse = exports.emptyWithLog = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
function emptyWithLog(text) {
    var response = new playwright_pb_1.Response.Empty();
    response.setLog(text);
    return response;
}
exports.emptyWithLog = emptyWithLog;
function stringResponse(body) {
    var response = new playwright_pb_1.Response.String();
    response.setBody(body);
    return response;
}
exports.stringResponse = stringResponse;
function intResponse(body) {
    var response = new playwright_pb_1.Response.Int();
    response.setBody(body);
    return response;
}
exports.intResponse = intResponse;
function boolResponse(value) {
    var response = new playwright_pb_1.Response.Bool();
    response.setBody(value);
    return response;
}
exports.boolResponse = boolResponse;
function jsResponse(result) {
    var response = new playwright_pb_1.Response.JavascriptExecutionResult();
    response.setResult(JSON.stringify(result));
    return response;
}
exports.jsResponse = jsResponse;


/***/ }),

/***/ "./node/playwright-wrapper/server.ts":
/*!*******************************************!*\
  !*** ./node/playwright-wrapper/server.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaywrightServer = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
var browserControl = __importStar(__webpack_require__(/*! ./browser-control */ "./node/playwright-wrapper/browser-control.ts"));
var evaluation = __importStar(__webpack_require__(/*! ./evaluation */ "./node/playwright-wrapper/evaluation.ts"));
var getters = __importStar(__webpack_require__(/*! ./getters */ "./node/playwright-wrapper/getters.ts"));
var interaction = __importStar(__webpack_require__(/*! ./interaction */ "./node/playwright-wrapper/interaction.ts"));
var browserState = __importStar(__webpack_require__(/*! ./browser-state */ "./node/playwright-wrapper/browser-state.ts"));
var browser_state_1 = __webpack_require__(/*! ./browser-state */ "./node/playwright-wrapper/browser-state.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
var PlaywrightServer = /** @class */ (function () {
    function PlaywrightServer() {
        var _this = this;
        this.setActiveBrowser = function (browser) {
            _this.browserState = browser;
        };
        this.browserState = new browser_state_1.BrowserState();
        this.openBrowsers = [this.browserState];
    }
    PlaywrightServer.prototype.closeBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.closeBrowser(callback, this.browserState);
                this.browserState = new browser_state_1.BrowserState();
                callback(null, response_util_1.emptyWithLog('Closed browser'));
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.autoActivatePages = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.autoActivatePages(call, callback, this.browserState);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchPage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.switchPage(call, callback, this.browserState);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchContext = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.switchContext(call, callback, this.browserState);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.switchBrowser(call, callback, this.openBrowsers, this.setActiveBrowser);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.createPage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.createPage(call, callback, this.browserState);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.createContext = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.createContext(call, callback, this.browserState);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.createBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserState.createBrowser(call, callback, this.openBrowsers, this.setActiveBrowser);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goTo = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                browserControl.goTo(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goBack = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                browserControl.goBack(callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goForward = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                browserControl.goForward(callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.takeScreenshot = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                browserControl.takeScreenshot(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.setTimeout = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                browserControl.setTimeout(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.context);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getTitle = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getTitle(callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getUrl = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getUrl(callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getTextContent = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getTextContent(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getElementCount = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getElementCount(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getSelectContent = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getSelectContent(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getDomProperty = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getDomProperty(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getBoolProperty = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                getters.getBoolProperty(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.selectOption = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.selectOption(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.deselectOption = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.deSelectOption(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.inputText = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.inputText(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.typeText = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.typeText(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.fillText = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.fillText(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.clearText = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.clearText(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.press = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.press(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.click = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.click(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.clickWithOptions = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.clickWithOptions(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.focus = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.focus(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.checkCheckbox = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.checkCheckbox(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.uncheckCheckbox = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                interaction.uncheckCheckbox(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.addStyleTag = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                evaluation.addStyleTag(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.waitForElementsState = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                evaluation.waitForElementState(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.executeJavascriptOnPage = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                evaluation.executeJavascriptOnPage(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getPageState = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                evaluation.getPageState(callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.health = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                response = new playwright_pb_1.Response.String();
                response.setBody('OK');
                callback(null, response);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.highlightElements = function (call, callback) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_b) {
                evaluation.highlightElements(call, callback, (_a = this.browserState) === null || _a === void 0 ? void 0 : _a.page);
                return [2 /*return*/];
            });
        });
    };
    return PlaywrightServer;
}());
exports.PlaywrightServer = PlaywrightServer;


/***/ }),

/***/ "./node_modules/google-protobuf/google-protobuf.js":
/*!*********************************************************!*\
  !*** ./node_modules/google-protobuf/google-protobuf.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.findInternal=function(a,b,c){a instanceof String&&(a=String(a));for(var d=a.length,e=0;e<d;e++){var f=a[e];if(b.call(c,f,e,a))return{i:e,v:f}}return{i:-1,v:void 0}};$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.SIMPLE_FROUND_POLYFILL=!1;
$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(a,b,c){a!=Array.prototype&&a!=Object.prototype&&(a[b]=c.value)};$jscomp.getGlobal=function(a){return"undefined"!=typeof window&&window===a?a:"undefined"!=typeof global&&null!=global?global:a};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.polyfill=function(a,b,c,d){if(b){c=$jscomp.global;a=a.split(".");for(d=0;d<a.length-1;d++){var e=a[d];e in c||(c[e]={});c=c[e]}a=a[a.length-1];d=c[a];b=b(d);b!=d&&null!=b&&$jscomp.defineProperty(c,a,{configurable:!0,writable:!0,value:b})}};$jscomp.polyfill("Array.prototype.findIndex",function(a){return a?a:function(a,c){return $jscomp.findInternal(this,a,c).i}},"es6","es3");
$jscomp.checkStringArgs=function(a,b,c){if(null==a)throw new TypeError("The 'this' value for String.prototype."+c+" must not be null or undefined");if(b instanceof RegExp)throw new TypeError("First argument to String.prototype."+c+" must not be a regular expression");return a+""};
$jscomp.polyfill("String.prototype.startsWith",function(a){return a?a:function(a,c){var b=$jscomp.checkStringArgs(this,a,"startsWith");a+="";var e=b.length,f=a.length;c=Math.max(0,Math.min(c|0,b.length));for(var g=0;g<f&&c<e;)if(b[c++]!=a[g++])return!1;return g>=f}},"es6","es3");
$jscomp.polyfill("String.prototype.endsWith",function(a){return a?a:function(a,c){var b=$jscomp.checkStringArgs(this,a,"endsWith");a+="";void 0===c&&(c=b.length);c=Math.max(0,Math.min(c|0,b.length));for(var e=a.length;0<e&&0<c;)if(b[--c]!=a[--e])return!1;return 0>=e}},"es6","es3");
$jscomp.polyfill("String.prototype.repeat",function(a){return a?a:function(a){var b=$jscomp.checkStringArgs(this,null,"repeat");if(0>a||1342177279<a)throw new RangeError("Invalid count value");a|=0;for(var d="";a;)if(a&1&&(d+=b),a>>>=1)b+=b;return d}},"es6","es3");$jscomp.polyfill("Array.prototype.find",function(a){return a?a:function(a,c){return $jscomp.findInternal(this,a,c).v}},"es6","es3");var COMPILED=!0,goog=goog||{};goog.global=this;goog.isDef=function(a){return void 0!==a};
goog.isString=function(a){return"string"==typeof a};goog.isBoolean=function(a){return"boolean"==typeof a};goog.isNumber=function(a){return"number"==typeof a};goog.exportPath_=function(a,b,c){a=a.split(".");c=c||goog.global;a[0]in c||"undefined"==typeof c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)!a.length&&goog.isDef(b)?c[d]=b:c=c[d]&&c[d]!==Object.prototype[d]?c[d]:c[d]={}};
goog.define=function(a,b){if(!COMPILED){var c=goog.global.CLOSURE_UNCOMPILED_DEFINES,d=goog.global.CLOSURE_DEFINES;c&&void 0===c.nodeType&&Object.prototype.hasOwnProperty.call(c,a)?b=c[a]:d&&void 0===d.nodeType&&Object.prototype.hasOwnProperty.call(d,a)&&(b=d[a])}goog.exportPath_(a,b);return b};goog.DEBUG=!0;goog.LOCALE="en";goog.TRUSTED_SITE=!0;goog.STRICT_MODE_COMPATIBLE=!1;goog.DISALLOW_TEST_ONLY_CODE=COMPILED&&!goog.DEBUG;goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING=!1;
goog.provide=function(a){if(goog.isInModuleLoader_())throw Error("goog.provide cannot be used within a module.");if(!COMPILED&&goog.isProvided_(a))throw Error('Namespace "'+a+'" already declared.');goog.constructNamespace_(a)};goog.constructNamespace_=function(a,b){if(!COMPILED){delete goog.implicitNamespaces_[a];for(var c=a;(c=c.substring(0,c.lastIndexOf(".")))&&!goog.getObjectByName(c);)goog.implicitNamespaces_[c]=!0}goog.exportPath_(a,b)};
goog.getScriptNonce=function(a){if(a&&a!=goog.global)return goog.getScriptNonce_(a.document);null===goog.cspNonce_&&(goog.cspNonce_=goog.getScriptNonce_(goog.global.document));return goog.cspNonce_};goog.NONCE_PATTERN_=/^[\w+/_-]+[=]{0,2}$/;goog.cspNonce_=null;goog.getScriptNonce_=function(a){return(a=a.querySelector&&a.querySelector("script[nonce]"))&&(a=a.nonce||a.getAttribute("nonce"))&&goog.NONCE_PATTERN_.test(a)?a:""};goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module=function(a){if(!goog.isString(a)||!a||-1==a.search(goog.VALID_MODULE_RE_))throw Error("Invalid module identifier");if(!goog.isInGoogModuleLoader_())throw Error("Module "+a+" has been loaded incorrectly. Note, modules cannot be loaded as normal scripts. They require some kind of pre-processing step. You're likely trying to load a module via a script tag or as a part of a concatenated bundle without rewriting the module. For more info see: https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");goog.moduleLoaderState_.moduleName=a;if(!COMPILED){if(goog.isProvided_(a))throw Error('Namespace "'+a+'" already declared.');delete goog.implicitNamespaces_[a]}};goog.module.get=function(a){return goog.module.getInternal_(a)};
goog.module.getInternal_=function(a){if(!COMPILED){if(a in goog.loadedModules_)return goog.loadedModules_[a].exports;if(!goog.implicitNamespaces_[a])return a=goog.getObjectByName(a),null!=a?a:null}return null};goog.ModuleType={ES6:"es6",GOOG:"goog"};goog.moduleLoaderState_=null;goog.isInModuleLoader_=function(){return goog.isInGoogModuleLoader_()||goog.isInEs6ModuleLoader_()};goog.isInGoogModuleLoader_=function(){return!!goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.GOOG};
goog.isInEs6ModuleLoader_=function(){if(goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.ES6)return!0;var a=goog.global.$jscomp;return a?"function"!=typeof a.getCurrentModulePath?!1:!!a.getCurrentModulePath():!1};
goog.module.declareLegacyNamespace=function(){if(!COMPILED&&!goog.isInGoogModuleLoader_())throw Error("goog.module.declareLegacyNamespace must be called from within a goog.module");if(!COMPILED&&!goog.moduleLoaderState_.moduleName)throw Error("goog.module must be called prior to goog.module.declareLegacyNamespace.");goog.moduleLoaderState_.declareLegacyNamespace=!0};
goog.declareModuleId=function(a){if(!COMPILED){if(!goog.isInEs6ModuleLoader_())throw Error("goog.declareModuleId may only be called from within an ES6 module");if(goog.moduleLoaderState_&&goog.moduleLoaderState_.moduleName)throw Error("goog.declareModuleId may only be called once per module.");if(a in goog.loadedModules_)throw Error('Module with namespace "'+a+'" already exists.');}if(goog.moduleLoaderState_)goog.moduleLoaderState_.moduleName=a;else{var b=goog.global.$jscomp;if(!b||"function"!=typeof b.getCurrentModulePath)throw Error('Module with namespace "'+
a+'" has been loaded incorrectly.');b=b.require(b.getCurrentModulePath());goog.loadedModules_[a]={exports:b,type:goog.ModuleType.ES6,moduleId:a}}};goog.module.declareNamespace=goog.declareModuleId;goog.setTestOnly=function(a){if(goog.DISALLOW_TEST_ONLY_CODE)throw a=a||"",Error("Importing test-only code into non-debug environment"+(a?": "+a:"."));};goog.forwardDeclare=function(a){};
COMPILED||(goog.isProvided_=function(a){return a in goog.loadedModules_||!goog.implicitNamespaces_[a]&&goog.isDefAndNotNull(goog.getObjectByName(a))},goog.implicitNamespaces_={"goog.module":!0});goog.getObjectByName=function(a,b){a=a.split(".");b=b||goog.global;for(var c=0;c<a.length;c++)if(b=b[a[c]],!goog.isDefAndNotNull(b))return null;return b};goog.globalize=function(a,b){b=b||goog.global;for(var c in a)b[c]=a[c]};
goog.addDependency=function(a,b,c,d){!COMPILED&&goog.DEPENDENCIES_ENABLED&&goog.debugLoader_.addDependency(a,b,c,d)};goog.ENABLE_DEBUG_LOADER=!0;goog.logToConsole_=function(a){goog.global.console&&goog.global.console.error(a)};
goog.require=function(a){if(!COMPILED){goog.ENABLE_DEBUG_LOADER&&goog.debugLoader_.requested(a);if(goog.isProvided_(a)){if(goog.isInModuleLoader_())return goog.module.getInternal_(a)}else if(goog.ENABLE_DEBUG_LOADER){var b=goog.moduleLoaderState_;goog.moduleLoaderState_=null;try{goog.debugLoader_.load_(a)}finally{goog.moduleLoaderState_=b}}return null}};goog.requireType=function(a){return{}};goog.basePath="";goog.nullFunction=function(){};
goog.abstractMethod=function(){throw Error("unimplemented abstract method");};goog.addSingletonGetter=function(a){a.instance_=void 0;a.getInstance=function(){if(a.instance_)return a.instance_;goog.DEBUG&&(goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=a);return a.instance_=new a}};goog.instantiatedSingletons_=[];goog.LOAD_MODULE_USING_EVAL=!0;goog.SEAL_MODULE_EXPORTS=goog.DEBUG;goog.loadedModules_={};goog.DEPENDENCIES_ENABLED=!COMPILED&&goog.ENABLE_DEBUG_LOADER;goog.TRANSPILE="detect";
goog.ASSUME_ES_MODULES_TRANSPILED=!1;goog.TRANSPILE_TO_LANGUAGE="";goog.TRANSPILER="transpile.js";goog.hasBadLetScoping=null;goog.useSafari10Workaround=function(){if(null==goog.hasBadLetScoping){try{var a=!eval('"use strict";let x = 1; function f() { return typeof x; };f() == "number";')}catch(b){a=!1}goog.hasBadLetScoping=a}return goog.hasBadLetScoping};goog.workaroundSafari10EvalBug=function(a){return"(function(){"+a+"\n;})();\n"};
goog.loadModule=function(a){var b=goog.moduleLoaderState_;try{goog.moduleLoaderState_={moduleName:"",declareLegacyNamespace:!1,type:goog.ModuleType.GOOG};if(goog.isFunction(a))var c=a.call(void 0,{});else if(goog.isString(a))goog.useSafari10Workaround()&&(a=goog.workaroundSafari10EvalBug(a)),c=goog.loadModuleFromSource_.call(void 0,a);else throw Error("Invalid module definition");var d=goog.moduleLoaderState_.moduleName;if(goog.isString(d)&&d)goog.moduleLoaderState_.declareLegacyNamespace?goog.constructNamespace_(d,
c):goog.SEAL_MODULE_EXPORTS&&Object.seal&&"object"==typeof c&&null!=c&&Object.seal(c),goog.loadedModules_[d]={exports:c,type:goog.ModuleType.GOOG,moduleId:goog.moduleLoaderState_.moduleName};else throw Error('Invalid module name "'+d+'"');}finally{goog.moduleLoaderState_=b}};goog.loadModuleFromSource_=function(a){eval(a);return{}};goog.normalizePath_=function(a){a=a.split("/");for(var b=0;b<a.length;)"."==a[b]?a.splice(b,1):b&&".."==a[b]&&a[b-1]&&".."!=a[b-1]?a.splice(--b,2):b++;return a.join("/")};
goog.loadFileSync_=function(a){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(a);try{var b=new goog.global.XMLHttpRequest;b.open("get",a,!1);b.send();return 0==b.status||200==b.status?b.responseText:null}catch(c){return null}};
goog.transpile_=function(a,b,c){var d=goog.global.$jscomp;d||(goog.global.$jscomp=d={});var e=d.transpile;if(!e){var f=goog.basePath+goog.TRANSPILER,g=goog.loadFileSync_(f);if(g){(function(){eval(g+"\n//# sourceURL="+f)}).call(goog.global);if(goog.global.$gwtExport&&goog.global.$gwtExport.$jscomp&&!goog.global.$gwtExport.$jscomp.transpile)throw Error('The transpiler did not properly export the "transpile" method. $gwtExport: '+JSON.stringify(goog.global.$gwtExport));goog.global.$jscomp.transpile=
goog.global.$gwtExport.$jscomp.transpile;d=goog.global.$jscomp;e=d.transpile}}e||(e=d.transpile=function(a,b){goog.logToConsole_(b+" requires transpilation but no transpiler was found.");return a});return e(a,b,c)};
goog.typeOf=function(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b};goog.isNull=function(a){return null===a};goog.isDefAndNotNull=function(a){return null!=a};goog.isArray=function(a){return"array"==goog.typeOf(a)};goog.isArrayLike=function(a){var b=goog.typeOf(a);return"array"==b||"object"==b&&"number"==typeof a.length};goog.isDateLike=function(a){return goog.isObject(a)&&"function"==typeof a.getFullYear};goog.isFunction=function(a){return"function"==goog.typeOf(a)};
goog.isObject=function(a){var b=typeof a;return"object"==b&&null!=a||"function"==b};goog.getUid=function(a){return a[goog.UID_PROPERTY_]||(a[goog.UID_PROPERTY_]=++goog.uidCounter_)};goog.hasUid=function(a){return!!a[goog.UID_PROPERTY_]};goog.removeUid=function(a){null!==a&&"removeAttribute"in a&&a.removeAttribute(goog.UID_PROPERTY_);try{delete a[goog.UID_PROPERTY_]}catch(b){}};goog.UID_PROPERTY_="closure_uid_"+(1E9*Math.random()>>>0);goog.uidCounter_=0;goog.getHashCode=goog.getUid;
goog.removeHashCode=goog.removeUid;goog.cloneObject=function(a){var b=goog.typeOf(a);if("object"==b||"array"==b){if("function"===typeof a.clone)return a.clone();b="array"==b?[]:{};for(var c in a)b[c]=goog.cloneObject(a[c]);return b}return a};goog.bindNative_=function(a,b,c){return a.call.apply(a.bind,arguments)};
goog.bindJs_=function(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}};goog.bind=function(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?goog.bind=goog.bindNative_:goog.bind=goog.bindJs_;return goog.bind.apply(null,arguments)};
goog.partial=function(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}};goog.mixin=function(a,b){for(var c in b)a[c]=b[c]};goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date};
goog.globalEval=function(a){if(goog.global.execScript)goog.global.execScript(a,"JavaScript");else if(goog.global.eval){if(null==goog.evalWorksForGlobals_){try{goog.global.eval("var _evalTest_ = 1;")}catch(d){}if("undefined"!=typeof goog.global._evalTest_){try{delete goog.global._evalTest_}catch(d){}goog.evalWorksForGlobals_=!0}else goog.evalWorksForGlobals_=!1}if(goog.evalWorksForGlobals_)goog.global.eval(a);else{var b=goog.global.document,c=b.createElement("SCRIPT");c.type="text/javascript";c.defer=
!1;c.appendChild(b.createTextNode(a));b.head.appendChild(c);b.head.removeChild(c)}}else throw Error("goog.globalEval not available");};goog.evalWorksForGlobals_=null;
goog.getCssName=function(a,b){if("."==String(a).charAt(0))throw Error('className passed in goog.getCssName must not start with ".". You passed: '+a);var c=function(a){return goog.cssNameMapping_[a]||a},d=function(a){a=a.split("-");for(var b=[],d=0;d<a.length;d++)b.push(c(a[d]));return b.join("-")};d=goog.cssNameMapping_?"BY_WHOLE"==goog.cssNameMappingStyle_?c:d:function(a){return a};a=b?a+"-"+d(b):d(a);return goog.global.CLOSURE_CSS_NAME_MAP_FN?goog.global.CLOSURE_CSS_NAME_MAP_FN(a):a};
goog.setCssNameMapping=function(a,b){goog.cssNameMapping_=a;goog.cssNameMappingStyle_=b};!COMPILED&&goog.global.CLOSURE_CSS_NAME_MAPPING&&(goog.cssNameMapping_=goog.global.CLOSURE_CSS_NAME_MAPPING);goog.getMsg=function(a,b){b&&(a=a.replace(/\{\$([^}]+)}/g,function(a,d){return null!=b&&d in b?b[d]:a}));return a};goog.getMsgWithFallback=function(a,b){return a};goog.exportSymbol=function(a,b,c){goog.exportPath_(a,b,c)};goog.exportProperty=function(a,b,c){a[b]=c};
goog.inherits=function(a,b){function c(){}c.prototype=b.prototype;a.superClass_=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.base=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};
goog.base=function(a,b,c){var d=arguments.callee.caller;if(goog.STRICT_MODE_COMPATIBLE||goog.DEBUG&&!d)throw Error("arguments.caller not defined.  goog.base() cannot be used with strict mode code. See http://www.ecma-international.org/ecma-262/5.1/#sec-C");if("undefined"!==typeof d.superClass_){for(var e=Array(arguments.length-1),f=1;f<arguments.length;f++)e[f-1]=arguments[f];return d.superClass_.constructor.apply(a,e)}if("string"!=typeof b&&"symbol"!=typeof b)throw Error("method names provided to goog.base must be a string or a symbol");
e=Array(arguments.length-2);for(f=2;f<arguments.length;f++)e[f-2]=arguments[f];f=!1;for(var g=a.constructor;g;g=g.superClass_&&g.superClass_.constructor)if(g.prototype[b]===d)f=!0;else if(f)return g.prototype[b].apply(a,e);if(a[b]===d)return a.constructor.prototype[b].apply(a,e);throw Error("goog.base called from a method of one name to a method of a different name");};goog.scope=function(a){if(goog.isInModuleLoader_())throw Error("goog.scope is not supported within a module.");a.call(goog.global)};
COMPILED||(goog.global.COMPILED=COMPILED);goog.defineClass=function(a,b){var c=b.constructor,d=b.statics;c&&c!=Object.prototype.constructor||(c=function(){throw Error("cannot instantiate an interface (no constructor defined).");});c=goog.defineClass.createSealingConstructor_(c,a);a&&goog.inherits(c,a);delete b.constructor;delete b.statics;goog.defineClass.applyProperties_(c.prototype,b);null!=d&&(d instanceof Function?d(c):goog.defineClass.applyProperties_(c,d));return c};
goog.defineClass.SEAL_CLASS_INSTANCES=goog.DEBUG;goog.defineClass.createSealingConstructor_=function(a,b){if(!goog.defineClass.SEAL_CLASS_INSTANCES)return a;var c=!goog.defineClass.isUnsealable_(b),d=function(){var b=a.apply(this,arguments)||this;b[goog.UID_PROPERTY_]=b[goog.UID_PROPERTY_];this.constructor===d&&c&&Object.seal instanceof Function&&Object.seal(b);return b};return d};goog.defineClass.isUnsealable_=function(a){return a&&a.prototype&&a.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");goog.defineClass.applyProperties_=function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c]);for(var d=0;d<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;d++)c=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[d],Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};
goog.tagUnsealableClass=function(a){!COMPILED&&goog.defineClass.SEAL_CLASS_INSTANCES&&(a.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]=!0)};goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable";
!COMPILED&&goog.DEPENDENCIES_ENABLED&&(goog.inHtmlDocument_=function(){var a=goog.global.document;return null!=a&&"write"in a},goog.isDocumentLoading_=function(){var a=goog.global.document;return a.attachEvent?"complete"!=a.readyState:"loading"==a.readyState},goog.findBasePath_=function(){if(goog.isDef(goog.global.CLOSURE_BASE_PATH)&&goog.isString(goog.global.CLOSURE_BASE_PATH))goog.basePath=goog.global.CLOSURE_BASE_PATH;else if(goog.inHtmlDocument_()){var a=goog.global.document,b=a.currentScript;
a=b?[b]:a.getElementsByTagName("SCRIPT");for(b=a.length-1;0<=b;--b){var c=a[b].src,d=c.lastIndexOf("?");d=-1==d?c.length:d;if("base.js"==c.substr(d-7,7)){goog.basePath=c.substr(0,d-7);break}}}},goog.findBasePath_(),goog.Transpiler=function(){this.requiresTranspilation_=null;this.transpilationTarget_=goog.TRANSPILE_TO_LANGUAGE},goog.Transpiler.prototype.createRequiresTranspilation_=function(){function a(a,b){e?d[a]=!0:b()?(c=a,d[a]=!1):e=d[a]=!0}function b(a){try{return!!eval(a)}catch(h){return!1}}
var c="es3",d={es3:!1},e=!1,f=goog.global.navigator&&goog.global.navigator.userAgent?goog.global.navigator.userAgent:"";a("es5",function(){return b("[1,].length==1")});a("es6",function(){return f.match(/Edge\/(\d+)(\.\d)*/i)?!1:b('(()=>{"use strict";class X{constructor(){if(new.target!=String)throw 1;this.x=42}}let q=Reflect.construct(X,[],String);if(q.x!=42||!(q instanceof String))throw 1;for(const a of[2,3]){if(a==2)continue;function f(z={a}){let a=0;return z.a}{function f(){return 0;}}return f()==3}})()')});
a("es6-impl",function(){return!0});a("es7",function(){return b("2 ** 2 == 4")});a("es8",function(){return b("async () => 1, true")});a("es9",function(){return b("({...rest} = {}), true")});a("es_next",function(){return!1});return{target:c,map:d}},goog.Transpiler.prototype.needsTranspile=function(a,b){if("always"==goog.TRANSPILE)return!0;if("never"==goog.TRANSPILE)return!1;if(!this.requiresTranspilation_){var c=this.createRequiresTranspilation_();this.requiresTranspilation_=c.map;this.transpilationTarget_=
this.transpilationTarget_||c.target}if(a in this.requiresTranspilation_)return this.requiresTranspilation_[a]?!0:!goog.inHtmlDocument_()||"es6"!=b||"noModule"in goog.global.document.createElement("script")?!1:!0;throw Error("Unknown language mode: "+a);},goog.Transpiler.prototype.transpile=function(a,b){return goog.transpile_(a,b,this.transpilationTarget_)},goog.transpiler_=new goog.Transpiler,goog.protectScriptTag_=function(a){return a.replace(/<\/(SCRIPT)/ig,"\\x3c/$1")},goog.DebugLoader_=function(){this.dependencies_=
{};this.idToPath_={};this.written_={};this.loadingDeps_=[];this.depsToLoad_=[];this.paused_=!1;this.factory_=new goog.DependencyFactory(goog.transpiler_);this.deferredCallbacks_={};this.deferredQueue_=[]},goog.DebugLoader_.prototype.bootstrap=function(a,b){function c(){d&&(goog.global.setTimeout(d,0),d=null)}var d=b;if(a.length){b=[];for(var e=0;e<a.length;e++){var f=this.getPathFromDeps_(a[e]);if(!f)throw Error("Unregonized namespace: "+a[e]);b.push(this.dependencies_[f])}f=goog.require;var g=0;
for(e=0;e<a.length;e++)f(a[e]),b[e].onLoad(function(){++g==a.length&&c()})}else c()},goog.DebugLoader_.prototype.loadClosureDeps=function(){this.depsToLoad_.push(this.factory_.createDependency(goog.normalizePath_(goog.basePath+"deps.js"),"deps.js",[],[],{},!1));this.loadDeps_()},goog.DebugLoader_.prototype.requested=function(a,b){(a=this.getPathFromDeps_(a))&&(b||this.areDepsLoaded_(this.dependencies_[a].requires))&&(b=this.deferredCallbacks_[a])&&(delete this.deferredCallbacks_[a],b())},goog.DebugLoader_.prototype.setDependencyFactory=
function(a){this.factory_=a},goog.DebugLoader_.prototype.load_=function(a){if(this.getPathFromDeps_(a)){var b=this,c=[],d=function(a){var e=b.getPathFromDeps_(a);if(!e)throw Error("Bad dependency path or symbol: "+a);if(!b.written_[e]){b.written_[e]=!0;a=b.dependencies_[e];for(e=0;e<a.requires.length;e++)goog.isProvided_(a.requires[e])||d(a.requires[e]);c.push(a)}};d(a);a=!!this.depsToLoad_.length;this.depsToLoad_=this.depsToLoad_.concat(c);this.paused_||a||this.loadDeps_()}else throw a="goog.require could not find: "+
a,goog.logToConsole_(a),Error(a);},goog.DebugLoader_.prototype.loadDeps_=function(){for(var a=this,b=this.paused_;this.depsToLoad_.length&&!b;)(function(){var c=!1,d=a.depsToLoad_.shift(),e=!1;a.loading_(d);var f={pause:function(){if(c)throw Error("Cannot call pause after the call to load.");b=!0},resume:function(){c?a.resume_():b=!1},loaded:function(){if(e)throw Error("Double call to loaded.");e=!0;a.loaded_(d)},pending:function(){for(var b=[],c=0;c<a.loadingDeps_.length;c++)b.push(a.loadingDeps_[c]);
return b},setModuleState:function(a){goog.moduleLoaderState_={type:a,moduleName:"",declareLegacyNamespace:!1}},registerEs6ModuleExports:function(a,b,c){c&&(goog.loadedModules_[c]={exports:b,type:goog.ModuleType.ES6,moduleId:c||""})},registerGoogModuleExports:function(a,b){goog.loadedModules_[a]={exports:b,type:goog.ModuleType.GOOG,moduleId:a}},clearModuleState:function(){goog.moduleLoaderState_=null},defer:function(b){if(c)throw Error("Cannot register with defer after the call to load.");a.defer_(d,
b)},areDepsLoaded:function(){return a.areDepsLoaded_(d.requires)}};try{d.load(f)}finally{c=!0}})();b&&this.pause_()},goog.DebugLoader_.prototype.pause_=function(){this.paused_=!0},goog.DebugLoader_.prototype.resume_=function(){this.paused_&&(this.paused_=!1,this.loadDeps_())},goog.DebugLoader_.prototype.loading_=function(a){this.loadingDeps_.push(a)},goog.DebugLoader_.prototype.loaded_=function(a){for(var b=0;b<this.loadingDeps_.length;b++)if(this.loadingDeps_[b]==a){this.loadingDeps_.splice(b,1);
break}for(b=0;b<this.deferredQueue_.length;b++)if(this.deferredQueue_[b]==a.path){this.deferredQueue_.splice(b,1);break}if(this.loadingDeps_.length==this.deferredQueue_.length&&!this.depsToLoad_.length)for(;this.deferredQueue_.length;)this.requested(this.deferredQueue_.shift(),!0);a.loaded()},goog.DebugLoader_.prototype.areDepsLoaded_=function(a){for(var b=0;b<a.length;b++){var c=this.getPathFromDeps_(a[b]);if(!c||!(c in this.deferredCallbacks_||goog.isProvided_(a[b])))return!1}return!0},goog.DebugLoader_.prototype.getPathFromDeps_=
function(a){return a in this.idToPath_?this.idToPath_[a]:a in this.dependencies_?a:null},goog.DebugLoader_.prototype.defer_=function(a,b){this.deferredCallbacks_[a.path]=b;this.deferredQueue_.push(a.path)},goog.LoadController=function(){},goog.LoadController.prototype.pause=function(){},goog.LoadController.prototype.resume=function(){},goog.LoadController.prototype.loaded=function(){},goog.LoadController.prototype.pending=function(){},goog.LoadController.prototype.registerEs6ModuleExports=function(a,
b,c){},goog.LoadController.prototype.setModuleState=function(a){},goog.LoadController.prototype.clearModuleState=function(){},goog.LoadController.prototype.defer=function(a){},goog.LoadController.prototype.areDepsLoaded=function(){},goog.Dependency=function(a,b,c,d,e){this.path=a;this.relativePath=b;this.provides=c;this.requires=d;this.loadFlags=e;this.loaded_=!1;this.loadCallbacks_=[]},goog.Dependency.prototype.getPathName=function(){var a=this.path,b=a.indexOf("://");0<=b&&(a=a.substring(b+3),b=
a.indexOf("/"),0<=b&&(a=a.substring(b+1)));return a},goog.Dependency.prototype.onLoad=function(a){this.loaded_?a():this.loadCallbacks_.push(a)},goog.Dependency.prototype.loaded=function(){this.loaded_=!0;var a=this.loadCallbacks_;this.loadCallbacks_=[];for(var b=0;b<a.length;b++)a[b]()},goog.Dependency.defer_=!1,goog.Dependency.callbackMap_={},goog.Dependency.registerCallback_=function(a){var b=Math.random().toString(32);goog.Dependency.callbackMap_[b]=a;return b},goog.Dependency.unregisterCallback_=
function(a){delete goog.Dependency.callbackMap_[a]},goog.Dependency.callback_=function(a,b){if(a in goog.Dependency.callbackMap_){for(var c=goog.Dependency.callbackMap_[a],d=[],e=1;e<arguments.length;e++)d.push(arguments[e]);c.apply(void 0,d)}else throw Error("Callback key "+a+" does not exist (was base.js loaded more than once?).");},goog.Dependency.prototype.load=function(a){if(goog.global.CLOSURE_IMPORT_SCRIPT)goog.global.CLOSURE_IMPORT_SCRIPT(this.path)?a.loaded():a.pause();else if(goog.inHtmlDocument_()){var b=
goog.global.document;if("complete"==b.readyState&&!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING){if(/\bdeps.js$/.test(this.path)){a.loaded();return}throw Error('Cannot write "'+this.path+'" after document load');}if(!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING&&goog.isDocumentLoading_()){var c=goog.Dependency.registerCallback_(function(b){goog.DebugLoader_.IS_OLD_IE_&&"complete"!=b.readyState||(goog.Dependency.unregisterCallback_(c),a.loaded())}),d=!goog.DebugLoader_.IS_OLD_IE_&&goog.getScriptNonce()?
' nonce="'+goog.getScriptNonce()+'"':"";b.write('<script src="'+this.path+'" '+(goog.DebugLoader_.IS_OLD_IE_?"onreadystatechange":"onload")+"=\"goog.Dependency.callback_('"+c+'\', this)" type="text/javascript" '+(goog.Dependency.defer_?"defer":"")+d+">\x3c/script>")}else{var e=b.createElement("script");e.defer=goog.Dependency.defer_;e.async=!1;e.type="text/javascript";(d=goog.getScriptNonce())&&e.setAttribute("nonce",d);goog.DebugLoader_.IS_OLD_IE_?(a.pause(),e.onreadystatechange=function(){if("loaded"==
e.readyState||"complete"==e.readyState)a.loaded(),a.resume()}):e.onload=function(){e.onload=null;a.loaded()};e.src=this.path;b.head.appendChild(e)}}else goog.logToConsole_("Cannot use default debug loader outside of HTML documents."),"deps.js"==this.relativePath?(goog.logToConsole_("Consider setting CLOSURE_IMPORT_SCRIPT before loading base.js, or setting CLOSURE_NO_DEPS to true."),a.loaded()):a.pause()},goog.Es6ModuleDependency=function(a,b,c,d,e){goog.Dependency.call(this,a,b,c,d,e)},goog.inherits(goog.Es6ModuleDependency,
goog.Dependency),goog.Es6ModuleDependency.prototype.load=function(a){function b(a,b){b?d.write('<script type="module" crossorigin>'+b+"\x3c/script>"):d.write('<script type="module" crossorigin src="'+a+'">\x3c/script>')}function c(a,b){var c=d.createElement("script");c.defer=!0;c.async=!1;c.type="module";c.setAttribute("crossorigin",!0);var e=goog.getScriptNonce();e&&c.setAttribute("nonce",e);b?c.textContent=b:c.src=a;d.head.appendChild(c)}if(goog.global.CLOSURE_IMPORT_SCRIPT)goog.global.CLOSURE_IMPORT_SCRIPT(this.path)?
a.loaded():a.pause();else if(goog.inHtmlDocument_()){var d=goog.global.document,e=this;if(goog.isDocumentLoading_()){var f=b;goog.Dependency.defer_=!0}else f=c;var g=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(g);a.setModuleState(goog.ModuleType.ES6)});f(void 0,'goog.Dependency.callback_("'+g+'")');f(this.path,void 0);var h=goog.Dependency.registerCallback_(function(b){goog.Dependency.unregisterCallback_(h);a.registerEs6ModuleExports(e.path,b,goog.moduleLoaderState_.moduleName)});
f(void 0,'import * as m from "'+this.path+'"; goog.Dependency.callback_("'+h+'", m)');var k=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(k);a.clearModuleState();a.loaded()});f(void 0,'goog.Dependency.callback_("'+k+'")')}else goog.logToConsole_("Cannot use default debug loader outside of HTML documents."),a.pause()},goog.TransformedDependency=function(a,b,c,d,e){goog.Dependency.call(this,a,b,c,d,e);this.contents_=null;this.lazyFetch_=!goog.inHtmlDocument_()||!("noModule"in
goog.global.document.createElement("script"))},goog.inherits(goog.TransformedDependency,goog.Dependency),goog.TransformedDependency.prototype.load=function(a){function b(){e.contents_=goog.loadFileSync_(e.path);e.contents_&&(e.contents_=e.transform(e.contents_),e.contents_&&(e.contents_+="\n//# sourceURL="+e.path))}function c(){e.lazyFetch_&&b();if(e.contents_){f&&a.setModuleState(goog.ModuleType.ES6);try{var c=e.contents_;e.contents_=null;goog.globalEval(c);if(f)var d=goog.moduleLoaderState_.moduleName}finally{f&&
a.clearModuleState()}f&&goog.global.$jscomp.require.ensure([e.getPathName()],function(){a.registerEs6ModuleExports(e.path,goog.global.$jscomp.require(e.getPathName()),d)});a.loaded()}}function d(){var a=goog.global.document,b=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(b);c()});a.write('<script type="text/javascript">'+goog.protectScriptTag_('goog.Dependency.callback_("'+b+'");')+"\x3c/script>")}var e=this;if(goog.global.CLOSURE_IMPORT_SCRIPT)b(),this.contents_&&
goog.global.CLOSURE_IMPORT_SCRIPT("",this.contents_)?(this.contents_=null,a.loaded()):a.pause();else{var f=this.loadFlags.module==goog.ModuleType.ES6;this.lazyFetch_||b();var g=1<a.pending().length,h=g&&goog.DebugLoader_.IS_OLD_IE_;g=goog.Dependency.defer_&&(g||goog.isDocumentLoading_());if(h||g)a.defer(function(){c()});else{var k=goog.global.document;h=goog.inHtmlDocument_()&&"ActiveXObject"in goog.global;if(f&&goog.inHtmlDocument_()&&goog.isDocumentLoading_()&&!h){goog.Dependency.defer_=!0;a.pause();
var l=k.onreadystatechange;k.onreadystatechange=function(){"interactive"==k.readyState&&(k.onreadystatechange=l,c(),a.resume());goog.isFunction(l)&&l.apply(void 0,arguments)}}else!goog.DebugLoader_.IS_OLD_IE_&&goog.inHtmlDocument_()&&goog.isDocumentLoading_()?d():c()}}},goog.TransformedDependency.prototype.transform=function(a){},goog.TranspiledDependency=function(a,b,c,d,e,f){goog.TransformedDependency.call(this,a,b,c,d,e);this.transpiler=f},goog.inherits(goog.TranspiledDependency,goog.TransformedDependency),
goog.TranspiledDependency.prototype.transform=function(a){return this.transpiler.transpile(a,this.getPathName())},goog.PreTranspiledEs6ModuleDependency=function(a,b,c,d,e){goog.TransformedDependency.call(this,a,b,c,d,e)},goog.inherits(goog.PreTranspiledEs6ModuleDependency,goog.TransformedDependency),goog.PreTranspiledEs6ModuleDependency.prototype.transform=function(a){return a},goog.GoogModuleDependency=function(a,b,c,d,e,f,g){goog.TransformedDependency.call(this,a,b,c,d,e);this.needsTranspile_=f;
this.transpiler_=g},goog.inherits(goog.GoogModuleDependency,goog.TransformedDependency),goog.GoogModuleDependency.prototype.transform=function(a){this.needsTranspile_&&(a=this.transpiler_.transpile(a,this.getPathName()));return goog.LOAD_MODULE_USING_EVAL&&goog.isDef(goog.global.JSON)?"goog.loadModule("+goog.global.JSON.stringify(a+"\n//# sourceURL="+this.path+"\n")+");":'goog.loadModule(function(exports) {"use strict";'+a+"\n;return exports});\n//# sourceURL="+this.path+"\n"},goog.DebugLoader_.IS_OLD_IE_=
!(goog.global.atob||!goog.global.document||!goog.global.document.all),goog.DebugLoader_.prototype.addDependency=function(a,b,c,d){b=b||[];a=a.replace(/\\/g,"/");var e=goog.normalizePath_(goog.basePath+a);d&&"boolean"!==typeof d||(d=d?{module:goog.ModuleType.GOOG}:{});c=this.factory_.createDependency(e,a,b,c,d,goog.transpiler_.needsTranspile(d.lang||"es3",d.module));this.dependencies_[e]=c;for(c=0;c<b.length;c++)this.idToPath_[b[c]]=e;this.idToPath_[a]=e},goog.DependencyFactory=function(a){this.transpiler=
a},goog.DependencyFactory.prototype.createDependency=function(a,b,c,d,e,f){return e.module==goog.ModuleType.GOOG?new goog.GoogModuleDependency(a,b,c,d,e,f,this.transpiler):f?new goog.TranspiledDependency(a,b,c,d,e,this.transpiler):e.module==goog.ModuleType.ES6?"never"==goog.TRANSPILE&&goog.ASSUME_ES_MODULES_TRANSPILED?new goog.PreTranspiledEs6ModuleDependency(a,b,c,d,e):new goog.Es6ModuleDependency(a,b,c,d,e):new goog.Dependency(a,b,c,d,e)},goog.debugLoader_=new goog.DebugLoader_,goog.loadClosureDeps=
function(){goog.debugLoader_.loadClosureDeps()},goog.setDependencyFactory=function(a){goog.debugLoader_.setDependencyFactory(a)},goog.global.CLOSURE_NO_DEPS||goog.debugLoader_.loadClosureDeps(),goog.bootstrap=function(a,b){goog.debugLoader_.bootstrap(a,b)});var jspb={BinaryConstants:{},ConstBinaryMessage:function(){},BinaryMessage:function(){}};jspb.BinaryConstants.FieldType={INVALID:-1,DOUBLE:1,FLOAT:2,INT64:3,UINT64:4,INT32:5,FIXED64:6,FIXED32:7,BOOL:8,STRING:9,GROUP:10,MESSAGE:11,BYTES:12,UINT32:13,ENUM:14,SFIXED32:15,SFIXED64:16,SINT32:17,SINT64:18,FHASH64:30,VHASH64:31};jspb.BinaryConstants.WireType={INVALID:-1,VARINT:0,FIXED64:1,DELIMITED:2,START_GROUP:3,END_GROUP:4,FIXED32:5};
jspb.BinaryConstants.FieldTypeToWireType=function(a){var b=jspb.BinaryConstants.FieldType,c=jspb.BinaryConstants.WireType;switch(a){case b.INT32:case b.INT64:case b.UINT32:case b.UINT64:case b.SINT32:case b.SINT64:case b.BOOL:case b.ENUM:case b.VHASH64:return c.VARINT;case b.DOUBLE:case b.FIXED64:case b.SFIXED64:case b.FHASH64:return c.FIXED64;case b.STRING:case b.MESSAGE:case b.BYTES:return c.DELIMITED;case b.FLOAT:case b.FIXED32:case b.SFIXED32:return c.FIXED32;default:return c.INVALID}};
jspb.BinaryConstants.INVALID_FIELD_NUMBER=-1;jspb.BinaryConstants.FLOAT32_EPS=1.401298464324817E-45;jspb.BinaryConstants.FLOAT32_MIN=1.1754943508222875E-38;jspb.BinaryConstants.FLOAT32_MAX=3.4028234663852886E38;jspb.BinaryConstants.FLOAT64_EPS=4.9E-324;jspb.BinaryConstants.FLOAT64_MIN=2.2250738585072014E-308;jspb.BinaryConstants.FLOAT64_MAX=1.7976931348623157E308;jspb.BinaryConstants.TWO_TO_20=1048576;jspb.BinaryConstants.TWO_TO_23=8388608;jspb.BinaryConstants.TWO_TO_31=2147483648;
jspb.BinaryConstants.TWO_TO_32=4294967296;jspb.BinaryConstants.TWO_TO_52=4503599627370496;jspb.BinaryConstants.TWO_TO_63=0x7fffffffffffffff;jspb.BinaryConstants.TWO_TO_64=1.8446744073709552E19;jspb.BinaryConstants.ZERO_HASH="\x00\x00\x00\x00\x00\x00\x00\x00";goog.dom={};goog.dom.NodeType={ELEMENT:1,ATTRIBUTE:2,TEXT:3,CDATA_SECTION:4,ENTITY_REFERENCE:5,ENTITY:6,PROCESSING_INSTRUCTION:7,COMMENT:8,DOCUMENT:9,DOCUMENT_TYPE:10,DOCUMENT_FRAGMENT:11,NOTATION:12};goog.debug={};goog.debug.Error=function(a){if(Error.captureStackTrace)Error.captureStackTrace(this,goog.debug.Error);else{var b=Error().stack;b&&(this.stack=b)}a&&(this.message=String(a));this.reportErrorToServer=!0};goog.inherits(goog.debug.Error,Error);goog.debug.Error.prototype.name="CustomError";goog.asserts={};goog.asserts.ENABLE_ASSERTS=goog.DEBUG;goog.asserts.AssertionError=function(a,b){goog.debug.Error.call(this,goog.asserts.subs_(a,b));this.messagePattern=a};goog.inherits(goog.asserts.AssertionError,goog.debug.Error);goog.asserts.AssertionError.prototype.name="AssertionError";goog.asserts.DEFAULT_ERROR_HANDLER=function(a){throw a;};goog.asserts.errorHandler_=goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.subs_=function(a,b){a=a.split("%s");for(var c="",d=a.length-1,e=0;e<d;e++)c+=a[e]+(e<b.length?b[e]:"%s");return c+a[d]};goog.asserts.doAssertFailure_=function(a,b,c,d){var e="Assertion failed";if(c){e+=": "+c;var f=d}else a&&(e+=": "+a,f=b);a=new goog.asserts.AssertionError(""+e,f||[]);goog.asserts.errorHandler_(a)};goog.asserts.setErrorHandler=function(a){goog.asserts.ENABLE_ASSERTS&&(goog.asserts.errorHandler_=a)};
goog.asserts.assert=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!a&&goog.asserts.doAssertFailure_("",null,b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.fail=function(a,b){goog.asserts.ENABLE_ASSERTS&&goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure"+(a?": "+a:""),Array.prototype.slice.call(arguments,1)))};
goog.asserts.assertNumber=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isNumber(a)&&goog.asserts.doAssertFailure_("Expected number but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertString=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isString(a)&&goog.asserts.doAssertFailure_("Expected string but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertFunction=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isFunction(a)&&goog.asserts.doAssertFailure_("Expected function but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertObject=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isObject(a)&&goog.asserts.doAssertFailure_("Expected object but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertArray=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isArray(a)&&goog.asserts.doAssertFailure_("Expected array but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertBoolean=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isBoolean(a)&&goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertElement=function(a,b,c){!goog.asserts.ENABLE_ASSERTS||goog.isObject(a)&&a.nodeType==goog.dom.NodeType.ELEMENT||goog.asserts.doAssertFailure_("Expected Element but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertInstanceof=function(a,b,c,d){!goog.asserts.ENABLE_ASSERTS||a instanceof b||goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.",[goog.asserts.getType_(b),goog.asserts.getType_(a)],c,Array.prototype.slice.call(arguments,3));return a};goog.asserts.assertFinite=function(a,b,c){!goog.asserts.ENABLE_ASSERTS||"number"==typeof a&&isFinite(a)||goog.asserts.doAssertFailure_("Expected %s to be a finite number but it is not.",[a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertObjectPrototypeIsIntact=function(){for(var a in Object.prototype)goog.asserts.fail(a+" should not be enumerable in Object.prototype.")};goog.asserts.getType_=function(a){return a instanceof Function?a.displayName||a.name||"unknown type name":a instanceof Object?a.constructor.displayName||a.constructor.name||Object.prototype.toString.call(a):null===a?"null":typeof a};goog.array={};goog.NATIVE_ARRAY_PROTOTYPES=goog.TRUSTED_SITE;goog.array.ASSUME_NATIVE_FUNCTIONS=!1;goog.array.peek=function(a){return a[a.length-1]};goog.array.last=goog.array.peek;
goog.array.indexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.indexOf)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.indexOf.call(a,b,c)}:function(a,b,c){c=null==c?0:0>c?Math.max(0,a.length+c):c;if(goog.isString(a))return goog.isString(b)&&1==b.length?a.indexOf(b,c):-1;for(;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1};
goog.array.lastIndexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.lastIndexOf)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.lastIndexOf.call(a,b,null==c?a.length-1:c)}:function(a,b,c){c=null==c?a.length-1:c;0>c&&(c=Math.max(0,a.length+c));if(goog.isString(a))return goog.isString(b)&&1==b.length?a.lastIndexOf(b,c):-1;for(;0<=c;c--)if(c in a&&a[c]===b)return c;return-1};
goog.array.forEach=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.forEach)?function(a,b,c){goog.asserts.assert(null!=a.length);Array.prototype.forEach.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)f in e&&b.call(c,e[f],f,a)};goog.array.forEachRight=function(a,b,c){var d=a.length,e=goog.isString(a)?a.split(""):a;for(--d;0<=d;--d)d in e&&b.call(c,e[d],d,a)};
goog.array.filter=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.filter)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.filter.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=[],f=0,g=goog.isString(a)?a.split(""):a,h=0;h<d;h++)if(h in g){var k=g[h];b.call(c,k,h,a)&&(e[f++]=k)}return e};
goog.array.map=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.map)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.map.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=Array(d),f=goog.isString(a)?a.split(""):a,g=0;g<d;g++)g in f&&(e[g]=b.call(c,f[g],g,a));return e};
goog.array.reduce=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduce)?function(a,b,c,d){goog.asserts.assert(null!=a.length);d&&(b=goog.bind(b,d));return Array.prototype.reduce.call(a,b,c)}:function(a,b,c,d){var e=c;goog.array.forEach(a,function(c,g){e=b.call(d,e,c,g,a)});return e};
goog.array.reduceRight=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduceRight)?function(a,b,c,d){goog.asserts.assert(null!=a.length);goog.asserts.assert(null!=b);d&&(b=goog.bind(b,d));return Array.prototype.reduceRight.call(a,b,c)}:function(a,b,c,d){var e=c;goog.array.forEachRight(a,function(c,g){e=b.call(d,e,c,g,a)});return e};
goog.array.some=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.some)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.some.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&b.call(c,e[f],f,a))return!0;return!1};
goog.array.every=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.every)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.every.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&!b.call(c,e[f],f,a))return!1;return!0};goog.array.count=function(a,b,c){var d=0;goog.array.forEach(a,function(a,f,g){b.call(c,a,f,g)&&++d},c);return d};
goog.array.find=function(a,b,c){b=goog.array.findIndex(a,b,c);return 0>b?null:goog.isString(a)?a.charAt(b):a[b]};goog.array.findIndex=function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&b.call(c,e[f],f,a))return f;return-1};goog.array.findRight=function(a,b,c){b=goog.array.findIndexRight(a,b,c);return 0>b?null:goog.isString(a)?a.charAt(b):a[b]};
goog.array.findIndexRight=function(a,b,c){var d=a.length,e=goog.isString(a)?a.split(""):a;for(--d;0<=d;d--)if(d in e&&b.call(c,e[d],d,a))return d;return-1};goog.array.contains=function(a,b){return 0<=goog.array.indexOf(a,b)};goog.array.isEmpty=function(a){return 0==a.length};goog.array.clear=function(a){if(!goog.isArray(a))for(var b=a.length-1;0<=b;b--)delete a[b];a.length=0};goog.array.insert=function(a,b){goog.array.contains(a,b)||a.push(b)};
goog.array.insertAt=function(a,b,c){goog.array.splice(a,c,0,b)};goog.array.insertArrayAt=function(a,b,c){goog.partial(goog.array.splice,a,c,0).apply(null,b)};goog.array.insertBefore=function(a,b,c){var d;2==arguments.length||0>(d=goog.array.indexOf(a,c))?a.push(b):goog.array.insertAt(a,b,d)};goog.array.remove=function(a,b){b=goog.array.indexOf(a,b);var c;(c=0<=b)&&goog.array.removeAt(a,b);return c};
goog.array.removeLast=function(a,b){b=goog.array.lastIndexOf(a,b);return 0<=b?(goog.array.removeAt(a,b),!0):!1};goog.array.removeAt=function(a,b){goog.asserts.assert(null!=a.length);return 1==Array.prototype.splice.call(a,b,1).length};goog.array.removeIf=function(a,b,c){b=goog.array.findIndex(a,b,c);return 0<=b?(goog.array.removeAt(a,b),!0):!1};goog.array.removeAllIf=function(a,b,c){var d=0;goog.array.forEachRight(a,function(e,f){b.call(c,e,f,a)&&goog.array.removeAt(a,f)&&d++});return d};
goog.array.concat=function(a){return Array.prototype.concat.apply([],arguments)};goog.array.join=function(a){return Array.prototype.concat.apply([],arguments)};goog.array.toArray=function(a){var b=a.length;if(0<b){for(var c=Array(b),d=0;d<b;d++)c[d]=a[d];return c}return[]};goog.array.clone=goog.array.toArray;goog.array.extend=function(a,b){for(var c=1;c<arguments.length;c++){var d=arguments[c];if(goog.isArrayLike(d)){var e=a.length||0,f=d.length||0;a.length=e+f;for(var g=0;g<f;g++)a[e+g]=d[g]}else a.push(d)}};
goog.array.splice=function(a,b,c,d){goog.asserts.assert(null!=a.length);return Array.prototype.splice.apply(a,goog.array.slice(arguments,1))};goog.array.slice=function(a,b,c){goog.asserts.assert(null!=a.length);return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};
goog.array.removeDuplicates=function(a,b,c){b=b||a;var d=function(a){return goog.isObject(a)?"o"+goog.getUid(a):(typeof a).charAt(0)+a};c=c||d;d={};for(var e=0,f=0;f<a.length;){var g=a[f++],h=c(g);Object.prototype.hasOwnProperty.call(d,h)||(d[h]=!0,b[e++]=g)}b.length=e};goog.array.binarySearch=function(a,b,c){return goog.array.binarySearch_(a,c||goog.array.defaultCompare,!1,b)};goog.array.binarySelect=function(a,b,c){return goog.array.binarySearch_(a,b,!0,void 0,c)};
goog.array.binarySearch_=function(a,b,c,d,e){for(var f=0,g=a.length,h;f<g;){var k=f+g>>1;var l=c?b.call(e,a[k],k,a):b(d,a[k]);0<l?f=k+1:(g=k,h=!l)}return h?f:~f};goog.array.sort=function(a,b){a.sort(b||goog.array.defaultCompare)};goog.array.stableSort=function(a,b){for(var c=Array(a.length),d=0;d<a.length;d++)c[d]={index:d,value:a[d]};var e=b||goog.array.defaultCompare;goog.array.sort(c,function(a,b){return e(a.value,b.value)||a.index-b.index});for(d=0;d<a.length;d++)a[d]=c[d].value};
goog.array.sortByKey=function(a,b,c){var d=c||goog.array.defaultCompare;goog.array.sort(a,function(a,c){return d(b(a),b(c))})};goog.array.sortObjectsByKey=function(a,b,c){goog.array.sortByKey(a,function(a){return a[b]},c)};goog.array.isSorted=function(a,b,c){b=b||goog.array.defaultCompare;for(var d=1;d<a.length;d++){var e=b(a[d-1],a[d]);if(0<e||0==e&&c)return!1}return!0};
goog.array.equals=function(a,b,c){if(!goog.isArrayLike(a)||!goog.isArrayLike(b)||a.length!=b.length)return!1;var d=a.length;c=c||goog.array.defaultCompareEquality;for(var e=0;e<d;e++)if(!c(a[e],b[e]))return!1;return!0};goog.array.compare3=function(a,b,c){c=c||goog.array.defaultCompare;for(var d=Math.min(a.length,b.length),e=0;e<d;e++){var f=c(a[e],b[e]);if(0!=f)return f}return goog.array.defaultCompare(a.length,b.length)};goog.array.defaultCompare=function(a,b){return a>b?1:a<b?-1:0};
goog.array.inverseDefaultCompare=function(a,b){return-goog.array.defaultCompare(a,b)};goog.array.defaultCompareEquality=function(a,b){return a===b};goog.array.binaryInsert=function(a,b,c){c=goog.array.binarySearch(a,b,c);return 0>c?(goog.array.insertAt(a,b,-(c+1)),!0):!1};goog.array.binaryRemove=function(a,b,c){b=goog.array.binarySearch(a,b,c);return 0<=b?goog.array.removeAt(a,b):!1};
goog.array.bucket=function(a,b,c){for(var d={},e=0;e<a.length;e++){var f=a[e],g=b.call(c,f,e,a);goog.isDef(g)&&(d[g]||(d[g]=[])).push(f)}return d};goog.array.toObject=function(a,b,c){var d={};goog.array.forEach(a,function(e,f){d[b.call(c,e,f,a)]=e});return d};goog.array.range=function(a,b,c){var d=[],e=0,f=a;c=c||1;void 0!==b&&(e=a,f=b);if(0>c*(f-e))return[];if(0<c)for(a=e;a<f;a+=c)d.push(a);else for(a=e;a>f;a+=c)d.push(a);return d};
goog.array.repeat=function(a,b){for(var c=[],d=0;d<b;d++)c[d]=a;return c};goog.array.flatten=function(a){for(var b=[],c=0;c<arguments.length;c++){var d=arguments[c];if(goog.isArray(d))for(var e=0;e<d.length;e+=8192){var f=goog.array.slice(d,e,e+8192);f=goog.array.flatten.apply(null,f);for(var g=0;g<f.length;g++)b.push(f[g])}else b.push(d)}return b};
goog.array.rotate=function(a,b){goog.asserts.assert(null!=a.length);a.length&&(b%=a.length,0<b?Array.prototype.unshift.apply(a,a.splice(-b,b)):0>b&&Array.prototype.push.apply(a,a.splice(0,-b)));return a};goog.array.moveItem=function(a,b,c){goog.asserts.assert(0<=b&&b<a.length);goog.asserts.assert(0<=c&&c<a.length);b=Array.prototype.splice.call(a,b,1);Array.prototype.splice.call(a,c,0,b[0])};
goog.array.zip=function(a){if(!arguments.length)return[];for(var b=[],c=arguments[0].length,d=1;d<arguments.length;d++)arguments[d].length<c&&(c=arguments[d].length);for(d=0;d<c;d++){for(var e=[],f=0;f<arguments.length;f++)e.push(arguments[f][d]);b.push(e)}return b};goog.array.shuffle=function(a,b){b=b||Math.random;for(var c=a.length-1;0<c;c--){var d=Math.floor(b()*(c+1)),e=a[c];a[c]=a[d];a[d]=e}};goog.array.copyByIndex=function(a,b){var c=[];goog.array.forEach(b,function(b){c.push(a[b])});return c};
goog.array.concatMap=function(a,b,c){return goog.array.concat.apply([],goog.array.map(a,b,c))};goog.crypt={};goog.crypt.stringToByteArray=function(a){for(var b=[],c=0,d=0;d<a.length;d++){var e=a.charCodeAt(d);255<e&&(b[c++]=e&255,e>>=8);b[c++]=e}return b};goog.crypt.byteArrayToString=function(a){if(8192>=a.length)return String.fromCharCode.apply(null,a);for(var b="",c=0;c<a.length;c+=8192){var d=goog.array.slice(a,c,c+8192);b+=String.fromCharCode.apply(null,d)}return b};
goog.crypt.byteArrayToHex=function(a,b){return goog.array.map(a,function(a){a=a.toString(16);return 1<a.length?a:"0"+a}).join(b||"")};goog.crypt.hexToByteArray=function(a){goog.asserts.assert(0==a.length%2,"Key string length must be multiple of 2");for(var b=[],c=0;c<a.length;c+=2)b.push(parseInt(a.substring(c,c+2),16));return b};
goog.crypt.stringToUtf8ByteArray=function(a){for(var b=[],c=0,d=0;d<a.length;d++){var e=a.charCodeAt(d);128>e?b[c++]=e:(2048>e?b[c++]=e>>6|192:(55296==(e&64512)&&d+1<a.length&&56320==(a.charCodeAt(d+1)&64512)?(e=65536+((e&1023)<<10)+(a.charCodeAt(++d)&1023),b[c++]=e>>18|240,b[c++]=e>>12&63|128):b[c++]=e>>12|224,b[c++]=e>>6&63|128),b[c++]=e&63|128)}return b};
goog.crypt.utf8ByteArrayToString=function(a){for(var b=[],c=0,d=0;c<a.length;){var e=a[c++];if(128>e)b[d++]=String.fromCharCode(e);else if(191<e&&224>e){var f=a[c++];b[d++]=String.fromCharCode((e&31)<<6|f&63)}else if(239<e&&365>e){f=a[c++];var g=a[c++],h=a[c++];e=((e&7)<<18|(f&63)<<12|(g&63)<<6|h&63)-65536;b[d++]=String.fromCharCode(55296+(e>>10));b[d++]=String.fromCharCode(56320+(e&1023))}else f=a[c++],g=a[c++],b[d++]=String.fromCharCode((e&15)<<12|(f&63)<<6|g&63)}return b.join("")};
goog.crypt.xorByteArray=function(a,b){goog.asserts.assert(a.length==b.length,"XOR array lengths must match");for(var c=[],d=0;d<a.length;d++)c.push(a[d]^b[d]);return c};goog.string={};goog.string.internal={};goog.string.internal.startsWith=function(a,b){return 0==a.lastIndexOf(b,0)};goog.string.internal.endsWith=function(a,b){var c=a.length-b.length;return 0<=c&&a.indexOf(b,c)==c};goog.string.internal.caseInsensitiveStartsWith=function(a,b){return 0==goog.string.internal.caseInsensitiveCompare(b,a.substr(0,b.length))};goog.string.internal.caseInsensitiveEndsWith=function(a,b){return 0==goog.string.internal.caseInsensitiveCompare(b,a.substr(a.length-b.length,b.length))};
goog.string.internal.caseInsensitiveEquals=function(a,b){return a.toLowerCase()==b.toLowerCase()};goog.string.internal.isEmptyOrWhitespace=function(a){return/^[\s\xa0]*$/.test(a)};goog.string.internal.trim=goog.TRUSTED_SITE&&String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(a)[1]};goog.string.internal.caseInsensitiveCompare=function(a,b){a=String(a).toLowerCase();b=String(b).toLowerCase();return a<b?-1:a==b?0:1};
goog.string.internal.newLineToBr=function(a,b){return a.replace(/(\r\n|\r|\n)/g,b?"<br />":"<br>")};
goog.string.internal.htmlEscape=function(a,b){if(b)a=a.replace(goog.string.internal.AMP_RE_,"&amp;").replace(goog.string.internal.LT_RE_,"&lt;").replace(goog.string.internal.GT_RE_,"&gt;").replace(goog.string.internal.QUOT_RE_,"&quot;").replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;").replace(goog.string.internal.NULL_RE_,"&#0;");else{if(!goog.string.internal.ALL_RE_.test(a))return a;-1!=a.indexOf("&")&&(a=a.replace(goog.string.internal.AMP_RE_,"&amp;"));-1!=a.indexOf("<")&&(a=a.replace(goog.string.internal.LT_RE_,
"&lt;"));-1!=a.indexOf(">")&&(a=a.replace(goog.string.internal.GT_RE_,"&gt;"));-1!=a.indexOf('"')&&(a=a.replace(goog.string.internal.QUOT_RE_,"&quot;"));-1!=a.indexOf("'")&&(a=a.replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;"));-1!=a.indexOf("\x00")&&(a=a.replace(goog.string.internal.NULL_RE_,"&#0;"))}return a};goog.string.internal.AMP_RE_=/&/g;goog.string.internal.LT_RE_=/</g;goog.string.internal.GT_RE_=/>/g;goog.string.internal.QUOT_RE_=/"/g;goog.string.internal.SINGLE_QUOTE_RE_=/'/g;
goog.string.internal.NULL_RE_=/\x00/g;goog.string.internal.ALL_RE_=/[\x00&<>"']/;goog.string.internal.whitespaceEscape=function(a,b){return goog.string.internal.newLineToBr(a.replace(/  /g," &#160;"),b)};goog.string.internal.contains=function(a,b){return-1!=a.indexOf(b)};goog.string.internal.caseInsensitiveContains=function(a,b){return goog.string.internal.contains(a.toLowerCase(),b.toLowerCase())};
goog.string.internal.compareVersions=function(a,b){var c=0;a=goog.string.internal.trim(String(a)).split(".");b=goog.string.internal.trim(String(b)).split(".");for(var d=Math.max(a.length,b.length),e=0;0==c&&e<d;e++){var f=a[e]||"",g=b[e]||"";do{f=/(\d*)(\D*)(.*)/.exec(f)||["","","",""];g=/(\d*)(\D*)(.*)/.exec(g)||["","","",""];if(0==f[0].length&&0==g[0].length)break;c=0==f[1].length?0:parseInt(f[1],10);var h=0==g[1].length?0:parseInt(g[1],10);c=goog.string.internal.compareElements_(c,h)||goog.string.internal.compareElements_(0==
f[2].length,0==g[2].length)||goog.string.internal.compareElements_(f[2],g[2]);f=f[3];g=g[3]}while(0==c)}return c};goog.string.internal.compareElements_=function(a,b){return a<b?-1:a>b?1:0};goog.string.DETECT_DOUBLE_ESCAPING=!1;goog.string.FORCE_NON_DOM_HTML_UNESCAPING=!1;goog.string.Unicode={NBSP:"\u00a0"};goog.string.startsWith=goog.string.internal.startsWith;goog.string.endsWith=goog.string.internal.endsWith;goog.string.caseInsensitiveStartsWith=goog.string.internal.caseInsensitiveStartsWith;goog.string.caseInsensitiveEndsWith=goog.string.internal.caseInsensitiveEndsWith;goog.string.caseInsensitiveEquals=goog.string.internal.caseInsensitiveEquals;
goog.string.subs=function(a,b){for(var c=a.split("%s"),d="",e=Array.prototype.slice.call(arguments,1);e.length&&1<c.length;)d+=c.shift()+e.shift();return d+c.join("%s")};goog.string.collapseWhitespace=function(a){return a.replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")};goog.string.isEmptyOrWhitespace=goog.string.internal.isEmptyOrWhitespace;goog.string.isEmptyString=function(a){return 0==a.length};goog.string.isEmpty=goog.string.isEmptyOrWhitespace;goog.string.isEmptyOrWhitespaceSafe=function(a){return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(a))};
goog.string.isEmptySafe=goog.string.isEmptyOrWhitespaceSafe;goog.string.isBreakingWhitespace=function(a){return!/[^\t\n\r ]/.test(a)};goog.string.isAlpha=function(a){return!/[^a-zA-Z]/.test(a)};goog.string.isNumeric=function(a){return!/[^0-9]/.test(a)};goog.string.isAlphaNumeric=function(a){return!/[^a-zA-Z0-9]/.test(a)};goog.string.isSpace=function(a){return" "==a};goog.string.isUnicodeChar=function(a){return 1==a.length&&" "<=a&&"~">=a||"\u0080"<=a&&"\ufffd">=a};
goog.string.stripNewlines=function(a){return a.replace(/(\r\n|\r|\n)+/g," ")};goog.string.canonicalizeNewlines=function(a){return a.replace(/(\r\n|\r|\n)/g,"\n")};goog.string.normalizeWhitespace=function(a){return a.replace(/\xa0|\s/g," ")};goog.string.normalizeSpaces=function(a){return a.replace(/\xa0|[ \t]+/g," ")};goog.string.collapseBreakingSpaces=function(a){return a.replace(/[\t\r\n ]+/g," ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g,"")};goog.string.trim=goog.string.internal.trim;
goog.string.trimLeft=function(a){return a.replace(/^[\s\xa0]+/,"")};goog.string.trimRight=function(a){return a.replace(/[\s\xa0]+$/,"")};goog.string.caseInsensitiveCompare=goog.string.internal.caseInsensitiveCompare;
goog.string.numberAwareCompare_=function(a,b,c){if(a==b)return 0;if(!a)return-1;if(!b)return 1;for(var d=a.toLowerCase().match(c),e=b.toLowerCase().match(c),f=Math.min(d.length,e.length),g=0;g<f;g++){c=d[g];var h=e[g];if(c!=h)return a=parseInt(c,10),!isNaN(a)&&(b=parseInt(h,10),!isNaN(b)&&a-b)?a-b:c<h?-1:1}return d.length!=e.length?d.length-e.length:a<b?-1:1};goog.string.intAwareCompare=function(a,b){return goog.string.numberAwareCompare_(a,b,/\d+|\D+/g)};
goog.string.floatAwareCompare=function(a,b){return goog.string.numberAwareCompare_(a,b,/\d+|\.\d+|\D+/g)};goog.string.numerateCompare=goog.string.floatAwareCompare;goog.string.urlEncode=function(a){return encodeURIComponent(String(a))};goog.string.urlDecode=function(a){return decodeURIComponent(a.replace(/\+/g," "))};goog.string.newLineToBr=goog.string.internal.newLineToBr;
goog.string.htmlEscape=function(a,b){a=goog.string.internal.htmlEscape(a,b);goog.string.DETECT_DOUBLE_ESCAPING&&(a=a.replace(goog.string.E_RE_,"&#101;"));return a};goog.string.E_RE_=/e/g;goog.string.unescapeEntities=function(a){return goog.string.contains(a,"&")?!goog.string.FORCE_NON_DOM_HTML_UNESCAPING&&"document"in goog.global?goog.string.unescapeEntitiesUsingDom_(a):goog.string.unescapePureXmlEntities_(a):a};
goog.string.unescapeEntitiesWithDocument=function(a,b){return goog.string.contains(a,"&")?goog.string.unescapeEntitiesUsingDom_(a,b):a};
goog.string.unescapeEntitiesUsingDom_=function(a,b){var c={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"'};var d=b?b.createElement("div"):goog.global.document.createElement("div");return a.replace(goog.string.HTML_ENTITY_PATTERN_,function(a,b){var e=c[a];if(e)return e;"#"==b.charAt(0)&&(b=Number("0"+b.substr(1)),isNaN(b)||(e=String.fromCharCode(b)));e||(d.innerHTML=a+" ",e=d.firstChild.nodeValue.slice(0,-1));return c[a]=e})};
goog.string.unescapePureXmlEntities_=function(a){return a.replace(/&([^;]+);/g,function(a,c){switch(c){case "amp":return"&";case "lt":return"<";case "gt":return">";case "quot":return'"';default:return"#"!=c.charAt(0)||(c=Number("0"+c.substr(1)),isNaN(c))?a:String.fromCharCode(c)}})};goog.string.HTML_ENTITY_PATTERN_=/&([^;\s<&]+);?/g;goog.string.whitespaceEscape=function(a,b){return goog.string.newLineToBr(a.replace(/  /g," &#160;"),b)};
goog.string.preserveSpaces=function(a){return a.replace(/(^|[\n ]) /g,"$1"+goog.string.Unicode.NBSP)};goog.string.stripQuotes=function(a,b){for(var c=b.length,d=0;d<c;d++){var e=1==c?b:b.charAt(d);if(a.charAt(0)==e&&a.charAt(a.length-1)==e)return a.substring(1,a.length-1)}return a};goog.string.truncate=function(a,b,c){c&&(a=goog.string.unescapeEntities(a));a.length>b&&(a=a.substring(0,b-3)+"...");c&&(a=goog.string.htmlEscape(a));return a};
goog.string.truncateMiddle=function(a,b,c,d){c&&(a=goog.string.unescapeEntities(a));if(d&&a.length>b){d>b&&(d=b);var e=a.length-d;a=a.substring(0,b-d)+"..."+a.substring(e)}else a.length>b&&(d=Math.floor(b/2),e=a.length-d,a=a.substring(0,d+b%2)+"..."+a.substring(e));c&&(a=goog.string.htmlEscape(a));return a};goog.string.specialEscapeChars_={"\x00":"\\0","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\x0B":"\\x0B",'"':'\\"',"\\":"\\\\","<":"<"};goog.string.jsEscapeCache_={"'":"\\'"};
goog.string.quote=function(a){a=String(a);for(var b=['"'],c=0;c<a.length;c++){var d=a.charAt(c),e=d.charCodeAt(0);b[c+1]=goog.string.specialEscapeChars_[d]||(31<e&&127>e?d:goog.string.escapeChar(d))}b.push('"');return b.join("")};goog.string.escapeString=function(a){for(var b=[],c=0;c<a.length;c++)b[c]=goog.string.escapeChar(a.charAt(c));return b.join("")};
goog.string.escapeChar=function(a){if(a in goog.string.jsEscapeCache_)return goog.string.jsEscapeCache_[a];if(a in goog.string.specialEscapeChars_)return goog.string.jsEscapeCache_[a]=goog.string.specialEscapeChars_[a];var b=a.charCodeAt(0);if(31<b&&127>b)var c=a;else{if(256>b){if(c="\\x",16>b||256<b)c+="0"}else c="\\u",4096>b&&(c+="0");c+=b.toString(16).toUpperCase()}return goog.string.jsEscapeCache_[a]=c};goog.string.contains=goog.string.internal.contains;goog.string.caseInsensitiveContains=goog.string.internal.caseInsensitiveContains;
goog.string.countOf=function(a,b){return a&&b?a.split(b).length-1:0};goog.string.removeAt=function(a,b,c){var d=a;0<=b&&b<a.length&&0<c&&(d=a.substr(0,b)+a.substr(b+c,a.length-b-c));return d};goog.string.remove=function(a,b){return a.replace(b,"")};goog.string.removeAll=function(a,b){b=new RegExp(goog.string.regExpEscape(b),"g");return a.replace(b,"")};goog.string.replaceAll=function(a,b,c){b=new RegExp(goog.string.regExpEscape(b),"g");return a.replace(b,c.replace(/\$/g,"$$$$"))};
goog.string.regExpEscape=function(a){return String(a).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")};goog.string.repeat=String.prototype.repeat?function(a,b){return a.repeat(b)}:function(a,b){return Array(b+1).join(a)};goog.string.padNumber=function(a,b,c){a=goog.isDef(c)?a.toFixed(c):String(a);c=a.indexOf(".");-1==c&&(c=a.length);return goog.string.repeat("0",Math.max(0,b-c))+a};goog.string.makeSafe=function(a){return null==a?"":String(a)};
goog.string.buildString=function(a){return Array.prototype.join.call(arguments,"")};goog.string.getRandomString=function(){return Math.floor(2147483648*Math.random()).toString(36)+Math.abs(Math.floor(2147483648*Math.random())^goog.now()).toString(36)};goog.string.compareVersions=goog.string.internal.compareVersions;goog.string.hashCode=function(a){for(var b=0,c=0;c<a.length;++c)b=31*b+a.charCodeAt(c)>>>0;return b};goog.string.uniqueStringCounter_=2147483648*Math.random()|0;
goog.string.createUniqueString=function(){return"goog_"+goog.string.uniqueStringCounter_++};goog.string.toNumber=function(a){var b=Number(a);return 0==b&&goog.string.isEmptyOrWhitespace(a)?NaN:b};goog.string.isLowerCamelCase=function(a){return/^[a-z]+([A-Z][a-z]*)*$/.test(a)};goog.string.isUpperCamelCase=function(a){return/^([A-Z][a-z]*)+$/.test(a)};goog.string.toCamelCase=function(a){return String(a).replace(/\-([a-z])/g,function(a,c){return c.toUpperCase()})};
goog.string.toSelectorCase=function(a){return String(a).replace(/([A-Z])/g,"-$1").toLowerCase()};goog.string.toTitleCase=function(a,b){b=goog.isString(b)?goog.string.regExpEscape(b):"\\s";return a.replace(new RegExp("(^"+(b?"|["+b+"]+":"")+")([a-z])","g"),function(a,b,e){return b+e.toUpperCase()})};goog.string.capitalize=function(a){return String(a.charAt(0)).toUpperCase()+String(a.substr(1)).toLowerCase()};
goog.string.parseInt=function(a){isFinite(a)&&(a=String(a));return goog.isString(a)?/^\s*-?0x/i.test(a)?parseInt(a,16):parseInt(a,10):NaN};goog.string.splitLimit=function(a,b,c){a=a.split(b);for(var d=[];0<c&&a.length;)d.push(a.shift()),c--;a.length&&d.push(a.join(b));return d};goog.string.lastComponent=function(a,b){if(b)"string"==typeof b&&(b=[b]);else return a;for(var c=-1,d=0;d<b.length;d++)if(""!=b[d]){var e=a.lastIndexOf(b[d]);e>c&&(c=e)}return-1==c?a:a.slice(c+1)};
goog.string.editDistance=function(a,b){var c=[],d=[];if(a==b)return 0;if(!a.length||!b.length)return Math.max(a.length,b.length);for(var e=0;e<b.length+1;e++)c[e]=e;for(e=0;e<a.length;e++){d[0]=e+1;for(var f=0;f<b.length;f++)d[f+1]=Math.min(d[f]+1,c[f+1]+1,c[f]+Number(a[e]!=b[f]));for(f=0;f<c.length;f++)c[f]=d[f]}return d[b.length]};goog.labs={};goog.labs.userAgent={};goog.labs.userAgent.util={};goog.labs.userAgent.util.getNativeUserAgentString_=function(){var a=goog.labs.userAgent.util.getNavigator_();return a&&(a=a.userAgent)?a:""};goog.labs.userAgent.util.getNavigator_=function(){return goog.global.navigator};goog.labs.userAgent.util.userAgent_=goog.labs.userAgent.util.getNativeUserAgentString_();goog.labs.userAgent.util.setUserAgent=function(a){goog.labs.userAgent.util.userAgent_=a||goog.labs.userAgent.util.getNativeUserAgentString_()};
goog.labs.userAgent.util.getUserAgent=function(){return goog.labs.userAgent.util.userAgent_};goog.labs.userAgent.util.matchUserAgent=function(a){var b=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.contains(b,a)};goog.labs.userAgent.util.matchUserAgentIgnoreCase=function(a){var b=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.caseInsensitiveContains(b,a)};
goog.labs.userAgent.util.extractVersionTuples=function(a){for(var b=/(\w[\w ]+)\/([^\s]+)\s*(?:\((.*?)\))?/g,c=[],d;d=b.exec(a);)c.push([d[1],d[2],d[3]||void 0]);return c};goog.labs.userAgent.platform={};goog.labs.userAgent.platform.isAndroid=function(){return goog.labs.userAgent.util.matchUserAgent("Android")};goog.labs.userAgent.platform.isIpod=function(){return goog.labs.userAgent.util.matchUserAgent("iPod")};goog.labs.userAgent.platform.isIphone=function(){return goog.labs.userAgent.util.matchUserAgent("iPhone")&&!goog.labs.userAgent.util.matchUserAgent("iPod")&&!goog.labs.userAgent.util.matchUserAgent("iPad")};goog.labs.userAgent.platform.isIpad=function(){return goog.labs.userAgent.util.matchUserAgent("iPad")};
goog.labs.userAgent.platform.isIos=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpad()||goog.labs.userAgent.platform.isIpod()};goog.labs.userAgent.platform.isMacintosh=function(){return goog.labs.userAgent.util.matchUserAgent("Macintosh")};goog.labs.userAgent.platform.isLinux=function(){return goog.labs.userAgent.util.matchUserAgent("Linux")};goog.labs.userAgent.platform.isWindows=function(){return goog.labs.userAgent.util.matchUserAgent("Windows")};
goog.labs.userAgent.platform.isChromeOS=function(){return goog.labs.userAgent.util.matchUserAgent("CrOS")};goog.labs.userAgent.platform.isChromecast=function(){return goog.labs.userAgent.util.matchUserAgent("CrKey")};goog.labs.userAgent.platform.isKaiOS=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("KaiOS")};goog.labs.userAgent.platform.isGo2Phone=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("GAFP")};
goog.labs.userAgent.platform.getVersion=function(){var a=goog.labs.userAgent.util.getUserAgent(),b="";goog.labs.userAgent.platform.isWindows()?(b=/Windows (?:NT|Phone) ([0-9.]+)/,b=(a=b.exec(a))?a[1]:"0.0"):goog.labs.userAgent.platform.isIos()?(b=/(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/,b=(a=b.exec(a))&&a[1].replace(/_/g,".")):goog.labs.userAgent.platform.isMacintosh()?(b=/Mac OS X ([0-9_.]+)/,b=(a=b.exec(a))?a[1].replace(/_/g,"."):"10"):goog.labs.userAgent.platform.isAndroid()?(b=/Android\s+([^\);]+)(\)|;)/,
b=(a=b.exec(a))&&a[1]):goog.labs.userAgent.platform.isChromeOS()&&(b=/(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/,b=(a=b.exec(a))&&a[1]);return b||""};goog.labs.userAgent.platform.isVersionOrHigher=function(a){return 0<=goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(),a)};goog.object={};goog.object.is=function(a,b){return a===b?0!==a||1/a===1/b:a!==a&&b!==b};goog.object.forEach=function(a,b,c){for(var d in a)b.call(c,a[d],d,a)};goog.object.filter=function(a,b,c){var d={},e;for(e in a)b.call(c,a[e],e,a)&&(d[e]=a[e]);return d};goog.object.map=function(a,b,c){var d={},e;for(e in a)d[e]=b.call(c,a[e],e,a);return d};goog.object.some=function(a,b,c){for(var d in a)if(b.call(c,a[d],d,a))return!0;return!1};
goog.object.every=function(a,b,c){for(var d in a)if(!b.call(c,a[d],d,a))return!1;return!0};goog.object.getCount=function(a){var b=0,c;for(c in a)b++;return b};goog.object.getAnyKey=function(a){for(var b in a)return b};goog.object.getAnyValue=function(a){for(var b in a)return a[b]};goog.object.contains=function(a,b){return goog.object.containsValue(a,b)};goog.object.getValues=function(a){var b=[],c=0,d;for(d in a)b[c++]=a[d];return b};
goog.object.getKeys=function(a){var b=[],c=0,d;for(d in a)b[c++]=d;return b};goog.object.getValueByKeys=function(a,b){var c=goog.isArrayLike(b),d=c?b:arguments;for(c=c?0:1;c<d.length;c++){if(null==a)return;a=a[d[c]]}return a};goog.object.containsKey=function(a,b){return null!==a&&b in a};goog.object.containsValue=function(a,b){for(var c in a)if(a[c]==b)return!0;return!1};goog.object.findKey=function(a,b,c){for(var d in a)if(b.call(c,a[d],d,a))return d};
goog.object.findValue=function(a,b,c){return(b=goog.object.findKey(a,b,c))&&a[b]};goog.object.isEmpty=function(a){for(var b in a)return!1;return!0};goog.object.clear=function(a){for(var b in a)delete a[b]};goog.object.remove=function(a,b){var c;(c=b in a)&&delete a[b];return c};goog.object.add=function(a,b,c){if(null!==a&&b in a)throw Error('The object already contains the key "'+b+'"');goog.object.set(a,b,c)};goog.object.get=function(a,b,c){return null!==a&&b in a?a[b]:c};
goog.object.set=function(a,b,c){a[b]=c};goog.object.setIfUndefined=function(a,b,c){return b in a?a[b]:a[b]=c};goog.object.setWithReturnValueIfNotSet=function(a,b,c){if(b in a)return a[b];c=c();return a[b]=c};goog.object.equals=function(a,b){for(var c in a)if(!(c in b)||a[c]!==b[c])return!1;for(c in b)if(!(c in a))return!1;return!0};goog.object.clone=function(a){var b={},c;for(c in a)b[c]=a[c];return b};
goog.object.unsafeClone=function(a){var b=goog.typeOf(a);if("object"==b||"array"==b){if(goog.isFunction(a.clone))return a.clone();b="array"==b?[]:{};for(var c in a)b[c]=goog.object.unsafeClone(a[c]);return b}return a};goog.object.transpose=function(a){var b={},c;for(c in a)b[a[c]]=c;return b};goog.object.PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");
goog.object.extend=function(a,b){for(var c,d,e=1;e<arguments.length;e++){d=arguments[e];for(c in d)a[c]=d[c];for(var f=0;f<goog.object.PROTOTYPE_FIELDS_.length;f++)c=goog.object.PROTOTYPE_FIELDS_[f],Object.prototype.hasOwnProperty.call(d,c)&&(a[c]=d[c])}};
goog.object.create=function(a){var b=arguments.length;if(1==b&&goog.isArray(arguments[0]))return goog.object.create.apply(null,arguments[0]);if(b%2)throw Error("Uneven number of arguments");for(var c={},d=0;d<b;d+=2)c[arguments[d]]=arguments[d+1];return c};goog.object.createSet=function(a){var b=arguments.length;if(1==b&&goog.isArray(arguments[0]))return goog.object.createSet.apply(null,arguments[0]);for(var c={},d=0;d<b;d++)c[arguments[d]]=!0;return c};
goog.object.createImmutableView=function(a){var b=a;Object.isFrozen&&!Object.isFrozen(a)&&(b=Object.create(a),Object.freeze(b));return b};goog.object.isImmutableView=function(a){return!!Object.isFrozen&&Object.isFrozen(a)};
goog.object.getAllPropertyNames=function(a,b,c){if(!a)return[];if(!Object.getOwnPropertyNames||!Object.getPrototypeOf)return goog.object.getKeys(a);for(var d={};a&&(a!==Object.prototype||b)&&(a!==Function.prototype||c);){for(var e=Object.getOwnPropertyNames(a),f=0;f<e.length;f++)d[e[f]]=!0;a=Object.getPrototypeOf(a)}return goog.object.getKeys(d)};goog.labs.userAgent.browser={};goog.labs.userAgent.browser.matchOpera_=function(){return goog.labs.userAgent.util.matchUserAgent("Opera")};goog.labs.userAgent.browser.matchIE_=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")};goog.labs.userAgent.browser.matchEdge_=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")};
goog.labs.userAgent.browser.matchFirefox_=function(){return goog.labs.userAgent.util.matchUserAgent("Firefox")||goog.labs.userAgent.util.matchUserAgent("FxiOS")};
goog.labs.userAgent.browser.matchSafari_=function(){return goog.labs.userAgent.util.matchUserAgent("Safari")&&!(goog.labs.userAgent.browser.matchChrome_()||goog.labs.userAgent.browser.matchCoast_()||goog.labs.userAgent.browser.matchOpera_()||goog.labs.userAgent.browser.matchEdge_()||goog.labs.userAgent.browser.matchFirefox_()||goog.labs.userAgent.browser.isSilk()||goog.labs.userAgent.util.matchUserAgent("Android"))};goog.labs.userAgent.browser.matchCoast_=function(){return goog.labs.userAgent.util.matchUserAgent("Coast")};
goog.labs.userAgent.browser.matchIosWebview_=function(){return(goog.labs.userAgent.util.matchUserAgent("iPad")||goog.labs.userAgent.util.matchUserAgent("iPhone"))&&!goog.labs.userAgent.browser.matchSafari_()&&!goog.labs.userAgent.browser.matchChrome_()&&!goog.labs.userAgent.browser.matchCoast_()&&!goog.labs.userAgent.browser.matchFirefox_()&&goog.labs.userAgent.util.matchUserAgent("AppleWebKit")};
goog.labs.userAgent.browser.matchChrome_=function(){return(goog.labs.userAgent.util.matchUserAgent("Chrome")||goog.labs.userAgent.util.matchUserAgent("CriOS"))&&!goog.labs.userAgent.browser.matchEdge_()};goog.labs.userAgent.browser.matchAndroidBrowser_=function(){return goog.labs.userAgent.util.matchUserAgent("Android")&&!(goog.labs.userAgent.browser.isChrome()||goog.labs.userAgent.browser.isFirefox()||goog.labs.userAgent.browser.isOpera()||goog.labs.userAgent.browser.isSilk())};
goog.labs.userAgent.browser.isOpera=goog.labs.userAgent.browser.matchOpera_;goog.labs.userAgent.browser.isIE=goog.labs.userAgent.browser.matchIE_;goog.labs.userAgent.browser.isEdge=goog.labs.userAgent.browser.matchEdge_;goog.labs.userAgent.browser.isFirefox=goog.labs.userAgent.browser.matchFirefox_;goog.labs.userAgent.browser.isSafari=goog.labs.userAgent.browser.matchSafari_;goog.labs.userAgent.browser.isCoast=goog.labs.userAgent.browser.matchCoast_;goog.labs.userAgent.browser.isIosWebview=goog.labs.userAgent.browser.matchIosWebview_;
goog.labs.userAgent.browser.isChrome=goog.labs.userAgent.browser.matchChrome_;goog.labs.userAgent.browser.isAndroidBrowser=goog.labs.userAgent.browser.matchAndroidBrowser_;goog.labs.userAgent.browser.isSilk=function(){return goog.labs.userAgent.util.matchUserAgent("Silk")};
goog.labs.userAgent.browser.getVersion=function(){function a(a){a=goog.array.find(a,d);return c[a]||""}var b=goog.labs.userAgent.util.getUserAgent();if(goog.labs.userAgent.browser.isIE())return goog.labs.userAgent.browser.getIEVersion_(b);b=goog.labs.userAgent.util.extractVersionTuples(b);var c={};goog.array.forEach(b,function(a){c[a[0]]=a[1]});var d=goog.partial(goog.object.containsKey,c);return goog.labs.userAgent.browser.isOpera()?a(["Version","Opera"]):goog.labs.userAgent.browser.isEdge()?a(["Edge"]):
goog.labs.userAgent.browser.isChrome()?a(["Chrome","CriOS"]):(b=b[2])&&b[1]||""};goog.labs.userAgent.browser.isVersionOrHigher=function(a){return 0<=goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(),a)};
goog.labs.userAgent.browser.getIEVersion_=function(a){var b=/rv: *([\d\.]*)/.exec(a);if(b&&b[1])return b[1];b="";var c=/MSIE +([\d\.]+)/.exec(a);if(c&&c[1])if(a=/Trident\/(\d.\d)/.exec(a),"7.0"==c[1])if(a&&a[1])switch(a[1]){case "4.0":b="8.0";break;case "5.0":b="9.0";break;case "6.0":b="10.0";break;case "7.0":b="11.0"}else b="7.0";else b=c[1];return b};goog.reflect={};goog.reflect.object=function(a,b){return b};goog.reflect.objectProperty=function(a,b){return a};goog.reflect.sinkValue=function(a){goog.reflect.sinkValue[" "](a);return a};goog.reflect.sinkValue[" "]=goog.nullFunction;goog.reflect.canAccessProperty=function(a,b){try{return goog.reflect.sinkValue(a[b]),!0}catch(c){}return!1};goog.reflect.cache=function(a,b,c,d){d=d?d(b):b;return Object.prototype.hasOwnProperty.call(a,d)?a[d]:a[d]=c(b)};goog.labs.userAgent.engine={};goog.labs.userAgent.engine.isPresto=function(){return goog.labs.userAgent.util.matchUserAgent("Presto")};goog.labs.userAgent.engine.isTrident=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")};goog.labs.userAgent.engine.isEdge=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")};
goog.labs.userAgent.engine.isWebKit=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit")&&!goog.labs.userAgent.engine.isEdge()};goog.labs.userAgent.engine.isGecko=function(){return goog.labs.userAgent.util.matchUserAgent("Gecko")&&!goog.labs.userAgent.engine.isWebKit()&&!goog.labs.userAgent.engine.isTrident()&&!goog.labs.userAgent.engine.isEdge()};
goog.labs.userAgent.engine.getVersion=function(){var a=goog.labs.userAgent.util.getUserAgent();if(a){a=goog.labs.userAgent.util.extractVersionTuples(a);var b=goog.labs.userAgent.engine.getEngineTuple_(a);if(b)return"Gecko"==b[0]?goog.labs.userAgent.engine.getVersionForKey_(a,"Firefox"):b[1];a=a[0];var c;if(a&&(c=a[2])&&(c=/Trident\/([^\s;]+)/.exec(c)))return c[1]}return""};
goog.labs.userAgent.engine.getEngineTuple_=function(a){if(!goog.labs.userAgent.engine.isEdge())return a[1];for(var b=0;b<a.length;b++){var c=a[b];if("Edge"==c[0])return c}};goog.labs.userAgent.engine.isVersionOrHigher=function(a){return 0<=goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(),a)};goog.labs.userAgent.engine.getVersionForKey_=function(a,b){return(a=goog.array.find(a,function(a){return b==a[0]}))&&a[1]||""};goog.userAgent={};goog.userAgent.ASSUME_IE=!1;goog.userAgent.ASSUME_EDGE=!1;goog.userAgent.ASSUME_GECKO=!1;goog.userAgent.ASSUME_WEBKIT=!1;goog.userAgent.ASSUME_MOBILE_WEBKIT=!1;goog.userAgent.ASSUME_OPERA=!1;goog.userAgent.ASSUME_ANY_VERSION=!1;goog.userAgent.BROWSER_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_GECKO||goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_OPERA;goog.userAgent.getUserAgentString=function(){return goog.labs.userAgent.util.getUserAgent()};
goog.userAgent.getNavigatorTyped=function(){return goog.global.navigator||null};goog.userAgent.getNavigator=function(){return goog.userAgent.getNavigatorTyped()};goog.userAgent.OPERA=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_OPERA:goog.labs.userAgent.browser.isOpera();goog.userAgent.IE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_IE:goog.labs.userAgent.browser.isIE();goog.userAgent.EDGE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_EDGE:goog.labs.userAgent.engine.isEdge();
goog.userAgent.EDGE_OR_IE=goog.userAgent.EDGE||goog.userAgent.IE;goog.userAgent.GECKO=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_GECKO:goog.labs.userAgent.engine.isGecko();goog.userAgent.WEBKIT=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_MOBILE_WEBKIT:goog.labs.userAgent.engine.isWebKit();goog.userAgent.isMobile_=function(){return goog.userAgent.WEBKIT&&goog.labs.userAgent.util.matchUserAgent("Mobile")};
goog.userAgent.MOBILE=goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.isMobile_();goog.userAgent.SAFARI=goog.userAgent.WEBKIT;goog.userAgent.determinePlatform_=function(){var a=goog.userAgent.getNavigatorTyped();return a&&a.platform||""};goog.userAgent.PLATFORM=goog.userAgent.determinePlatform_();goog.userAgent.ASSUME_MAC=!1;goog.userAgent.ASSUME_WINDOWS=!1;goog.userAgent.ASSUME_LINUX=!1;goog.userAgent.ASSUME_X11=!1;goog.userAgent.ASSUME_ANDROID=!1;goog.userAgent.ASSUME_IPHONE=!1;
goog.userAgent.ASSUME_IPAD=!1;goog.userAgent.ASSUME_IPOD=!1;goog.userAgent.ASSUME_KAIOS=!1;goog.userAgent.ASSUME_GO2PHONE=!1;goog.userAgent.PLATFORM_KNOWN_=goog.userAgent.ASSUME_MAC||goog.userAgent.ASSUME_WINDOWS||goog.userAgent.ASSUME_LINUX||goog.userAgent.ASSUME_X11||goog.userAgent.ASSUME_ANDROID||goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD;goog.userAgent.MAC=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_MAC:goog.labs.userAgent.platform.isMacintosh();
goog.userAgent.WINDOWS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_WINDOWS:goog.labs.userAgent.platform.isWindows();goog.userAgent.isLegacyLinux_=function(){return goog.labs.userAgent.platform.isLinux()||goog.labs.userAgent.platform.isChromeOS()};goog.userAgent.LINUX=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_LINUX:goog.userAgent.isLegacyLinux_();goog.userAgent.isX11_=function(){var a=goog.userAgent.getNavigatorTyped();return!!a&&goog.string.contains(a.appVersion||"","X11")};
goog.userAgent.X11=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_X11:goog.userAgent.isX11_();goog.userAgent.ANDROID=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_ANDROID:goog.labs.userAgent.platform.isAndroid();goog.userAgent.IPHONE=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE:goog.labs.userAgent.platform.isIphone();goog.userAgent.IPAD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad();
goog.userAgent.IPOD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIpod();goog.userAgent.IOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIos();goog.userAgent.KAIOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_KAIOS:goog.labs.userAgent.platform.isKaiOS();goog.userAgent.GO2PHONE=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_GO2PHONE:goog.labs.userAgent.platform.isGo2Phone();
goog.userAgent.determineVersion_=function(){var a="",b=goog.userAgent.getVersionRegexResult_();b&&(a=b?b[1]:"");return goog.userAgent.IE&&(b=goog.userAgent.getDocumentMode_(),null!=b&&b>parseFloat(a))?String(b):a};
goog.userAgent.getVersionRegexResult_=function(){var a=goog.userAgent.getUserAgentString();if(goog.userAgent.GECKO)return/rv:([^\);]+)(\)|;)/.exec(a);if(goog.userAgent.EDGE)return/Edge\/([\d\.]+)/.exec(a);if(goog.userAgent.IE)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(goog.userAgent.WEBKIT)return/WebKit\/(\S+)/.exec(a);if(goog.userAgent.OPERA)return/(?:Version)[ \/]?(\S+)/.exec(a)};goog.userAgent.getDocumentMode_=function(){var a=goog.global.document;return a?a.documentMode:void 0};
goog.userAgent.VERSION=goog.userAgent.determineVersion_();goog.userAgent.compare=function(a,b){return goog.string.compareVersions(a,b)};goog.userAgent.isVersionOrHigherCache_={};goog.userAgent.isVersionOrHigher=function(a){return goog.userAgent.ASSUME_ANY_VERSION||goog.reflect.cache(goog.userAgent.isVersionOrHigherCache_,a,function(){return 0<=goog.string.compareVersions(goog.userAgent.VERSION,a)})};goog.userAgent.isVersion=goog.userAgent.isVersionOrHigher;
goog.userAgent.isDocumentModeOrHigher=function(a){return Number(goog.userAgent.DOCUMENT_MODE)>=a};goog.userAgent.isDocumentMode=goog.userAgent.isDocumentModeOrHigher;goog.userAgent.DOCUMENT_MODE=function(){var a=goog.global.document,b=goog.userAgent.getDocumentMode_();if(a&&goog.userAgent.IE)return b||("CSS1Compat"==a.compatMode?parseInt(goog.userAgent.VERSION,10):5)}();goog.userAgent.product={};goog.userAgent.product.ASSUME_FIREFOX=!1;goog.userAgent.product.ASSUME_IPHONE=!1;goog.userAgent.product.ASSUME_IPAD=!1;goog.userAgent.product.ASSUME_ANDROID=!1;goog.userAgent.product.ASSUME_CHROME=!1;goog.userAgent.product.ASSUME_SAFARI=!1;
goog.userAgent.product.PRODUCT_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_OPERA||goog.userAgent.product.ASSUME_FIREFOX||goog.userAgent.product.ASSUME_IPHONE||goog.userAgent.product.ASSUME_IPAD||goog.userAgent.product.ASSUME_ANDROID||goog.userAgent.product.ASSUME_CHROME||goog.userAgent.product.ASSUME_SAFARI;goog.userAgent.product.OPERA=goog.userAgent.OPERA;goog.userAgent.product.IE=goog.userAgent.IE;goog.userAgent.product.EDGE=goog.userAgent.EDGE;
goog.userAgent.product.FIREFOX=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_FIREFOX:goog.labs.userAgent.browser.isFirefox();goog.userAgent.product.isIphoneOrIpod_=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpod()};goog.userAgent.product.IPHONE=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPHONE:goog.userAgent.product.isIphoneOrIpod_();
goog.userAgent.product.IPAD=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad();goog.userAgent.product.ANDROID=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_ANDROID:goog.labs.userAgent.browser.isAndroidBrowser();goog.userAgent.product.CHROME=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_CHROME:goog.labs.userAgent.browser.isChrome();
goog.userAgent.product.isSafariDesktop_=function(){return goog.labs.userAgent.browser.isSafari()&&!goog.labs.userAgent.platform.isIos()};goog.userAgent.product.SAFARI=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_SAFARI:goog.userAgent.product.isSafariDesktop_();goog.crypt.base64={};goog.crypt.base64.byteToCharMap_=null;goog.crypt.base64.charToByteMap_=null;goog.crypt.base64.byteToCharMapWebSafe_=null;goog.crypt.base64.ENCODED_VALS_BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";goog.crypt.base64.ENCODED_VALS=goog.crypt.base64.ENCODED_VALS_BASE+"+/=";goog.crypt.base64.ENCODED_VALS_WEBSAFE=goog.crypt.base64.ENCODED_VALS_BASE+"-_.";
goog.crypt.base64.ASSUME_NATIVE_SUPPORT_=goog.userAgent.GECKO||goog.userAgent.WEBKIT&&!goog.userAgent.product.SAFARI||goog.userAgent.OPERA;goog.crypt.base64.HAS_NATIVE_ENCODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||"function"==typeof goog.global.btoa;goog.crypt.base64.HAS_NATIVE_DECODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||!goog.userAgent.product.SAFARI&&!goog.userAgent.IE&&"function"==typeof goog.global.atob;
goog.crypt.base64.encodeByteArray=function(a,b){goog.asserts.assert(goog.isArrayLike(a),"encodeByteArray takes an array as a parameter");goog.crypt.base64.init_();b=b?goog.crypt.base64.byteToCharMapWebSafe_:goog.crypt.base64.byteToCharMap_;for(var c=[],d=0;d<a.length;d+=3){var e=a[d],f=d+1<a.length,g=f?a[d+1]:0,h=d+2<a.length,k=h?a[d+2]:0,l=e>>2;e=(e&3)<<4|g>>4;g=(g&15)<<2|k>>6;k&=63;h||(k=64,f||(g=64));c.push(b[l],b[e],b[g],b[k])}return c.join("")};
goog.crypt.base64.encodeString=function(a,b){return goog.crypt.base64.HAS_NATIVE_ENCODE_&&!b?goog.global.btoa(a):goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(a),b)};goog.crypt.base64.decodeString=function(a,b){if(goog.crypt.base64.HAS_NATIVE_DECODE_&&!b)return goog.global.atob(a);var c="";goog.crypt.base64.decodeStringInternal_(a,function(a){c+=String.fromCharCode(a)});return c};
goog.crypt.base64.decodeStringToByteArray=function(a,b){var c=[];goog.crypt.base64.decodeStringInternal_(a,function(a){c.push(a)});return c};
goog.crypt.base64.decodeStringToUint8Array=function(a){goog.asserts.assert(!goog.userAgent.IE||goog.userAgent.isVersionOrHigher("10"),"Browser does not support typed arrays");var b=a.length,c=0;"="===a[b-2]?c=2:"="===a[b-1]&&(c=1);var d=new Uint8Array(Math.ceil(3*b/4)-c),e=0;goog.crypt.base64.decodeStringInternal_(a,function(a){d[e++]=a});return d.subarray(0,e)};
goog.crypt.base64.decodeStringInternal_=function(a,b){function c(b){for(;d<a.length;){var c=a.charAt(d++),e=goog.crypt.base64.charToByteMap_[c];if(null!=e)return e;if(!goog.string.isEmptyOrWhitespace(c))throw Error("Unknown base64 encoding at char: "+c);}return b}goog.crypt.base64.init_();for(var d=0;;){var e=c(-1),f=c(0),g=c(64),h=c(64);if(64===h&&-1===e)break;b(e<<2|f>>4);64!=g&&(b(f<<4&240|g>>2),64!=h&&b(g<<6&192|h))}};
goog.crypt.base64.init_=function(){if(!goog.crypt.base64.byteToCharMap_){goog.crypt.base64.byteToCharMap_={};goog.crypt.base64.charToByteMap_={};goog.crypt.base64.byteToCharMapWebSafe_={};for(var a=0;a<goog.crypt.base64.ENCODED_VALS.length;a++)goog.crypt.base64.byteToCharMap_[a]=goog.crypt.base64.ENCODED_VALS.charAt(a),goog.crypt.base64.charToByteMap_[goog.crypt.base64.byteToCharMap_[a]]=a,goog.crypt.base64.byteToCharMapWebSafe_[a]=goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(a),a>=goog.crypt.base64.ENCODED_VALS_BASE.length&&
(goog.crypt.base64.charToByteMap_[goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(a)]=a)}};jspb.utils={};jspb.utils.split64Low=0;jspb.utils.split64High=0;jspb.utils.splitUint64=function(a){var b=a>>>0;a=Math.floor((a-b)/jspb.BinaryConstants.TWO_TO_32)>>>0;jspb.utils.split64Low=b;jspb.utils.split64High=a};jspb.utils.splitInt64=function(a){var b=0>a;a=Math.abs(a);var c=a>>>0;a=Math.floor((a-c)/jspb.BinaryConstants.TWO_TO_32);a>>>=0;b&&(a=~a>>>0,c=(~c>>>0)+1,4294967295<c&&(c=0,a++,4294967295<a&&(a=0)));jspb.utils.split64Low=c;jspb.utils.split64High=a};
jspb.utils.splitZigzag64=function(a){var b=0>a;a=2*Math.abs(a);jspb.utils.splitUint64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;b&&(0==a?0==c?c=a=4294967295:(c--,a=4294967295):a--);jspb.utils.split64Low=a;jspb.utils.split64High=c};
jspb.utils.splitFloat32=function(a){var b=0>a?1:0;a=b?-a:a;if(0===a)0<1/a?(jspb.utils.split64High=0,jspb.utils.split64Low=0):(jspb.utils.split64High=0,jspb.utils.split64Low=2147483648);else if(isNaN(a))jspb.utils.split64High=0,jspb.utils.split64Low=2147483647;else if(a>jspb.BinaryConstants.FLOAT32_MAX)jspb.utils.split64High=0,jspb.utils.split64Low=(b<<31|2139095040)>>>0;else if(a<jspb.BinaryConstants.FLOAT32_MIN)a=Math.round(a/Math.pow(2,-149)),jspb.utils.split64High=0,jspb.utils.split64Low=(b<<31|
a)>>>0;else{var c=Math.floor(Math.log(a)/Math.LN2);a*=Math.pow(2,-c);a=Math.round(a*jspb.BinaryConstants.TWO_TO_23)&8388607;jspb.utils.split64High=0;jspb.utils.split64Low=(b<<31|c+127<<23|a)>>>0}};
jspb.utils.splitFloat64=function(a){var b=0>a?1:0;a=b?-a:a;if(0===a)jspb.utils.split64High=0<1/a?0:2147483648,jspb.utils.split64Low=0;else if(isNaN(a))jspb.utils.split64High=2147483647,jspb.utils.split64Low=4294967295;else if(a>jspb.BinaryConstants.FLOAT64_MAX)jspb.utils.split64High=(b<<31|2146435072)>>>0,jspb.utils.split64Low=0;else if(a<jspb.BinaryConstants.FLOAT64_MIN){var c=a/Math.pow(2,-1074);a=c/jspb.BinaryConstants.TWO_TO_32;jspb.utils.split64High=(b<<31|a)>>>0;jspb.utils.split64Low=c>>>0}else{var d=
Math.floor(Math.log(a)/Math.LN2);1024==d&&(d=1023);c=a*Math.pow(2,-d);a=c*jspb.BinaryConstants.TWO_TO_20&1048575;c=c*jspb.BinaryConstants.TWO_TO_52>>>0;jspb.utils.split64High=(b<<31|d+1023<<20|a)>>>0;jspb.utils.split64Low=c}};
jspb.utils.splitHash64=function(a){var b=a.charCodeAt(0),c=a.charCodeAt(1),d=a.charCodeAt(2),e=a.charCodeAt(3),f=a.charCodeAt(4),g=a.charCodeAt(5),h=a.charCodeAt(6);a=a.charCodeAt(7);jspb.utils.split64Low=b+(c<<8)+(d<<16)+(e<<24)>>>0;jspb.utils.split64High=f+(g<<8)+(h<<16)+(a<<24)>>>0};jspb.utils.joinUint64=function(a,b){return b*jspb.BinaryConstants.TWO_TO_32+a};
jspb.utils.joinInt64=function(a,b){var c=b&2147483648;c&&(a=~a+1>>>0,b=~b>>>0,0==a&&(b=b+1>>>0));a=jspb.utils.joinUint64(a,b);return c?-a:a};jspb.utils.joinZigzag64=function(a,b){var c=a&1;a=(a>>>1|b<<31)>>>0;b>>>=1;c&&(a=a+1>>>0,0==a&&(b=b+1>>>0));a=jspb.utils.joinUint64(a,b);return c?-a:a};jspb.utils.joinFloat32=function(a,b){b=2*(a>>31)+1;var c=a>>>23&255;a&=8388607;return 255==c?a?NaN:Infinity*b:0==c?b*Math.pow(2,-149)*a:b*Math.pow(2,c-150)*(a+Math.pow(2,23))};
jspb.utils.joinFloat64=function(a,b){var c=2*(b>>31)+1,d=b>>>20&2047;a=jspb.BinaryConstants.TWO_TO_32*(b&1048575)+a;return 2047==d?a?NaN:Infinity*c:0==d?c*Math.pow(2,-1074)*a:c*Math.pow(2,d-1075)*(a+jspb.BinaryConstants.TWO_TO_52)};jspb.utils.joinHash64=function(a,b){return String.fromCharCode(a>>>0&255,a>>>8&255,a>>>16&255,a>>>24&255,b>>>0&255,b>>>8&255,b>>>16&255,b>>>24&255)};jspb.utils.DIGITS="0123456789abcdef".split("");
jspb.utils.joinUnsignedDecimalString=function(a,b){function c(a){for(var b=1E7,c=0;7>c;c++){b/=10;var d=a/b%10>>>0;if(0!=d||f)f=!0,g+=e[d]}}if(2097151>=b)return""+(jspb.BinaryConstants.TWO_TO_32*b+a);var d=(a>>>24|b<<8)>>>0&16777215;b=b>>16&65535;a=(a&16777215)+6777216*d+6710656*b;d+=8147497*b;b*=2;1E7<=a&&(d+=Math.floor(a/1E7),a%=1E7);1E7<=d&&(b+=Math.floor(d/1E7),d%=1E7);var e=jspb.utils.DIGITS,f=!1,g="";(b||f)&&c(b);(d||f)&&c(d);(a||f)&&c(a);return g};
jspb.utils.joinSignedDecimalString=function(a,b){var c=b&2147483648;c&&(a=~a+1>>>0,b=~b+(0==a?1:0)>>>0);a=jspb.utils.joinUnsignedDecimalString(a,b);return c?"-"+a:a};jspb.utils.hash64ToDecimalString=function(a,b){jspb.utils.splitHash64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;return b?jspb.utils.joinSignedDecimalString(a,c):jspb.utils.joinUnsignedDecimalString(a,c)};
jspb.utils.hash64ArrayToDecimalStrings=function(a,b){for(var c=Array(a.length),d=0;d<a.length;d++)c[d]=jspb.utils.hash64ToDecimalString(a[d],b);return c};jspb.utils.decimalStringToHash64=function(a){function b(a,b){for(var c=0;8>c&&(1!==a||0<b);c++)b=a*e[c]+b,e[c]=b&255,b>>>=8}function c(){for(var a=0;8>a;a++)e[a]=~e[a]&255}goog.asserts.assert(0<a.length);var d=!1;"-"===a[0]&&(d=!0,a=a.slice(1));for(var e=[0,0,0,0,0,0,0,0],f=0;f<a.length;f++)b(10,jspb.utils.DIGITS.indexOf(a[f]));d&&(c(),b(1,1));return goog.crypt.byteArrayToString(e)};
jspb.utils.splitDecimalString=function(a){jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(a))};jspb.utils.hash64ToHexString=function(a){var b=Array(18);b[0]="0";b[1]="x";for(var c=0;8>c;c++){var d=a.charCodeAt(7-c);b[2*c+2]=jspb.utils.DIGITS[d>>4];b[2*c+3]=jspb.utils.DIGITS[d&15]}return b.join("")};
jspb.utils.hexStringToHash64=function(a){a=a.toLowerCase();goog.asserts.assert(18==a.length);goog.asserts.assert("0"==a[0]);goog.asserts.assert("x"==a[1]);for(var b="",c=0;8>c;c++){var d=jspb.utils.DIGITS.indexOf(a[2*c+2]),e=jspb.utils.DIGITS.indexOf(a[2*c+3]);b=String.fromCharCode(16*d+e)+b}return b};jspb.utils.hash64ToNumber=function(a,b){jspb.utils.splitHash64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;return b?jspb.utils.joinInt64(a,c):jspb.utils.joinUint64(a,c)};
jspb.utils.numberToHash64=function(a){jspb.utils.splitInt64(a);return jspb.utils.joinHash64(jspb.utils.split64Low,jspb.utils.split64High)};jspb.utils.countVarints=function(a,b,c){for(var d=0,e=b;e<c;e++)d+=a[e]>>7;return c-b-d};
jspb.utils.countVarintFields=function(a,b,c,d){var e=0;d=8*d+jspb.BinaryConstants.WireType.VARINT;if(128>d)for(;b<c&&a[b++]==d;)for(e++;;){var f=a[b++];if(0==(f&128))break}else for(;b<c;){for(f=d;128<f;){if(a[b]!=(f&127|128))return e;b++;f>>=7}if(a[b++]!=f)break;for(e++;f=a[b++],0!=(f&128););}return e};jspb.utils.countFixedFields_=function(a,b,c,d,e){var f=0;if(128>d)for(;b<c&&a[b++]==d;)f++,b+=e;else for(;b<c;){for(var g=d;128<g;){if(a[b++]!=(g&127|128))return f;g>>=7}if(a[b++]!=g)break;f++;b+=e}return f};
jspb.utils.countFixed32Fields=function(a,b,c,d){return jspb.utils.countFixedFields_(a,b,c,8*d+jspb.BinaryConstants.WireType.FIXED32,4)};jspb.utils.countFixed64Fields=function(a,b,c,d){return jspb.utils.countFixedFields_(a,b,c,8*d+jspb.BinaryConstants.WireType.FIXED64,8)};
jspb.utils.countDelimitedFields=function(a,b,c,d){var e=0;for(d=8*d+jspb.BinaryConstants.WireType.DELIMITED;b<c;){for(var f=d;128<f;){if(a[b++]!=(f&127|128))return e;f>>=7}if(a[b++]!=f)break;e++;for(var g=0,h=1;f=a[b++],g+=(f&127)*h,h*=128,0!=(f&128););b+=g}return e};jspb.utils.debugBytesToTextFormat=function(a){var b='"';if(a){a=jspb.utils.byteSourceToUint8Array(a);for(var c=0;c<a.length;c++)b+="\\x",16>a[c]&&(b+="0"),b+=a[c].toString(16)}return b+'"'};
jspb.utils.debugScalarToTextFormat=function(a){return goog.isString(a)?goog.string.quote(a):a.toString()};jspb.utils.stringToByteArray=function(a){for(var b=new Uint8Array(a.length),c=0;c<a.length;c++){var d=a.charCodeAt(c);if(255<d)throw Error("Conversion error: string contains codepoint outside of byte range");b[c]=d}return b};
jspb.utils.byteSourceToUint8Array=function(a){if(a.constructor===Uint8Array)return a;if(a.constructor===ArrayBuffer||"undefined"!=typeof Buffer&&a.constructor===Buffer||a.constructor===Array)return new Uint8Array(a);if(a.constructor===String)return goog.crypt.base64.decodeStringToUint8Array(a);goog.asserts.fail("Type not convertible to Uint8Array.");return new Uint8Array(0)};jspb.BinaryIterator=function(a,b,c){this.elements_=this.nextMethod_=this.decoder_=null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!0;this.init_(a,b,c)};jspb.BinaryIterator.prototype.init_=function(a,b,c){a&&b&&(this.decoder_=a,this.nextMethod_=b);this.elements_=c||null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!this.decoder_&&!this.elements_;this.next()};jspb.BinaryIterator.instanceCache_=[];
jspb.BinaryIterator.alloc=function(a,b,c){if(jspb.BinaryIterator.instanceCache_.length){var d=jspb.BinaryIterator.instanceCache_.pop();d.init_(a,b,c);return d}return new jspb.BinaryIterator(a,b,c)};jspb.BinaryIterator.prototype.free=function(){this.clear();100>jspb.BinaryIterator.instanceCache_.length&&jspb.BinaryIterator.instanceCache_.push(this)};
jspb.BinaryIterator.prototype.clear=function(){this.decoder_&&this.decoder_.free();this.elements_=this.nextMethod_=this.decoder_=null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!0};jspb.BinaryIterator.prototype.get=function(){return this.nextValue_};jspb.BinaryIterator.prototype.atEnd=function(){return this.atEnd_};
jspb.BinaryIterator.prototype.next=function(){var a=this.nextValue_;this.decoder_?this.decoder_.atEnd()?(this.nextValue_=null,this.atEnd_=!0):this.nextValue_=this.nextMethod_.call(this.decoder_):this.elements_&&(this.cursor_==this.elements_.length?(this.nextValue_=null,this.atEnd_=!0):this.nextValue_=this.elements_[this.cursor_++]);return a};jspb.BinaryDecoder=function(a,b,c){this.bytes_=null;this.tempHigh_=this.tempLow_=this.cursor_=this.end_=this.start_=0;this.error_=!1;a&&this.setBlock(a,b,c)};
jspb.BinaryDecoder.instanceCache_=[];jspb.BinaryDecoder.alloc=function(a,b,c){if(jspb.BinaryDecoder.instanceCache_.length){var d=jspb.BinaryDecoder.instanceCache_.pop();a&&d.setBlock(a,b,c);return d}return new jspb.BinaryDecoder(a,b,c)};jspb.BinaryDecoder.prototype.free=function(){this.clear();100>jspb.BinaryDecoder.instanceCache_.length&&jspb.BinaryDecoder.instanceCache_.push(this)};jspb.BinaryDecoder.prototype.clone=function(){return jspb.BinaryDecoder.alloc(this.bytes_,this.start_,this.end_-this.start_)};
jspb.BinaryDecoder.prototype.clear=function(){this.bytes_=null;this.cursor_=this.end_=this.start_=0;this.error_=!1};jspb.BinaryDecoder.prototype.getBuffer=function(){return this.bytes_};jspb.BinaryDecoder.prototype.setBlock=function(a,b,c){this.bytes_=jspb.utils.byteSourceToUint8Array(a);this.start_=goog.isDef(b)?b:0;this.end_=goog.isDef(c)?this.start_+c:this.bytes_.length;this.cursor_=this.start_};jspb.BinaryDecoder.prototype.getEnd=function(){return this.end_};
jspb.BinaryDecoder.prototype.setEnd=function(a){this.end_=a};jspb.BinaryDecoder.prototype.reset=function(){this.cursor_=this.start_};jspb.BinaryDecoder.prototype.getCursor=function(){return this.cursor_};jspb.BinaryDecoder.prototype.setCursor=function(a){this.cursor_=a};jspb.BinaryDecoder.prototype.advance=function(a){this.cursor_+=a;goog.asserts.assert(this.cursor_<=this.end_)};jspb.BinaryDecoder.prototype.atEnd=function(){return this.cursor_==this.end_};
jspb.BinaryDecoder.prototype.pastEnd=function(){return this.cursor_>this.end_};jspb.BinaryDecoder.prototype.getError=function(){return this.error_||0>this.cursor_||this.cursor_>this.end_};
jspb.BinaryDecoder.prototype.readSplitVarint64_=function(){for(var a,b=0,c,d=0;4>d;d++)if(a=this.bytes_[this.cursor_++],b|=(a&127)<<7*d,128>a){this.tempLow_=b>>>0;this.tempHigh_=0;return}a=this.bytes_[this.cursor_++];b|=(a&127)<<28;c=0|(a&127)>>4;if(128>a)this.tempLow_=b>>>0,this.tempHigh_=c>>>0;else{for(d=0;5>d;d++)if(a=this.bytes_[this.cursor_++],c|=(a&127)<<7*d+3,128>a){this.tempLow_=b>>>0;this.tempHigh_=c>>>0;return}goog.asserts.fail("Failed to read varint, encoding is invalid.");this.error_=
!0}};jspb.BinaryDecoder.prototype.skipVarint=function(){for(;this.bytes_[this.cursor_]&128;)this.cursor_++;this.cursor_++};jspb.BinaryDecoder.prototype.unskipVarint=function(a){for(;128<a;)this.cursor_--,a>>>=7;this.cursor_--};
jspb.BinaryDecoder.prototype.readUnsignedVarint32=function(){var a=this.bytes_;var b=a[this.cursor_+0];var c=b&127;if(128>b)return this.cursor_+=1,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+1];c|=(b&127)<<7;if(128>b)return this.cursor_+=2,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+2];c|=(b&127)<<14;if(128>b)return this.cursor_+=3,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+3];c|=(b&127)<<21;if(128>b)return this.cursor_+=4,goog.asserts.assert(this.cursor_<=
this.end_),c;b=a[this.cursor_+4];c|=(b&15)<<28;if(128>b)return this.cursor_+=5,goog.asserts.assert(this.cursor_<=this.end_),c>>>0;this.cursor_+=5;128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&goog.asserts.assert(!1);goog.asserts.assert(this.cursor_<=this.end_);return c};jspb.BinaryDecoder.prototype.readSignedVarint32=jspb.BinaryDecoder.prototype.readUnsignedVarint32;jspb.BinaryDecoder.prototype.readUnsignedVarint32String=function(){return this.readUnsignedVarint32().toString()};
jspb.BinaryDecoder.prototype.readSignedVarint32String=function(){return this.readSignedVarint32().toString()};jspb.BinaryDecoder.prototype.readZigzagVarint32=function(){var a=this.readUnsignedVarint32();return a>>>1^-(a&1)};jspb.BinaryDecoder.prototype.readUnsignedVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinUint64(this.tempLow_,this.tempHigh_)};
jspb.BinaryDecoder.prototype.readUnsignedVarint64String=function(){this.readSplitVarint64_();return jspb.utils.joinUnsignedDecimalString(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readSignedVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinInt64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readSignedVarint64String=function(){this.readSplitVarint64_();return jspb.utils.joinSignedDecimalString(this.tempLow_,this.tempHigh_)};
jspb.BinaryDecoder.prototype.readZigzagVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinZigzag64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readZigzagVarint64String=function(){return this.readZigzagVarint64().toString()};jspb.BinaryDecoder.prototype.readUint8=function(){var a=this.bytes_[this.cursor_+0];this.cursor_+=1;goog.asserts.assert(this.cursor_<=this.end_);return a};
jspb.BinaryDecoder.prototype.readUint16=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1];this.cursor_+=2;goog.asserts.assert(this.cursor_<=this.end_);return a<<0|b<<8};jspb.BinaryDecoder.prototype.readUint32=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1],c=this.bytes_[this.cursor_+2],d=this.bytes_[this.cursor_+3];this.cursor_+=4;goog.asserts.assert(this.cursor_<=this.end_);return(a<<0|b<<8|c<<16|d<<24)>>>0};
jspb.BinaryDecoder.prototype.readUint64=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinUint64(a,b)};jspb.BinaryDecoder.prototype.readUint64String=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinUnsignedDecimalString(a,b)};jspb.BinaryDecoder.prototype.readInt8=function(){var a=this.bytes_[this.cursor_+0];this.cursor_+=1;goog.asserts.assert(this.cursor_<=this.end_);return a<<24>>24};
jspb.BinaryDecoder.prototype.readInt16=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1];this.cursor_+=2;goog.asserts.assert(this.cursor_<=this.end_);return(a<<0|b<<8)<<16>>16};jspb.BinaryDecoder.prototype.readInt32=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1],c=this.bytes_[this.cursor_+2],d=this.bytes_[this.cursor_+3];this.cursor_+=4;goog.asserts.assert(this.cursor_<=this.end_);return a<<0|b<<8|c<<16|d<<24};
jspb.BinaryDecoder.prototype.readInt64=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinInt64(a,b)};jspb.BinaryDecoder.prototype.readInt64String=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinSignedDecimalString(a,b)};jspb.BinaryDecoder.prototype.readFloat=function(){var a=this.readUint32();return jspb.utils.joinFloat32(a,0)};
jspb.BinaryDecoder.prototype.readDouble=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinFloat64(a,b)};jspb.BinaryDecoder.prototype.readBool=function(){return!!this.bytes_[this.cursor_++]};jspb.BinaryDecoder.prototype.readEnum=function(){return this.readSignedVarint32()};
jspb.BinaryDecoder.prototype.readString=function(a){var b=this.bytes_,c=this.cursor_;a=c+a;for(var d=[],e="";c<a;){var f=b[c++];if(128>f)d.push(f);else if(192>f)continue;else if(224>f){var g=b[c++];d.push((f&31)<<6|g&63)}else if(240>f){g=b[c++];var h=b[c++];d.push((f&15)<<12|(g&63)<<6|h&63)}else if(248>f){g=b[c++];h=b[c++];var k=b[c++];f=(f&7)<<18|(g&63)<<12|(h&63)<<6|k&63;f-=65536;d.push((f>>10&1023)+55296,(f&1023)+56320)}8192<=d.length&&(e+=String.fromCharCode.apply(null,d),d.length=0)}e+=goog.crypt.byteArrayToString(d);
this.cursor_=c;return e};jspb.BinaryDecoder.prototype.readStringWithLength=function(){var a=this.readUnsignedVarint32();return this.readString(a)};jspb.BinaryDecoder.prototype.readBytes=function(a){if(0>a||this.cursor_+a>this.bytes_.length)return this.error_=!0,goog.asserts.fail("Invalid byte length!"),new Uint8Array(0);var b=this.bytes_.subarray(this.cursor_,this.cursor_+a);this.cursor_+=a;goog.asserts.assert(this.cursor_<=this.end_);return b};
jspb.BinaryDecoder.prototype.readVarintHash64=function(){this.readSplitVarint64_();return jspb.utils.joinHash64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readFixedHash64=function(){var a=this.bytes_,b=this.cursor_,c=a[b+0],d=a[b+1],e=a[b+2],f=a[b+3],g=a[b+4],h=a[b+5],k=a[b+6];a=a[b+7];this.cursor_+=8;return String.fromCharCode(c,d,e,f,g,h,k,a)};jspb.BinaryReader=function(a,b,c){this.decoder_=jspb.BinaryDecoder.alloc(a,b,c);this.fieldCursor_=this.decoder_.getCursor();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID;this.error_=!1;this.readCallbacks_=null};jspb.BinaryReader.instanceCache_=[];
jspb.BinaryReader.alloc=function(a,b,c){if(jspb.BinaryReader.instanceCache_.length){var d=jspb.BinaryReader.instanceCache_.pop();a&&d.decoder_.setBlock(a,b,c);return d}return new jspb.BinaryReader(a,b,c)};jspb.BinaryReader.prototype.alloc=jspb.BinaryReader.alloc;
jspb.BinaryReader.prototype.free=function(){this.decoder_.clear();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID;this.error_=!1;this.readCallbacks_=null;100>jspb.BinaryReader.instanceCache_.length&&jspb.BinaryReader.instanceCache_.push(this)};jspb.BinaryReader.prototype.getFieldCursor=function(){return this.fieldCursor_};jspb.BinaryReader.prototype.getCursor=function(){return this.decoder_.getCursor()};
jspb.BinaryReader.prototype.getBuffer=function(){return this.decoder_.getBuffer()};jspb.BinaryReader.prototype.getFieldNumber=function(){return this.nextField_};jspb.BinaryReader.prototype.getWireType=function(){return this.nextWireType_};jspb.BinaryReader.prototype.isEndGroup=function(){return this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP};jspb.BinaryReader.prototype.getError=function(){return this.error_||this.decoder_.getError()};
jspb.BinaryReader.prototype.setBlock=function(a,b,c){this.decoder_.setBlock(a,b,c);this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID};jspb.BinaryReader.prototype.reset=function(){this.decoder_.reset();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID};jspb.BinaryReader.prototype.advance=function(a){this.decoder_.advance(a)};
jspb.BinaryReader.prototype.nextField=function(){if(this.decoder_.atEnd())return!1;if(this.getError())return goog.asserts.fail("Decoder hit an error"),!1;this.fieldCursor_=this.decoder_.getCursor();var a=this.decoder_.readUnsignedVarint32(),b=a>>>3;a&=7;if(a!=jspb.BinaryConstants.WireType.VARINT&&a!=jspb.BinaryConstants.WireType.FIXED32&&a!=jspb.BinaryConstants.WireType.FIXED64&&a!=jspb.BinaryConstants.WireType.DELIMITED&&a!=jspb.BinaryConstants.WireType.START_GROUP&&a!=jspb.BinaryConstants.WireType.END_GROUP)return goog.asserts.fail("Invalid wire type: %s (at position %s)",
a,this.fieldCursor_),this.error_=!0,!1;this.nextField_=b;this.nextWireType_=a;return!0};jspb.BinaryReader.prototype.unskipHeader=function(){this.decoder_.unskipVarint(this.nextField_<<3|this.nextWireType_)};jspb.BinaryReader.prototype.skipMatchingFields=function(){var a=this.nextField_;for(this.unskipHeader();this.nextField()&&this.getFieldNumber()==a;)this.skipField();this.decoder_.atEnd()||this.unskipHeader()};
jspb.BinaryReader.prototype.skipVarintField=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.VARINT?(goog.asserts.fail("Invalid wire type for skipVarintField"),this.skipField()):this.decoder_.skipVarint()};jspb.BinaryReader.prototype.skipDelimitedField=function(){if(this.nextWireType_!=jspb.BinaryConstants.WireType.DELIMITED)goog.asserts.fail("Invalid wire type for skipDelimitedField"),this.skipField();else{var a=this.decoder_.readUnsignedVarint32();this.decoder_.advance(a)}};
jspb.BinaryReader.prototype.skipFixed32Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED32?(goog.asserts.fail("Invalid wire type for skipFixed32Field"),this.skipField()):this.decoder_.advance(4)};jspb.BinaryReader.prototype.skipFixed64Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED64?(goog.asserts.fail("Invalid wire type for skipFixed64Field"),this.skipField()):this.decoder_.advance(8)};
jspb.BinaryReader.prototype.skipGroup=function(){var a=this.nextField_;do{if(!this.nextField()){goog.asserts.fail("Unmatched start-group tag: stream EOF");this.error_=!0;break}if(this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP){this.nextField_!=a&&(goog.asserts.fail("Unmatched end-group tag"),this.error_=!0);break}this.skipField()}while(1)};
jspb.BinaryReader.prototype.skipField=function(){switch(this.nextWireType_){case jspb.BinaryConstants.WireType.VARINT:this.skipVarintField();break;case jspb.BinaryConstants.WireType.FIXED64:this.skipFixed64Field();break;case jspb.BinaryConstants.WireType.DELIMITED:this.skipDelimitedField();break;case jspb.BinaryConstants.WireType.FIXED32:this.skipFixed32Field();break;case jspb.BinaryConstants.WireType.START_GROUP:this.skipGroup();break;default:goog.asserts.fail("Invalid wire encoding for field.")}};
jspb.BinaryReader.prototype.registerReadCallback=function(a,b){goog.isNull(this.readCallbacks_)&&(this.readCallbacks_={});goog.asserts.assert(!this.readCallbacks_[a]);this.readCallbacks_[a]=b};jspb.BinaryReader.prototype.runReadCallback=function(a){goog.asserts.assert(!goog.isNull(this.readCallbacks_));a=this.readCallbacks_[a];goog.asserts.assert(a);return a(this)};
jspb.BinaryReader.prototype.readAny=function(a){this.nextWireType_=jspb.BinaryConstants.FieldTypeToWireType(a);var b=jspb.BinaryConstants.FieldType;switch(a){case b.DOUBLE:return this.readDouble();case b.FLOAT:return this.readFloat();case b.INT64:return this.readInt64();case b.UINT64:return this.readUint64();case b.INT32:return this.readInt32();case b.FIXED64:return this.readFixed64();case b.FIXED32:return this.readFixed32();case b.BOOL:return this.readBool();case b.STRING:return this.readString();
case b.GROUP:goog.asserts.fail("Group field type not supported in readAny()");case b.MESSAGE:goog.asserts.fail("Message field type not supported in readAny()");case b.BYTES:return this.readBytes();case b.UINT32:return this.readUint32();case b.ENUM:return this.readEnum();case b.SFIXED32:return this.readSfixed32();case b.SFIXED64:return this.readSfixed64();case b.SINT32:return this.readSint32();case b.SINT64:return this.readSint64();case b.FHASH64:return this.readFixedHash64();case b.VHASH64:return this.readVarintHash64();
default:goog.asserts.fail("Invalid field type in readAny()")}return 0};jspb.BinaryReader.prototype.readMessage=function(a,b){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var c=this.decoder_.getEnd(),d=this.decoder_.readUnsignedVarint32();d=this.decoder_.getCursor()+d;this.decoder_.setEnd(d);b(a,this);this.decoder_.setCursor(d);this.decoder_.setEnd(c)};
jspb.BinaryReader.prototype.readGroup=function(a,b,c){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.START_GROUP);goog.asserts.assert(this.nextField_==a);c(b,this);this.error_||this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP||(goog.asserts.fail("Group submessage did not end with an END_GROUP tag"),this.error_=!0)};
jspb.BinaryReader.prototype.getFieldDecoder=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32(),b=this.decoder_.getCursor(),c=b+a;a=jspb.BinaryDecoder.alloc(this.decoder_.getBuffer(),b,a);this.decoder_.setCursor(c);return a};jspb.BinaryReader.prototype.readInt32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint32()};
jspb.BinaryReader.prototype.readInt32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint32String()};jspb.BinaryReader.prototype.readInt64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64()};jspb.BinaryReader.prototype.readInt64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64String()};
jspb.BinaryReader.prototype.readUint32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint32()};jspb.BinaryReader.prototype.readUint32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint32String()};jspb.BinaryReader.prototype.readUint64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint64()};
jspb.BinaryReader.prototype.readUint64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint64String()};jspb.BinaryReader.prototype.readSint32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint32()};jspb.BinaryReader.prototype.readSint64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint64()};
jspb.BinaryReader.prototype.readSint64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint64String()};jspb.BinaryReader.prototype.readFixed32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readUint32()};jspb.BinaryReader.prototype.readFixed64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readUint64()};
jspb.BinaryReader.prototype.readFixed64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readUint64String()};jspb.BinaryReader.prototype.readSfixed32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readInt32()};jspb.BinaryReader.prototype.readSfixed32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readInt32().toString()};
jspb.BinaryReader.prototype.readSfixed64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readInt64()};jspb.BinaryReader.prototype.readSfixed64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readInt64String()};jspb.BinaryReader.prototype.readFloat=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readFloat()};
jspb.BinaryReader.prototype.readDouble=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readDouble()};jspb.BinaryReader.prototype.readBool=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return!!this.decoder_.readUnsignedVarint32()};jspb.BinaryReader.prototype.readEnum=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64()};
jspb.BinaryReader.prototype.readString=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32();return this.decoder_.readString(a)};jspb.BinaryReader.prototype.readBytes=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32();return this.decoder_.readBytes(a)};
jspb.BinaryReader.prototype.readVarintHash64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readVarintHash64()};jspb.BinaryReader.prototype.readFixedHash64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readFixedHash64()};
jspb.BinaryReader.prototype.readPackedField_=function(a){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var b=this.decoder_.readUnsignedVarint32();b=this.decoder_.getCursor()+b;for(var c=[];this.decoder_.getCursor()<b;)c.push(a.call(this.decoder_));return c};jspb.BinaryReader.prototype.readPackedInt32=function(){return this.readPackedField_(this.decoder_.readSignedVarint32)};jspb.BinaryReader.prototype.readPackedInt32String=function(){return this.readPackedField_(this.decoder_.readSignedVarint32String)};
jspb.BinaryReader.prototype.readPackedInt64=function(){return this.readPackedField_(this.decoder_.readSignedVarint64)};jspb.BinaryReader.prototype.readPackedInt64String=function(){return this.readPackedField_(this.decoder_.readSignedVarint64String)};jspb.BinaryReader.prototype.readPackedUint32=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32)};jspb.BinaryReader.prototype.readPackedUint32String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32String)};
jspb.BinaryReader.prototype.readPackedUint64=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64)};jspb.BinaryReader.prototype.readPackedUint64String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64String)};jspb.BinaryReader.prototype.readPackedSint32=function(){return this.readPackedField_(this.decoder_.readZigzagVarint32)};jspb.BinaryReader.prototype.readPackedSint64=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64)};
jspb.BinaryReader.prototype.readPackedSint64String=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64String)};jspb.BinaryReader.prototype.readPackedFixed32=function(){return this.readPackedField_(this.decoder_.readUint32)};jspb.BinaryReader.prototype.readPackedFixed64=function(){return this.readPackedField_(this.decoder_.readUint64)};jspb.BinaryReader.prototype.readPackedFixed64String=function(){return this.readPackedField_(this.decoder_.readUint64String)};
jspb.BinaryReader.prototype.readPackedSfixed32=function(){return this.readPackedField_(this.decoder_.readInt32)};jspb.BinaryReader.prototype.readPackedSfixed64=function(){return this.readPackedField_(this.decoder_.readInt64)};jspb.BinaryReader.prototype.readPackedSfixed64String=function(){return this.readPackedField_(this.decoder_.readInt64String)};jspb.BinaryReader.prototype.readPackedFloat=function(){return this.readPackedField_(this.decoder_.readFloat)};
jspb.BinaryReader.prototype.readPackedDouble=function(){return this.readPackedField_(this.decoder_.readDouble)};jspb.BinaryReader.prototype.readPackedBool=function(){return this.readPackedField_(this.decoder_.readBool)};jspb.BinaryReader.prototype.readPackedEnum=function(){return this.readPackedField_(this.decoder_.readEnum)};jspb.BinaryReader.prototype.readPackedVarintHash64=function(){return this.readPackedField_(this.decoder_.readVarintHash64)};
jspb.BinaryReader.prototype.readPackedFixedHash64=function(){return this.readPackedField_(this.decoder_.readFixedHash64)};jspb.Map=function(a,b){this.arr_=a;this.valueCtor_=b;this.map_={};this.arrClean=!0;0<this.arr_.length&&this.loadFromArray_()};jspb.Map.prototype.loadFromArray_=function(){for(var a=0;a<this.arr_.length;a++){var b=this.arr_[a],c=b[0];this.map_[c.toString()]=new jspb.Map.Entry_(c,b[1])}this.arrClean=!0};
jspb.Map.prototype.toArray=function(){if(this.arrClean){if(this.valueCtor_){var a=this.map_,b;for(b in a)if(Object.prototype.hasOwnProperty.call(a,b)){var c=a[b].valueWrapper;c&&c.toArray()}}}else{this.arr_.length=0;a=this.stringKeys_();a.sort();for(b=0;b<a.length;b++){var d=this.map_[a[b]];(c=d.valueWrapper)&&c.toArray();this.arr_.push([d.key,d.value])}this.arrClean=!0}return this.arr_};
jspb.Map.prototype.toObject=function(a,b){for(var c=this.toArray(),d=[],e=0;e<c.length;e++){var f=this.map_[c[e][0].toString()];this.wrapEntry_(f);var g=f.valueWrapper;g?(goog.asserts.assert(b),d.push([f.key,b(a,g)])):d.push([f.key,f.value])}return d};jspb.Map.fromObject=function(a,b,c){b=new jspb.Map([],b);for(var d=0;d<a.length;d++){var e=a[d][0],f=c(a[d][1]);b.set(e,f)}return b};jspb.Map.ArrayIteratorIterable_=function(a){this.idx_=0;this.arr_=a};
jspb.Map.ArrayIteratorIterable_.prototype.next=function(){return this.idx_<this.arr_.length?{done:!1,value:this.arr_[this.idx_++]}:{done:!0,value:void 0}};"undefined"!=typeof Symbol&&(jspb.Map.ArrayIteratorIterable_.prototype[Symbol.iterator]=function(){return this});jspb.Map.prototype.getLength=function(){return this.stringKeys_().length};jspb.Map.prototype.clear=function(){this.map_={};this.arrClean=!1};
jspb.Map.prototype.del=function(a){a=a.toString();var b=this.map_.hasOwnProperty(a);delete this.map_[a];this.arrClean=!1;return b};jspb.Map.prototype.getEntryList=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++){var d=this.map_[b[c]];a.push([d.key,d.value])}return a};jspb.Map.prototype.entries=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++){var d=this.map_[b[c]];a.push([d.key,this.wrapEntry_(d)])}return new jspb.Map.ArrayIteratorIterable_(a)};
jspb.Map.prototype.keys=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++)a.push(this.map_[b[c]].key);return new jspb.Map.ArrayIteratorIterable_(a)};jspb.Map.prototype.values=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++)a.push(this.wrapEntry_(this.map_[b[c]]));return new jspb.Map.ArrayIteratorIterable_(a)};
jspb.Map.prototype.forEach=function(a,b){var c=this.stringKeys_();c.sort();for(var d=0;d<c.length;d++){var e=this.map_[c[d]];a.call(b,this.wrapEntry_(e),e.key,this)}};jspb.Map.prototype.set=function(a,b){var c=new jspb.Map.Entry_(a);this.valueCtor_?(c.valueWrapper=b,c.value=b.toArray()):c.value=b;this.map_[a.toString()]=c;this.arrClean=!1;return this};jspb.Map.prototype.wrapEntry_=function(a){return this.valueCtor_?(a.valueWrapper||(a.valueWrapper=new this.valueCtor_(a.value)),a.valueWrapper):a.value};
jspb.Map.prototype.get=function(a){if(a=this.map_[a.toString()])return this.wrapEntry_(a)};jspb.Map.prototype.has=function(a){return a.toString()in this.map_};jspb.Map.prototype.serializeBinary=function(a,b,c,d,e){var f=this.stringKeys_();f.sort();for(var g=0;g<f.length;g++){var h=this.map_[f[g]];b.beginSubMessage(a);c.call(b,1,h.key);this.valueCtor_?d.call(b,2,this.wrapEntry_(h),e):d.call(b,2,h.value);b.endSubMessage()}};
jspb.Map.deserializeBinary=function(a,b,c,d,e,f){for(var g=void 0;b.nextField()&&!b.isEndGroup();){var h=b.getFieldNumber();1==h?f=c.call(b):2==h&&(a.valueCtor_?(goog.asserts.assert(e),g=new a.valueCtor_,d.call(b,g,e)):g=d.call(b))}goog.asserts.assert(void 0!=f);goog.asserts.assert(void 0!=g);a.set(f,g)};jspb.Map.prototype.stringKeys_=function(){var a=this.map_,b=[],c;for(c in a)Object.prototype.hasOwnProperty.call(a,c)&&b.push(c);return b};
jspb.Map.Entry_=function(a,b){this.key=a;this.value=b;this.valueWrapper=void 0};jspb.ExtensionFieldInfo=function(a,b,c,d,e){this.fieldIndex=a;this.fieldName=b;this.ctor=c;this.toObjectFn=d;this.isRepeated=e};jspb.ExtensionFieldBinaryInfo=function(a,b,c,d,e,f){this.fieldInfo=a;this.binaryReaderFn=b;this.binaryWriterFn=c;this.binaryMessageSerializeFn=d;this.binaryMessageDeserializeFn=e;this.isPacked=f};jspb.ExtensionFieldInfo.prototype.isMessageType=function(){return!!this.ctor};jspb.Message=function(){};jspb.Message.GENERATE_TO_OBJECT=!0;jspb.Message.GENERATE_FROM_OBJECT=!goog.DISALLOW_TEST_ONLY_CODE;
jspb.Message.GENERATE_TO_STRING=!0;jspb.Message.ASSUME_LOCAL_ARRAYS=!1;jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS=!0;jspb.Message.SUPPORTS_UINT8ARRAY_="function"==typeof Uint8Array;jspb.Message.prototype.getJsPbMessageId=function(){return this.messageId_};jspb.Message.getIndex_=function(a,b){return b+a.arrayIndexOffset_};jspb.Message.hiddenES6Property_=function(){};jspb.Message.getFieldNumber_=function(a,b){return b-a.arrayIndexOffset_};
jspb.Message.initialize=function(a,b,c,d,e,f){a.wrappers_=null;b||(b=c?[c]:[]);a.messageId_=c?String(c):void 0;a.arrayIndexOffset_=0===c?-1:0;a.array=b;jspb.Message.initPivotAndExtensionObject_(a,d);a.convertedPrimitiveFields_={};jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS||(a.repeatedFields=e);if(e)for(b=0;b<e.length;b++)c=e[b],c<a.pivot_?(c=jspb.Message.getIndex_(a,c),a.array[c]=a.array[c]||jspb.Message.EMPTY_LIST_SENTINEL_):(jspb.Message.maybeInitEmptyExtensionObject_(a),a.extensionObject_[c]=
a.extensionObject_[c]||jspb.Message.EMPTY_LIST_SENTINEL_);if(f&&f.length)for(b=0;b<f.length;b++)jspb.Message.computeOneofCase(a,f[b])};jspb.Message.EMPTY_LIST_SENTINEL_=goog.DEBUG&&Object.freeze?Object.freeze([]):[];jspb.Message.isArray_=function(a){return jspb.Message.ASSUME_LOCAL_ARRAYS?a instanceof Array:goog.isArray(a)};jspb.Message.isExtensionObject_=function(a){return null!==a&&"object"==typeof a&&!jspb.Message.isArray_(a)&&!(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)};
jspb.Message.initPivotAndExtensionObject_=function(a,b){var c=a.array.length,d=-1;if(c&&(d=c-1,c=a.array[d],jspb.Message.isExtensionObject_(c))){a.pivot_=jspb.Message.getFieldNumber_(a,d);a.extensionObject_=c;return}-1<b?(a.pivot_=Math.max(b,jspb.Message.getFieldNumber_(a,d+1)),a.extensionObject_=null):a.pivot_=Number.MAX_VALUE};jspb.Message.maybeInitEmptyExtensionObject_=function(a){var b=jspb.Message.getIndex_(a,a.pivot_);a.array[b]||(a.extensionObject_=a.array[b]={})};
jspb.Message.toObjectList=function(a,b,c){for(var d=[],e=0;e<a.length;e++)d[e]=b.call(a[e],c,a[e]);return d};jspb.Message.toObjectExtension=function(a,b,c,d,e){for(var f in c){var g=c[f],h=d.call(a,g);if(null!=h){for(var k in g.fieldName)if(g.fieldName.hasOwnProperty(k))break;b[k]=g.toObjectFn?g.isRepeated?jspb.Message.toObjectList(h,g.toObjectFn,e):g.toObjectFn(e,h):h}}};
jspb.Message.serializeBinaryExtensions=function(a,b,c,d){for(var e in c){var f=c[e],g=f.fieldInfo;if(!f.binaryWriterFn)throw Error("Message extension present that was generated without binary serialization support");var h=d.call(a,g);if(null!=h)if(g.isMessageType())if(f.binaryMessageSerializeFn)f.binaryWriterFn.call(b,g.fieldIndex,h,f.binaryMessageSerializeFn);else throw Error("Message extension present holding submessage without binary support enabled, and message is being serialized to binary format");
else f.binaryWriterFn.call(b,g.fieldIndex,h)}};jspb.Message.readBinaryExtension=function(a,b,c,d,e){var f=c[b.getFieldNumber()];if(f){c=f.fieldInfo;if(!f.binaryReaderFn)throw Error("Deserializing extension whose generated code does not support binary format");if(c.isMessageType()){var g=new c.ctor;f.binaryReaderFn.call(b,g,f.binaryMessageDeserializeFn)}else g=f.binaryReaderFn.call(b);c.isRepeated&&!f.isPacked?(b=d.call(a,c))?b.push(g):e.call(a,c,[g]):e.call(a,c,g)}else b.skipField()};
jspb.Message.getField=function(a,b){if(b<a.pivot_){b=jspb.Message.getIndex_(a,b);var c=a.array[b];return c===jspb.Message.EMPTY_LIST_SENTINEL_?a.array[b]=[]:c}if(a.extensionObject_)return c=a.extensionObject_[b],c===jspb.Message.EMPTY_LIST_SENTINEL_?a.extensionObject_[b]=[]:c};jspb.Message.getRepeatedField=function(a,b){return jspb.Message.getField(a,b)};jspb.Message.getOptionalFloatingPointField=function(a,b){a=jspb.Message.getField(a,b);return null==a?a:+a};
jspb.Message.getBooleanField=function(a,b){a=jspb.Message.getField(a,b);return null==a?a:!!a};jspb.Message.getRepeatedFloatingPointField=function(a,b){var c=jspb.Message.getRepeatedField(a,b);a.convertedPrimitiveFields_||(a.convertedPrimitiveFields_={});if(!a.convertedPrimitiveFields_[b]){for(var d=0;d<c.length;d++)c[d]=+c[d];a.convertedPrimitiveFields_[b]=!0}return c};
jspb.Message.getRepeatedBooleanField=function(a,b){var c=jspb.Message.getRepeatedField(a,b);a.convertedPrimitiveFields_||(a.convertedPrimitiveFields_={});if(!a.convertedPrimitiveFields_[b]){for(var d=0;d<c.length;d++)c[d]=!!c[d];a.convertedPrimitiveFields_[b]=!0}return c};
jspb.Message.bytesAsB64=function(a){if(null==a||goog.isString(a))return a;if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)return goog.crypt.base64.encodeByteArray(a);goog.asserts.fail("Cannot coerce to b64 string: "+goog.typeOf(a));return null};jspb.Message.bytesAsU8=function(a){if(null==a||a instanceof Uint8Array)return a;if(goog.isString(a))return goog.crypt.base64.decodeStringToUint8Array(a);goog.asserts.fail("Cannot coerce to Uint8Array: "+goog.typeOf(a));return null};
jspb.Message.bytesListAsB64=function(a){jspb.Message.assertConsistentTypes_(a);return!a.length||goog.isString(a[0])?a:goog.array.map(a,jspb.Message.bytesAsB64)};jspb.Message.bytesListAsU8=function(a){jspb.Message.assertConsistentTypes_(a);return!a.length||a[0]instanceof Uint8Array?a:goog.array.map(a,jspb.Message.bytesAsU8)};
jspb.Message.assertConsistentTypes_=function(a){if(goog.DEBUG&&a&&1<a.length){var b=goog.typeOf(a[0]);goog.array.forEach(a,function(a){goog.typeOf(a)!=b&&goog.asserts.fail("Inconsistent type in JSPB repeated field array. Got "+goog.typeOf(a)+" expected "+b)})}};jspb.Message.getFieldWithDefault=function(a,b,c){a=jspb.Message.getField(a,b);return null==a?c:a};jspb.Message.getBooleanFieldWithDefault=function(a,b,c){a=jspb.Message.getBooleanField(a,b);return null==a?c:a};
jspb.Message.getFloatingPointFieldWithDefault=function(a,b,c){a=jspb.Message.getOptionalFloatingPointField(a,b);return null==a?c:a};jspb.Message.getFieldProto3=jspb.Message.getFieldWithDefault;jspb.Message.getMapField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});if(b in a.wrappers_)return a.wrappers_[b];var e=jspb.Message.getField(a,b);if(!e){if(c)return;e=[];jspb.Message.setField(a,b,e)}return a.wrappers_[b]=new jspb.Map(e,d)};
jspb.Message.setField=function(a,b,c){b<a.pivot_?a.array[jspb.Message.getIndex_(a,b)]=c:(jspb.Message.maybeInitEmptyExtensionObject_(a),a.extensionObject_[b]=c)};jspb.Message.setProto3IntField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3FloatField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3BooleanField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,!1)};
jspb.Message.setProto3StringField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"")};jspb.Message.setProto3BytesField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"")};jspb.Message.setProto3EnumField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3StringIntField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"0")};
jspb.Message.setFieldIgnoringDefault_=function(a,b,c,d){c!==d?jspb.Message.setField(a,b,c):a.array[jspb.Message.getIndex_(a,b)]=null};jspb.Message.addToRepeatedField=function(a,b,c,d){a=jspb.Message.getRepeatedField(a,b);void 0!=d?a.splice(d,0,c):a.push(c)};jspb.Message.setOneofField=function(a,b,c,d){(c=jspb.Message.computeOneofCase(a,c))&&c!==b&&void 0!==d&&(a.wrappers_&&c in a.wrappers_&&(a.wrappers_[c]=void 0),jspb.Message.setField(a,c,void 0));jspb.Message.setField(a,b,d)};
jspb.Message.computeOneofCase=function(a,b){for(var c,d,e=0;e<b.length;e++){var f=b[e],g=jspb.Message.getField(a,f);null!=g&&(c=f,d=g,jspb.Message.setField(a,f,void 0))}return c?(jspb.Message.setField(a,c,d),c):0};jspb.Message.getWrapperField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});if(!a.wrappers_[c]){var e=jspb.Message.getField(a,c);if(d||e)a.wrappers_[c]=new b(e)}return a.wrappers_[c]};
jspb.Message.getRepeatedWrapperField=function(a,b,c){jspb.Message.wrapRepeatedField_(a,b,c);b=a.wrappers_[c];b==jspb.Message.EMPTY_LIST_SENTINEL_&&(b=a.wrappers_[c]=[]);return b};jspb.Message.wrapRepeatedField_=function(a,b,c){a.wrappers_||(a.wrappers_={});if(!a.wrappers_[c]){for(var d=jspb.Message.getRepeatedField(a,c),e=[],f=0;f<d.length;f++)e[f]=new b(d[f]);a.wrappers_[c]=e}};
jspb.Message.setWrapperField=function(a,b,c){a.wrappers_||(a.wrappers_={});var d=c?c.toArray():c;a.wrappers_[b]=c;jspb.Message.setField(a,b,d)};jspb.Message.setOneofWrapperField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});var e=d?d.toArray():d;a.wrappers_[b]=d;jspb.Message.setOneofField(a,b,c,e)};jspb.Message.setRepeatedWrapperField=function(a,b,c){a.wrappers_||(a.wrappers_={});c=c||[];for(var d=[],e=0;e<c.length;e++)d[e]=c[e].toArray();a.wrappers_[b]=c;jspb.Message.setField(a,b,d)};
jspb.Message.addToRepeatedWrapperField=function(a,b,c,d,e){jspb.Message.wrapRepeatedField_(a,d,b);var f=a.wrappers_[b];f||(f=a.wrappers_[b]=[]);c=c?c:new d;a=jspb.Message.getRepeatedField(a,b);void 0!=e?(f.splice(e,0,c),a.splice(e,0,c.toArray())):(f.push(c),a.push(c.toArray()));return c};jspb.Message.toMap=function(a,b,c,d){for(var e={},f=0;f<a.length;f++)e[b.call(a[f])]=c?c.call(a[f],d,a[f]):a[f];return e};
jspb.Message.prototype.syncMapFields_=function(){if(this.wrappers_)for(var a in this.wrappers_){var b=this.wrappers_[a];if(goog.isArray(b))for(var c=0;c<b.length;c++)b[c]&&b[c].toArray();else b&&b.toArray()}};jspb.Message.prototype.toArray=function(){this.syncMapFields_();return this.array};jspb.Message.GENERATE_TO_STRING&&(jspb.Message.prototype.toString=function(){this.syncMapFields_();return this.array.toString()});
jspb.Message.prototype.getExtension=function(a){if(this.extensionObject_){this.wrappers_||(this.wrappers_={});var b=a.fieldIndex;if(a.isRepeated){if(a.isMessageType())return this.wrappers_[b]||(this.wrappers_[b]=goog.array.map(this.extensionObject_[b]||[],function(b){return new a.ctor(b)})),this.wrappers_[b]}else if(a.isMessageType())return!this.wrappers_[b]&&this.extensionObject_[b]&&(this.wrappers_[b]=new a.ctor(this.extensionObject_[b])),this.wrappers_[b];return this.extensionObject_[b]}};
jspb.Message.prototype.setExtension=function(a,b){this.wrappers_||(this.wrappers_={});jspb.Message.maybeInitEmptyExtensionObject_(this);var c=a.fieldIndex;a.isRepeated?(b=b||[],a.isMessageType()?(this.wrappers_[c]=b,this.extensionObject_[c]=goog.array.map(b,function(a){return a.toArray()})):this.extensionObject_[c]=b):a.isMessageType()?(this.wrappers_[c]=b,this.extensionObject_[c]=b?b.toArray():b):this.extensionObject_[c]=b;return this};
jspb.Message.difference=function(a,b){if(!(a instanceof b.constructor))throw Error("Messages have different types.");var c=a.toArray();b=b.toArray();var d=[],e=0,f=c.length>b.length?c.length:b.length;a.getJsPbMessageId()&&(d[0]=a.getJsPbMessageId(),e=1);for(;e<f;e++)jspb.Message.compareFields(c[e],b[e])||(d[e]=b[e]);return new a.constructor(d)};jspb.Message.equals=function(a,b){return a==b||!(!a||!b)&&a instanceof b.constructor&&jspb.Message.compareFields(a.toArray(),b.toArray())};
jspb.Message.compareExtensions=function(a,b){a=a||{};b=b||{};var c={},d;for(d in a)c[d]=0;for(d in b)c[d]=0;for(d in c)if(!jspb.Message.compareFields(a[d],b[d]))return!1;return!0};
jspb.Message.compareFields=function(a,b){if(a==b)return!0;if(!goog.isObject(a)||!goog.isObject(b))return goog.isNumber(a)&&isNaN(a)||goog.isNumber(b)&&isNaN(b)?String(a)==String(b):!1;if(a.constructor!=b.constructor)return!1;if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a.constructor===Uint8Array){if(a.length!=b.length)return!1;for(var c=0;c<a.length;c++)if(a[c]!=b[c])return!1;return!0}if(a.constructor===Array){var d=void 0,e=void 0,f=Math.max(a.length,b.length);for(c=0;c<f;c++){var g=a[c],h=b[c];g&&g.constructor==
Object&&(goog.asserts.assert(void 0===d),goog.asserts.assert(c===a.length-1),d=g,g=void 0);h&&h.constructor==Object&&(goog.asserts.assert(void 0===e),goog.asserts.assert(c===b.length-1),e=h,h=void 0);if(!jspb.Message.compareFields(g,h))return!1}return d||e?(d=d||{},e=e||{},jspb.Message.compareExtensions(d,e)):!0}if(a.constructor===Object)return jspb.Message.compareExtensions(a,b);throw Error("Invalid type in JSPB array");};jspb.Message.prototype.cloneMessage=function(){return jspb.Message.cloneMessage(this)};
jspb.Message.prototype.clone=function(){return jspb.Message.cloneMessage(this)};jspb.Message.clone=function(a){return jspb.Message.cloneMessage(a)};jspb.Message.cloneMessage=function(a){return new a.constructor(jspb.Message.clone_(a.toArray()))};
jspb.Message.copyInto=function(a,b){goog.asserts.assertInstanceof(a,jspb.Message);goog.asserts.assertInstanceof(b,jspb.Message);goog.asserts.assert(a.constructor==b.constructor,"Copy source and target message should have the same type.");a=jspb.Message.clone(a);for(var c=b.toArray(),d=a.toArray(),e=c.length=0;e<d.length;e++)c[e]=d[e];b.wrappers_=a.wrappers_;b.extensionObject_=a.extensionObject_};
jspb.Message.clone_=function(a){if(goog.isArray(a)){for(var b=Array(a.length),c=0;c<a.length;c++){var d=a[c];null!=d&&(b[c]="object"==typeof d?jspb.Message.clone_(goog.asserts.assert(d)):d)}return b}if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)return new Uint8Array(a);b={};for(c in a)d=a[c],null!=d&&(b[c]="object"==typeof d?jspb.Message.clone_(goog.asserts.assert(d)):d);return b};jspb.Message.registerMessageType=function(a,b){jspb.Message.registry_[a]=b;b.messageId=a};
jspb.Message.registry_={};jspb.Message.messageSetExtensions={};jspb.Message.messageSetExtensionsBinary={};jspb.arith={};jspb.arith.UInt64=function(a,b){this.lo=a;this.hi=b};jspb.arith.UInt64.prototype.cmp=function(a){return this.hi<a.hi||this.hi==a.hi&&this.lo<a.lo?-1:this.hi==a.hi&&this.lo==a.lo?0:1};jspb.arith.UInt64.prototype.rightShift=function(){return new jspb.arith.UInt64((this.lo>>>1|(this.hi&1)<<31)>>>0,this.hi>>>1>>>0)};jspb.arith.UInt64.prototype.leftShift=function(){return new jspb.arith.UInt64(this.lo<<1>>>0,(this.hi<<1|this.lo>>>31)>>>0)};
jspb.arith.UInt64.prototype.msb=function(){return!!(this.hi&2147483648)};jspb.arith.UInt64.prototype.lsb=function(){return!!(this.lo&1)};jspb.arith.UInt64.prototype.zero=function(){return 0==this.lo&&0==this.hi};jspb.arith.UInt64.prototype.add=function(a){return new jspb.arith.UInt64((this.lo+a.lo&4294967295)>>>0>>>0,((this.hi+a.hi&4294967295)>>>0)+(4294967296<=this.lo+a.lo?1:0)>>>0)};
jspb.arith.UInt64.prototype.sub=function(a){return new jspb.arith.UInt64((this.lo-a.lo&4294967295)>>>0>>>0,((this.hi-a.hi&4294967295)>>>0)-(0>this.lo-a.lo?1:0)>>>0)};jspb.arith.UInt64.mul32x32=function(a,b){var c=a&65535;a>>>=16;var d=b&65535,e=b>>>16;b=c*d+65536*(c*e&65535)+65536*(a*d&65535);for(c=a*e+(c*e>>>16)+(a*d>>>16);4294967296<=b;)b-=4294967296,c+=1;return new jspb.arith.UInt64(b>>>0,c>>>0)};
jspb.arith.UInt64.prototype.mul=function(a){var b=jspb.arith.UInt64.mul32x32(this.lo,a);a=jspb.arith.UInt64.mul32x32(this.hi,a);a.hi=a.lo;a.lo=0;return b.add(a)};
jspb.arith.UInt64.prototype.div=function(a){if(0==a)return[];var b=new jspb.arith.UInt64(0,0),c=new jspb.arith.UInt64(this.lo,this.hi);a=new jspb.arith.UInt64(a,0);for(var d=new jspb.arith.UInt64(1,0);!a.msb();)a=a.leftShift(),d=d.leftShift();for(;!d.zero();)0>=a.cmp(c)&&(b=b.add(d),c=c.sub(a)),a=a.rightShift(),d=d.rightShift();return[b,c]};jspb.arith.UInt64.prototype.toString=function(){for(var a="",b=this;!b.zero();){b=b.div(10);var c=b[0];a=b[1].lo+a;b=c}""==a&&(a="0");return a};
jspb.arith.UInt64.fromString=function(a){for(var b=new jspb.arith.UInt64(0,0),c=new jspb.arith.UInt64(0,0),d=0;d<a.length;d++){if("0">a[d]||"9"<a[d])return null;var e=parseInt(a[d],10);c.lo=e;b=b.mul(10).add(c)}return b};jspb.arith.UInt64.prototype.clone=function(){return new jspb.arith.UInt64(this.lo,this.hi)};jspb.arith.Int64=function(a,b){this.lo=a;this.hi=b};
jspb.arith.Int64.prototype.add=function(a){return new jspb.arith.Int64((this.lo+a.lo&4294967295)>>>0>>>0,((this.hi+a.hi&4294967295)>>>0)+(4294967296<=this.lo+a.lo?1:0)>>>0)};jspb.arith.Int64.prototype.sub=function(a){return new jspb.arith.Int64((this.lo-a.lo&4294967295)>>>0>>>0,((this.hi-a.hi&4294967295)>>>0)-(0>this.lo-a.lo?1:0)>>>0)};jspb.arith.Int64.prototype.clone=function(){return new jspb.arith.Int64(this.lo,this.hi)};
jspb.arith.Int64.prototype.toString=function(){var a=0!=(this.hi&2147483648),b=new jspb.arith.UInt64(this.lo,this.hi);a&&(b=(new jspb.arith.UInt64(0,0)).sub(b));return(a?"-":"")+b.toString()};jspb.arith.Int64.fromString=function(a){var b=0<a.length&&"-"==a[0];b&&(a=a.substring(1));a=jspb.arith.UInt64.fromString(a);if(null===a)return null;b&&(a=(new jspb.arith.UInt64(0,0)).sub(a));return new jspb.arith.Int64(a.lo,a.hi)};jspb.BinaryEncoder=function(){this.buffer_=[]};jspb.BinaryEncoder.prototype.length=function(){return this.buffer_.length};jspb.BinaryEncoder.prototype.end=function(){var a=this.buffer_;this.buffer_=[];return a};
jspb.BinaryEncoder.prototype.writeSplitVarint64=function(a,b){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(b==Math.floor(b));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);for(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32);0<b||127<a;)this.buffer_.push(a&127|128),a=(a>>>7|b<<25)>>>0,b>>>=7;this.buffer_.push(a)};
jspb.BinaryEncoder.prototype.writeSplitFixed64=function(a,b){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(b==Math.floor(b));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32);this.writeUint32(a);this.writeUint32(b)};
jspb.BinaryEncoder.prototype.writeUnsignedVarint32=function(a){goog.asserts.assert(a==Math.floor(a));for(goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);127<a;)this.buffer_.push(a&127|128),a>>>=7;this.buffer_.push(a)};
jspb.BinaryEncoder.prototype.writeSignedVarint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);if(0<=a)this.writeUnsignedVarint32(a);else{for(var b=0;9>b;b++)this.buffer_.push(a&127|128),a>>=7;this.buffer_.push(1)}};
jspb.BinaryEncoder.prototype.writeUnsignedVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_64);jspb.utils.splitInt64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeSignedVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitInt64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeZigzagVarint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.writeUnsignedVarint32((a<<1^a>>31)>>>0)};jspb.BinaryEncoder.prototype.writeZigzagVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitZigzag64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeZigzagVarint64String=function(a){this.writeZigzagVarint64(parseInt(a,10))};jspb.BinaryEncoder.prototype.writeUint8=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&256>a);this.buffer_.push(a>>>0&255)};jspb.BinaryEncoder.prototype.writeUint16=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&65536>a);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255)};
jspb.BinaryEncoder.prototype.writeUint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255);this.buffer_.push(a>>>16&255);this.buffer_.push(a>>>24&255)};jspb.BinaryEncoder.prototype.writeUint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_64);jspb.utils.splitUint64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeInt8=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(-128<=a&&128>a);this.buffer_.push(a>>>0&255)};jspb.BinaryEncoder.prototype.writeInt16=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(-32768<=a&&32768>a);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255)};
jspb.BinaryEncoder.prototype.writeInt32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255);this.buffer_.push(a>>>16&255);this.buffer_.push(a>>>24&255)};
jspb.BinaryEncoder.prototype.writeInt64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitInt64(a);this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeInt64String=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(+a>=-jspb.BinaryConstants.TWO_TO_63&&+a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(a));this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)};jspb.BinaryEncoder.prototype.writeFloat=function(a){goog.asserts.assert(a>=-jspb.BinaryConstants.FLOAT32_MAX&&a<=jspb.BinaryConstants.FLOAT32_MAX);jspb.utils.splitFloat32(a);this.writeUint32(jspb.utils.split64Low)};
jspb.BinaryEncoder.prototype.writeDouble=function(a){goog.asserts.assert(a>=-jspb.BinaryConstants.FLOAT64_MAX&&a<=jspb.BinaryConstants.FLOAT64_MAX);jspb.utils.splitFloat64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};jspb.BinaryEncoder.prototype.writeBool=function(a){goog.asserts.assert(goog.isBoolean(a)||goog.isNumber(a));this.buffer_.push(a?1:0)};
jspb.BinaryEncoder.prototype.writeEnum=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.writeSignedVarint32(a)};jspb.BinaryEncoder.prototype.writeBytes=function(a){this.buffer_.push.apply(this.buffer_,a)};jspb.BinaryEncoder.prototype.writeVarintHash64=function(a){jspb.utils.splitHash64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeFixedHash64=function(a){jspb.utils.splitHash64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeString=function(a){for(var b=this.buffer_.length,c=0;c<a.length;c++){var d=a.charCodeAt(c);if(128>d)this.buffer_.push(d);else if(2048>d)this.buffer_.push(d>>6|192),this.buffer_.push(d&63|128);else if(65536>d)if(55296<=d&&56319>=d&&c+1<a.length){var e=a.charCodeAt(c+1);56320<=e&&57343>=e&&(d=1024*(d-55296)+e-56320+65536,this.buffer_.push(d>>18|240),this.buffer_.push(d>>12&63|128),this.buffer_.push(d>>6&63|128),this.buffer_.push(d&63|128),c++)}else this.buffer_.push(d>>
12|224),this.buffer_.push(d>>6&63|128),this.buffer_.push(d&63|128)}return this.buffer_.length-b};jspb.BinaryWriter=function(){this.blocks_=[];this.totalLength_=0;this.encoder_=new jspb.BinaryEncoder;this.bookmarks_=[]};jspb.BinaryWriter.prototype.appendUint8Array_=function(a){var b=this.encoder_.end();this.blocks_.push(b);this.blocks_.push(a);this.totalLength_+=b.length+a.length};
jspb.BinaryWriter.prototype.beginDelimited_=function(a){this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED);a=this.encoder_.end();this.blocks_.push(a);this.totalLength_+=a.length;a.push(this.totalLength_);return a};jspb.BinaryWriter.prototype.endDelimited_=function(a){var b=a.pop();b=this.totalLength_+this.encoder_.length()-b;for(goog.asserts.assert(0<=b);127<b;)a.push(b&127|128),b>>>=7,this.totalLength_++;a.push(b);this.totalLength_++};
jspb.BinaryWriter.prototype.writeSerializedMessage=function(a,b,c){this.appendUint8Array_(a.subarray(b,c))};jspb.BinaryWriter.prototype.maybeWriteSerializedMessage=function(a,b,c){null!=a&&null!=b&&null!=c&&this.writeSerializedMessage(a,b,c)};jspb.BinaryWriter.prototype.reset=function(){this.blocks_=[];this.encoder_.end();this.totalLength_=0;this.bookmarks_=[]};
jspb.BinaryWriter.prototype.getResultBuffer=function(){goog.asserts.assert(0==this.bookmarks_.length);for(var a=new Uint8Array(this.totalLength_+this.encoder_.length()),b=this.blocks_,c=b.length,d=0,e=0;e<c;e++){var f=b[e];a.set(f,d);d+=f.length}b=this.encoder_.end();a.set(b,d);d+=b.length;goog.asserts.assert(d==a.length);this.blocks_=[a];return a};jspb.BinaryWriter.prototype.getResultBase64String=function(a){return goog.crypt.base64.encodeByteArray(this.getResultBuffer(),a)};
jspb.BinaryWriter.prototype.beginSubMessage=function(a){this.bookmarks_.push(this.beginDelimited_(a))};jspb.BinaryWriter.prototype.endSubMessage=function(){goog.asserts.assert(0<=this.bookmarks_.length);this.endDelimited_(this.bookmarks_.pop())};jspb.BinaryWriter.prototype.writeFieldHeader_=function(a,b){goog.asserts.assert(1<=a&&a==Math.floor(a));this.encoder_.writeUnsignedVarint32(8*a+b)};
jspb.BinaryWriter.prototype.writeAny=function(a,b,c){var d=jspb.BinaryConstants.FieldType;switch(a){case d.DOUBLE:this.writeDouble(b,c);break;case d.FLOAT:this.writeFloat(b,c);break;case d.INT64:this.writeInt64(b,c);break;case d.UINT64:this.writeUint64(b,c);break;case d.INT32:this.writeInt32(b,c);break;case d.FIXED64:this.writeFixed64(b,c);break;case d.FIXED32:this.writeFixed32(b,c);break;case d.BOOL:this.writeBool(b,c);break;case d.STRING:this.writeString(b,c);break;case d.GROUP:goog.asserts.fail("Group field type not supported in writeAny()");
break;case d.MESSAGE:goog.asserts.fail("Message field type not supported in writeAny()");break;case d.BYTES:this.writeBytes(b,c);break;case d.UINT32:this.writeUint32(b,c);break;case d.ENUM:this.writeEnum(b,c);break;case d.SFIXED32:this.writeSfixed32(b,c);break;case d.SFIXED64:this.writeSfixed64(b,c);break;case d.SINT32:this.writeSint32(b,c);break;case d.SINT64:this.writeSint64(b,c);break;case d.FHASH64:this.writeFixedHash64(b,c);break;case d.VHASH64:this.writeVarintHash64(b,c);break;default:goog.asserts.fail("Invalid field type in writeAny()")}};
jspb.BinaryWriter.prototype.writeUnsignedVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint32(b))};jspb.BinaryWriter.prototype.writeSignedVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(b))};jspb.BinaryWriter.prototype.writeUnsignedVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint64(b))};
jspb.BinaryWriter.prototype.writeSignedVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint64(b))};jspb.BinaryWriter.prototype.writeZigzagVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint32(b))};jspb.BinaryWriter.prototype.writeZigzagVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64(b))};
jspb.BinaryWriter.prototype.writeZigzagVarint64String_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64String(b))};jspb.BinaryWriter.prototype.writeInt32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeInt32String=function(a,b){null!=b&&(b=parseInt(b,10),goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(a,b))};jspb.BinaryWriter.prototype.writeInt64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeSignedVarint64_(a,b))};
jspb.BinaryWriter.prototype.writeInt64String=function(a,b){null!=b&&(b=jspb.arith.Int64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeUint32=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeUint32String=function(a,b){null!=b&&(b=parseInt(b,10),goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(a,b))};jspb.BinaryWriter.prototype.writeUint64=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_64),this.writeUnsignedVarint64_(a,b))};
jspb.BinaryWriter.prototype.writeUint64String=function(a,b){null!=b&&(b=jspb.arith.UInt64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeSint32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeZigzagVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeSint64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeZigzagVarint64_(a,b))};jspb.BinaryWriter.prototype.writeSint64String=function(a,b){null!=b&&(goog.asserts.assert(+b>=-jspb.BinaryConstants.TWO_TO_63&&+b<jspb.BinaryConstants.TWO_TO_63),this.writeZigzagVarint64String_(a,b))};
jspb.BinaryWriter.prototype.writeFixed32=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeUint32(b))};jspb.BinaryWriter.prototype.writeFixed64=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_64),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeUint64(b))};
jspb.BinaryWriter.prototype.writeFixed64String=function(a,b){null!=b&&(b=jspb.arith.UInt64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeSfixed32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeInt32(b))};
jspb.BinaryWriter.prototype.writeSfixed64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeInt64(b))};jspb.BinaryWriter.prototype.writeSfixed64String=function(a,b){null!=b&&(b=jspb.arith.Int64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(b.lo,b.hi))};
jspb.BinaryWriter.prototype.writeFloat=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeFloat(b))};jspb.BinaryWriter.prototype.writeDouble=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeDouble(b))};jspb.BinaryWriter.prototype.writeBool=function(a,b){null!=b&&(goog.asserts.assert(goog.isBoolean(b)||goog.isNumber(b)),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeBool(b))};
jspb.BinaryWriter.prototype.writeEnum=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(b))};jspb.BinaryWriter.prototype.writeString=function(a,b){null!=b&&(a=this.beginDelimited_(a),this.encoder_.writeString(b),this.endDelimited_(a))};
jspb.BinaryWriter.prototype.writeBytes=function(a,b){null!=b&&(b=jspb.utils.byteSourceToUint8Array(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(b.length),this.appendUint8Array_(b))};jspb.BinaryWriter.prototype.writeMessage=function(a,b,c){null!=b&&(a=this.beginDelimited_(a),c(b,this),this.endDelimited_(a))};
jspb.BinaryWriter.prototype.writeMessageSet=function(a,b,c){null!=b&&(this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.START_GROUP),this.writeFieldHeader_(2,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(a),a=this.beginDelimited_(3),c(b,this),this.endDelimited_(a),this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.END_GROUP))};
jspb.BinaryWriter.prototype.writeGroup=function(a,b,c){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.START_GROUP),c(b,this),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.END_GROUP))};jspb.BinaryWriter.prototype.writeFixedHash64=function(a,b){null!=b&&(goog.asserts.assert(8==b.length),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeFixedHash64(b))};
jspb.BinaryWriter.prototype.writeVarintHash64=function(a,b){null!=b&&(goog.asserts.assert(8==b.length),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeVarintHash64(b))};jspb.BinaryWriter.prototype.writeRepeatedInt32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSignedVarint32_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedInt32String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeInt32String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedInt64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSignedVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedInt64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeInt64String(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUnsignedVarint32_(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedUint32String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUint32String(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUnsignedVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUint64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedSint32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint32_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSint64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSint64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint64String_(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedFixed32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed32(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedFixed64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed64(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedFixed64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedSfixed32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed32(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSfixed64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed64(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSfixed64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedFloat=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFloat(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedDouble=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeDouble(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedBool=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeBool(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedEnum=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeEnum(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedString=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeString(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedBytes=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeBytes(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedMessage=function(a,b,c){if(null!=b)for(var d=0;d<b.length;d++){var e=this.beginDelimited_(a);c(b[d],this);this.endDelimited_(e)}};
jspb.BinaryWriter.prototype.writeRepeatedGroup=function(a,b,c){if(null!=b)for(var d=0;d<b.length;d++)this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.START_GROUP),c(b[d],this),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.END_GROUP)};jspb.BinaryWriter.prototype.writeRepeatedFixedHash64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixedHash64(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedVarintHash64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeVarintHash64(a,b[c])};jspb.BinaryWriter.prototype.writePackedInt32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedInt32String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint32(parseInt(b[c],10));this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedInt64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint64(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedInt64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++){var d=jspb.arith.Int64.fromString(b[c]);this.encoder_.writeSplitVarint64(d.lo,d.hi)}this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedUint32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedUint32String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint32(parseInt(b[c],10));this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedUint64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint64(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedUint64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++){var d=jspb.arith.UInt64.fromString(b[c]);this.encoder_.writeSplitVarint64(d.lo,d.hi)}this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedSint32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedSint64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint64(b[c]);this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedSint64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint64(parseInt(b[c],10));this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedFixed32=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeUint32(b[a])};jspb.BinaryWriter.prototype.writePackedFixed64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeUint64(b[a])};
jspb.BinaryWriter.prototype.writePackedFixed64String=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++){var c=jspb.arith.UInt64.fromString(b[a]);this.encoder_.writeSplitFixed64(c.lo,c.hi)}};
jspb.BinaryWriter.prototype.writePackedSfixed32=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeInt32(b[a])};jspb.BinaryWriter.prototype.writePackedSfixed64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeInt64(b[a])};
jspb.BinaryWriter.prototype.writePackedSfixed64String=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeInt64String(b[a])};jspb.BinaryWriter.prototype.writePackedFloat=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeFloat(b[a])};
jspb.BinaryWriter.prototype.writePackedDouble=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeDouble(b[a])};jspb.BinaryWriter.prototype.writePackedBool=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(b.length),a=0;a<b.length;a++)this.encoder_.writeBool(b[a])};
jspb.BinaryWriter.prototype.writePackedEnum=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeEnum(b[c]);this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedFixedHash64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeFixedHash64(b[a])};
jspb.BinaryWriter.prototype.writePackedVarintHash64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeVarintHash64(b[c]);this.endDelimited_(a)}};jspb.Export={};exports.Map=jspb.Map;exports.Message=jspb.Message;exports.BinaryReader=jspb.BinaryReader;exports.BinaryWriter=jspb.BinaryWriter;exports.ExtensionFieldInfo=jspb.ExtensionFieldInfo;exports.ExtensionFieldBinaryInfo=jspb.ExtensionFieldBinaryInfo;exports.exportSymbol=goog.exportSymbol;exports.inherits=goog.inherits;exports.object={extend:goog.object.extend};exports.typeOf=goog.typeOf;


/***/ }),

/***/ "grpc":
/*!***********************!*\
  !*** external "grpc" ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("grpc");

/***/ }),

/***/ "playwright":
/*!*****************************!*\
  !*** external "playwright" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("playwright");

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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