# Copyright 2021 The QHBM Library Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Defines the qhbmlib.inference package."""

from qhbmlib.inference.ebm import AnalyticEnergyInference
from qhbmlib.inference.ebm import BernoulliEnergyInference
from qhbmlib.inference.ebm import EnergyInference
from qhbmlib.inference.ebm import EnergyInferenceBase
from qhbmlib.inference.ebm import GibbsWithGradientsInference
from qhbmlib.inference.ebm_utils import probabilities
from qhbmlib.inference.qhbm import QHBM
from qhbmlib.inference.qhbm_utils import density_matrix
from qhbmlib.inference.qhbm_utils import fidelity
from qhbmlib.inference.qmhl_loss import qmhl
from qhbmlib.inference.qnn import QuantumInference
from qhbmlib.inference.qnn_utils import unitary
from qhbmlib.inference.vqt_loss import vqt

__all__ = [
    "AnalyticEnergyInference",
    "BernoulliEnergyInference",
    "density_matrix",
    "EnergyInference",
    "EnergyInferenceBase",
    "fidelity",
    "GibbsWithGradientsInference",
    "probabilities",
    "QHBM",
    "qmhl",
    "QuantumInference",
    "unitary",
    "vqt",
]
