# CRIPT Python SDK

![CRIPT Logo](/CRIPT_full_logo_colored_transparent.png)

[![License](https://img.shields.io/github/license/C-Accel-CRIPT/cript?style=flat-square)](https://github.com/C-Accel-CRIPT/cript/blob/master/LICENSE.txt)
[![Python](https://img.shields.io/badge/Language-Python%203.9+-blue?style=flat-square&logo=python)](https://www.python.org/)
[![Code style is black](https://img.shields.io/badge/Code%20Style-black-000000.svg?style=flat-square&logo=python)](https://github.com/psf/black)
[![Link to CRIPT website](https://img.shields.io/badge/platform-criptapp.org-blueviolet?style=flat-square)](https://criptapp.org/)
[![CRIPT Blog Link](https://img.shields.io/badge/Blog-blog.criptapp.org-blueviolet?style=flat-square)](https://blog.criptapp.org)
[![Material MkDocs](https://img.shields.io/badge/Docs-mkdocs--material-blueviolet?style=flat-square&logo=markdown)](https://squidfunk.github.io/mkdocs-material/)

## What is it?

The CRIPT Python SDK allows programmatic access to the [CRIPT platform](https://criptapp.org). It can help automate uploading your data to CRIPT, and aims to allow for manipulation of your CRIPT data through the python language. This is a perfect tool to use when you have some experience with python and have large amount of data to upload to [CRIPT](https://criptapp.org).

---

## Installation

CRIPT Python SDK requires Python 3.9+

The latest released of CRIPT Python SDK is available on [Python Package Index (PyPI)](https://pypi.org/project/cript/)

```bash
pip install cript
```

---

## Documentation

To learn more about the CRIPT Python SDK please check the [CRIPT-SDK documentation](https://c-accel-cript.github.io/cript/)

---

## Release Notes

For updates and release notes please visit the [CRIPT blog](https://blog.criptapp.org)

### Software development

You are welcome to contribute code via PR to this repository.
For the developmet, we are using [trunk.io](https://trunk.io) to achieve a consistent coding style.
You can run `./trunk fmt` to auto-format your contributions and `./trunk check` to verify your contribution complies with our standard via trunk.
We will run the same test automatically before we are able to merge the code.
Please, let us know if there are any issues.
