<a id="mypy-boto3-proton"></a>

# mypy-boto3-proton

[![PyPI - mypy-boto3-proton](https://img.shields.io/pypi/v/mypy-boto3-proton.svg?color=blue)](https://pypi.org/project/mypy-boto3-proton)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-proton.svg?color=blue)](https://pypi.org/project/mypy-boto3-proton)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-proton?color=blue)](https://pypistats.org/packages/mypy-boto3-proton)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Proton 1.17.112](https://boto3.amazonaws.com/v1/documentation/api/1.17.112/reference/services/proton.html#Proton)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-proton docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_proton/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-proton](#mypy-boto3-proton)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Proton` service.

```bash
python -m pip install boto3-stubs[proton]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[proton]` in your environment:
  `python -m pip install 'boto3-stubs[proton]'`

Both type checking and auto-complete should work for `Proton` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[proton]` in your environment:
  `python -m pip install 'boto3-stubs[proton]'`

Both type checking and auto-complete should work for `Proton` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[proton]` in your environment:
  `python -m pip install 'boto3-stubs[proton]'`
- Run `mypy` as usual

Type checking should work for `Proton` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[proton]` in your environment:
  `python -m pip install 'boto3-stubs[proton]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Proton` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ProtonClient` provides annotations for `boto3.client("proton")`.

```python
import boto3

from mypy_boto3_proton import ProtonClient

client: ProtonClient = boto3.client("proton")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ProtonClient = session.client("proton")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_proton.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_proton import ProtonClient
from mypy_boto3_proton.paginator import (
    ListEnvironmentAccountConnectionsPaginator,
    ListEnvironmentTemplateVersionsPaginator,
    ListEnvironmentTemplatesPaginator,
    ListEnvironmentsPaginator,
    ListServiceInstancesPaginator,
    ListServiceTemplateVersionsPaginator,
    ListServiceTemplatesPaginator,
    ListServicesPaginator,
    ListTagsForResourcePaginator,
)

client: ProtonClient = boto3.client("proton")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_environment_account_connections_paginator: ListEnvironmentAccountConnectionsPaginator = client.get_paginator("list_environment_account_connections")
list_environment_template_versions_paginator: ListEnvironmentTemplateVersionsPaginator = client.get_paginator("list_environment_template_versions")
list_environment_templates_paginator: ListEnvironmentTemplatesPaginator = client.get_paginator("list_environment_templates")
list_environments_paginator: ListEnvironmentsPaginator = client.get_paginator("list_environments")
list_service_instances_paginator: ListServiceInstancesPaginator = client.get_paginator("list_service_instances")
list_service_template_versions_paginator: ListServiceTemplateVersionsPaginator = client.get_paginator("list_service_template_versions")
list_service_templates_paginator: ListServiceTemplatesPaginator = client.get_paginator("list_service_templates")
list_services_paginator: ListServicesPaginator = client.get_paginator("list_services")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_proton.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_proton import ProtonClient
from mypy_boto3_proton.waiter import (
    EnvironmentDeployedWaiter,
    EnvironmentTemplateVersionRegisteredWaiter,
    ServiceCreatedWaiter,
    ServiceDeletedWaiter,
    ServiceInstanceDeployedWaiter,
    ServicePipelineDeployedWaiter,
    ServiceTemplateVersionRegisteredWaiter,
    ServiceUpdatedWaiter,
)

client: ProtonClient = boto3.client("proton")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
environment_deployed_waiter: EnvironmentDeployedWaiter = client.get_waiter("environment_deployed")
environment_template_version_registered_waiter: EnvironmentTemplateVersionRegisteredWaiter = client.get_waiter("environment_template_version_registered")
service_created_waiter: ServiceCreatedWaiter = client.get_waiter("service_created")
service_deleted_waiter: ServiceDeletedWaiter = client.get_waiter("service_deleted")
service_instance_deployed_waiter: ServiceInstanceDeployedWaiter = client.get_waiter("service_instance_deployed")
service_pipeline_deployed_waiter: ServicePipelineDeployedWaiter = client.get_waiter("service_pipeline_deployed")
service_template_version_registered_waiter: ServiceTemplateVersionRegisteredWaiter = client.get_waiter("service_template_version_registered")
service_updated_waiter: ServiceUpdatedWaiter = client.get_waiter("service_updated")
```

<a id="literals"></a>

### Literals

`mypy_boto3_proton.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_proton.literals import (
    DeploymentStatusType,
    DeploymentUpdateTypeType,
    EnvironmentAccountConnectionRequesterAccountTypeType,
    EnvironmentAccountConnectionStatusType,
    EnvironmentDeployedWaiterName,
    EnvironmentTemplateVersionRegisteredWaiterName,
    ListEnvironmentAccountConnectionsPaginatorName,
    ListEnvironmentTemplateVersionsPaginatorName,
    ListEnvironmentTemplatesPaginatorName,
    ListEnvironmentsPaginatorName,
    ListServiceInstancesPaginatorName,
    ListServiceTemplateVersionsPaginatorName,
    ListServiceTemplatesPaginatorName,
    ListServicesPaginatorName,
    ListTagsForResourcePaginatorName,
    ProvisioningType,
    ServiceCreatedWaiterName,
    ServiceDeletedWaiterName,
    ServiceInstanceDeployedWaiterName,
    ServicePipelineDeployedWaiterName,
    ServiceStatusType,
    ServiceTemplateVersionRegisteredWaiterName,
    ServiceUpdatedWaiterName,
    TemplateVersionStatusType,
)

def check_value(value: DeploymentStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_proton.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_proton.type_defs import (
    AcceptEnvironmentAccountConnectionInputRequestTypeDef,
    AcceptEnvironmentAccountConnectionOutputTypeDef,
    AccountSettingsTypeDef,
    CancelEnvironmentDeploymentInputRequestTypeDef,
    CancelEnvironmentDeploymentOutputTypeDef,
    CancelServiceInstanceDeploymentInputRequestTypeDef,
    CancelServiceInstanceDeploymentOutputTypeDef,
    CancelServicePipelineDeploymentInputRequestTypeDef,
    CancelServicePipelineDeploymentOutputTypeDef,
    CompatibleEnvironmentTemplateInputTypeDef,
    CompatibleEnvironmentTemplateTypeDef,
    CreateEnvironmentAccountConnectionInputRequestTypeDef,
    CreateEnvironmentAccountConnectionOutputTypeDef,
    CreateEnvironmentInputRequestTypeDef,
    CreateEnvironmentOutputTypeDef,
    CreateEnvironmentTemplateInputRequestTypeDef,
    CreateEnvironmentTemplateOutputTypeDef,
    CreateEnvironmentTemplateVersionInputRequestTypeDef,
    CreateEnvironmentTemplateVersionOutputTypeDef,
    CreateServiceInputRequestTypeDef,
    CreateServiceOutputTypeDef,
    CreateServiceTemplateInputRequestTypeDef,
    CreateServiceTemplateOutputTypeDef,
    CreateServiceTemplateVersionInputRequestTypeDef,
    CreateServiceTemplateVersionOutputTypeDef,
    DeleteEnvironmentAccountConnectionInputRequestTypeDef,
    DeleteEnvironmentAccountConnectionOutputTypeDef,
    DeleteEnvironmentInputRequestTypeDef,
    DeleteEnvironmentOutputTypeDef,
    DeleteEnvironmentTemplateInputRequestTypeDef,
    DeleteEnvironmentTemplateOutputTypeDef,
    DeleteEnvironmentTemplateVersionInputRequestTypeDef,
    DeleteEnvironmentTemplateVersionOutputTypeDef,
    DeleteServiceInputRequestTypeDef,
    DeleteServiceOutputTypeDef,
    DeleteServiceTemplateInputRequestTypeDef,
    DeleteServiceTemplateOutputTypeDef,
    DeleteServiceTemplateVersionInputRequestTypeDef,
    DeleteServiceTemplateVersionOutputTypeDef,
    EnvironmentAccountConnectionSummaryTypeDef,
    EnvironmentAccountConnectionTypeDef,
    EnvironmentSummaryTypeDef,
    EnvironmentTemplateFilterTypeDef,
    EnvironmentTemplateSummaryTypeDef,
    EnvironmentTemplateTypeDef,
    EnvironmentTemplateVersionSummaryTypeDef,
    EnvironmentTemplateVersionTypeDef,
    EnvironmentTypeDef,
    GetAccountSettingsOutputTypeDef,
    GetEnvironmentAccountConnectionInputRequestTypeDef,
    GetEnvironmentAccountConnectionOutputTypeDef,
    GetEnvironmentInputRequestTypeDef,
    GetEnvironmentOutputTypeDef,
    GetEnvironmentTemplateInputRequestTypeDef,
    GetEnvironmentTemplateOutputTypeDef,
    GetEnvironmentTemplateVersionInputRequestTypeDef,
    GetEnvironmentTemplateVersionOutputTypeDef,
    GetServiceInputRequestTypeDef,
    GetServiceInstanceInputRequestTypeDef,
    GetServiceInstanceOutputTypeDef,
    GetServiceOutputTypeDef,
    GetServiceTemplateInputRequestTypeDef,
    GetServiceTemplateOutputTypeDef,
    GetServiceTemplateVersionInputRequestTypeDef,
    GetServiceTemplateVersionOutputTypeDef,
    ListEnvironmentAccountConnectionsInputRequestTypeDef,
    ListEnvironmentAccountConnectionsOutputTypeDef,
    ListEnvironmentTemplateVersionsInputRequestTypeDef,
    ListEnvironmentTemplateVersionsOutputTypeDef,
    ListEnvironmentTemplatesInputRequestTypeDef,
    ListEnvironmentTemplatesOutputTypeDef,
    ListEnvironmentsInputRequestTypeDef,
    ListEnvironmentsOutputTypeDef,
    ListServiceInstancesInputRequestTypeDef,
    ListServiceInstancesOutputTypeDef,
    ListServiceTemplateVersionsInputRequestTypeDef,
    ListServiceTemplateVersionsOutputTypeDef,
    ListServiceTemplatesInputRequestTypeDef,
    ListServiceTemplatesOutputTypeDef,
    ListServicesInputRequestTypeDef,
    ListServicesOutputTypeDef,
    ListTagsForResourceInputRequestTypeDef,
    ListTagsForResourceOutputTypeDef,
    PaginatorConfigTypeDef,
    RejectEnvironmentAccountConnectionInputRequestTypeDef,
    RejectEnvironmentAccountConnectionOutputTypeDef,
    ResponseMetadataTypeDef,
    S3ObjectSourceTypeDef,
    ServiceInstanceSummaryTypeDef,
    ServiceInstanceTypeDef,
    ServicePipelineTypeDef,
    ServiceSummaryTypeDef,
    ServiceTemplateSummaryTypeDef,
    ServiceTemplateTypeDef,
    ServiceTemplateVersionSummaryTypeDef,
    ServiceTemplateVersionTypeDef,
    ServiceTypeDef,
    TagResourceInputRequestTypeDef,
    TagTypeDef,
    TemplateVersionSourceInputTypeDef,
    UntagResourceInputRequestTypeDef,
    UpdateAccountSettingsInputRequestTypeDef,
    UpdateAccountSettingsOutputTypeDef,
    UpdateEnvironmentAccountConnectionInputRequestTypeDef,
    UpdateEnvironmentAccountConnectionOutputTypeDef,
    UpdateEnvironmentInputRequestTypeDef,
    UpdateEnvironmentOutputTypeDef,
    UpdateEnvironmentTemplateInputRequestTypeDef,
    UpdateEnvironmentTemplateOutputTypeDef,
    UpdateEnvironmentTemplateVersionInputRequestTypeDef,
    UpdateEnvironmentTemplateVersionOutputTypeDef,
    UpdateServiceInputRequestTypeDef,
    UpdateServiceInstanceInputRequestTypeDef,
    UpdateServiceInstanceOutputTypeDef,
    UpdateServiceOutputTypeDef,
    UpdateServicePipelineInputRequestTypeDef,
    UpdateServicePipelineOutputTypeDef,
    UpdateServiceTemplateInputRequestTypeDef,
    UpdateServiceTemplateOutputTypeDef,
    UpdateServiceTemplateVersionInputRequestTypeDef,
    UpdateServiceTemplateVersionOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AcceptEnvironmentAccountConnectionInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-proton` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-proton docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_proton/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
