# coding: utf-8

"""
    FINBOURNE Workflows API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.1.38
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid_workflows.configuration import Configuration


class WorkflowInstance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'workflow_code': 'str',
        'workflow_version': 'int',
        'workflow_instance_id': 'str',
        'correlation_id': 'str',
        'state': 'str',
        'execution_status': 'str',
        'next_activity': 'str',
        'allowed_actions': 'list[str]',
        'started_at': 'datetime',
        'finished_at': 'datetime',
        'last_step_executed_at': 'datetime',
        'execution_context': 'dict(str, object)',
        'activity_history': 'list[WorkflowActivitySummary]',
        'execution_info': 'str'
    }

    attribute_map = {
        'workflow_code': 'workflowCode',
        'workflow_version': 'workflowVersion',
        'workflow_instance_id': 'workflowInstanceId',
        'correlation_id': 'correlationId',
        'state': 'state',
        'execution_status': 'executionStatus',
        'next_activity': 'nextActivity',
        'allowed_actions': 'allowedActions',
        'started_at': 'startedAt',
        'finished_at': 'finishedAt',
        'last_step_executed_at': 'lastStepExecutedAt',
        'execution_context': 'executionContext',
        'activity_history': 'activityHistory',
        'execution_info': 'executionInfo'
    }

    required_map = {
        'workflow_code': 'optional',
        'workflow_version': 'optional',
        'workflow_instance_id': 'optional',
        'correlation_id': 'optional',
        'state': 'optional',
        'execution_status': 'optional',
        'next_activity': 'optional',
        'allowed_actions': 'optional',
        'started_at': 'optional',
        'finished_at': 'optional',
        'last_step_executed_at': 'optional',
        'execution_context': 'optional',
        'activity_history': 'optional',
        'execution_info': 'optional'
    }

    def __init__(self, workflow_code=None, workflow_version=None, workflow_instance_id=None, correlation_id=None, state=None, execution_status=None, next_activity=None, allowed_actions=None, started_at=None, finished_at=None, last_step_executed_at=None, execution_context=None, activity_history=None, execution_info=None, local_vars_configuration=None):  # noqa: E501
        """WorkflowInstance - a model defined in OpenAPI"
        
        :param workflow_code:  Workflow Code
        :type workflow_code: str
        :param workflow_version:  Workflow definition version. When this version changes any new instance of the workflow will have the updated version number whereas  version number on existing instances will remain the same.
        :type workflow_version: int
        :param workflow_instance_id:  Workflow Instance Id which is system generated
        :type workflow_instance_id: str
        :param correlation_id:  Id of any external entity associated with the workflow instance, otherwise system generated id
        :type correlation_id: str
        :param state:  Any info about the workflow state, i.e. transition between activities
        :type state: str
        :param execution_status:  Workflow execution status
        :type execution_status: str
        :param next_activity:  Name of the next step/activity in the workflow. Empty if the workflow has already finished execution.
        :type next_activity: str
        :param allowed_actions:  Allowed actions if next activity in the workflow requires manual action, otherwise empty.
        :type allowed_actions: list[str]
        :param started_at:  Execution started at timestamp
        :type started_at: datetime
        :param finished_at:  Execution finished at timestamp. Null if the workflow isn't finished.
        :type finished_at: datetime
        :param last_step_executed_at:  Timestamp at which last activity/step in the workflow was executed. Null if the workflow is Idle.
        :type last_step_executed_at: datetime
        :param execution_context:  Data associated with a particular instance of the workflow.
        :type execution_context: dict(str, object)
        :param activity_history:  Summary of all executed activities in the workflow instance. The latest executed activity is at the top and traversal from top to bottom  would give us a history of state transition from latest state to initial.
        :type activity_history: list[lusid_workflows.WorkflowActivitySummary]
        :param execution_info:  Any info associated with the workflow execution. This would be an error message if ExecutionStatus is Faulted for example.
        :type execution_info: str

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._workflow_code = None
        self._workflow_version = None
        self._workflow_instance_id = None
        self._correlation_id = None
        self._state = None
        self._execution_status = None
        self._next_activity = None
        self._allowed_actions = None
        self._started_at = None
        self._finished_at = None
        self._last_step_executed_at = None
        self._execution_context = None
        self._activity_history = None
        self._execution_info = None
        self.discriminator = None

        self.workflow_code = workflow_code
        if workflow_version is not None:
            self.workflow_version = workflow_version
        self.workflow_instance_id = workflow_instance_id
        self.correlation_id = correlation_id
        self.state = state
        self.execution_status = execution_status
        self.next_activity = next_activity
        self.allowed_actions = allowed_actions
        if started_at is not None:
            self.started_at = started_at
        self.finished_at = finished_at
        self.last_step_executed_at = last_step_executed_at
        self.execution_context = execution_context
        self.activity_history = activity_history
        self.execution_info = execution_info

    @property
    def workflow_code(self):
        """Gets the workflow_code of this WorkflowInstance.  # noqa: E501

        Workflow Code  # noqa: E501

        :return: The workflow_code of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._workflow_code

    @workflow_code.setter
    def workflow_code(self, workflow_code):
        """Sets the workflow_code of this WorkflowInstance.

        Workflow Code  # noqa: E501

        :param workflow_code: The workflow_code of this WorkflowInstance.  # noqa: E501
        :type workflow_code: str
        """

        self._workflow_code = workflow_code

    @property
    def workflow_version(self):
        """Gets the workflow_version of this WorkflowInstance.  # noqa: E501

        Workflow definition version. When this version changes any new instance of the workflow will have the updated version number whereas  version number on existing instances will remain the same.  # noqa: E501

        :return: The workflow_version of this WorkflowInstance.  # noqa: E501
        :rtype: int
        """
        return self._workflow_version

    @workflow_version.setter
    def workflow_version(self, workflow_version):
        """Sets the workflow_version of this WorkflowInstance.

        Workflow definition version. When this version changes any new instance of the workflow will have the updated version number whereas  version number on existing instances will remain the same.  # noqa: E501

        :param workflow_version: The workflow_version of this WorkflowInstance.  # noqa: E501
        :type workflow_version: int
        """

        self._workflow_version = workflow_version

    @property
    def workflow_instance_id(self):
        """Gets the workflow_instance_id of this WorkflowInstance.  # noqa: E501

        Workflow Instance Id which is system generated  # noqa: E501

        :return: The workflow_instance_id of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._workflow_instance_id

    @workflow_instance_id.setter
    def workflow_instance_id(self, workflow_instance_id):
        """Sets the workflow_instance_id of this WorkflowInstance.

        Workflow Instance Id which is system generated  # noqa: E501

        :param workflow_instance_id: The workflow_instance_id of this WorkflowInstance.  # noqa: E501
        :type workflow_instance_id: str
        """

        self._workflow_instance_id = workflow_instance_id

    @property
    def correlation_id(self):
        """Gets the correlation_id of this WorkflowInstance.  # noqa: E501

        Id of any external entity associated with the workflow instance, otherwise system generated id  # noqa: E501

        :return: The correlation_id of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id):
        """Sets the correlation_id of this WorkflowInstance.

        Id of any external entity associated with the workflow instance, otherwise system generated id  # noqa: E501

        :param correlation_id: The correlation_id of this WorkflowInstance.  # noqa: E501
        :type correlation_id: str
        """

        self._correlation_id = correlation_id

    @property
    def state(self):
        """Gets the state of this WorkflowInstance.  # noqa: E501

        Any info about the workflow state, i.e. transition between activities  # noqa: E501

        :return: The state of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this WorkflowInstance.

        Any info about the workflow state, i.e. transition between activities  # noqa: E501

        :param state: The state of this WorkflowInstance.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def execution_status(self):
        """Gets the execution_status of this WorkflowInstance.  # noqa: E501

        Workflow execution status  # noqa: E501

        :return: The execution_status of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._execution_status

    @execution_status.setter
    def execution_status(self, execution_status):
        """Sets the execution_status of this WorkflowInstance.

        Workflow execution status  # noqa: E501

        :param execution_status: The execution_status of this WorkflowInstance.  # noqa: E501
        :type execution_status: str
        """

        self._execution_status = execution_status

    @property
    def next_activity(self):
        """Gets the next_activity of this WorkflowInstance.  # noqa: E501

        Name of the next step/activity in the workflow. Empty if the workflow has already finished execution.  # noqa: E501

        :return: The next_activity of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._next_activity

    @next_activity.setter
    def next_activity(self, next_activity):
        """Sets the next_activity of this WorkflowInstance.

        Name of the next step/activity in the workflow. Empty if the workflow has already finished execution.  # noqa: E501

        :param next_activity: The next_activity of this WorkflowInstance.  # noqa: E501
        :type next_activity: str
        """

        self._next_activity = next_activity

    @property
    def allowed_actions(self):
        """Gets the allowed_actions of this WorkflowInstance.  # noqa: E501

        Allowed actions if next activity in the workflow requires manual action, otherwise empty.  # noqa: E501

        :return: The allowed_actions of this WorkflowInstance.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_actions

    @allowed_actions.setter
    def allowed_actions(self, allowed_actions):
        """Sets the allowed_actions of this WorkflowInstance.

        Allowed actions if next activity in the workflow requires manual action, otherwise empty.  # noqa: E501

        :param allowed_actions: The allowed_actions of this WorkflowInstance.  # noqa: E501
        :type allowed_actions: list[str]
        """

        self._allowed_actions = allowed_actions

    @property
    def started_at(self):
        """Gets the started_at of this WorkflowInstance.  # noqa: E501

        Execution started at timestamp  # noqa: E501

        :return: The started_at of this WorkflowInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this WorkflowInstance.

        Execution started at timestamp  # noqa: E501

        :param started_at: The started_at of this WorkflowInstance.  # noqa: E501
        :type started_at: datetime
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """Gets the finished_at of this WorkflowInstance.  # noqa: E501

        Execution finished at timestamp. Null if the workflow isn't finished.  # noqa: E501

        :return: The finished_at of this WorkflowInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """Sets the finished_at of this WorkflowInstance.

        Execution finished at timestamp. Null if the workflow isn't finished.  # noqa: E501

        :param finished_at: The finished_at of this WorkflowInstance.  # noqa: E501
        :type finished_at: datetime
        """

        self._finished_at = finished_at

    @property
    def last_step_executed_at(self):
        """Gets the last_step_executed_at of this WorkflowInstance.  # noqa: E501

        Timestamp at which last activity/step in the workflow was executed. Null if the workflow is Idle.  # noqa: E501

        :return: The last_step_executed_at of this WorkflowInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._last_step_executed_at

    @last_step_executed_at.setter
    def last_step_executed_at(self, last_step_executed_at):
        """Sets the last_step_executed_at of this WorkflowInstance.

        Timestamp at which last activity/step in the workflow was executed. Null if the workflow is Idle.  # noqa: E501

        :param last_step_executed_at: The last_step_executed_at of this WorkflowInstance.  # noqa: E501
        :type last_step_executed_at: datetime
        """

        self._last_step_executed_at = last_step_executed_at

    @property
    def execution_context(self):
        """Gets the execution_context of this WorkflowInstance.  # noqa: E501

        Data associated with a particular instance of the workflow.  # noqa: E501

        :return: The execution_context of this WorkflowInstance.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._execution_context

    @execution_context.setter
    def execution_context(self, execution_context):
        """Sets the execution_context of this WorkflowInstance.

        Data associated with a particular instance of the workflow.  # noqa: E501

        :param execution_context: The execution_context of this WorkflowInstance.  # noqa: E501
        :type execution_context: dict(str, object)
        """

        self._execution_context = execution_context

    @property
    def activity_history(self):
        """Gets the activity_history of this WorkflowInstance.  # noqa: E501

        Summary of all executed activities in the workflow instance. The latest executed activity is at the top and traversal from top to bottom  would give us a history of state transition from latest state to initial.  # noqa: E501

        :return: The activity_history of this WorkflowInstance.  # noqa: E501
        :rtype: list[lusid_workflows.WorkflowActivitySummary]
        """
        return self._activity_history

    @activity_history.setter
    def activity_history(self, activity_history):
        """Sets the activity_history of this WorkflowInstance.

        Summary of all executed activities in the workflow instance. The latest executed activity is at the top and traversal from top to bottom  would give us a history of state transition from latest state to initial.  # noqa: E501

        :param activity_history: The activity_history of this WorkflowInstance.  # noqa: E501
        :type activity_history: list[lusid_workflows.WorkflowActivitySummary]
        """

        self._activity_history = activity_history

    @property
    def execution_info(self):
        """Gets the execution_info of this WorkflowInstance.  # noqa: E501

        Any info associated with the workflow execution. This would be an error message if ExecutionStatus is Faulted for example.  # noqa: E501

        :return: The execution_info of this WorkflowInstance.  # noqa: E501
        :rtype: str
        """
        return self._execution_info

    @execution_info.setter
    def execution_info(self, execution_info):
        """Sets the execution_info of this WorkflowInstance.

        Any info associated with the workflow execution. This would be an error message if ExecutionStatus is Faulted for example.  # noqa: E501

        :param execution_info: The execution_info of this WorkflowInstance.  # noqa: E501
        :type execution_info: str
        """

        self._execution_info = execution_info

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowInstance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowInstance):
            return True

        return self.to_dict() != other.to_dict()
