from _typeshed import Incomplete
from opentelemetry.metrics import CallbackOptions as CallbackOptions, Counter as Counter, Histogram as Histogram, Meter as Meter, ObservableCounter as ObservableCounter, ObservableGauge as ObservableGauge, ObservableUpDownCounter as ObservableUpDownCounter, Observation as Observation, UpDownCounter as UpDownCounter
from typing import Any, Callable

class MetricsAPI:
    def __new__(cls) -> MetricsAPI: ...
    def __init__(self) -> None: ...
    @property
    def meter(self) -> Meter: ...
    def create_counter(self, name: str, unit: str = '', description: str = '') -> Counter: ...
    def create_histogram(self, name: str, unit: str = '', description: str = '') -> Histogram: ...
    def create_up_down_counter(self, name: str, unit: str = '', description: str = '') -> UpDownCounter: ...
    def create_observable_counter(self, name: str, callbacks: list[Callable[[CallbackOptions], list[Observation]]], unit: str = '', description: str = '') -> ObservableCounter: ...
    def create_observable_gauge(self, name: str, callbacks: list[Callable[[CallbackOptions], list[Observation]]], unit: str = '', description: str = '') -> ObservableGauge: ...
    def create_observable_up_down_counter(self, name: str, callbacks: list[Callable[[CallbackOptions], list[Observation]]], unit: str = '', description: str = '') -> ObservableUpDownCounter: ...

class REDMetrics:
    service_name: Incomplete
    metrics_api: Incomplete
    request_counter: Incomplete
    error_counter: Incomplete
    duration_histogram: Incomplete
    def __init__(self, service_name: str, metrics_api: MetricsAPI | None = None) -> None: ...
    def record_request(self, attributes: dict[str, Any] | None = None) -> None: ...
    def record_error(self, attributes: dict[str, Any] | None = None) -> None: ...
    def record_duration(self, duration_seconds: float, attributes: dict[str, Any] | None = None) -> None: ...
    def measure(self, operation: str = 'request', record_errors: bool = True, attributes: dict[str, Any] | None = None): ...

def get_meter() -> Meter: ...
def create_counter(name: str, unit: str = '', description: str = '') -> Counter: ...
def create_histogram(name: str, unit: str = '', description: str = '') -> Histogram: ...
def create_up_down_counter(name: str, unit: str = '', description: str = '') -> UpDownCounter: ...
def create_red_metrics(service_name: str) -> REDMetrics: ...
