from ..internal_utils.fallback_logger import fallback_logger as fallback_logger
from _typeshed import Incomplete
from typing import Any

class ServerConfig:
    server_url: Incomplete
    grpc_port: Incomplete
    pid: Incomplete
    ttl_seconds: Incomplete
    last_heartbeat: Incomplete
    def __init__(self, server_url: str, grpc_port: int, pid: int, ttl_seconds: int = 300, last_heartbeat: float | None = None) -> None: ...
    def to_dict(self) -> dict[str, Any]: ...
    @classmethod
    def from_dict(cls, data: dict[str, Any]) -> ServerConfig: ...
    def is_alive(self) -> bool: ...
    def time_since_heartbeat(self) -> float: ...

class ServiceDiscovery:
    config_path: Incomplete
    def __init__(self, config_path: str | None = None) -> None: ...
    def check_existing_server(self) -> ServerConfig | None: ...
    def write_server_config(self, server_url: str, grpc_port: int, ttl_seconds: int = 300) -> None: ...
    def read_server_config(self) -> ServerConfig | None: ...
    def update_heartbeat(self) -> bool: ...
    def cleanup_stale_config(self) -> None: ...
    def cleanup_own_config(self) -> None: ...
    def is_server_available(self) -> tuple[bool, ServerConfig | None]: ...
    def get_server_endpoint(self) -> str | None: ...

def get_service_discovery() -> ServiceDiscovery: ...
def check_existing_server() -> ServerConfig | None: ...
def write_server_config(server_url: str, grpc_port: int, ttl_seconds: int = 300) -> None: ...
def update_heartbeat() -> bool: ...
def cleanup_own_config() -> None: ...
def is_server_available() -> tuple[bool, ServerConfig | None]: ...
def get_server_endpoint() -> str | None: ...
def is_port_available(port: int, host: str = 'localhost') -> bool: ...
def check_port_availability(port: int, host: str = 'localhost') -> str | None: ...
