from .internal_utils.fallback_logger import sdk_logger as sdk_logger
from opentelemetry._logs import SeverityNumber as SeverityNumber
from opentelemetry.sdk._logs import LogData as LogData, LogRecord as LogRecord
from opentelemetry.sdk._logs.export import LogExportResult, LogExporter
from opentelemetry.sdk.trace import ReadableSpan as ReadableSpan
from opentelemetry.sdk.trace.export import SpanExportResult, SpanExporter
from typing import Any, Callable, Sequence

class LumberjackSpanExporter(SpanExporter):
    def __init__(self, api_key: str, endpoint: str, project_name: str | None = None, config_version: int | None = None, update_callback: Callable[[dict[str, Any]], None] | None = None) -> None: ...
    def export(self, spans: Sequence[ReadableSpan]) -> SpanExportResult: ...
    def shutdown(self) -> None: ...
    def force_flush(self, timeout_millis: int = 30000) -> bool: ...

class LumberjackLogExporter(LogExporter):
    def __init__(self, api_key: str, endpoint: str, project_name: str | None = None, config_version: int | None = None, update_callback: Callable[[dict[str, Any]], None] | None = None) -> None: ...
    def export(self, batch: Sequence[LogData]) -> LogExportResult: ...
    def shutdown(self) -> None: ...
    def force_flush(self, timeout_millis: int = 30000) -> bool: ...
