from .config import LumberjackConfig as LumberjackConfig
from .exception_handlers import ExceptionHandlers as ExceptionHandlers
from .exporters import LumberjackLogExporter as LumberjackLogExporter, LumberjackSpanExporter as LumberjackSpanExporter
from .fallback_exporters import FallbackLogExporter as FallbackLogExporter
from .internal_utils.fallback_logger import fallback_logger as fallback_logger, sdk_logger as sdk_logger
from .logging_instrumentation import enable_python_logger_forwarding as enable_python_logger_forwarding
from .object_registration import ObjectRegistration as ObjectRegistration
from .stdout_override import enable_stdout_override as enable_stdout_override
from .version import __version__ as __version__
from lumberjack_sdk.internal_utils.flush_timer import FlushTimerWorker as FlushTimerWorker
from opentelemetry import metrics, trace
from opentelemetry._logs import Logger as Logger
from opentelemetry.sdk._logs.export import BatchLogRecordProcessor
from opentelemetry.sdk.metrics.export import PeriodicExportingMetricReader as PeriodicExportingMetricReader
from typing import Any

has_warned: bool
DEFAULT_BATCH_SIZE: int
DEFAULT_BATCH_AGE: float
DEFAULT_API_URL: str

class Lumberjack:
    def __new__(cls, *args: Any, **kwargs: Any) -> Lumberjack: ...
    def __init__(self, project_name: str | None = None, api_key: str | None = None, endpoint: str | None = None, objects_endpoint: str | None = None, spans_endpoint: str | None = None, metrics_endpoint: str | None = None, env: str | None = None, batch_size: int | None = None, batch_age: float | None = None, flush_interval: float | None = None, log_to_stdout: bool | None = None, stdout_log_level: str | None = None, debug_mode: bool | None = None, otel_format: bool | None = None, capture_stdout: bool | None = None, capture_python_logger: bool | None = None, python_logger_level: str | None = None, python_logger_name: str | None = None, code_snippet_enabled: bool | None = None, code_snippet_context_lines: int | None = None, code_snippet_max_frames: int | None = None, code_snippet_exclude_patterns: list[str] | None = None, install_signal_handlers: bool | None = None, local_server_enabled: bool | None = None, local_server_endpoint: str | None = None, local_server_service_name: str | None = None, custom_log_exporter: Any | None = None, custom_span_exporter: Any | None = None, custom_metrics_exporter: Any | None = None) -> None: ...
    def shutdown(self) -> None: ...
    @classmethod
    def init(cls, project_name: str | None = None, api_key: str | None = None, endpoint: str | None = None, objects_endpoint: str | None = None, spans_endpoint: str | None = None, metrics_endpoint: str | None = None, env: str | None = None, batch_size: int | None = None, batch_age: float | None = None, flush_interval: float | None = None, log_to_stdout: bool | None = None, stdout_log_level: str | None = None, debug_mode: bool | None = None, otel_format: bool | None = None, capture_stdout: bool | None = None, capture_python_logger: bool | None = None, python_logger_level: str | None = None, python_logger_name: str | None = None, code_snippet_enabled: bool | None = None, code_snippet_context_lines: int | None = None, code_snippet_max_frames: int | None = None, code_snippet_exclude_patterns: list[str] | None = None, install_signal_handlers: bool | None = None, local_server_enabled: bool | None = None, local_server_endpoint: str | None = None, local_server_service_name: str | None = None, custom_log_exporter: Any | None = None, custom_span_exporter: Any | None = None, custom_metrics_exporter: Any | None = None) -> None: ...
    @classmethod
    def get_instance(cls) -> Lumberjack | None: ...
    def update_project_config(self, config: dict[str, Any] | None = None, **kwargs: Any) -> None: ...
    @property
    def config(self) -> LumberjackConfig | None: ...
    @property
    def api_key(self) -> str | None: ...
    @property
    def debug_mode(self) -> bool: ...
    @property
    def code_snippet_enabled(self) -> bool: ...
    @property
    def code_snippet_context_lines(self) -> int: ...
    @property
    def code_snippet_max_frames(self) -> int: ...
    @property
    def code_snippet_exclude_patterns(self) -> list[str]: ...
    @property
    def log_processor(self) -> BatchLogRecordProcessor | None: ...
    @classmethod
    def reset(cls) -> None: ...
    def register_object(self, obj: Any = None, **kwargs: Any) -> None: ...
    def flush_objects(self) -> int: ...
    @classmethod
    def register(cls, obj: Any = None, **kwargs: Any) -> None: ...
    @property
    def tracer(self) -> trace.Tracer | None: ...
    @property
    def logger(self) -> Logger | None: ...
    @property
    def meter(self) -> metrics.Meter | None: ...
