/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections;

import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.runtime.util.collections.OptimizableHashSet;

public class DoubleHashSet
extends OptimizableHashSet {
    private double[] key;

    public DoubleHashSet(int expected, float f) {
        super(expected, f);
        this.key = new double[this.n + 1];
    }

    public DoubleHashSet(int expected) {
        this(expected, 0.75f);
    }

    public DoubleHashSet() {
        this(16, 0.75f);
    }

    public boolean add(double k) {
        long longKey = Double.doubleToLongBits(k);
        if (longKey == 0L) {
            if (this.containsZero) {
                return false;
            }
            this.containsZero = true;
        } else {
            double[] key = this.key;
            int pos = (int)MurmurHashUtil.fmix(longKey) & this.mask;
            long curr = Double.doubleToLongBits(key[pos]);
            if (curr != 0L) {
                if (curr == longKey) {
                    return false;
                }
                while ((curr = Double.doubleToLongBits(key[pos = pos + 1 & this.mask])) != 0L) {
                    if (curr != longKey) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OptimizableHashSet.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    public boolean contains(double k) {
        long longKey = Double.doubleToLongBits(k);
        if (longKey == 0L) {
            return this.containsZero;
        }
        double[] key = this.key;
        int pos = (int)MurmurHashUtil.fmix(longKey) & this.mask;
        long curr = Double.doubleToLongBits(key[pos]);
        if (curr == 0L) {
            return false;
        }
        if (longKey == curr) {
            return true;
        }
        while ((curr = Double.doubleToLongBits(key[pos = pos + 1 & this.mask])) != 0L) {
            if (longKey != curr) continue;
            return true;
        }
        return false;
    }

    private void rehash(int newN) {
        double[] key = this.key;
        int mask = newN - 1;
        double[] newKey = new double[newN + 1];
        int i = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (Double.doubleToLongBits(key[--i]) == 0L) {
            }
            int pos = (int)MurmurHashUtil.fmix(Double.doubleToLongBits(key[i])) & mask;
            if (Double.doubleToLongBits(newKey[pos]) != 0L) {
                while (Double.doubleToLongBits(newKey[pos = pos + 1 & mask]) != 0L) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = OptimizableHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    @Override
    public void optimize() {
    }
}

