/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.internal;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;

public abstract class InternalWindowProcessFunction<K, W extends Window>
implements Serializable {
    private static final long serialVersionUID = 5191040787066951059L;
    protected final WindowAssigner<W> windowAssigner;
    protected final NamespaceAggsHandleFunction<W> windowAggregator;
    protected final long allowedLateness;
    protected Context<K, W> ctx;

    protected InternalWindowProcessFunction(WindowAssigner<W> windowAssigner, NamespaceAggsHandleFunction<W> windowAggregator, long allowedLateness) {
        this.windowAssigner = windowAssigner;
        this.windowAggregator = windowAggregator;
        this.allowedLateness = allowedLateness;
    }

    public void open(Context<K, W> ctx) throws Exception {
        this.ctx = ctx;
        this.windowAssigner.open(ctx);
    }

    public abstract Collection<W> assignStateNamespace(BaseRow var1, long var2) throws Exception;

    public abstract Collection<W> assignActualWindows(BaseRow var1, long var2) throws Exception;

    public abstract BaseRow getWindowAggregationResult(W var1) throws Exception;

    public abstract void cleanWindowIfNeeded(W var1, long var2) throws Exception;

    public void close() throws Exception {
    }

    protected final boolean isCleanupTime(W window, long time) {
        return time == this.cleanupTime(window);
    }

    protected boolean isWindowLate(W window) {
        return this.windowAssigner.isEventTime() && this.cleanupTime(window) <= this.ctx.currentWatermark();
    }

    private long cleanupTime(W window) {
        if (this.windowAssigner.isEventTime()) {
            long cleanupTime = ((Window)window).maxTimestamp() + this.allowedLateness;
            return cleanupTime >= ((Window)window).maxTimestamp() ? cleanupTime : Long.MAX_VALUE;
        }
        return ((Window)window).maxTimestamp();
    }

    public static interface Context<K, W extends Window> {
        public <S extends State> S getPartitionedState(StateDescriptor<S, ?> var1) throws Exception;

        public K currentKey();

        public long currentProcessingTime();

        public long currentWatermark();

        public BaseRow getWindowAccumulators(W var1) throws Exception;

        public void setWindowAccumulators(W var1, BaseRow var2) throws Exception;

        public void clearWindowState(W var1) throws Exception;

        public void clearPreviousState(W var1) throws Exception;

        public void clearTrigger(W var1) throws Exception;

        public void onMerge(W var1, Collection<W> var2) throws Exception;

        public void deleteCleanupTimer(W var1) throws Exception;
    }
}

