/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.window.WindowOperator;
import org.apache.flink.table.runtime.operators.window.assigners.CountSlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.CountTumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.InternalTimeWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SessionWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.TumblingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public class WindowOperatorBuilder {
    private LogicalType[] inputFieldTypes;
    private WindowAssigner<?> windowAssigner;
    private Trigger<?> trigger;
    private NamespaceAggsHandleFunction<?> aggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction;
    private RecordEqualiser equaliser;
    private GeneratedRecordEqualiser generatedEqualiser;
    private LogicalType[] accumulatorTypes;
    private LogicalType[] aggResultTypes;
    private LogicalType[] windowPropertyTypes;
    private long allowedLateness = 0L;
    private boolean sendRetraction = false;
    private int rowtimeIndex = -1;

    public static WindowOperatorBuilder builder() {
        return new WindowOperatorBuilder();
    }

    public WindowOperatorBuilder withInputFields(LogicalType[] inputFieldTypes) {
        this.inputFieldTypes = inputFieldTypes;
        return this;
    }

    public WindowOperatorBuilder tumble(Duration size) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = TumblingWindowAssigner.of(size);
        return this;
    }

    public WindowOperatorBuilder sliding(Duration size, Duration slide) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = SlidingWindowAssigner.of(size, slide);
        return this;
    }

    public WindowOperatorBuilder session(Duration sessionGap) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        this.windowAssigner = SessionWindowAssigner.withGap(sessionGap);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.trigger == null ? 1 : 0) != 0);
        this.windowAssigner = CountTumblingWindowAssigner.of(size);
        this.trigger = ElementTriggers.count(size);
        return this;
    }

    public WindowOperatorBuilder countWindow(long size, long slide) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.trigger == null ? 1 : 0) != 0);
        this.windowAssigner = CountSlidingWindowAssigner.of(size, slide);
        this.trigger = ElementTriggers.count(size);
        return this;
    }

    public WindowOperatorBuilder assigner(WindowAssigner<?> windowAssigner) {
        Preconditions.checkArgument((this.windowAssigner == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(windowAssigner);
        this.windowAssigner = windowAssigner;
        return this;
    }

    public WindowOperatorBuilder triggering(Trigger<?> trigger) {
        Preconditions.checkNotNull(trigger);
        this.trigger = trigger;
        return this;
    }

    public WindowOperatorBuilder withEventTime(int rowtimeIndex) {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument((boolean)(this.windowAssigner instanceof InternalTimeWindowAssigner));
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withEventTime());
        this.rowtimeIndex = rowtimeIndex;
        if (this.trigger == null) {
            this.trigger = EventTimeTriggers.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withProcessingTime() {
        Preconditions.checkNotNull(this.windowAssigner);
        Preconditions.checkArgument((boolean)(this.windowAssigner instanceof InternalTimeWindowAssigner));
        InternalTimeWindowAssigner timeWindowAssigner = (InternalTimeWindowAssigner)((Object)this.windowAssigner);
        this.windowAssigner = (WindowAssigner)((Object)timeWindowAssigner.withProcessingTime());
        if (this.trigger == null) {
            this.trigger = ProcessingTimeTriggers.afterEndOfWindow();
        }
        return this;
    }

    public WindowOperatorBuilder withAllowedLateness(Duration allowedLateness) {
        Preconditions.checkArgument((!allowedLateness.isNegative() ? 1 : 0) != 0);
        if (allowedLateness.toMillis() > 0L) {
            this.allowedLateness = allowedLateness.toMillis();
            this.sendRetraction = true;
        }
        return this;
    }

    public WindowOperatorBuilder aggregate(NamespaceAggsHandleFunction<?> aggregateFunction, RecordEqualiser equaliser, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        ClosureCleaner.clean(aggregateFunction, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        this.accumulatorTypes = accumulatorTypes;
        this.aggResultTypes = aggResultTypes;
        this.windowPropertyTypes = windowPropertyTypes;
        this.aggregateFunction = (NamespaceAggsHandleFunction)Preconditions.checkNotNull(aggregateFunction);
        this.equaliser = (RecordEqualiser)Preconditions.checkNotNull((Object)equaliser);
        return this;
    }

    public WindowOperatorBuilder aggregate(GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction, GeneratedRecordEqualiser generatedEqualiser, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes) {
        this.accumulatorTypes = accumulatorTypes;
        this.aggResultTypes = aggResultTypes;
        this.windowPropertyTypes = windowPropertyTypes;
        this.generatedAggregateFunction = (GeneratedNamespaceAggsHandleFunction)Preconditions.checkNotNull(generatedAggregateFunction);
        this.generatedEqualiser = (GeneratedRecordEqualiser)Preconditions.checkNotNull((Object)generatedEqualiser);
        return this;
    }

    public WindowOperatorBuilder withSendRetraction() {
        this.sendRetraction = true;
        return this;
    }

    public WindowOperator build() {
        Preconditions.checkNotNull(this.trigger, (String)"trigger is not set");
        if (this.generatedAggregateFunction != null && this.generatedEqualiser != null) {
            return new WindowOperator(this.generatedAggregateFunction, this.generatedEqualiser, this.windowAssigner, this.trigger, this.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.inputFieldTypes, this.accumulatorTypes, this.aggResultTypes, this.windowPropertyTypes, this.rowtimeIndex, this.sendRetraction, this.allowedLateness);
        }
        return new WindowOperator(this.aggregateFunction, this.equaliser, this.windowAssigner, this.trigger, this.windowAssigner.getWindowSerializer(new ExecutionConfig()), this.inputFieldTypes, this.accumulatorTypes, this.aggResultTypes, this.windowPropertyTypes, this.rowtimeIndex, this.sendRetraction, this.allowedLateness);
    }
}

