/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public abstract class UnboundedFollowingOverFrame
implements OverWindowFrame {
    private GeneratedAggsHandleFunction aggsHandleFunction;
    private final RowType valueType;
    private AggsHandleFunction processor;
    private BaseRow accValue;
    ResettableExternalBuffer input;
    private BaseRowSerializer valueSer;
    int inputIndex = 0;

    public UnboundedFollowingOverFrame(RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction) {
        this.valueType = valueType;
        this.aggsHandleFunction = aggsHandleFunction;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(cl);
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.aggsHandleFunction = null;
        this.valueSer = new BaseRowSerializer(ctx.getRuntimeContext().getExecutionConfig(), this.valueType);
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        this.input = rows;
        this.processor.setAccumulators(this.processor.createAccumulators());
        this.inputIndex = 0;
    }

    BaseRow accumulateIterator(boolean bufferUpdated, BinaryRow firstRow, ResettableExternalBuffer.BufferIterator iterator) throws Exception {
        if (bufferUpdated) {
            this.processor.setAccumulators(this.processor.createAccumulators());
            if (firstRow != null) {
                this.processor.accumulate(firstRow);
            }
            while (iterator.advanceNext()) {
                this.processor.accumulate(iterator.getRow());
            }
            this.accValue = this.valueSer.copy(this.processor.getValue());
        }
        iterator.close();
        return this.accValue;
    }
}

