/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import java.util.ArrayDeque;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public abstract class SlidingOverFrame
implements OverWindowFrame {
    private final RowType inputType;
    private final RowType valueType;
    private GeneratedAggsHandleFunction aggsHandleFunction;
    private transient AggsHandleFunction processor;
    transient BaseRowSerializer inputSer;
    private transient BaseRowSerializer valueSer;
    transient ResettableExternalBuffer.BufferIterator inputIterator;
    transient BinaryRow nextRow;
    transient ArrayDeque<BaseRow> buffer;
    private transient BaseRow accValue;

    public SlidingOverFrame(RowType inputType, RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction) {
        this.inputType = inputType;
        this.valueType = valueType;
        this.aggsHandleFunction = aggsHandleFunction;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        ExecutionConfig conf = ctx.getRuntimeContext().getExecutionConfig();
        this.inputSer = new BaseRowSerializer(conf, this.inputType);
        this.valueSer = new BaseRowSerializer(conf, this.valueType);
        ClassLoader cl = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(cl);
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.buffer = new ArrayDeque();
        this.aggsHandleFunction = null;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        if (this.inputIterator != null) {
            this.inputIterator.close();
        }
        this.inputIterator = rows.newIterator();
        this.nextRow = OverWindowFrame.getNextOrNull(this.inputIterator);
        this.buffer.clear();
        this.processor.setAccumulators(this.processor.createAccumulators());
    }

    BaseRow accumulateBuffer(boolean bufferUpdated) throws Exception {
        if (bufferUpdated) {
            this.processor.setAccumulators(this.processor.createAccumulators());
            for (BaseRow row : this.buffer) {
                this.processor.accumulate(row);
            }
            this.accValue = this.valueSer.copy(this.processor.getValue());
        }
        return this.accValue;
    }
}

