/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

class HashTableBloomFilter {
    private final MemorySegment[] buffers;
    private final int numBuffers;
    private final int numBuffersMask;
    private final BloomFilter filter;
    private final int maxSize;
    private int size = 0;

    HashTableBloomFilter(MemorySegment[] buffers, long numRecords) {
        Preconditions.checkArgument((buffers != null && buffers.length > 0 ? 1 : 0) != 0);
        this.buffers = buffers;
        this.numBuffers = buffers.length;
        Preconditions.checkArgument((boolean)MathUtils.isPowerOf2((long)this.numBuffers));
        this.numBuffersMask = this.numBuffers - 1;
        int bufferSize = buffers[0].size();
        this.filter = new BloomFilter((int)(numRecords / (long)this.numBuffers), buffers[0].size());
        this.filter.setBitsLocation(buffers[0], 0);
        this.maxSize = (int)((double)(this.numBuffers * bufferSize) * 2.44);
    }

    private void setLocation(int hash2) {
        if (this.numBuffers > 1) {
            this.filter.setBitsLocation(this.buffers[hash2 & this.numBuffersMask], 0);
        }
    }

    boolean testHash(int hash2) {
        this.setLocation(hash2);
        return this.filter.testHash(hash2);
    }

    boolean addHash(int hash2) {
        this.setLocation(hash2);
        this.filter.addHash(hash2);
        ++this.size;
        return this.size <= this.maxSize;
    }

    public MemorySegment[] getBuffers() {
        return this.buffers;
    }

    static int optimalSegmentNumber(long maxNum, int segSize, double fpp) {
        double numBytes = (double)HashTableBloomFilter.optimalNumOfBits(maxNum, fpp) / 8.0;
        return (int)Math.ceil(numBytes / (double)segSize);
    }

    private static int optimalNumOfBits(long maxNumEntries, double fpp) {
        return (int)((double)(-maxNumEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }
}

