/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.generated;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.guava18.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava18.com.google.common.cache.CacheBuilder;
import org.apache.flink.util.Preconditions;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileUtils {
    private static final Logger CODE_LOG = LoggerFactory.getLogger(CompileUtils.class);
    protected static final Cache<Tuple2<ClassLoader, String>, Class<?>> COMPILED_CACHE = CacheBuilder.newBuilder().maximumSize(100L).build();

    public static <T> Class<T> compile(ClassLoader cl, String name, String code) {
        Tuple2 cacheKey = Tuple2.of((Object)cl, (Object)name);
        Class<T> clazz = (Class<T>)COMPILED_CACHE.getIfPresent((Object)cacheKey);
        if (clazz == null) {
            clazz = CompileUtils.doCompile(cl, name, code);
            COMPILED_CACHE.put((Object)cacheKey, clazz);
        }
        return clazz;
    }

    private static <T> Class<T> doCompile(ClassLoader cl, String name, String code) {
        Preconditions.checkNotNull((Object)cl, (String)"Classloader must not be null.");
        CODE_LOG.debug("Compiling: %s \n\n Code:\n%s", (Object)name, (Object)code);
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.setParentClassLoader(cl);
        try {
            compiler.cook(code);
        }
        catch (Throwable t) {
            System.out.println(CompileUtils.addLineNumber(code));
            throw new InvalidProgramException("Table program cannot be compiled. This is a bug. Please file an issue.", t);
        }
        try {
            return compiler.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can not load class " + name, e);
        }
    }

    private static String addLineNumber(String code) {
        String[] lines = code.split("\n");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            builder.append("/* ").append(i + 1).append(" */").append(lines[i]).append("\n");
        }
        return builder.toString();
    }
}

