/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.dataview;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.runtime.dataview.StateDataView;

public abstract class StateListView<N, T>
extends ListView<T>
implements StateDataView<N> {
    private static final long serialVersionUID = 1L;
    private final Iterable<T> emptyList = Collections.emptyList();

    @Override
    public Iterable<T> get() throws Exception {
        Iterable<T> original = (Iterable<T>)this.getListState().get();
        return original != null ? original : this.emptyList;
    }

    @Override
    public void add(T value) throws Exception {
        this.getListState().add(value);
    }

    @Override
    public void addAll(List<T> list) throws Exception {
        this.getListState().addAll(list);
    }

    @Override
    public boolean remove(T value) throws Exception {
        List list = (List)this.getListState().get();
        boolean success = list.remove(value);
        if (success) {
            this.getListState().update(list);
        }
        return success;
    }

    @Override
    public void clear() {
        this.getListState().clear();
    }

    protected abstract ListState<T> getListState();

    public static final class NamespacedStateListView<N, T>
    extends StateListView<N, T> {
        private static final long serialVersionUID = 1423184510190367940L;
        private final InternalListState<?, N, T> listState;
        private N namespace;

        public NamespacedStateListView(InternalListState<?, N, T> listState) {
            this.listState = listState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            this.namespace = namespace;
        }

        @Override
        protected ListState<T> getListState() {
            this.listState.setCurrentNamespace(this.namespace);
            return this.listState;
        }
    }

    public static final class KeyedStateListView<N, T>
    extends StateListView<N, T> {
        private static final long serialVersionUID = 6526065473887440980L;
        private final ListState<T> listState;

        public KeyedStateListView(ListState<T> listState) {
            this.listState = listState;
        }

        @Override
        public void setCurrentNamespace(N namespace) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected ListState<T> getListState() {
            return this.listState;
        }
    }
}

