/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class TableSinkUtils$ {
    public static final TableSinkUtils$ MODULE$;

    static {
        new TableSinkUtils$();
    }

    public void validateSink(CatalogSinkModifyOperation sinkOperation, List<String> sinkPath, TableSink<?> sink) {
        String invalidMsg;
        block6: {
            block5: {
                DataType[] sinkFieldTypes;
                QueryOperation query = sinkOperation.getChild();
                DataType[] srcFieldTypes = query.getTableSchema().getFieldDataTypes();
                if (srcFieldTypes.length != (sinkFieldTypes = sink.getTableSchema().getFieldDataTypes()).length || Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])srcFieldTypes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sinkFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).exists((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<DataType, DataType> x0$1) {
                        Tuple2<DataType, DataType> tuple2 = x0$1;
                        if (tuple2 != null) {
                            DataType srcF = (DataType)tuple2._1();
                            DataType snkF = (DataType)tuple2._2();
                            boolean bl = !PlannerTypeUtils.isInteroperable(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(srcF), LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(snkF));
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })) {
                    String[] srcFieldNames = query.getTableSchema().getFieldNames();
                    String[] sinkFieldNames = sink.getTableSchema().getFieldNames();
                    String srcSchema = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])srcFieldNames).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])srcFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, DataType> x0$2) {
                            Tuple2<String, DataType> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String n = (String)tuple2._1();
                                DataType t = (DataType)tuple2._2();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n, t.getConversionClass().getSimpleName()}));
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", ", ", "]");
                    String sinkSchema = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sinkFieldNames).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sinkFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, DataType> x0$3) {
                            Tuple2<String, DataType> tuple2 = x0$3;
                            if (tuple2 != null) {
                                String n = (String)tuple2._1();
                                DataType t = (DataType)tuple2._2();
                                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n, t.getConversionClass().getSimpleName()}));
                                return string;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("[", ", ", "]");
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field types of query result and registered TableSink "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " do not match.\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkPath}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query result schema: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcSchema}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableSink schema:    ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkSchema}))).toString());
                }
                Map<String, String> staticPartitions = sinkOperation.getStaticPartitions();
                if (staticPartitions == null || staticPartitions.isEmpty()) break block5;
                invalidMsg = "Can't insert static partitions into a non-partitioned table sink. A partitioned sink should implement 'PartitionableTableSink' and return partition field names via 'getPartitionFieldNames()' method.";
                TableSink<?> tableSink = sink;
                if (!(tableSink instanceof PartitionableTableSink)) break block6;
                PartitionableTableSink partitionableTableSink = (PartitionableTableSink)((Object)tableSink);
                List<String> partitionFields = partitionableTableSink.getPartitionFieldNames();
                if (partitionFields == null || partitionFields.isEmpty()) {
                    throw new ValidationException(invalidMsg);
                }
                ((IterableLike)JavaConversions$.MODULE$.mapAsScalaMap(staticPartitions).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x$1) {
                        return (String)x$1._1();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(partitionFields){
                    public static final long serialVersionUID = 0L;
                    private final List partitionFields$1;

                    public final void apply(String p) {
                        if (this.partitionFields$1.contains(p)) {
                            return;
                        }
                        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Static partition column ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"should be in the partition fields list ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionFields$1}))).toString());
                    }
                    {
                        this.partitionFields$1 = partitionFields$1;
                    }
                });
                ((IterableLike)((IterableLike)JavaConversions$.MODULE$.mapAsScalaMap(staticPartitions).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x$2) {
                        return (String)x$2._1();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).zip((GenIterable)JavaConversions$.MODULE$.asScalaBuffer(partitionFields), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<String, String> x0$4) {
                        Tuple2<String, String> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String p1 = (String)tuple2._1();
                            String p2 = (String)tuple2._2();
                            String string = p1;
                            String string2 = p2;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Static partition column ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"should appear before dynamic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p2}))).toString());
                        }
                        throw new MatchError(tuple2);
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new ValidationException(invalidMsg);
    }

    private TableSinkUtils$() {
        MODULE$ = this;
    }
}

