/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.type;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.type.NumericOrDefaultReturnTypeInference;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.VarCharType;

public class FlinkReturnTypes {
    public static final SqlReturnTypeInference ROUND_FUNCTION = new SqlReturnTypeInference(){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            BigDecimal lenVal;
            RelDataType numType = opBinding.getOperandType(0);
            if (numType.getSqlTypeName() != SqlTypeName.DECIMAL) {
                return numType;
            }
            if (opBinding.getOperandCount() == 1) {
                lenVal = BigDecimal.ZERO;
            } else if (opBinding.getOperandCount() == 2) {
                lenVal = this.getArg1Literal(opBinding);
            } else {
                throw new AssertionError();
            }
            if (lenVal == null) {
                return numType;
            }
            int p = numType.getPrecision();
            int s = numType.getScale();
            int r = lenVal.intValueExact();
            DecimalType dt = FlinkTypeSystem.inferRoundType(p, s, r);
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
        }

        private BigDecimal getArg1Literal(SqlOperatorBinding opBinding) {
            try {
                return opBinding.getOperandLiteralValue(1, BigDecimal.class);
            }
            catch (Throwable e) {
                return null;
            }
        }
    };
    public static final SqlReturnTypeInference ARG0_VARCHAR_FORCE_NULLABLE = new OrdinalReturnTypeInference(0){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType newType;
            RelDataType type = super.inferReturnType(opBinding);
            switch (type.getSqlTypeName()) {
                case CHAR: {
                    newType = opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, type.getPrecision());
                    break;
                }
                case VARCHAR: {
                    newType = type;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
            }
            return opBinding.getTypeFactory().createTypeWithNullability(newType, true);
        }
    };
    public static final SqlReturnTypeInference FLINK_QUOTIENT_NULLABLE = opBinding -> {
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        if (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2)) {
            return ReturnTypes.QUOTIENT_NULLABLE.inferReturnType(opBinding);
        }
        RelDataType doubleType = opBinding.getTypeFactory().createSqlType(SqlTypeName.DOUBLE);
        if (type1.isNullable() || type2.isNullable()) {
            return opBinding.getTypeFactory().createTypeWithNullability(doubleType, true);
        }
        return doubleType;
    };
    public static final SqlReturnTypeInference FLINK_DIV_NULLABLE = opBinding -> {
        RelDataType returnType;
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        if (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2)) {
            DecimalType dt = FlinkTypeSystem.inferIntDivType(type1.getPrecision(), type1.getScale(), type2.getScale());
            returnType = opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
        } else {
            returnType = type1;
        }
        return opBinding.getTypeFactory().createTypeWithNullability(returnType, type1.isNullable() || type2.isNullable());
    };
    public static final SqlReturnTypeInference VARCHAR_2000_NULLABLE = ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference ROUND_FUNCTION_NULLABLE = ReturnTypes.cascade(ROUND_FUNCTION, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1 = new NumericOrDefaultReturnTypeInference(1, 1);
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1_NULLABLE = ReturnTypes.cascade(NUMERIC_FROM_ARG1_DEFAULT1, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference STR_MAP_NULLABLE = ReturnTypes.explicit(factory -> ((FlinkTypeFactory)factory).createFieldTypeFromLogicalType(new MapType(new VarCharType(Integer.MAX_VALUE), new VarCharType(Integer.MAX_VALUE))));
}

