/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!B\u0001\u0003\u0003\u0003\u0019\"A\b'pO&\u001c\u0017\r\\,j]\u0012|w/Q4he\u0016<\u0017\r^3Sk2,')Y:f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\b/)\u0011\u0001DD\u0001\bG\u0006d7-\u001b;f\u0013\tQbC\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002\u001fI9\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\u00051\u0001K]3eK\u001aL!!\n\u0014\u0003\rM#(/\u001b8h\u0015\t\u0019\u0003\u0005C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u0003\tAQ\u0001H\u0014A\u0002uAQA\f\u0001\u0005B=\nq!\\1uG\",7\u000f\u0006\u00021gA\u0011q$M\u0005\u0003e\u0001\u0012qAQ8pY\u0016\fg\u000eC\u00035[\u0001\u0007Q'\u0001\u0003dC2d\u0007CA\u000b7\u0013\t9dC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000be\u0002A\u0011\t\u001e\u0002\u000f=tW*\u0019;dQR\u00111H\u0010\t\u0003?qJ!!\u0010\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006ia\u0002\r!\u000e\u0005\u0006\u0001\u0002!I!Q\u0001\fC\u0012TWo\u001d;UsB,7\u000fF\u0002C%f\u00032a\u0011%K\u001b\u0005!%BA#G\u0003\u001diW\u000f^1cY\u0016T!a\u0012\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002J\t\n1!)\u001e4gKJ\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t\r|'/\u001a\u0006\u0003\u001f^\t1A]3m\u0013\t\tFJA\u0007BO\u001e\u0014XmZ1uK\u000e\u000bG\u000e\u001c\u0005\u0006'~\u0002\r\u0001V\u0001\u0004C\u001e<\u0007CA+X\u001b\u00051&BA\u0002O\u0013\tAfK\u0001\tM_\u001eL7-\u00197BO\u001e\u0014XmZ1uK\")!l\u0010a\u00017\u0006i\u0011N\u001c3fq\u0006sG\rV=qKN\u0004BA\b/_C&\u0011QL\n\u0002\u0004\u001b\u0006\u0004\bCA\u0010`\u0013\t\u0001\u0007EA\u0002J]R\u0004\"AY3\u000e\u0003\rT!\u0001\u001a(\u0002\tQL\b/Z\u0005\u0003M\u000e\u00141BU3m\t\u0006$\u0018\rV=qK\")\u0001\u000e\u0001C\u0005S\u0006\ts-\u001a;J]\u0012,\u00070\u00118e\u0013:4WM\u001d:fIRK\b/Z:JM\u000eC\u0017M\\4fIR\u00111L\u001b\u0005\u0006'\u001e\u0004\r\u0001\u0016\u0005\u0007Y\u0002!\tAC7\u0002)\u001d,GoV5oI><X\t\u001f9sKN\u001c\u0018n\u001c8t)\rq\u0017q\u0001\t\u0004_^ThB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019(#\u0001\u0004=e>|GOP\u0005\u0002C%\u0011a\u000fI\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018PA\u0002TKFT!A\u001e\u0011\u0011\t}YXPX\u0005\u0003y\u0002\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002]\t1A]3y\u0013\r\t)a \u0002\b%\u0016D8)\u00197m\u0011\u0015\u00196\u000e1\u0001U\u0011!\tY\u0001\u0001D\u0001\u0015\u00055\u0011!H4fi&s\u0017iZ4sK\u001e\fG/Z$s_V\u0004X\t\u001f9sKN\u001c\u0018n\u001c8\u0015\r\u0005=\u0011QCA\u0010!\rq\u0018\u0011C\u0005\u0004\u0003'y(a\u0002*fq:{G-\u001a\u0005\t\u0003/\tI\u00011\u0001\u0002\u001a\u0005Q!/\u001a=Ck&dG-\u001a:\u0011\u0007y\fY\"C\u0002\u0002\u001e}\u0014!BU3y\u0005VLG\u000eZ3s\u0011\u001d\t\t#!\u0003A\u0002u\f\u0001c^5oI><X\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0005\u0015\u0002A\"\u0001\u000b\u0003O\tadZ3u\u001fV$\u0018iZ4sK\u001e\fG/Z$s_V\u0004X\t\u001f9sKN\u001c\u0018n\u001c8\u0015\r\u0005=\u0011\u0011FA\u0016\u0011!\t9\"a\tA\u0002\u0005e\u0001bBA\u0011\u0003G\u0001\r! \u0005\t\u0003_\u0001A\u0011\u0001\u0006\u00022\u0005yAO]1og2\fG/Z,j]\u0012|w\u000f\u0006\u0005\u00024\u0005u\u0012\u0011IA#!\u0011\t)$!\u000f\u000e\u0005\u0005]\"BA\u0002\u0007\u0013\u0011\tY$a\u000e\u0003\u001b1{w-[2bY^Kg\u000eZ8x\u0011\u001d\ty$!\fA\u0002u\f!b^5oI><X\t\u001f9s\u0011\u001d\t\u0019%!\fA\u0002y\u000bQb^5oI><X\t\u001f9s\u0013\u0012D\bbBA$\u0003[\u0001\r!Y\u0001\be><H+\u001f9f\u0011!\tY\u0005\u0001D\u0001\u0015\u00055\u0013!F4fiRKW.\u001a$jK2$'+\u001a4fe\u0016t7-\u001a\u000b\t\u0003\u001f\nY&a\u0018\u0002bA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V)\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011LA*\u0005a1\u0015.\u001a7e%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\t\u0003;\nI\u00051\u0001\u0002\u0010\u00059q\u000e]3sC:$\u0007bBA\"\u0003\u0013\u0002\rA\u0018\u0005\b\u0003\u000f\nI\u00051\u0001b\u0001")
public abstract class LogicalWindowAggregateRuleBase
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        Seq<Tuple2<RexCall, Object>> windowExpressions = this.getWindowExpressions(agg);
        if (windowExpressions.length() > 1) {
            throw new TableException("Only a single window group function may be used in GROUP BY");
        }
        Aggregate.Group group = agg.getGroupType();
        Aggregate.Group group2 = Aggregate.Group.SIMPLE;
        boolean groupSets = group != null ? !((Object)((Object)group)).equals((Object)group2) : group2 != null;
        return !groupSets && !false && windowExpressions.nonEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        Tuple2 tuple2 = (Tuple2)this.getWindowExpressions(agg).head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            RexCall windowExpr = (RexCall)tuple2._1();
            int windowExprIdx = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)windowExpr, (Object)BoxesRunTime.boxToInteger((int)windowExprIdx));
            RexCall windowExpr2 = (RexCall)tuple23._1();
            int windowExprIdx2 = tuple23._2$mcI$sp();
            LogicalWindow window = this.translateWindow(windowExpr2, windowExprIdx2, project.getInput().getRowType());
            RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
            RexNode inAggGroupExpression = this.getInAggregateGroupExpression(rexBuilder, windowExpr2);
            ImmutableBitSet newGroupSet = agg.getGroupSet().except(ImmutableBitSet.of(windowExprIdx2));
            RelBuilder builder = call.builder();
            RelNode newProject = builder.push(project.getInput()).project(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(project.getChildExps()).updated(windowExprIdx2, (Object)inAggGroupExpression, Buffer$.MODULE$.canBuildFrom()))).build();
            scala.collection.immutable.Map<Object, RelDataType> indexAndTypes = this.getIndexAndInferredTypesIfChanged(agg);
            Buffer<AggregateCall> finalCalls = this.adjustTypes(agg, indexAndTypes);
            LogicalAggregate newAgg = LogicalAggregate.create(newProject, false, newGroupSet, ImmutableList.of(newGroupSet), JavaConversions$.MODULE$.bufferAsJavaList(finalCalls));
            RelBuilder transformed = call.builder();
            LogicalWindowAggregate windowAgg = LogicalWindowAggregate$.MODULE$.create(window, (Seq<FlinkRelBuilder.PlannerNamedWindowProperty>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), newAgg);
            transformed.push(windowAgg);
            RexNode outAggGroupExpression0 = this.getOutAggregateGroupExpression(rexBuilder, windowExpr2);
            RexNode outAggGroupExpression = windowExpr2.getType().isNullable() != outAggGroupExpression0.getType().isNullable() ? builder.getRexBuilder().makeAbstractCast(builder.getRexBuilder().matchNullability(outAggGroupExpression0.getType(), windowExpr2), outAggGroupExpression0) : outAggGroupExpression0;
            Buffer projectsEnsureGroupKeyTypes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(transformed.fields()).patch(windowExprIdx2, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{outAggGroupExpression})), 0, Buffer$.MODULE$.canBuildFrom());
            Buffer projectsEnsureAggCallTypes = (Buffer)((TraversableLike)projectsEnsureGroupKeyTypes.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, agg, rexBuilder, indexAndTypes){
                public static final long serialVersionUID = 0L;
                private final LogicalAggregate agg$1;
                private final RexBuilder rexBuilder$1;
                private final scala.collection.immutable.Map indexAndTypes$1;

                public final RexNode apply(Tuple2<RexNode, Object> x0$2) {
                    Tuple2<RexNode, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        RexNode aggCall = (RexNode)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        int aggCallIndex = index - this.agg$1.getGroupCount();
                        RexNode rexNode = JavaConversions$.MODULE$.mapAsJavaMap((Map)this.indexAndTypes$1).containsKey(BoxesRunTime.boxToInteger((int)aggCallIndex)) ? this.rexBuilder$1.makeCast(this.agg$1.getAggCallList().get((int)aggCallIndex).type, aggCall, true) : aggCall;
                        return rexNode;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.agg$1 = agg$1;
                    this.rexBuilder$1 = rexBuilder$1;
                    this.indexAndTypes$1 = indexAndTypes$1;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            transformed.project(JavaConversions$.MODULE$.bufferAsJavaList(projectsEnsureAggCallTypes));
            RelNode result = transformed.build();
            call.transformTo(result);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Buffer<AggregateCall> adjustTypes(LogicalAggregate agg, scala.collection.immutable.Map<Object, RelDataType> indexAndTypes) {
        return (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, agg, indexAndTypes){
            public static final long serialVersionUID = 0L;
            private final LogicalAggregate agg$3;
            private final scala.collection.immutable.Map indexAndTypes$2;

            public final AggregateCall apply(Tuple2<AggregateCall, Object> x0$1) {
                Tuple2<AggregateCall, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    AggregateCall aggCall = (AggregateCall)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    AggregateCall aggregateCall = JavaConversions$.MODULE$.mapAsJavaMap((Map)this.indexAndTypes$2).containsKey(BoxesRunTime.boxToInteger((int)index)) ? AggregateCall.create(aggCall.getAggregation(), aggCall.isDistinct(), aggCall.isApproximate(), aggCall.ignoreNulls(), aggCall.getArgList(), aggCall.filterArg, aggCall.collation, this.agg$3.getGroupCount(), this.agg$3.getInput(), (RelDataType)this.indexAndTypes$2.apply((Object)BoxesRunTime.boxToInteger((int)index)), aggCall.name) : aggCall;
                    return aggregateCall;
                }
                throw new MatchError(tuple2);
            }
            {
                this.agg$3 = agg$3;
                this.indexAndTypes$2 = indexAndTypes$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<Object, RelDataType> getIndexAndInferredTypesIfChanged(LogicalAggregate agg) {
        return ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, agg){
            public static final long serialVersionUID = 0L;
            private final LogicalAggregate agg$2;

            public final Iterable<Tuple2<Object, RelDataType>> apply(Tuple2<AggregateCall, Object> x0$3) {
                Tuple2<AggregateCall, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    AggregateCall aggCall = (AggregateCall)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    RelDataType origType = aggCall.type;
                    Aggregate.AggCallBinding aggCallBinding = new Aggregate.AggCallBinding(this.agg$2.getCluster().getTypeFactory(), aggCall.getAggregation(), SqlTypeUtil.projectTypes(this.agg$2.getInput().getRowType(), aggCall.getArgList()), 0, aggCall.hasFilter());
                    RelDataType inferredType = aggCall.getAggregation().inferReturnType(aggCallBinding);
                    RelDataType relDataType = origType;
                    RelDataType relDataType2 = inferredType;
                    Iterable iterable = (relDataType == null ? relDataType2 != null : !relDataType.equals(relDataType2)) && this.agg$2.getGroupCount() == 1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)inferredType))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
            {
                this.agg$2 = agg$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<RexCall, Object>> getWindowExpressions(LogicalAggregate agg) {
        LogicalProject project = (LogicalProject)((HepRelVertex)agg.getInput()).getCurrentRel();
        ImmutableBitSet groupKeys = agg.getGroupSet();
        Buffer groupExpr = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(project.getProjects()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, groupKeys){
            public static final long serialVersionUID = 0L;
            private final ImmutableBitSet groupKeys$1;

            public final boolean apply(Tuple2<RexNode, Object> p) {
                return this.groupKeys$1.get(p._2$mcI$sp());
            }
            {
                this.groupKeys$1 = groupKeys$1;
            }
        });
        return (Seq)((TraversableLike)groupExpr.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<RexNode, Object> g) {
                RexNode rexNode = (RexNode)g._1();
                if (!(rexNode instanceof RexCall)) return false;
                RexCall rexCall = (RexCall)rexNode;
                SqlOperator sqlOperator = rexCall.getOperator();
                SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE;
                SqlOperator sqlOperator2 = sqlOperator;
                if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                    if (rexCall.getOperands().size() != 2) throw new TableException("TUMBLE window with alignment is not supported yet.");
                    return true;
                }
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    if (rexCall.getOperands().size() != 3) throw new TableException("HOP window with alignment is not supported yet.");
                    return true;
                }
                SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION;
                SqlOperator sqlOperator4 = sqlOperator;
                if (sqlGroupedWindowFunction3 == null) {
                    if (sqlOperator4 != null) {
                        return false;
                    }
                } else if (!((Object)sqlGroupedWindowFunction3).equals(sqlOperator4)) return false;
                if (rexCall.getOperands().size() != 2) throw new TableException("SESSION window with alignment is not supported yet.");
                return true;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<RexCall, Object> apply(Tuple2<RexNode, Object> w) {
                return new Tuple2((Object)((RexCall)w._1()), (Object)BoxesRunTime.boxToInteger((int)w._2$mcI$sp()));
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public abstract RexNode getInAggregateGroupExpression(RexBuilder var1, RexCall var2);

    public abstract RexNode getOutAggregateGroupExpression(RexBuilder var1, RexCall var2);

    public LogicalWindow translateWindow(RexCall windowExpr, int windowExprIdx, RelDataType rowType) {
        SqlOperator sqlOperator;
        block6: {
            LogicalWindow logicalWindow;
            block3: {
                PlannerWindowReference windowRef;
                FieldReferenceExpression timeField;
                block4: {
                    Tuple2.mcJJ.sp sp2;
                    block5: {
                        Tuple2.mcJJ.sp sp3;
                        block2: {
                            timeField = this.getTimeFieldReference(windowExpr.getOperands().get(0), windowExprIdx, rowType);
                            Some resultType2 = new Some((Object)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(timeField.getOutputDataType()));
                            windowRef = new PlannerWindowReference("w$", (Option<LogicalType>)resultType2);
                            sqlOperator = windowExpr.getOperator();
                            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE;
                            SqlOperator sqlOperator2 = sqlOperator;
                            if (sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null) break block2;
                            long interval = this.getOperandAsLong$1(windowExpr, 1);
                            logicalWindow = new TumblingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(interval));
                            break block3;
                        }
                        SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.HOP;
                        SqlOperator sqlOperator3 = sqlOperator;
                        if (sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator3) : sqlOperator3 != null) break block4;
                        sp2 = new Tuple2.mcJJ.sp(this.getOperandAsLong$1(windowExpr, 1), this.getOperandAsLong$1(windowExpr, 2));
                        if (sp2 == null) break block5;
                        long slide = sp2._1$mcJ$sp();
                        long size = sp2._2$mcJ$sp();
                        Tuple2.mcJJ.sp sp4 = sp3 = new Tuple2.mcJJ.sp(slide, size);
                        long slide2 = sp4._1$mcJ$sp();
                        long size2 = sp4._2$mcJ$sp();
                        logicalWindow = new SlidingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(size2), ApiExpressionUtils.intervalOfMillis(slide2));
                        break block3;
                    }
                    throw new MatchError((Object)sp2);
                }
                SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.SESSION;
                SqlOperator sqlOperator4 = sqlOperator;
                if (sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator4) : sqlOperator4 != null) break block6;
                long gap = this.getOperandAsLong$1(windowExpr, 1);
                logicalWindow = new SessionGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(gap));
            }
            return logicalWindow;
        }
        throw new MatchError((Object)sqlOperator);
    }

    public abstract FieldReferenceExpression getTimeFieldReference(RexNode var1, int var2, RelDataType var3);

    private final long getOperandAsLong$1(RexCall call, int idx) {
        RexNode rexNode = call.getOperands().get(idx);
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            long l = ((BigDecimal)rexLiteral.getValue()).longValue();
            return l;
        }
        throw new TableException("Only constant window descriptors are supported");
    }

    public LogicalWindowAggregateRuleBase(String description) {
        super(RelOptRule.operand(LogicalAggregate.class, RelOptRule.operand(LogicalProject.class, RelOptRule.none()), new RelOptRuleOperand[0]), description);
    }
}

