/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.api.common.typeutils.base.LocalDateSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalTimeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class RankLikeAggFunctionBase
extends DeclarativeAggregateFunction {
    protected UnresolvedReferenceExpression sequence = ApiExpressionUtils.unresolvedRef("sequence");
    protected UnresolvedReferenceExpression[] lastValues;
    protected LogicalType[] orderKeyTypes;

    public RankLikeAggFunctionBase(LogicalType[] orderKeyTypes) {
        this.orderKeyTypes = orderKeyTypes;
        this.lastValues = new UnresolvedReferenceExpression[orderKeyTypes.length];
        for (int i = 0; i < orderKeyTypes.length; ++i) {
            this.lastValues[i] = ApiExpressionUtils.unresolvedRef("lastValue_" + i);
        }
    }

    @Override
    public int operandCount() {
        return this.orderKeyTypes.length;
    }

    @Override
    public DataType getResultType() {
        return DataTypes.BIGINT();
    }

    @Override
    public Expression[] retractExpressions() {
        throw new TableException("This function does not support retraction.");
    }

    @Override
    public Expression[] mergeExpressions() {
        throw new TableException("This function does not support merge.");
    }

    @Override
    public Expression getValueExpression() {
        return this.sequence;
    }

    protected Expression orderKeyEqualsExpression() {
        Expression[] orderKeyEquals = new Expression[this.orderKeyTypes.length];
        for (int i = 0; i < this.orderKeyTypes.length; ++i) {
            UnresolvedReferenceExpression lasValue = this.lastValues[i];
            orderKeyEquals[i] = ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(lasValue), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(i)), ExpressionBuilder.literal(true), ExpressionBuilder.literal(false)), ExpressionBuilder.equalTo(lasValue, this.operand(i)));
        }
        Optional<Expression> ret = Arrays.stream(orderKeyEquals).reduce(ExpressionBuilder::and);
        return ret.orElseGet(() -> ExpressionBuilder.literal(true));
    }

    protected Expression generateInitLiteral(LogicalType orderType) {
        Object value;
        switch (orderType.getTypeRoot()) {
            case BOOLEAN: {
                value = false;
                break;
            }
            case TINYINT: {
                value = (byte)0;
                break;
            }
            case SMALLINT: {
                value = (short)0;
                break;
            }
            case INTEGER: {
                value = 0;
                break;
            }
            case BIGINT: {
                value = 0L;
                break;
            }
            case FLOAT: {
                value = Float.valueOf(0.0f);
                break;
            }
            case DOUBLE: {
                value = 0.0;
                break;
            }
            case DECIMAL: {
                value = BigDecimal.ZERO;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value = "";
                break;
            }
            case DATE: {
                value = LocalDateSerializer.INSTANCE.createInstance();
                break;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                value = LocalTimeSerializer.INSTANCE.createInstance();
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                value = LocalDateTimeSerializer.INSTANCE.createInstance();
                break;
            }
            default: {
                throw new TableException("Unsupported type: " + orderType);
            }
        }
        return ApiExpressionUtils.valueLiteral(value, LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(orderType));
    }
}

