/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;

public abstract class MaxWithRetractAggFunction<T extends Comparable>
extends AggregateFunction<T, MaxWithRetractAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;

    @Override
    public MaxWithRetractAccumulator<T> createAccumulator() {
        MaxWithRetractAccumulator acc = new MaxWithRetractAccumulator();
        acc.max = null;
        acc.mapSize = 0L;
        acc.map = new MapView(this.getValueTypeInfo(), (TypeInformation<?>)BasicTypeInfo.LONG_TYPE_INFO);
        return acc;
    }

    public void accumulate(MaxWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Long count;
            Comparable v = (Comparable)value;
            if (acc.mapSize == 0L || ((Comparable)acc.max).compareTo(v) < 0) {
                acc.max = v;
            }
            if ((count = acc.map.get(v)) == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count + 1L)) == 0L) {
                acc.map.remove(v);
            } else {
                acc.map.put(v, count);
            }
            if (count == 1L) {
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator = acc;
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize + 1L;
            }
        }
    }

    public void retract(MaxWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Comparable v = (Comparable)value;
            Long count = acc.map.get(v);
            if (count == null) {
                count = 0L;
            }
            if ((count = Long.valueOf(count - 1L)) == 0L) {
                acc.map.remove(v);
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator = acc;
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize - 1L;
                if (acc.mapSize == 0L) {
                    acc.max = null;
                    return;
                }
                if (v.equals(acc.max)) {
                    this.updateMax(acc);
                }
            } else {
                acc.map.put(v, count);
            }
        }
    }

    private void updateMax(MaxWithRetractAccumulator<T> acc) throws Exception {
        boolean hasMax = false;
        for (Comparable key : acc.map.keys()) {
            if (hasMax && ((Comparable)acc.max).compareTo(key) >= 0) continue;
            acc.max = key;
            hasMax = true;
        }
        if (!hasMax) {
            acc.mapSize = 0L;
            acc.max = null;
        }
    }

    public void merge(MaxWithRetractAccumulator<T> acc, Iterable<MaxWithRetractAccumulator<T>> its) throws Exception {
        boolean needUpdateMax = false;
        for (MaxWithRetractAccumulator<T> a : its) {
            if (acc.mapSize == 0L || a.mapSize > 0L && a.max != null && ((Comparable)acc.max).compareTo(a.max) < 0) {
                acc.max = a.max;
            }
            for (Map.Entry entry : a.map.entries()) {
                MaxWithRetractAccumulator<T> maxWithRetractAccumulator;
                long mergedCount;
                Comparable key = (Comparable)entry.getKey();
                Long otherCount = entry.getValue();
                Long thisCount = acc.map.get(key);
                if (thisCount == null) {
                    thisCount = 0L;
                }
                if ((mergedCount = otherCount + thisCount) == 0L) {
                    acc.map.remove(key);
                    if (thisCount <= 0L) continue;
                    maxWithRetractAccumulator = acc;
                    Long.valueOf(maxWithRetractAccumulator.mapSize - 1L);
                    maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.max)) continue;
                    needUpdateMax = true;
                    continue;
                }
                if (mergedCount < 0L) {
                    acc.map.put(key, mergedCount);
                    if (thisCount <= 0L) continue;
                    maxWithRetractAccumulator = acc;
                    Long.valueOf(maxWithRetractAccumulator.mapSize - 1L);
                    maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
                    if (!key.equals(acc.max)) continue;
                    needUpdateMax = true;
                    continue;
                }
                acc.map.put(key, mergedCount);
                if (thisCount > 0L) continue;
                maxWithRetractAccumulator = acc;
                Long.valueOf(maxWithRetractAccumulator.mapSize + 1L);
                maxWithRetractAccumulator.mapSize = maxWithRetractAccumulator.mapSize;
            }
        }
        if (needUpdateMax) {
            this.updateMax(acc);
        }
    }

    public void resetAccumulator(MaxWithRetractAccumulator<T> acc) {
        acc.max = null;
        acc.mapSize = 0L;
        acc.map.clear();
    }

    @Override
    public T getValue(MaxWithRetractAccumulator<T> acc) {
        if (acc.mapSize > 0L) {
            return (T)((Comparable)acc.max);
        }
        return null;
    }

    @Override
    public TypeInformation<MaxWithRetractAccumulator<T>> getAccumulatorType() {
        PojoTypeInfo pojoType = (PojoTypeInfo)TypeExtractor.createTypeInfo(MaxWithRetractAccumulator.class);
        ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
        for (int i = 0; i < pojoType.getTotalFields(); ++i) {
            PojoField field = pojoType.getPojoFieldAt(i);
            if (field.getField().getName().equals("max")) {
                pojoFields.add(new PojoField(field.getField(), this.getValueTypeInfo()));
                continue;
            }
            pojoFields.add(field);
        }
        return new PojoTypeInfo(pojoType.getTypeClass(), pojoFields);
    }

    @Override
    public TypeInformation<T> getResultType() {
        return this.getValueTypeInfo();
    }

    protected abstract TypeInformation<T> getValueTypeInfo();

    public static class TimeMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Time> {
        private static final long serialVersionUID = 3578216747876121493L;

        @Override
        protected TypeInformation<Time> getValueTypeInfo() {
            return Types.SQL_TIME;
        }
    }

    public static class DateMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Date> {
        private static final long serialVersionUID = 7452698503075473023L;

        @Override
        protected TypeInformation<Date> getValueTypeInfo() {
            return Types.SQL_DATE;
        }
    }

    public static class TimestampMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Timestamp> {
        private static final long serialVersionUID = -7096481949093142944L;

        @Override
        protected TypeInformation<Timestamp> getValueTypeInfo() {
            return Types.SQL_TIMESTAMP;
        }
    }

    public static class StringMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<BinaryString> {
        private static final long serialVersionUID = 787528574867514796L;

        public void accumulate(MaxWithRetractAccumulator<BinaryString> acc, BinaryString value) throws Exception {
            super.accumulate(acc, value);
        }

        public void retract(MaxWithRetractAccumulator<BinaryString> acc, BinaryString value) throws Exception {
            super.retract(acc, value);
        }

        @Override
        protected TypeInformation<BinaryString> getValueTypeInfo() {
            return BinaryStringTypeInfo.INSTANCE;
        }
    }

    public static class DecimalMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Decimal> {
        private static final long serialVersionUID = 5301860581297042635L;
        private DecimalTypeInfo decimalType;

        public DecimalMaxWithRetractAggFunction(DecimalTypeInfo decimalType) {
            this.decimalType = decimalType;
        }

        public void accumulate(MaxWithRetractAccumulator<Decimal> acc, Decimal value) throws Exception {
            super.accumulate(acc, value);
        }

        public void retract(MaxWithRetractAccumulator<Decimal> acc, Decimal value) throws Exception {
            super.retract(acc, value);
        }

        @Override
        protected TypeInformation<Decimal> getValueTypeInfo() {
            return this.decimalType;
        }
    }

    public static class BooleanMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Boolean> {
        private static final long serialVersionUID = -8408715018822625309L;

        @Override
        protected TypeInformation<Boolean> getValueTypeInfo() {
            return BasicTypeInfo.BOOLEAN_TYPE_INFO;
        }
    }

    public static class DoubleMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Double> {
        private static final long serialVersionUID = -1525221057708740308L;

        @Override
        protected TypeInformation<Double> getValueTypeInfo() {
            return BasicTypeInfo.DOUBLE_TYPE_INFO;
        }
    }

    public static class FloatMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Float> {
        private static final long serialVersionUID = -1433882434794024584L;

        @Override
        protected TypeInformation<Float> getValueTypeInfo() {
            return BasicTypeInfo.FLOAT_TYPE_INFO;
        }
    }

    public static class LongMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Long> {
        private static final long serialVersionUID = 8585384188523017375L;

        @Override
        protected TypeInformation<Long> getValueTypeInfo() {
            return BasicTypeInfo.LONG_TYPE_INFO;
        }
    }

    public static class IntMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Integer> {
        private static final long serialVersionUID = 3833976566544263072L;

        @Override
        protected TypeInformation<Integer> getValueTypeInfo() {
            return BasicTypeInfo.INT_TYPE_INFO;
        }
    }

    public static class ShortMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Short> {
        private static final long serialVersionUID = 7579072678911328694L;

        @Override
        protected TypeInformation<Short> getValueTypeInfo() {
            return BasicTypeInfo.SHORT_TYPE_INFO;
        }
    }

    public static class ByteMaxWithRetractAggFunction
    extends MaxWithRetractAggFunction<Byte> {
        private static final long serialVersionUID = 7383980948808353819L;

        @Override
        protected TypeInformation<Byte> getValueTypeInfo() {
            return BasicTypeInfo.BYTE_TYPE_INFO;
        }
    }

    public static class MaxWithRetractAccumulator<T> {
        public T max;
        public Long mapSize;
        public MapView<T, Long> map;
    }
}

