/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.RankLikeAggFunctionBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;

public class DenseRankAggFunction
extends RankLikeAggFunctionBase {
    public DenseRankAggFunction(LogicalType[] orderKeyTypes) {
        super(orderKeyTypes);
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        UnresolvedReferenceExpression[] aggBufferAttrs = new UnresolvedReferenceExpression[1 + this.lastValues.length];
        aggBufferAttrs[0] = this.sequence;
        System.arraycopy(this.lastValues, 0, aggBufferAttrs, 1, this.lastValues.length);
        return aggBufferAttrs;
    }

    @Override
    public DataType[] getAggBufferTypes() {
        DataType[] aggBufferTypes2 = new DataType[1 + this.orderKeyTypes.length];
        aggBufferTypes2[0] = DataTypes.BIGINT();
        System.arraycopy(Arrays.stream(this.orderKeyTypes).map(LogicalTypeDataTypeConverter::toDataType).toArray(DataType[]::new), 0, aggBufferTypes2, 1, this.orderKeyTypes.length);
        return aggBufferTypes2;
    }

    @Override
    public Expression[] initialValuesExpressions() {
        Expression[] initExpressions = new Expression[1 + this.orderKeyTypes.length];
        initExpressions[0] = ExpressionBuilder.literal(0L);
        for (int i = 0; i < this.orderKeyTypes.length; ++i) {
            initExpressions[i + 1] = this.generateInitLiteral(this.orderKeyTypes[i]);
        }
        return initExpressions;
    }

    @Override
    public Expression[] accumulateExpressions() {
        Expression[] accExpressions = new Expression[1 + this.operands().length];
        accExpressions[0] = ExpressionBuilder.ifThenElse(this.orderKeyEqualsExpression(), this.sequence, ExpressionBuilder.plus(this.sequence, ExpressionBuilder.literal(1L)));
        UnresolvedReferenceExpression[] operands = this.operands();
        System.arraycopy(operands, 0, accExpressions, 1, operands.length);
        return accExpressions;
    }
}

