/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import scala.Option;

public class SqlAggFunctionVisitor
extends ExpressionDefaultVisitor<SqlAggFunction> {
    private static final Map<FunctionDefinition, SqlAggFunction> AGG_DEF_SQL_OPERATOR_MAPPING = new IdentityHashMap<FunctionDefinition, SqlAggFunction>();
    private final FlinkTypeFactory typeFactory;

    public SqlAggFunctionVisitor(FlinkTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public SqlAggFunction visit(CallExpression call) {
        Preconditions.checkArgument((boolean)ApiExpressionUtils.isFunctionOfKind(call, FunctionKind.AGGREGATE));
        FunctionDefinition def = call.getFunctionDefinition();
        if (AGG_DEF_SQL_OPERATOR_MAPPING.containsKey(def)) {
            return AGG_DEF_SQL_OPERATOR_MAPPING.get(def);
        }
        if (BuiltInFunctionDefinitions.DISTINCT == def) {
            Expression innerAgg = call.getChildren().get(0);
            return innerAgg.accept(this);
        }
        AggregateFunctionDefinition aggDef = (AggregateFunctionDefinition)def;
        AggregateFunction<?, ?> userDefinedAggregateFunc = aggDef.getAggregateFunction();
        if (userDefinedAggregateFunc instanceof AggregateFunction) {
            AggregateFunction<?, ?> aggFunc = userDefinedAggregateFunc;
            return new AggSqlFunction(aggFunc.functionIdentifier(), aggFunc.toString(), aggFunc, TypeConversions.fromLegacyInfoToDataType(aggDef.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType(aggDef.getAccumulatorTypeInfo()), this.typeFactory, aggFunc.requiresOver(), (Option<SqlReturnTypeInference>)Option.empty());
        }
        throw new UnsupportedOperationException("TableAggregateFunction is not supported yet!");
    }

    @Override
    protected SqlAggFunction defaultMethod(Expression expression2) {
        throw new TableException("Unexpected expression: " + expression2);
    }

    static {
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.AVG, FlinkSqlOperatorTable.AVG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.COUNT, FlinkSqlOperatorTable.COUNT);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.MAX, FlinkSqlOperatorTable.MAX);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.MIN, FlinkSqlOperatorTable.MIN);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.SUM, FlinkSqlOperatorTable.SUM);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.SUM0, FlinkSqlOperatorTable.SUM0);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.STDDEV_POP, FlinkSqlOperatorTable.STDDEV_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.STDDEV_SAMP, FlinkSqlOperatorTable.STDDEV_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.VAR_POP, FlinkSqlOperatorTable.VAR_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.VAR_SAMP, FlinkSqlOperatorTable.VAR_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put(BuiltInFunctionDefinitions.COLLECT, FlinkSqlOperatorTable.COLLECT);
    }
}

