/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.List;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;
import org.apache.flink.table.types.DataType;

public class ExpressionBuilder {
    public static Expression nullOf(DataType type) {
        return ExpressionBuilder.literal(null, type);
    }

    public static Expression literal(Object value) {
        return ApiExpressionUtils.valueLiteral(value);
    }

    public static Expression literal(Object value, DataType type) {
        return ApiExpressionUtils.valueLiteral(value, type);
    }

    public static Expression call(FunctionDefinition functionDefinition, Expression ... args) {
        return ApiExpressionUtils.unresolvedCall(functionDefinition, args);
    }

    public static Expression call(FunctionDefinition functionDefinition, List<Expression> args) {
        return ApiExpressionUtils.unresolvedCall(functionDefinition, args.toArray(new Expression[0]));
    }

    public static Expression and(Expression arg1, Expression arg2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.AND, arg1, arg2);
    }

    public static Expression or(Expression arg1, Expression arg2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.OR, arg1, arg2);
    }

    public static Expression not(Expression arg) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.NOT, arg);
    }

    public static Expression isNull(Expression input) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, input);
    }

    public static Expression ifThenElse(Expression condition, Expression ifTrue, Expression ifFalse) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.IF, condition, ifTrue, ifFalse);
    }

    public static Expression plus(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.PLUS, input1, input2);
    }

    public static Expression minus(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.MINUS, input1, input2);
    }

    public static Expression div(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.DIVIDE, input1, input2);
    }

    public static Expression times(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.TIMES, input1, input2);
    }

    public static Expression mod(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.MOD, input1, input2);
    }

    public static Expression equalTo(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, input1, input2);
    }

    public static Expression lessThan(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, input1, input2);
    }

    public static Expression greaterThan(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, input1, input2);
    }

    public static Expression cast(Expression child, Expression type) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.CAST, child, type);
    }

    public static Expression reinterpretCast(Expression child, Expression type, boolean checkOverflow) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, child, type, ExpressionBuilder.literal(checkOverflow));
    }

    public static TypeLiteralExpression typeLiteral(DataType type) {
        return ApiExpressionUtils.typeLiteral(type);
    }

    public static Expression concat(Expression input1, Expression input2) {
        return ExpressionBuilder.call((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT, input1, input2);
    }

    public static Expression throwException(String msg, DataType type) {
        return ExpressionBuilder.call((FunctionDefinition)InternalFunctionDefinitions.THROW_EXCEPTION, ExpressionBuilder.literal(msg), ExpressionBuilder.typeLiteral(type));
    }
}

