/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelOptClusterFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.catalog.FunctionCatalogOperatorTable;
import org.apache.flink.table.planner.codegen.ExpressionReducer;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;

@Internal
public class PlannerContext {
    private final RelDataTypeSystem typeSystem = new FlinkTypeSystem();
    private final FlinkTypeFactory typeFactory = new FlinkTypeFactory(this.typeSystem);
    private final TableConfig tableConfig;
    private final FunctionCatalog functionCatalog;
    private final RelOptCluster cluster;
    private final Context context;
    private final CalciteSchema rootSchema;
    private final List<RelTraitDef> traitDefs;

    public PlannerContext(TableConfig tableConfig, FunctionCatalog functionCatalog, CalciteSchema rootSchema, List<RelTraitDef> traitDefs) {
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.context = new FlinkContextImpl(tableConfig, functionCatalog);
        this.rootSchema = rootSchema;
        this.traitDefs = traitDefs;
        FrameworkConfig frameworkConfig = this.createFrameworkConfig();
        VolcanoPlanner planner = new VolcanoPlanner(frameworkConfig.getCostFactory(), frameworkConfig.getContext());
        planner.setExecutor(frameworkConfig.getExecutor());
        for (RelTraitDef traitDef : frameworkConfig.getTraitDefs()) {
            planner.addRelTraitDef(traitDef);
        }
        this.cluster = FlinkRelOptClusterFactory.create(planner, new RexBuilder(this.typeFactory));
    }

    private FrameworkConfig createFrameworkConfig() {
        return Frameworks.newConfigBuilder().defaultSchema(this.rootSchema.plus()).parserConfig(this.getSqlParserConfig()).costFactory(new FlinkCostFactory()).typeSystem(this.typeSystem).sqlToRelConverterConfig(this.getSqlToRelConverterConfig(this.getCalciteConfig(this.tableConfig))).operatorTable(this.getSqlOperatorTable(this.getCalciteConfig(this.tableConfig), this.functionCatalog)).executor(new ExpressionReducer(this.tableConfig, false)).context(this.context).traitDefs(this.traitDefs).build();
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public FlinkRelBuilder createRelBuilder(String currentCatalog, String currentDatabase) {
        FlinkCalciteCatalogReader relOptSchema = this.createCatalogReader(false, currentCatalog, currentDatabase);
        return new FlinkRelBuilder(this.context, this.cluster, relOptSchema);
    }

    public FlinkPlannerImpl createFlinkPlanner(String currentCatalog, String currentDatabase) {
        return new FlinkPlannerImpl(this.createFrameworkConfig(), isLenient -> this.createCatalogReader((boolean)isLenient, currentCatalog, currentDatabase), this.typeFactory, this.cluster);
    }

    private FlinkCalciteCatalogReader createCatalogReader(boolean lenientCaseSensitivity, String currentCatalog, String currentDatabase) {
        SqlParser.Config sqlParserConfig = this.getSqlParserConfig();
        boolean caseSensitive = lenientCaseSensitivity ? false : sqlParserConfig.caseSensitive();
        SqlParser.Config newSqlParserConfig = SqlParser.configBuilder(sqlParserConfig).setCaseSensitive(caseSensitive).build();
        SchemaPlus rootSchema = this.getRootSchema(this.rootSchema.plus());
        return new FlinkCalciteCatalogReader(CalciteSchema.from(rootSchema), Arrays.asList(Arrays.asList(currentCatalog, currentDatabase), Collections.singletonList(currentCatalog)), (RelDataTypeFactory)this.typeFactory, CalciteConfig$.MODULE$.connectionConfig(newSqlParserConfig));
    }

    private SchemaPlus getRootSchema(SchemaPlus schema) {
        if (schema.getParentSchema() == null) {
            return schema;
        }
        return this.getRootSchema(schema.getParentSchema());
    }

    private CalciteConfig getCalciteConfig(TableConfig tableConfig) {
        return TableConfigUtils.getCalciteConfig(tableConfig);
    }

    private SqlParser.Config getSqlParserConfig() {
        return JavaScalaConversionUtil.toJava(this.getCalciteConfig(this.tableConfig).getSqlParserConfig()).orElseGet(() -> SqlParser.configBuilder().setParserFactory(FlinkSqlParserImpl.FACTORY).setConformance(this.getSqlConformance()).setLex(Lex.JAVA).setIdentifierMaxLength(256).build());
    }

    private FlinkSqlConformance getSqlConformance() {
        SqlDialect sqlDialect = this.tableConfig.getSqlDialect();
        switch (sqlDialect) {
            case HIVE: {
                return FlinkSqlConformance.HIVE;
            }
            case DEFAULT: {
                return FlinkSqlConformance.DEFAULT;
            }
        }
        throw new TableException("Unsupported SQL dialect: " + (Object)((Object)sqlDialect));
    }

    private SqlToRelConverter.Config getSqlToRelConverterConfig(CalciteConfig calciteConfig) {
        return JavaScalaConversionUtil.toJava(calciteConfig.getSqlToRelConverterConfig()).orElseGet(() -> SqlToRelConverter.configBuilder().withTrimUnusedFields(false).withConvertTableAccess(false).withInSubQueryThreshold(Integer.MAX_VALUE).withExpand(false).build());
    }

    private SqlOperatorTable getSqlOperatorTable(CalciteConfig calciteConfig, FunctionCatalog functionCatalog) {
        return JavaScalaConversionUtil.toJava(calciteConfig.getSqlOperatorTable()).map(operatorTable -> {
            if (calciteConfig.replacesSqlOperatorTable()) {
                return operatorTable;
            }
            return ChainedSqlOperatorTable.of(this.getBuiltinSqlOperatorTable(functionCatalog), operatorTable);
        }).orElseGet(() -> this.getBuiltinSqlOperatorTable(functionCatalog));
    }

    private SqlOperatorTable getBuiltinSqlOperatorTable(FunctionCatalog functionCatalog) {
        return ChainedSqlOperatorTable.of(new FunctionCatalogOperatorTable(functionCatalog, this.typeFactory), FlinkSqlOperatorTable.instance());
    }
}

