/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.BatchExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.ExecNodePlanDumper$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.PlanUtil$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001=\u0011ABQ1uG\"\u0004F.\u00198oKJT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005AQ\r_3dkR|'\u000f\u0005\u0002\u001835\t\u0001D\u0003\u0002\u0004\r%\u0011!\u0004\u0007\u0002\t\u000bb,7-\u001e;pe\"AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0004d_:4\u0017n\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\t1!\u00199j\u0013\t\u0011sDA\u0006UC\ndWmQ8oM&<\u0007\"\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eL!AK\u0014\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eL!\u0001\n\n\t\u00115\u0002!\u0011!Q\u0001\n9\nabY1uC2|w-T1oC\u001e,'\u000f\u0005\u0002'_%\u0011\u0001g\n\u0002\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q)A'\u000e\u001c8qA\u0011\u0011\u0003\u0001\u0005\u0006+E\u0002\rA\u0006\u0005\u00069E\u0002\r!\b\u0005\u0006IE\u0002\r!\n\u0005\u0006[E\u0002\rA\f\u0005\u0006u\u0001!\tfO\u0001\rO\u0016$HK]1ji\u0012+gm]\u000b\u0002yA\u0019Q\b\u0011\"\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012Q!\u0011:sCf\u0004$aQ'\u0011\u0007\u0011K5*D\u0001F\u0015\t1u)\u0001\u0003qY\u0006t'B\u0001%\u000b\u0003\u001d\u0019\u0017\r\\2ji\u0016L!AS#\u0003\u0017I+G\u000e\u0016:bSR$UM\u001a\t\u0003\u00196c\u0001\u0001B\u0005Os\u0005\u0005\t\u0011!B\u0001\u001f\n\u0019q\fJ\u0019\u0012\u0005A\u001b\u0006CA\u001fR\u0013\t\u0011fHA\u0004O_RD\u0017N\\4\u0011\u0005\u0011#\u0016BA+F\u0005!\u0011V\r\u001c+sC&$\b\"B,\u0001\t#B\u0016\u0001D4fi>\u0003H/[7ju\u0016\u0014X#A-\u0011\u0005isV\"A.\u000b\u0005qk\u0016\u0001C8qi&l\u0017N_3\u000b\u0005\u0019#\u0011BA0\\\u0005%y\u0005\u000f^5nSj,'\u000f\u0003\u0004b\u0001\u0011\u0005\u0003BY\u0001\u0018iJ\fgn\u001d7bi\u0016$v.\u0012=fG:{G-\u001a)mC:$\"a\u0019@\u0011\u0007\u0011L7.D\u0001f\u0015\t1w-\u0001\u0003vi&d'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014A\u0001T5tiB\u001aA.\u001e?\u0011\t5\u0014Ho_\u0007\u0002]*\u0011q\u000e]\u0001\u0005Kb,7M\u0003\u0002r;\u0006)an\u001c3fg&\u00111O\u001c\u0002\t\u000bb,7MT8eKB\u0011A*\u001e\u0003\nm\u0002\f\t\u0011!A\u0003\u0002]\u00141a\u0018\u00133#\t\u0001\u0006\u0010\u0005\u0002>s&\u0011!P\u0010\u0002\u0004\u0003:L\bC\u0001'}\t%i\b-!A\u0001\u0002\u000b\u0005qOA\u0002`IMBaa 1A\u0002\u0005\u0005\u0011!E8qi&l\u0017N_3e%\u0016dgj\u001c3fgB1\u00111AA\n\u00033qA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f9\ta\u0001\u0010:p_Rt\u0014\"A \n\u0007\u0005Ea(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0011q\u0003\u0002\u0004'\u0016\f(bAA\t}A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u001d\u000b1A]3m\u0013\u0011\t\u0019#!\b\u0003\u000fI+GNT8eK\"9\u0011q\u0005\u0001\u0005R\u0005%\u0012a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\t\u0005-\u00121\t\t\u0005I&\fi\u0003\r\u0003\u00020\u0005}\u0002CBA\u0019\u0003s\ti$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\r!\u0017m\u001a\u0006\u0003A!IA!a\u000f\u00024\tqAK]1og\u001a|'/\\1uS>t\u0007c\u0001'\u0002@\u0011Y\u0011\u0011IA\u0013\u0003\u0003\u0005\tQ!\u0001x\u0005\ryFE\u000e\u0005\t\u0003\u000b\n)\u00031\u0001\u0002H\u0005IQ\r_3d\u001d>$Wm\u001d\t\u0005I&\fI\u0005\r\u0004\u0002L\u0005=\u0013Q\u000b\t\u0007[J\fi%a\u0015\u0011\u00071\u000by\u0005B\u0006\u0002R\u0005\r\u0013\u0011!A\u0001\u0006\u00039(aA0%iA\u0019A*!\u0016\u0005\u0017\u0005]\u00131IA\u0001\u0002\u0003\u0015\ta\u001e\u0002\u0004?\u0012*\u0004bBA.\u0001\u0011\u0005\u0013QL\u0001\bKb\u0004H.Y5o)\u0019\ty&!\u001c\u0002~A!\u0011\u0011MA4\u001d\ri\u00141M\u0005\u0004\u0003Kr\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002fyB\u0001\"a\u001c\u0002Z\u0001\u0007\u0011\u0011O\u0001\u000b_B,'/\u0019;j_:\u001c\b\u0003\u00023j\u0003g\u0002B!!\u001e\u0002z5\u0011\u0011q\u000f\u0006\u0004\u0003_2\u0011\u0002BA>\u0003o\u0012\u0011b\u00149fe\u0006$\u0018n\u001c8\t\u0011\u0005}\u0014\u0011\fa\u0001\u0003\u0003\u000b\u0001\"\u001a=uK:$W\r\u001a\t\u0004{\u0005\r\u0015bAAC}\t9!i\\8mK\u0006t\u0007")
public class BatchPlanner
extends PlannerBase {
    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public List<ExecNode<?, ?>> translateToExecNodePlan(Seq<RelNode> optimizedRelNodes) {
        List<ExecNode<?, ?>> execNodePlan = super.translateToExecNodePlan(optimizedRelNodes);
        DAGProcessContext context = new DAGProcessContext(this);
        return new DeadlockBreakupProcessor().process(execNodePlan, context);
    }

    @Override
    public List<Transformation<?>> translateToPlan(List<ExecNode<?, ?>> execNodes) {
        this.overrideEnvParallelism();
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(execNodes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchPlanner $outer;

            public final Transformation<?> apply(ExecNode<?, ?> x0$2) {
                ExecNode<?, ?> execNode = x0$2;
                if (execNode instanceof BatchExecNode) {
                    BatchExecNode batchExecNode = (BatchExecNode)execNode;
                    Transformation<T> transformation = batchExecNode.translateToPlan(this.$outer);
                    return transformation;
                }
                throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public String explain(List<Operation> operations, boolean extended) {
        Predef$.MODULE$.require(JavaConversions$.MODULE$.asScalaBuffer(operations).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "operations should not be empty";
            }
        });
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(operations).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchPlanner $outer;

            public final RelNode apply(Operation x0$3) {
                Operation operation;
                block4: {
                    RelNode relNode;
                    block3: {
                        block2: {
                            operation = x0$3;
                            if (!(operation instanceof QueryOperation)) break block2;
                            QueryOperation queryOperation = (QueryOperation)operation;
                            relNode = this.$outer.getRelBuilder().queryOperation(queryOperation).build();
                            break block3;
                        }
                        if (!(operation instanceof ModifyOperation)) break block4;
                        ModifyOperation modifyOperation = (ModifyOperation)operation;
                        relNode = this.$outer.translateToRel(modifyOperation);
                    }
                    return relNode;
                }
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.getClass().getCanonicalName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        List<ExecNode<?, ?>> execNodes = this.translateToExecNodePlan(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execNodes);
        BatchExecutor batchExecutor = new BatchExecutor(this.getExecEnv());
        batchExecutor.setTableConfig(this.getTableConfig());
        StreamGraph streamGraph = batchExecutor.generateStreamGraph(transformations, "");
        String executionPlan = PlanUtil$.MODULE$.explainStreamGraph(streamGraph);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1)new Serializable(this, sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(RelNode sink) {
                this.sb$1.append(FlinkRelOptUtil$.MODULE$.toString(sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
                return this.sb$1.append(System.lineSeparator());
            }
            {
                this.sb$1 = sb$1;
            }
        });
        sb.append("== Optimized Logical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extended ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        sb.append(ExecNodePlanDumper$.MODULE$.dagToString((Seq<ExecNode<?, ?>>)JavaConversions$.MODULE$.asScalaBuffer(execNodes), explainLevel, ExecNodePlanDumper$.MODULE$.dagToString$default$3(), ExecNodePlanDumper$.MODULE$.dagToString$default$4(), ExecNodePlanDumper$.MODULE$.dagToString$default$5(), ExecNodePlanDumper$.MODULE$.dagToString$default$6()));
        sb.append(System.lineSeparator());
        sb.append("== Physical Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(executionPlan);
        return sb.toString();
    }

    public BatchPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        super(executor, config, functionCatalog, catalogManager, false);
    }
}

