/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.catalog.FlinkSchema;
import org.apache.flink.table.planner.catalog.QueryOperationCatalogViewTable;
import org.apache.flink.table.planner.operations.DataStreamQueryOperation;
import org.apache.flink.table.planner.operations.RichTableSourceQueryOperation;
import org.apache.flink.table.planner.plan.schema.TableSinkTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.util.CatalogTableStatisticsConverter;

class DatabaseCalciteSchema
extends FlinkSchema {
    private final String databaseName;
    private final String catalogName;
    private final Catalog catalog;
    private final boolean isStreamingMode;

    public DatabaseCalciteSchema(String databaseName, String catalogName, Catalog catalog, boolean isStreamingMode) {
        this.databaseName = databaseName;
        this.catalogName = catalogName;
        this.catalog = catalog;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Table getTable(String tableName) {
        ObjectPath tablePath = new ObjectPath(this.databaseName, tableName);
        try {
            if (!this.catalog.tableExists(tablePath)) {
                return null;
            }
            CatalogBaseTable table = this.catalog.getTable(tablePath);
            if (table instanceof QueryOperationCatalogView) {
                QueryOperationCatalogView view = (QueryOperationCatalogView)table;
                QueryOperation operation = view.getQueryOperation();
                if (operation instanceof DataStreamQueryOperation) {
                    List<String> qualifiedName = Arrays.asList(this.catalogName, this.databaseName, tableName);
                    ((DataStreamQueryOperation)operation).setQualifiedName(qualifiedName);
                } else if (operation instanceof RichTableSourceQueryOperation) {
                    List<String> qualifiedName = Arrays.asList(this.catalogName, this.databaseName, tableName);
                    ((RichTableSourceQueryOperation)operation).setQualifiedName(qualifiedName);
                }
                return QueryOperationCatalogViewTable.createCalciteTable(view);
            }
            if (table instanceof ConnectorCatalogTable) {
                return this.convertConnectorTable((ConnectorCatalogTable)table, tablePath);
            }
            if (table instanceof CatalogTable) {
                return this.convertCatalogTable(tablePath, (CatalogTable)table);
            }
            throw new TableException("Unsupported table type: " + table);
        }
        catch (CatalogException | TableNotExistException e) {
            throw new TableException(String.format("A failure occurred when accessing table. Table path [%s, %s, %s]", this.catalogName, this.databaseName, tableName), e);
        }
    }

    private Table convertConnectorTable(ConnectorCatalogTable<?, ?> table, ObjectPath tablePath) throws TableNotExistException {
        if (table.getTableSource().isPresent()) {
            TableSource<?> tableSource = table.getTableSource().get();
            if (!(tableSource instanceof StreamTableSource) && !(tableSource instanceof LookupableTableSource)) {
                throw new TableException("Only StreamTableSource and LookupableTableSource can be used in Blink planner.");
            }
            if (!this.isStreamingMode && tableSource instanceof StreamTableSource && !((StreamTableSource)tableSource).isBounded()) {
                throw new TableException("Only bounded StreamTableSource can be used in batch mode.");
            }
            TableStats tableStats = TableStats.UNKNOWN;
            if (!table.isPartitioned()) {
                CatalogTableStatistics tableStatistics = this.catalog.getTableStatistics(tablePath);
                CatalogColumnStatistics columnStatistics = this.catalog.getTableColumnStatistics(tablePath);
                tableStats = CatalogTableStatisticsConverter.convertToTableStats(tableStatistics, columnStatistics);
            }
            return new TableSourceTable(tableSource, this.isStreamingMode, FlinkStatistic.builder().tableStats(tableStats).build());
        }
        Optional<TableSinkTable> tableSinkTable = table.getTableSink().map(tableSink -> new TableSinkTable(tableSink, FlinkStatistic.UNKNOWN()));
        if (tableSinkTable.isPresent()) {
            return tableSinkTable.get();
        }
        throw new TableException("Cannot convert a connector table without either source or sink.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Table convertCatalogTable(ObjectPath tablePath, CatalogTable table) {
        TableSource tableSource;
        Optional<TableFactory> tableFactory = this.catalog.getTableFactory();
        if (tableFactory.isPresent()) {
            TableFactory tf = tableFactory.get();
            if (!(tf instanceof TableSourceFactory)) throw new TableException(String.format("Cannot query a sink-only table. TableFactory provided by catalog %s must implement TableSourceFactory", this.catalog.getClass()));
            tableSource = ((TableSourceFactory)tf).createTableSource(tablePath, table);
        } else {
            tableSource = TableFactoryUtil.findAndCreateTableSource(table);
        }
        if (tableSource instanceof StreamTableSource) return new TableSourceTable(tableSource, !((StreamTableSource)tableSource).isBounded(), FlinkStatistic.UNKNOWN());
        throw new TableException("Catalog tables support only StreamTableSource and InputFormatTableSource");
    }

    @Override
    public Set<String> getTableNames() {
        try {
            return new HashSet<String>(this.catalog.listTables(this.databaseName));
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public Schema getSubSchema(String s) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

