/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.table.functions.UserFunctionsTypeHelper;
import org.apache.flink.util.Preconditions;

@Internal
public class FunctionCatalog
implements FunctionLookup {
    private final CatalogManager catalogManager;
    private final Map<String, FunctionDefinition> userFunctions = new LinkedHashMap<String, FunctionDefinition>();
    private PlannerTypeInferenceUtil plannerTypeInferenceUtil;

    public FunctionCatalog(CatalogManager catalogManager) {
        this.catalogManager = (CatalogManager)Preconditions.checkNotNull((Object)catalogManager);
    }

    public void setPlannerTypeInferenceUtil(PlannerTypeInferenceUtil plannerTypeInferenceUtil) {
        this.plannerTypeInferenceUtil = plannerTypeInferenceUtil;
    }

    public void registerScalarFunction(String name, ScalarFunction function) {
        UserFunctionsTypeHelper.validateInstantiation(function.getClass());
        this.registerFunction(name, new ScalarFunctionDefinition(name, function));
    }

    public <T> void registerTableFunction(String name, TableFunction<T> function, TypeInformation<T> resultType2) {
        UserFunctionsTypeHelper.validateNotSingleton(function.getClass());
        UserFunctionsTypeHelper.validateInstantiation(function.getClass());
        this.registerFunction(name, new TableFunctionDefinition(name, function, resultType2));
    }

    public <T, ACC> void registerAggregateFunction(String name, UserDefinedAggregateFunction<T, ACC> function, TypeInformation<T> resultType2, TypeInformation<ACC> accType) {
        FunctionDefinition definition;
        UserFunctionsTypeHelper.validateNotSingleton(function.getClass());
        UserFunctionsTypeHelper.validateInstantiation(function.getClass());
        if (function instanceof AggregateFunction) {
            definition = new AggregateFunctionDefinition(name, (AggregateFunction)function, resultType2, accType);
        } else if (function instanceof TableAggregateFunction) {
            definition = new TableAggregateFunctionDefinition(name, (TableAggregateFunction)function, resultType2, accType);
        } else {
            throw new TableException("Unknown function class: " + function.getClass());
        }
        this.registerFunction(name, definition);
    }

    public String[] getUserDefinedFunctions() {
        ArrayList<String> result = new ArrayList<String>();
        Catalog catalog = this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get();
        try {
            result.addAll(catalog.listFunctions(this.catalogManager.getCurrentDatabase()));
        }
        catch (DatabaseNotExistException databaseNotExistException) {
            // empty catch block
        }
        result.addAll(this.userFunctions.values().stream().map(Object::toString).collect(Collectors.toList()));
        return result.toArray(new String[0]);
    }

    @Override
    public Optional<FunctionLookup.Result> lookupFunction(String name) {
        String functionName = this.normalizeName(name);
        Catalog catalog = this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get();
        try {
            CatalogFunction catalogFunction = catalog.getFunction(new ObjectPath(this.catalogManager.getCurrentDatabase(), functionName));
            if (catalog.getTableFactory().isPresent() && catalog.getTableFactory().get() instanceof FunctionDefinitionFactory) {
                FunctionDefinitionFactory factory = (FunctionDefinitionFactory)catalog.getTableFactory().get();
                FunctionDefinition userCandidate = factory.createFunctionDefinition(functionName, catalogFunction);
                return Optional.of(new FunctionLookup.Result(ObjectIdentifier.of(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase(), name), userCandidate));
            }
        }
        catch (FunctionNotExistException catalogFunction) {
            // empty catch block
        }
        FunctionDefinition userCandidate = this.userFunctions.get(functionName);
        Optional<FunctionDefinition> foundDefinition = userCandidate != null ? Optional.of(userCandidate) : BuiltInFunctionDefinitions.getDefinitions().stream().filter(f -> functionName.equals(this.normalizeName(f.getName()))).findFirst().map(Function.identity());
        return foundDefinition.map(definition -> new FunctionLookup.Result(ObjectIdentifier.of(this.catalogManager.getBuiltInCatalogName(), this.catalogManager.getBuiltInDatabaseName(), name), (FunctionDefinition)definition));
    }

    @Override
    public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil() {
        Preconditions.checkNotNull((Object)this.plannerTypeInferenceUtil, (String)"A planner should have set the type inference utility.");
        return this.plannerTypeInferenceUtil;
    }

    private void registerFunction(String name, FunctionDefinition functionDefinition) {
        this.userFunctions.put(this.normalizeName(name), functionDefinition);
    }

    private String normalizeName(String name) {
        return name.toUpperCase();
    }
}

