/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;

public class RexToLixTranslator {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = Util.mapOf(RexToLixTranslator.findMethod(String.class, "toUpperCase", new Class[0]), SqlStdOperatorTable.UPPER, RexToLixTranslator.findMethod(SqlFunctions.class, "substring", String.class, Integer.TYPE, Integer.TYPE), SqlStdOperatorTable.SUBSTRING, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHARACTER_LENGTH, RexToLixTranslator.findMethod(SqlFunctions.class, "charLength", String.class), SqlStdOperatorTable.CHAR_LENGTH, RexToLixTranslator.findMethod(SqlFunctions.class, "translate3", String.class, String.class, String.class), SqlLibraryOperators.TRANSLATE3);
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final RexProgram program;
    final SqlConformance conformance;
    private final Expression root;
    private final InputGetter inputGetter;
    private final BlockBuilder list;
    private final Map<? extends RexNode, Boolean> exprNullableMap;
    private final RexToLixTranslator parent;
    private final Function1<String, InputGetter> correlates;

    private static Method findMethod(Class<?> clazz, String name, Class ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private RexToLixTranslator(RexProgram program, JavaTypeFactory typeFactory, Expression root, InputGetter inputGetter, BlockBuilder list, Map<? extends RexNode, Boolean> exprNullableMap, RexBuilder builder, SqlConformance conformance, RexToLixTranslator parent, Function1<String, InputGetter> correlates) {
        this.program = program;
        this.typeFactory = Objects.requireNonNull(typeFactory);
        this.conformance = Objects.requireNonNull(conformance);
        this.root = Objects.requireNonNull(root);
        this.inputGetter = inputGetter;
        this.list = Objects.requireNonNull(list);
        this.exprNullableMap = Objects.requireNonNull(exprNullableMap);
        this.builder = Objects.requireNonNull(builder);
        this.parent = parent;
        this.correlates = correlates;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, PhysType outputPhysType, Expression root, InputGetter inputGetter, Function1<String, InputGetter> correlates) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, root, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory), conformance, null, null).setCorrelates(correlates).translateList(program.getProjectList(), storageTypes);
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter, SqlConformance conformance) {
        ParameterExpression root = DataContext.ROOT;
        return new RexToLixTranslator(null, typeFactory, root, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory), conformance, null, null);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        Expression expression2 = this.translate0(expr, nullAs, storageType);
        expression2 = EnumUtils.enforce(storageType, expression2);
        assert (expression2 != null);
        return this.list.append("v", expression2);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert2 = null;
        block0 : switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert2 = operand;
                break;
            }
            case DATE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_DATE.method, operand);
                        break;
                    }
                    case TIMESTAMP: {
                        convert2 = Expressions.convert_(Expressions.call(BuiltInMethod.FLOOR_DIV.method, operand, Expressions.constant(86400000L)), Integer.TYPE);
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                    }
                }
                break;
            }
            case TIME: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_TIME.method, operand);
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIME.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break;
                    }
                    case TIMESTAMP: {
                        convert2 = Expressions.convert_(Expressions.call(BuiltInMethod.FLOOR_MOD.method, operand, Expressions.constant(86400000L)), Integer.TYPE);
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                    }
                }
                break;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, operand);
                        break;
                    }
                    case TIME: {
                        convert2 = Expressions.call(BuiltInMethod.TIME_STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIME_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break;
                    }
                    case TIMESTAMP: {
                        convert2 = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME_WITH_LOCAL_TIME_ZONE.method, operand));
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_TIMESTAMP.method, operand);
                        break;
                    }
                    case DATE: {
                        convert2 = Expressions.multiply(Expressions.convert_(operand, Long.TYPE), Expressions.constant(86400000L));
                        break;
                    }
                    case TIME: {
                        convert2 = Expressions.add(Expressions.multiply(Expressions.convert_(Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root), Long.TYPE), Expressions.constant(86400000L)), Expressions.convert_(operand, Long.TYPE));
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root)), operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                    }
                }
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, operand);
                        break;
                    }
                    case DATE: {
                        convert2 = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, Expressions.multiply(Expressions.convert_(operand, Long.TYPE), Expressions.constant(86400000L)))), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break;
                    }
                    case TIME: {
                        convert2 = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, Expressions.add(Expressions.multiply(Expressions.convert_(Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root), Long.TYPE), Expressions.constant(86400000L)), Expressions.convert_(operand, Long.TYPE)))), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root)), operand));
                        break;
                    }
                    case TIMESTAMP: {
                        convert2 = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert2 = Expressions.call(BuiltInMethod.STRING_TO_BOOLEAN.method, operand);
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIME: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIME_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_STRING.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_STRING.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, operand, Expressions.constant((Object)interval.timeUnitRange)));
                        break block0;
                    }
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method, operand, Expressions.constant((Object)interval.timeUnitRange), Expressions.constant(interval.getFractionalSecondPrecision(this.typeFactory.getTypeSystem()))));
                        break block0;
                    }
                    case BOOLEAN: {
                        convert2 = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.BOOLEAN_TO_STRING.method, operand));
                    }
                }
            }
        }
        if (convert2 == null) {
            convert2 = RexToLixTranslator.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        boolean pad = false;
        boolean truncate = true;
        switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case BINARY: {
                pad = true;
            }
            case VARCHAR: 
            case VARBINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: 
                    case VARBINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (SqlTypeUtil.comparePrecision(sourcePrecision, targetPrecision) <= 0) {
                            truncate = false;
                        }
                        if (SqlTypeUtil.comparePrecision(sourcePrecision, targetPrecision) < 0) break;
                        pad = false;
                    }
                }
                if (!truncate && !pad) break;
                convert2 = Expressions.call(pad ? BuiltInMethod.TRUNCATE_OR_PAD.method : BuiltInMethod.TRUNCATE.method, convert2, Expressions.constant(targetPrecision));
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert2 = Expressions.call(BuiltInMethod.ROUND_LONG.method, convert2, Expressions.constant((long)Math.pow(10.0, 3 - targetScale)));
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                switch (sourceType.getSqlTypeName().getFamily()) {
                    case NUMERIC: {
                        BigDecimal multiplier = targetType.getSqlTypeName().getEndUnit().multiplier;
                        BigDecimal divider = BigDecimal.ONE;
                        convert2 = RexImpTable.multiplyDivide(convert2, multiplier, divider);
                    }
                }
            }
        }
        return RexToLixTranslator.scaleIntervalToNumber(sourceType, targetType, convert2);
    }

    private Expression handleNullUnboxingIfNecessary(Expression input, RexImpTable.NullAs nullAs, Type storageType) {
        if (RexImpTable.NullAs.NOT_POSSIBLE == nullAs && input.type.equals(storageType)) {
            return input;
        }
        return this.handleNull(input, nullAs);
    }

    public Expression handleNull(Expression input, RexImpTable.NullAs nullAs) {
        Expression nullHandled = nullAs.handle(input);
        if (nullHandled instanceof ConstantExpression) {
            return nullHandled;
        }
        if (nullHandled == input) {
            return input;
        }
        String unboxVarName = "v_unboxed";
        if (input instanceof ParameterExpression) {
            unboxVarName = ((ParameterExpression)input).name + "_unboxed";
        }
        ParameterExpression unboxed = Expressions.parameter(nullHandled.getType(), this.list.newName(unboxVarName));
        this.list.add(Expressions.declare(16, unboxed, nullHandled));
        return unboxed;
    }

    private Expression translate0(RexNode expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (nullAs == RexImpTable.NullAs.NULL && !expr.getType().isNullable()) {
            nullAs = RexImpTable.NullAs.NOT_POSSIBLE;
        }
        switch (expr.getKind()) {
            case INPUT_REF: {
                int index = ((RexInputRef)expr).getIndex();
                Expression x = this.inputGetter.field(this.list, index, storageType);
                Expression input = this.list.append("inp" + index + "_", x);
                return this.handleNullUnboxingIfNecessary(input, nullAs, storageType);
            }
            case LOCAL_REF: {
                return this.translate(this.deref(expr), nullAs, storageType);
            }
            case LITERAL: {
                return RexToLixTranslator.translateLiteral((RexLiteral)expr, this.nullifyType(expr.getType(), this.isNullable(expr) && nullAs != RexImpTable.NullAs.NOT_POSSIBLE), this.typeFactory, nullAs);
            }
            case DYNAMIC_PARAM: {
                return this.translateParameter((RexDynamicParam)expr, nullAs, storageType);
            }
            case CORREL_VARIABLE: {
                throw new RuntimeException("Cannot translate " + expr + ". Correlated variables should always be referenced by field access");
            }
            case FIELD_ACCESS: {
                RexFieldAccess fieldAccess = (RexFieldAccess)expr;
                RexNode target = this.deref(fieldAccess.getReferenceExpr());
                int fieldIndex = fieldAccess.getField().getIndex();
                String fieldName = fieldAccess.getField().getName();
                switch (target.getKind()) {
                    case CORREL_VARIABLE: {
                        if (this.correlates == null) {
                            throw new RuntimeException("Cannot translate " + expr + " since correlate variables resolver is not defined");
                        }
                        InputGetter getter = this.correlates.apply(((RexCorrelVariable)target).getName());
                        Expression y = getter.field(this.list, fieldIndex, storageType);
                        Expression input = this.list.append("corInp" + fieldIndex + "_", y);
                        return this.handleNullUnboxingIfNecessary(input, nullAs, storageType);
                    }
                }
                RexNode rxIndex = this.builder.makeLiteral(fieldIndex, this.typeFactory.createType(Integer.TYPE), true);
                RexNode rxName = this.builder.makeLiteral(fieldName, this.typeFactory.createType((Type)((Object)String.class)), true);
                RexCall accessCall = (RexCall)this.builder.makeCall(fieldAccess.getType(), SqlStdOperatorTable.STRUCT_ACCESS, ImmutableList.of(target, rxIndex, rxName));
                return this.translateCall(accessCall, nullAs);
            }
        }
        if (expr instanceof RexCall) {
            return this.translateCall((RexCall)expr, nullAs);
        }
        throw new RuntimeException("cannot translate expression " + expr);
    }

    public RexNode deref(RexNode expr) {
        if (expr instanceof RexLocalRef) {
            RexLocalRef ref = (RexLocalRef)expr;
            RexNode e2 = this.program.getExprList().get(ref.getIndex());
            assert (ref.getType().equals(e2.getType()));
            return e2;
        }
        return expr;
    }

    private Expression translateCall(RexCall call, RexImpTable.NullAs nullAs) {
        SqlOperator operator = call.getOperator();
        CallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        return implementor.implement(this, call, nullAs);
    }

    private Expression translateParameter(RexDynamicParam expr, RexImpTable.NullAs nullAs, Type storageType) {
        if (storageType == null) {
            storageType = this.typeFactory.getJavaClass(expr.getType());
        }
        return nullAs.handle(RexToLixTranslator.convert(Expressions.call(this.root, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant("?" + expr.getIndex())), storageType));
    }

    public static Expression translateLiteral(RexLiteral literal, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        if (literal.isNull()) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw AlwaysNull.INSTANCE;
                }
            }
            return RexImpTable.NULL_EXPR;
        }
        switch (nullAs) {
            case IS_NOT_NULL: {
                return RexImpTable.TRUE_EXPR;
            }
            case IS_NULL: {
                return RexImpTable.FALSE_EXPR;
            }
        }
        Class<Number> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                BigDecimal bd = literal.getValueAs(BigDecimal.class);
                if (javaClass == Float.TYPE) {
                    return Expressions.constant(bd, javaClass);
                }
                if (javaClass == Double.TYPE) {
                    return Expressions.constant(bd, javaClass);
                }
                assert (javaClass == BigDecimal.class);
                return Expressions.new_(BigDecimal.class, new Expression[]{Expressions.constant(bd.toString())});
            }
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIME: 
            case DATE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                value2 = literal.getValueAs(Integer.class);
                javaClass = Integer.TYPE;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                value2 = literal.getValueAs(Long.class);
                javaClass = Long.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = literal.getValueAs(String.class);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(ByteString.class, new Expression[]{Expressions.constant(literal.getValueAs(byte[].class), byte[].class)});
            }
            case SYMBOL: {
                value2 = literal.getValueAs(Enum.class);
                javaClass = value2.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr(javaClass);
                Comparable value = literal.getValueAs(Comparable.class);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant(value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        return this.translateList(operandList, nullAs, EnumUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Pair<RexNode, ? extends Type> e : Pair.zip(operandList, storageTypes)) {
            list.add(this.translate((RexNode)e.left, nullAs, (Type)e.right));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, EnumUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, List<? extends Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox(translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter, Function1<String, InputGetter> correlates, SqlConformance conformance) {
        if (program.getCondition() == null) {
            return RexImpTable.TRUE_EXPR;
        }
        ParameterExpression root = DataContext.ROOT;
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, root, inputGetter, list, Collections.emptyMap(), new RexBuilder(typeFactory), conformance, null, null);
        translator = translator.setCorrelates(correlates);
        return translator.translate((RexNode)program.getCondition(), RexImpTable.NullAs.FALSE);
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        return RexToLixTranslator.convert(operand, fromType, toType);
    }

    public static Expression convert(Expression operand, Type fromType, Type toType) {
        boolean fromNumber;
        if (fromType.equals(toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of(toType);
        Primitive toBox = Primitive.ofBox(toType);
        Primitive fromBox = Primitive.ofBox(fromType);
        Primitive fromPrimitive = Primitive.of(fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, "parse" + SqlFunctions.initcap(toPrimitive.primitiveName), operand);
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, "valueOf", operand);
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_(operand, toPrimitive.primitiveClass);
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox(operand, toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, "to" + SqlFunctions.initcap(toPrimitive.primitiveName), new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.box(Expressions.unbox(operand, toBox), toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert || Primitive.of(una.getType()) == toBox) {
                    return Expressions.box(una.expression, toBox);
                }
            }
            return Expressions.box(operand, toBox);
        }
        if (fromType == Date.class) {
            if (toBox == Primitive.INT) {
                return Expressions.call(BuiltInMethod.DATE_TO_INT.method, operand);
            }
            return Expressions.convert_(operand, toType);
        }
        if (toType == Date.class) {
            if (RexToLixTranslator.isA(fromType, Primitive.INT)) {
                return Expressions.call(BuiltInMethod.INTERNAL_TO_DATE.method, operand);
            }
            return Expressions.convert_(operand, Date.class);
        }
        if (toType == Time.class) {
            if (RexToLixTranslator.isA(fromType, Primitive.INT)) {
                return Expressions.call(BuiltInMethod.INTERNAL_TO_TIME.method, operand);
            }
            return Expressions.convert_(operand, Time.class);
        }
        if (toType == Timestamp.class) {
            if (RexToLixTranslator.isA(fromType, Primitive.LONG)) {
                return Expressions.call(BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, operand);
            }
            return Expressions.convert_(operand, Timestamp.class);
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.new_(BigDecimal.class, new Expression[]{Expressions.unbox(operand, fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, new Expression[]{operand});
            }
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toBigDecimal", new Expression[]{operand}));
        }
        if (toType == String.class) {
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, "toString", operand);
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(SqlFunctions.class, "toString", new Expression[]{operand}));
            }
            return Expressions.condition(Expressions.equal(operand, RexImpTable.NULL_EXPR), RexImpTable.NULL_EXPR, Expressions.call(operand, "toString", new Expression[0]));
        }
        return Expressions.convert_(operand, toType);
    }

    static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of(fromType) == primitive || Primitive.ofBox(fromType) == primitive;
    }

    public Expression translateConstructor(List<RexNode> operandList, SqlKind kind) {
        switch (kind) {
            case MAP_VALUE_CONSTRUCTOR: {
                Expression map = this.list.append("map", Expressions.new_(LinkedHashMap.class), false);
                for (int i = 0; i < operandList.size(); ++i) {
                    RexNode key = operandList.get(i++);
                    RexNode value = operandList.get(i);
                    this.list.add(Expressions.statement(Expressions.call(map, BuiltInMethod.MAP_PUT.method, Expressions.box(this.translate(key)), Expressions.box(this.translate(value)))));
                }
                return map;
            }
            case ARRAY_VALUE_CONSTRUCTOR: {
                Expression lyst = this.list.append("list", Expressions.new_(ArrayList.class), false);
                for (RexNode value : operandList) {
                    this.list.add(Expressions.statement(Expressions.call(lyst, BuiltInMethod.COLLECTION_ADD.method, Expressions.box(this.translate(value)))));
                }
                return lyst;
            }
        }
        throw new AssertionError((Object)("unexpected: " + (Object)((Object)kind)));
    }

    public boolean isNullable(RexNode e) {
        if (!e.getType().isNullable()) {
            return false;
        }
        Boolean b = this.isKnownNullable(e);
        return b == null || b != false;
    }

    protected Boolean isKnownNullable(RexNode node) {
        Boolean nullable;
        if (!this.exprNullableMap.isEmpty() && (nullable = this.exprNullableMap.get(node)) != null) {
            return nullable;
        }
        return this.parent == null ? null : this.parent.isKnownNullable(node);
    }

    public RexToLixTranslator setNullable(RexNode e, boolean nullable) {
        return this.setNullable(Collections.singletonMap(e, nullable));
    }

    public RexToLixTranslator setNullable(Map<? extends RexNode, Boolean> nullable) {
        if (nullable == null || nullable.isEmpty()) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, nullable, this.builder, this.conformance, this, this.correlates);
    }

    public RexToLixTranslator setBlock(BlockBuilder block) {
        if (block == this.list) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, block, ImmutableMap.of(), this.builder, this.conformance, this, this.correlates);
    }

    public RexToLixTranslator setCorrelates(Function1<String, InputGetter> correlates) {
        if (this.correlates == correlates) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, Collections.emptyMap(), this.builder, this.conformance, this, correlates);
    }

    private RexToLixTranslator withConformance(SqlConformance conformance) {
        if (conformance == this.conformance) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, Collections.emptyMap(), this.builder, conformance, this, this.correlates);
    }

    public RelDataType nullifyType(RelDataType type, boolean nullable) {
        Primitive primitive;
        if (!nullable && (primitive = this.javaPrimitive(type)) != null) {
            return this.typeFactory.createJavaType(primitive.primitiveClass);
        }
        return this.typeFactory.createTypeWithNullability(type, nullable);
    }

    private Primitive javaPrimitive(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return Primitive.ofBox(((RelDataTypeFactoryImpl.JavaType)type).getJavaClass());
        }
        return null;
    }

    public Expression getRoot() {
        return this.root;
    }

    private static Expression scaleIntervalToNumber(RelDataType sourceType, RelDataType targetType, Expression operand) {
        switch (targetType.getSqlTypeName().getFamily()) {
            case NUMERIC: {
                switch (sourceType.getSqlTypeName()) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        BigDecimal multiplier = BigDecimal.ONE;
                        BigDecimal divider = sourceType.getSqlTypeName().getEndUnit().multiplier;
                        return RexImpTable.multiplyDivide(operand, multiplier, divider);
                    }
                }
            }
        }
        return operand;
    }

    static class AlwaysNull
    extends ControlFlowException {
        public static final AlwaysNull INSTANCE = new AlwaysNull();

        private AlwaysNull() {
        }
    }

    public static class InputGetterImpl
    implements InputGetter {
        private List<Pair<Expression, PhysType>> inputs;

        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            int offset = 0;
            for (Pair<Expression, PhysType> input : this.inputs) {
                PhysType physType = (PhysType)input.right;
                int fieldCount = physType.getRowType().getFieldCount();
                if (index >= offset + fieldCount) {
                    offset += fieldCount;
                    continue;
                }
                Expression left = list.append("current", (Expression)input.left);
                return physType.fieldReference(left, index - offset, storageType);
            }
            throw new IllegalArgumentException("Unable to find field #" + index);
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, Type var3);
    }
}

