/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.python.util;

import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.operator.batch.source.MemSourceBatchOp;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import org.apache.flink.ml.api.misc.param.ParamInfo;
import org.apache.flink.ml.api.misc.param.ParamInfoFactory;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.types.Row;

public class InMemorySourceBatchOp
extends BatchOperator<InMemorySourceBatchOp> {
    static final ParamInfo<String> DATA = ParamInfoFactory.createParamInfo((String)"data", String.class).setDescription("the json format of data").setRequired().build();
    static final ParamInfo<String[]> COL_NAMES = ParamInfoFactory.createParamInfo((String)"colNames", String[].class).setDescription("the name list of columns").setRequired().build();
    static final ParamInfo<String[]> COL_TYPES = ParamInfoFactory.createParamInfo((String)"colTypes", String[].class).setDescription("the type list of columns, each should be one of {\"BOOLEAN\", \"DOUBLE\", \"LONG\", \"STRING\"}").build();

    public InMemorySourceBatchOp(Params params) {
        super(params);
        String dataJson = (String)params.get(DATA);
        String[] colNames = (String[])params.get(COL_NAMES);
        JsonArray data = new JsonParser().parse(dataJson).getAsJsonArray();
        ArrayList<Row> rows = new ArrayList<Row>(data.size());
        if (params.contains(COL_TYPES)) {
            String[] colTypes = (String[])params.get(COL_TYPES);
            for (int i = 0; i < data.size(); ++i) {
                JsonArray a = data.get(i).getAsJsonArray();
                Row r = this.makeRow(a, colTypes);
                rows.add(r);
            }
        } else {
            for (int i = 0; i < data.size(); ++i) {
                JsonArray a = data.get(i).getAsJsonArray();
                Row r = this.makeRow(a);
                rows.add(r);
            }
            this.setOutputTable(((MemSourceBatchOp)new MemSourceBatchOp(rows, colNames).setMLEnvironmentId(this.getMLEnvironmentId())).getOutputTable());
        }
        this.setOutputTable(((MemSourceBatchOp)new MemSourceBatchOp(rows, colNames).setMLEnvironmentId(this.getMLEnvironmentId())).getOutputTable());
    }

    Row makeRow(JsonArray a) {
        Object[] g = new Object[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            JsonElement e = a.get(i);
            if (e.isJsonNull()) {
                g[i] = null;
                continue;
            }
            if (e.isJsonPrimitive()) {
                JsonPrimitive x = e.getAsJsonPrimitive();
                if (x.isNumber()) {
                    g[i] = x.getAsDouble();
                    continue;
                }
                if (x.isBoolean()) {
                    g[i] = x.getAsBoolean();
                    continue;
                }
                if (x.isString()) {
                    g[i] = x.getAsString();
                    continue;
                }
                g[i] = x.getAsString();
                continue;
            }
            g[i] = e.getAsString();
        }
        return Row.of((Object[])g);
    }

    Row makeRow(JsonArray a, String[] types) {
        Object[] g = new Object[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            JsonElement e = a.get(i);
            g[i] = this.cast(a.get(i), types[i]);
        }
        return Row.of((Object[])g);
    }

    Object cast(JsonElement e, String type) {
        switch (type.toUpperCase()) {
            case "BOOL": 
            case "BOOLEAN": {
                return e.getAsBoolean();
            }
            case "BYTE": {
                return e.getAsByte();
            }
            case "SHORT": {
                return e.getAsShort();
            }
            case "INT": 
            case "INTEGER": {
                return e.getAsInt();
            }
            case "LONG": 
            case "BIGINT": {
                return e.getAsLong();
            }
            case "FLOAT": {
                return Float.valueOf(e.getAsFloat());
            }
            case "DOUBLE": {
                return e.getAsDouble();
            }
            case "STRING": {
                return e.getAsString();
            }
            case "CHAR": 
            case "CHARACTER": {
                return Character.valueOf(e.getAsCharacter());
            }
            case "BIGDECIMAL": {
                return e.getAsBigDecimal();
            }
            case "BIGINTEGER": {
                return e.getAsBigInteger();
            }
        }
        throw new RuntimeException("Not support type: " + type);
    }

    public InMemorySourceBatchOp linkFrom(BatchOperator<?> ... inputs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

