/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.OldCsvValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sinks.CsvTableSink;

@Internal
public abstract class CsvTableSinkFactoryBase
implements TableFactory {
    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "filesystem");
        context.put("format.type", "csv");
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return context;
    }

    @Override
    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.path");
        properties.add("format.fields.#.type");
        properties.add("format.fields.#.name");
        properties.add("format.field-delimiter");
        properties.add("connector.path");
        properties.add("schema.#.type");
        properties.add("schema.#.name");
        return properties;
    }

    protected CsvTableSink createTableSink(Boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new OldCsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        TableSchema formatSchema = params.getTableSchema("format.fields");
        TableSchema tableSchema = params.getTableSchema("schema");
        if (!formatSchema.equals(tableSchema)) {
            throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSink.");
        }
        String path = params.getString("connector.path");
        String fieldDelimiter = params.getOptionalString("format.field-delimiter").orElse(",");
        CsvTableSink csvTableSink = new CsvTableSink(path, fieldDelimiter);
        return (CsvTableSink)csvTableSink.configure(formatSchema.getFieldNames(), formatSchema.getFieldTypes());
    }
}

