/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.runtime.RowComparator;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.cep.CEP;
import org.apache.flink.cep.PatternStream;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.codegen.MatchCodeGenerator;
import org.apache.flink.table.codegen.MatchCodeGenerator$;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.nodes.CommonMatchRecognize;
import org.apache.flink.table.plan.nodes.CommonMatchRecognize$class;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel$class;
import org.apache.flink.table.plan.nodes.datastream.PatternVisitor;
import org.apache.flink.table.plan.rules.datastream.DataStreamRetractionRules$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.RowKeySelector;
import org.apache.flink.table.runtime.RowtimeProcessFunction;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.table.runtime.conversion.CRowToRowMapFunction;
import org.apache.flink.table.runtime.match.EventRowComparator;
import org.apache.flink.table.runtime.match.PatternProcessFunctionRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u0001\u0003\u0001E\u0011q\u0002R1uCN#(/Z1n\u001b\u0006$8\r\u001b\u0006\u0003\u0007\u0011\t!\u0002Z1uCN$(/Z1n\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u001b=A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0004e\u0016d'BA\f\r\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!\u0007\u000b\u0003\u0013MKgn\u001a7f%\u0016d\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005Q\u0019u.\\7p]6\u000bGo\u00195SK\u000e|wM\\5{KB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\u000e\t\u0006$\u0018m\u0015;sK\u0006l'+\u001a7\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nqa\u00197vgR,'\u000f\u0005\u0002&O5\taE\u0003\u0002\b-%\u0011\u0001F\n\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011)\u0002!\u0011!Q\u0001\n-\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003K1J!!\f\u0014\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I\u0011N\u001c9vi:{G-\u001a\t\u0003'EJ!A\r\u000b\u0003\u000fI+GNT8eK\"AA\u0007\u0001B\u0001B\u0003%Q'\u0001\u0007m_\u001eL7-\u00197NCR\u001c\u0007\u000e\u0005\u00027s5\tqG\u0003\u00029\r\u00059An\\4jG\u0006d\u0017B\u0001\u001e8\u00059i\u0015\r^2i%\u0016\u001cwn\u001a8ju\u0016D\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0007g\u000eDW-\\1\u0011\u0005y\u0002U\"A \u000b\u0005q2\u0011BA!@\u0005%\u0011vn^*dQ\u0016l\u0017\r\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0003-Ig\u000e];u'\u000eDW-\\1\t\u000b\u0015\u0003A\u0011\u0001$\u0002\rqJg.\u001b;?)\u001d9\u0005*\u0013&L\u00196\u0003\"a\b\u0001\t\u000b\r\"\u0005\u0019\u0001\u0013\t\u000b)\"\u0005\u0019A\u0016\t\u000b=\"\u0005\u0019\u0001\u0019\t\u000bQ\"\u0005\u0019A\u001b\t\u000bq\"\u0005\u0019A\u001f\t\u000b\r#\u0005\u0019A\u001f\t\u000b=\u0003A\u0011\t)\u000219,W\rZ:Va\u0012\fG/Z:BgJ+GO]1di&|g.F\u0001R!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0001\u0005BA\u000b1cY8ogVlWm\u001d*fiJ\f7\r^5p]NDQA\u0017\u0001\u0005Bm\u000bQ\u0002Z3sSZ,'k\\<UsB,G#\u0001/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}#\u0012\u0001\u0002;za\u0016L!!\u00190\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\u0006G\u0002!\t\u0005Z\u0001\u0005G>\u0004\u0018\u0010F\u00021K\u001aDQA\u000b2A\u0002-BQa\u001a2A\u0002!\fa!\u001b8qkR\u001c\bcA5oa5\t!N\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\t1K7\u000f\u001e\u0005\u0006c\u0002!\tE]\u0001\ti>\u001cFO]5oOR\t1\u000f\u0005\u0002uo:\u0011!+^\u0005\u0003mN\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011ao\u0015\u0005\u0006w\u0002!\t\u0005`\u0001\rKb\u0004H.Y5o)\u0016\u0014Xn\u001d\u000b\u0004{\u0006\u0005\u0001CA\n\u007f\u0013\tyHCA\u0005SK2<&/\u001b;fe\"1\u00111\u0001>A\u0002u\f!\u0001]<\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n\u0005\u0011BO]1og2\fG/\u001a+j[\u0016\u0014u.\u001e8e)\u0011\tY!a\t\u0011\t\u00055\u0011qD\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!A/[7f\u0015\u0011\t)\"a\u0006\u0002\u0013]Lg\u000eZ8xS:<'\u0002BA\r\u00037\t1!\u00199j\u0015\r\tiBC\u0001\ngR\u0014X-Y7j]\u001eLA!!\t\u0002\u0010\t!A+[7f\u0011!\t)#!\u0002A\u0002\u0005\u001d\u0012\u0001C5oi\u0016\u0014h/\u00197\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\u0017\u0003\r\u0011X\r_\u0005\u0005\u0003c\tYCA\u0004SKbtu\u000eZ3\t\u0011\u0005U\u0002\u0001\"\u0001\u000b\u0003o\t\u0001\u0003\u001e:b]Nd\u0017\r^3QCR$XM\u001d8\u0015\r\u0005e\u00121OAA!\u001d\u0011\u00161HA \u00037J1!!\u0010T\u0005\u0019!V\u000f\u001d7feAA\u0011\u0011IA&\u0003\u001f\ny%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u001d\u0001\u0018\r\u001e;fe:T1!!\u0013\u000b\u0003\r\u0019W\r]\u0005\u0005\u0003\u001b\n\u0019EA\u0004QCR$XM\u001d8\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016\u000b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tI&a\u0015\u0003\u0007I{w\u000fE\u0003\u0002^\u000554O\u0004\u0003\u0002`\u0005%d\u0002BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015\u0004#\u0001\u0004=e>|GOP\u0005\u0002)&\u0019\u00111N*\u0002\u000fA\f7m[1hK&!\u0011qNA9\u0005!IE/\u001a:bE2,'bAA6'\"A\u0011QOA\u001a\u0001\u0004\t9(\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003s\ni(\u0004\u0002\u0002|)\u0019\u0011\u0011\u0004\u0005\n\t\u0005}\u00141\u0010\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005\u0002\u0004\u0006M\u0002\u0019AAC\u00035Ig\u000e];u)f\u0004X-\u00138g_B1\u0011qQAJ\u0003\u001fj!!!#\u000b\t\u0005-\u0015QR\u0001\tif\u0004X-\u001b8g_*!\u0011qRAI\u0003\u0019\u0019w.\\7p]*\u0019\u0011\u0011\u0004\u0006\n\t\u0005U\u0015\u0011\u0012\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]\"\"\u00111GAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAP\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016Q\u0014\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0007bBAT\u0001\u0011\u0005\u0013\u0011V\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R1\u00111VAb\u0003#\u0004b!!,\u00022\u0006UVBAAX\u0015\r\u0019\u0011qC\u0005\u0005\u0003g\u000byK\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004B!a.\u0002@6\u0011\u0011\u0011\u0018\u0006\u0005\u0003+\nYLC\u0002\u0002>\"\tqA];oi&lW-\u0003\u0003\u0002B\u0006e&\u0001B\"S_^D\u0001\"!2\u0002&\u0002\u0007\u0011qY\u0001\ba2\fgN\\3s!\u0011\tI-!4\u000e\u0005\u0005-'bAAc\u0011%!\u0011qZAf\u00055\u0019FO]3b[Bc\u0017M\u001c8fe\"A\u00111[AS\u0001\u0004\t).A\u0006rk\u0016\u0014\u0018pQ8oM&<\u0007\u0003BA=\u0003/LA!!7\u0002|\t\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\u0006qAO]1og2\fG/Z(sI\u0016\u0014H\u0003CAq\u0003s\fY0a@\u0011\u000fI\u000bY$a+\u0002dB)!+!:\u0002j&\u0019\u0011q]*\u0003\r=\u0003H/[8o!\u0011\tY/!>\u000e\u0005\u00055(\u0002BA_\u0003_TA!!=\u0002t\u0006IA/\u001f9fkRLGn\u001d\u0006\u0004[\u0006E\u0015\u0002BA|\u0003[\u0014QBU8x\u0007>l\u0007/\u0019:bi>\u0014\b\u0002CAc\u00037\u0004\r!a2\t\u0011\u0005u\u00181\u001ca\u0001\u0003W\u000b\u0011b\u0019:po&s\u0007/\u001e;\t\u0011\t\u0005\u00111\u001ca\u0001\u0005\u0007\t\u0011b\u001c:eKJ\\U-_:\u0011\u0007M\u0011)!C\u0002\u0003\bQ\u0011ABU3m\u0007>dG.\u0019;j_:DqAa\u0003\u0001\t\u0013\u0011i!A\tbaBd\u0017\u0010U1si&$\u0018n\u001c8j]\u001e$bAa\u0004\u0003\u0012\t]\u0001CBAW\u0003c\u000by\u0005\u0003\u0005\u0003\u0014\t%\u0001\u0019\u0001B\u000b\u00035\u0001\u0018M\u001d;ji&|gnS3zgB!\u0011N\\A\u0014\u0011!\u0011IB!\u0003A\u0002\t=\u0011aB5oaV$Hi\u001d")
public class DataStreamMatch
extends SingleRel
implements CommonMatchRecognize,
DataStreamRel {
    private final RelOptCluster cluster;
    private final MatchRecognize logicalMatch;
    private final RowSchema schema;
    private final RowSchema inputSchema;

    @Override
    public boolean producesUpdates() {
        return DataStreamRel$class.producesUpdates(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel$class.producesRetractions(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode$class.estimateRowSize(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode$class.estimateDataTypeSize(this, t);
    }

    @Override
    public String matchToString(MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression2) {
        return CommonMatchRecognize$class.matchToString(this, logicalMatch, fieldNames, expression2);
    }

    @Override
    public RelWriter explainMatch(RelWriter pw, MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression2) {
        return CommonMatchRecognize$class.explainMatch(this, pw, logicalMatch, fieldNames, expression2);
    }

    @Override
    public boolean needsUpdatesAsRetraction() {
        return true;
    }

    @Override
    public boolean consumesRetractions() {
        return true;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataStreamMatch(this.cluster, traitSet, inputs.get(0), this.logicalMatch, this.schema, this.inputSchema);
    }

    @Override
    public String toString() {
        return this.matchToString(this.logicalMatch, this.inputSchema.fieldNames(), (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataStreamMatch $outer;

            public final String apply(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
                return this.$outer.getExpressionString(expr, inFields, localExprsTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.explainMatch(super.explainTerms(pw), this.logicalMatch, this.inputSchema.fieldNames(), (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataStreamMatch $outer;

            public final String apply(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
                return this.$outer.getExpressionString(expr, inFields, localExprsTable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Time translateTimeBound(RexNode interval) {
        RexNode rexNode = interval;
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
            SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
            if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) {
                Time time = Time.milliseconds((long)Predef$.MODULE$.Long2long(rexLiteral.getValueAs(Long.class)));
                return time;
            }
        }
        throw new TableException("Only constant intervals with millisecond resolution are supported as time constraints of patterns.");
    }

    @VisibleForTesting
    public Tuple2<Pattern<Row, Row>, Iterable<String>> translatePattern(TableConfig config, TypeInformation<Row> inputTypeInfo) {
        Pattern<Row, Row> pattern;
        PatternVisitor patternVisitor = new PatternVisitor(config, inputTypeInfo, this.logicalMatch);
        if (this.logicalMatch.interval() == null) {
            pattern = this.logicalMatch.pattern().accept(patternVisitor);
        } else {
            Time interval = this.translateTimeBound(this.logicalMatch.interval());
            pattern = this.logicalMatch.pattern().accept(patternVisitor).within(interval);
        }
        Pattern<Row, Row> cepPattern = pattern;
        return new Tuple2(cepPattern, patternVisitor.names());
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner, StreamQueryConfig queryConfig) {
        boolean inputIsAccRetract = DataStreamRetractionRules$.MODULE$.isAccRetract(this.getInput());
        TableConfig config = planner.getConfig();
        TypeInformation<Row> inputTypeInfo = this.inputSchema.typeInfo();
        DataStream<CRow> crowInput = ((DataStreamRel)this.getInput()).translateToPlan(planner, queryConfig);
        if (inputIsAccRetract) {
            throw new TableException("Retraction on match recognize is not supported. Note: Match recognize should not follow a non-windowed GroupBy aggregation.");
        }
        Tuple2<DataStream<CRow>, Option<RowComparator>> tuple2 = this.translateOrder(planner, crowInput, this.logicalMatch.orderKeys());
        if (tuple2 != null) {
            Tuple2 tuple22;
            DataStream timestampedInput = (DataStream)tuple2._1();
            Option rowComparator = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)timestampedInput, (Object)rowComparator);
            DataStream timestampedInput2 = (DataStream)tuple23._1();
            Option rowComparator2 = (Option)tuple23._2();
            Tuple2<Pattern<Row, Row>, Iterable<String>> tuple24 = this.translatePattern(config, inputTypeInfo);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Pattern cepPattern = (Pattern)tuple24._1();
                Iterable patternNames = (Iterable)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)cepPattern, (Object)patternNames);
                Pattern cepPattern2 = (Pattern)tuple26._1();
                Iterable patternNames2 = (Iterable)tuple26._2();
                if (NFACompiler.canProduceEmptyMatches(cepPattern2)) {
                    throw new TableException("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
                }
                if (cepPattern2.getQuantifier().hasProperty(Quantifier.QuantifierProperty.GREEDY)) {
                    throw new TableException("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
                }
                SingleOutputStreamOperator inputDS = timestampedInput2.map((MapFunction)new CRowToRowMapFunction()).setParallelism(timestampedInput2.getParallelism()).name("ConvertToRow").returns(inputTypeInfo);
                List<RexNode> partitionKeys = this.logicalMatch.partitionKeys();
                DataStream<Row> partitionedStream = this.applyPartitioning(partitionKeys, (DataStream<Row>)inputDS);
                PatternStream<Row> patternStream = rowComparator2.isDefined() ? CEP.pattern(partitionedStream, cepPattern2, new EventRowComparator((TypeComparator<Row>)((TypeComparator)rowComparator2.get()))) : CEP.pattern(partitionedStream, cepPattern2);
                ImmutableMap<String, RexNode> measures = this.logicalMatch.measures();
                CRowTypeInfo outTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
                if (this.logicalMatch.allRows()) {
                    throw new TableException("All rows per match mode is not supported yet.");
                }
                MatchCodeGenerator generator = new MatchCodeGenerator(config, inputTypeInfo, (Seq<String>)patternNames2.toSeq(), MatchCodeGenerator$.MODULE$.$lessinit$greater$default$4());
                PatternProcessFunctionRunner patternSelectFunction = generator.generateOneRowPerMatchExpression(this.schema, partitionKeys, measures);
                return patternStream.process(patternSelectFunction, outTypeInfo);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<DataStream<CRow>, Option<RowComparator>> translateOrder(StreamPlanner planner, DataStream<CRow> crowInput, RelCollation orderKeys) {
        if (orderKeys.getFieldCollations().size() == 0) {
            throw new ValidationException("You must specify either rowtime or proctime for order by.");
        }
        RelDataTypeField timeOrderField = SortUtil$.MODULE$.getFirstSortField(orderKeys, this.inputSchema.relDataType());
        if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(timeOrderField.getType())) {
            RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(orderKeys);
            RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
            if (!(direction != null ? !((Object)((Object)direction)).equals((Object)direction2) : direction2 != null)) {
                None$ rowComparator = orderKeys.getFieldCollations().size() > 1 ? new Some((Object)SortUtil$.MODULE$.createRowComparator(this.inputSchema.relDataType(), (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orderKeys.getFieldCollations()).asScala()).tail()), planner.getExecutionEnvironment().getConfig())) : None$.MODULE$;
                RelDataType relDataType = timeOrderField.getType();
                Tuple2 tuple2 = FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeOrderField.getType()) ? new Tuple2((Object)crowInput.process((ProcessFunction)new RowtimeProcessFunction(timeOrderField.getIndex(), (TypeInformation<CRow>)CRowTypeInfo$.MODULE$.apply(this.inputSchema.typeInfo()))).setParallelism(crowInput.getParallelism()), (Object)rowComparator) : new Tuple2(crowInput, (Object)rowComparator);
                return tuple2;
            }
            throw new ValidationException("Primary sort order of a streaming table must be ascending on time.");
        }
        throw new ValidationException("You must specify either rowtime or proctime for order by as the first one.");
    }

    private DataStream<Row> applyPartitioning(List<RexNode> partitionKeys, DataStream<Row> inputDs) {
        KeyedStream keyedStream;
        if (partitionKeys.size() > 0) {
            int[] keys = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionKeys).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(RexNode x0$1) {
                    RexNode rexNode = x0$1;
                    if (rexNode instanceof RexInputRef) {
                        RexInputRef rexInputRef = (RexInputRef)rexNode;
                        int n = rexInputRef.getIndex();
                        return n;
                    }
                    throw new MatchError((Object)rexNode);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            RowKeySelector keySelector = new RowKeySelector(keys, this.inputSchema.projectedTypeInfo(keys));
            keyedStream = inputDs.keyBy((KeySelector)keySelector);
        } else {
            keyedStream = inputDs;
        }
        return keyedStream;
    }

    public DataStreamMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, MatchRecognize logicalMatch, RowSchema schema, RowSchema inputSchema) {
        this.cluster = cluster;
        this.logicalMatch = logicalMatch;
        this.schema = schema;
        this.inputSchema = inputSchema;
        super(cluster, traitSet, inputNode);
        CommonMatchRecognize$class.$init$(this);
        FlinkRelNode$class.$init$(this);
        DataStreamRel$class.$init$(this);
    }
}

