/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.AmbiguousTableFactoryException;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.factories.ComponentFactory;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryService;

@Internal
public class ComponentFactoryService {
    public static <T extends ComponentFactory> T find(Class<T> factoryClass, Map<String, String> propertyMap) {
        List<T> all = TableFactoryService.findAll(factoryClass, propertyMap);
        List filtered = all.stream().filter(factory -> {
            Map<String, String> optionalContext = factory.optionalContext();
            return optionalContext.entrySet().stream().allMatch(entry -> {
                String property = (String)propertyMap.get(entry.getKey());
                if (property != null) {
                    return property.equals(entry.getValue());
                }
                return true;
            });
        }).collect(Collectors.toList());
        if (filtered.size() > 1) {
            throw new AmbiguousTableFactoryException(filtered, factoryClass, new ArrayList<TableFactory>(all), propertyMap);
        }
        if (filtered.isEmpty()) {
            throw new NoMatchingTableFactoryException("No factory supports the additional filters.", factoryClass, new ArrayList<TableFactory>(all), propertyMap);
        }
        return (T)((ComponentFactory)filtered.get(0));
    }
}

