/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.Schema;
import org.apache.flink.table.descriptors.SchematicDescriptor;
import org.apache.flink.table.descriptors.TableDescriptor;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class ConnectTableDescriptor
extends TableDescriptor<ConnectTableDescriptor>
implements SchematicDescriptor<ConnectTableDescriptor> {
    private final TableEnvironment tableEnv;
    @Nullable
    private Schema schemaDescriptor;

    public ConnectTableDescriptor(TableEnvironment tableEnv, ConnectorDescriptor connectorDescriptor) {
        super(connectorDescriptor);
        this.tableEnv = tableEnv;
    }

    @Override
    public ConnectTableDescriptor withSchema(Schema schema) {
        this.schemaDescriptor = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this;
    }

    public void registerTableSource(String name) {
        Preconditions.checkNotNull((Object)name);
        TableSource tableSource = TableFactoryUtil.findAndCreateTableSource(this);
        this.tableEnv.registerTableSource(name, tableSource);
    }

    public void registerTableSink(String name) {
        Preconditions.checkNotNull((Object)name);
        TableSink tableSink = TableFactoryUtil.findAndCreateTableSink(this);
        this.tableEnv.registerTableSink(name, tableSink);
    }

    public void registerTableSourceAndSink(String name) {
        this.registerTableSource(name);
        this.registerTableSink(name);
    }

    @Override
    protected Map<String, String> additionalProperties() {
        if (this.schemaDescriptor != null) {
            return this.schemaDescriptor.toProperties();
        }
        return Collections.emptyMap();
    }
}

