/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.slf4j.Logger;
import scala.None$;
import scala.Option;
import scala.Some;

public final class ExternalTableUtil$
implements Logging {
    public static final ExternalTableUtil$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExternalTableUtil$();
    }

    private Logger LOG$lzycompute() {
        ExternalTableUtil$ externalTableUtil$ = this;
        synchronized (externalTableUtil$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public <T> Option<TableSourceTable<T>> fromExternalCatalogTable(boolean isStreamingMode, ExternalCatalogTable externalTable) {
        FlinkStatistic statistics = new FlinkStatistic(JavaScalaConversionUtil$.MODULE$.toScala(externalTable.getTableStats()));
        return externalTable.isTableSource() ? new Some(this.createTableSource(isStreamingMode, externalTable, statistics)) : None$.MODULE$;
    }

    private <T> TableSourceTable<T> createTableSource(boolean isStreamingMode, ExternalCatalogTable externalTable, FlinkStatistic statistics) {
        if (this.isModeCompatibleWithTable(isStreamingMode, externalTable)) {
            TableSource source = TableFactoryUtil.findAndCreateTableSource(externalTable);
            return new TableSourceTable(source, isStreamingMode, statistics);
        }
        throw new ValidationException("External catalog table does not support the current environment for a table source.");
    }

    private <T> boolean isModeCompatibleWithTable(boolean isStreamingMode, ExternalCatalogTable externalTable) {
        return !isStreamingMode && externalTable.isBatchTable() || isStreamingMode && externalTable.isStreamTable();
    }

    private ExternalTableUtil$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

