/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.descriptors.ConnectTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.util.StringUtils;

@Internal
public class TableEnvironmentImpl
implements TableEnvironment {
    private static final boolean IS_STREAM_TABLE = true;
    private final CatalogManager catalogManager;
    private final OperationTreeBuilder operationTreeBuilder;
    private final List<ModifyOperation> bufferedModifyOperations = new ArrayList<ModifyOperation>();
    protected final TableConfig tableConfig;
    protected final Executor execEnv;
    protected final FunctionCatalog functionCatalog;
    protected final Planner planner;

    protected TableEnvironmentImpl(CatalogManager catalogManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode) {
        this.catalogManager = catalogManager;
        this.execEnv = executor;
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
        this.operationTreeBuilder = OperationTreeBuilder.create(functionCatalog, path -> {
            Optional<CatalogQueryOperation> catalogTableOperation = this.scanInternal(path);
            return catalogTableOperation.map(tableOperation -> new TableReferenceExpression(path, (QueryOperation)tableOperation));
        }, isStreamingMode);
    }

    public static TableEnvironmentImpl create(EnvironmentSettings settings) {
        CatalogManager catalogManager = new CatalogManager(settings.getBuiltInCatalogName(), new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName()));
        FunctionCatalog functionCatalog = new FunctionCatalog(catalogManager);
        Map<String, String> executorProperties = settings.toExecutorProperties();
        Executor executor = ComponentFactoryService.find(ExecutorFactory.class, executorProperties).create(executorProperties);
        TableConfig tableConfig = new TableConfig();
        Map<String, String> plannerProperties = settings.toPlannerProperties();
        Planner planner = ComponentFactoryService.find(PlannerFactory.class, plannerProperties).create(plannerProperties, executor, tableConfig, functionCatalog, catalogManager);
        return new TableEnvironmentImpl(catalogManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode());
    }

    @VisibleForTesting
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public Table fromTableSource(TableSource<?> source) {
        return this.createTable(new TableSourceQueryOperation(source, false));
    }

    @Override
    public void registerExternalCatalog(String name, ExternalCatalog externalCatalog) {
        this.catalogManager.registerExternalCatalog(name, externalCatalog);
    }

    @Override
    public ExternalCatalog getRegisteredExternalCatalog(String name) {
        return this.catalogManager.getExternalCatalog(name).orElseThrow(() -> new CatalogNotExistException(name));
    }

    @Override
    public void registerCatalog(String catalogName, Catalog catalog) {
        this.catalogManager.registerCatalog(catalogName, catalog);
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return this.catalogManager.getCatalog(catalogName);
    }

    @Override
    public void registerFunction(String name, ScalarFunction function) {
        this.functionCatalog.registerScalarFunction(name, function);
    }

    @Override
    public void registerTable(String name, Table table) {
        if (((TableImpl)table).getTableEnvironment() != this) {
            throw new TableException("Only tables that belong to this TableEnvironment can be registered.");
        }
        QueryOperationCatalogView tableTable = new QueryOperationCatalogView(table.getQueryOperation());
        this.registerTableInternal(name, tableTable);
    }

    @Override
    public void registerTableSource(String name, TableSource<?> tableSource) {
        this.registerTableSourceInternal(name, tableSource);
    }

    @Override
    public void registerTableSink(String name, String[] fieldNames, TypeInformation<?>[] fieldTypes, TableSink<?> tableSink) {
        this.registerTableSink(name, tableSink.configure(fieldNames, fieldTypes));
    }

    @Override
    public void registerTableSink(String name, TableSink<?> configuredSink) {
        if (configuredSink.getTableSchema().getFieldCount() == 0) {
            throw new TableException("Table schema cannot be empty.");
        }
        this.checkValidTableName(name);
        this.registerTableSinkInternal(name, configuredSink);
    }

    @Override
    public Table scan(String ... tablePath) {
        return this.scanInternal(tablePath).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table '%s' was not found.", String.join((CharSequence)".", tablePath))));
    }

    private Optional<CatalogQueryOperation> scanInternal(String ... tablePath) {
        return this.catalogManager.resolveTable(tablePath).map(t -> new CatalogQueryOperation(t.getTablePath(), t.getTableSchema()));
    }

    @Override
    public ConnectTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return new StreamTableDescriptor(this, connectorDescriptor);
    }

    @Override
    public String[] listCatalogs() {
        return this.catalogManager.getCatalogs().toArray(new String[0]);
    }

    @Override
    public String[] listDatabases() {
        return this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get().listDatabases().toArray(new String[0]);
    }

    @Override
    public String[] listTables() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        Optional<Catalog> currentCatalog = this.catalogManager.getCatalog(currentCatalogName);
        return currentCatalog.map(catalog -> {
            try {
                return catalog.listTables(this.catalogManager.getCurrentDatabase()).toArray(new String[0]);
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException("Current database does not exist", e);
            }
        }).orElseThrow(() -> new TableException(String.format("The current catalog %s does not exist.", currentCatalogName)));
    }

    @Override
    public String[] listUserDefinedFunctions() {
        return this.functionCatalog.getUserDefinedFunctions();
    }

    @Override
    public String explain(Table table) {
        return this.explain(table, false);
    }

    @Override
    public String explain(Table table, boolean extended) {
        return this.planner.explain(Collections.singletonList(table.getQueryOperation()), extended);
    }

    @Override
    public String explain(boolean extended) {
        List<Operation> operations = this.bufferedModifyOperations.stream().map(o -> o).collect(Collectors.toList());
        return this.planner.explain(operations, extended);
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        return this.planner.getCompletionHints(statement, position);
    }

    @Override
    public Table sqlQuery(String query) {
        List<Operation> operations = this.planner.parse(query);
        if (operations.size() != 1) {
            throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query.");
        }
        Operation operation = operations.get(0);
        if (operation instanceof QueryOperation && !(operation instanceof ModifyOperation)) {
            return this.createTable((QueryOperation)operation);
        }
        throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, and ORDER_BY.");
    }

    @Override
    public void insertInto(Table table, String path, String ... pathContinued) {
        ArrayList<String> fullPath = new ArrayList<String>(Arrays.asList(pathContinued));
        fullPath.add(0, path);
        List<ModifyOperation> modifyOperations = Collections.singletonList(new CatalogSinkModifyOperation(fullPath, table.getQueryOperation()));
        if (this.isEagerOperationTranslation()) {
            this.translate(modifyOperations);
        } else {
            this.buffer(modifyOperations);
        }
    }

    @Override
    public void sqlUpdate(String stmt) {
        List<Operation> operations = this.planner.parse(stmt);
        if (operations.size() != 1) {
            throw new TableException("Unsupported SQL query! sqlUpdate() only accepts a single SQL statement of type INSERT, CREATE TABLE, DROP TABLE");
        }
        Operation operation = operations.get(0);
        if (operation instanceof ModifyOperation) {
            List<ModifyOperation> modifyOperations = Collections.singletonList((ModifyOperation)operation);
            if (this.isEagerOperationTranslation()) {
                this.translate(modifyOperations);
            } else {
                this.buffer(modifyOperations);
            }
        } else if (operation instanceof CreateTableOperation) {
            CreateTableOperation createTableOperation = (CreateTableOperation)operation;
            this.registerCatalogTableInternal(createTableOperation.getTablePath(), createTableOperation.getCatalogTable(), createTableOperation.isIgnoreIfExists());
        } else if (operation instanceof DropTableOperation) {
            String[] name = ((DropTableOperation)operation).getTableName();
            boolean isIfExists = ((DropTableOperation)operation).isIfExists();
            String[] paths = this.catalogManager.getFullTablePath(Arrays.asList(name));
            Optional<Catalog> catalog = this.getCatalog(paths[0]);
            if (!catalog.isPresent()) {
                if (!isIfExists) {
                    throw new TableException("Catalog " + paths[0] + " does not exist.");
                }
            } else {
                try {
                    catalog.get().dropTable(new ObjectPath(paths[1], paths[2]), isIfExists);
                }
                catch (TableNotExistException e) {
                    throw new TableException(e.getMessage());
                }
            }
        } else {
            throw new TableException("Unsupported SQL query! sqlUpdate() only accepts a single SQL statements of type INSERT, CREATE TABLE, DROP TABLE");
        }
    }

    @Override
    public String getCurrentCatalog() {
        return this.catalogManager.getCurrentCatalog();
    }

    @Override
    public void useCatalog(String catalogName) {
        this.catalogManager.setCurrentCatalog(catalogName);
    }

    @Override
    public String getCurrentDatabase() {
        return this.catalogManager.getCurrentDatabase();
    }

    @Override
    public void useDatabase(String databaseName) {
        this.catalogManager.setCurrentDatabase(databaseName);
    }

    @Override
    public TableConfig getConfig() {
        return this.tableConfig;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        this.translate(this.bufferedModifyOperations);
        this.bufferedModifyOperations.clear();
        return this.execEnv.execute(jobName);
    }

    protected boolean isEagerOperationTranslation() {
        return false;
    }

    protected void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource);
    }

    private void translate(List<ModifyOperation> modifyOperations) {
        List<Transformation<?>> transformations = this.planner.translate(modifyOperations);
        this.execEnv.apply(transformations);
    }

    private void buffer(List<ModifyOperation> modifyOperations) {
        this.bufferedModifyOperations.addAll(modifyOperations);
    }

    private void registerCatalogTableInternal(String[] path, CatalogBaseTable catalogTable, boolean ignoreIfExists) {
        String[] fullName = this.catalogManager.getFullTablePath(Arrays.asList(path));
        Catalog catalog = this.getCatalog(fullName[0]).orElseThrow(() -> new TableException("Catalog " + fullName[0] + " does not exist"));
        ObjectPath objectPath = new ObjectPath(fullName[1], fullName[2]);
        try {
            catalog.createTable(objectPath, catalogTable, ignoreIfExists);
        }
        catch (Exception e) {
            throw new TableException("Could not register table", e);
        }
    }

    protected void registerTableInternal(String name, CatalogBaseTable table) {
        try {
            this.checkValidTableName(name);
            ObjectPath path = new ObjectPath(this.catalogManager.getBuiltInDatabaseName(), name);
            Optional<Catalog> catalog = this.catalogManager.getCatalog(this.catalogManager.getBuiltInCatalogName());
            if (catalog.isPresent()) {
                catalog.get().createTable(path, table, false);
            }
        }
        catch (Exception e) {
            throw new TableException("Could not register table", e);
        }
    }

    private void replaceTableInternal(String name, CatalogBaseTable table) {
        try {
            ObjectPath path = new ObjectPath(this.catalogManager.getBuiltInDatabaseName(), name);
            Optional<Catalog> catalog = this.catalogManager.getCatalog(this.catalogManager.getBuiltInCatalogName());
            if (catalog.isPresent()) {
                catalog.get().alterTable(path, table, false);
            }
        }
        catch (Exception e) {
            throw new TableException("Could not register table", e);
        }
    }

    private void checkValidTableName(String name) {
        if (StringUtils.isNullOrWhitespaceOnly((String)name)) {
            throw new ValidationException("A table name cannot be null or consist of only whitespaces.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerTableSourceInternal(String name, TableSource<?> tableSource) {
        this.validateTableSource(tableSource);
        Optional<CatalogBaseTable> table = this.getCatalogTable(this.catalogManager.getBuiltInCatalogName(), this.catalogManager.getBuiltInDatabaseName(), name);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSource().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            this.replaceTableInternal(name, ConnectorCatalogTable.sourceAndSink(tableSource, sourceSinkTable.getTableSink().get(), false));
            return;
        } else {
            this.registerTableInternal(name, ConnectorCatalogTable.source(tableSource, false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerTableSinkInternal(String name, TableSink<?> tableSink) {
        Optional<CatalogBaseTable> table = this.getCatalogTable(this.catalogManager.getBuiltInCatalogName(), this.catalogManager.getBuiltInDatabaseName(), name);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSink().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            this.replaceTableInternal(name, ConnectorCatalogTable.sourceAndSink(sourceSinkTable.getTableSource().get(), tableSink, false));
            return;
        } else {
            this.registerTableInternal(name, ConnectorCatalogTable.sink(tableSink, false));
        }
    }

    private Optional<CatalogBaseTable> getCatalogTable(String ... name) {
        return this.catalogManager.resolveTable(name).flatMap(CatalogManager.ResolvedTable::getCatalogTable);
    }

    protected TableImpl createTable(QueryOperation tableOperation) {
        return TableImpl.createTable(this, tableOperation, this.operationTreeBuilder, this.functionCatalog);
    }
}

