/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.network;

import java.nio.channels.SelectionKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka011.org.apache.kafka.common.network.ChannelBuilder;
import shaded.alink.kafka011.org.apache.kafka.common.network.ChannelBuilders;
import shaded.alink.kafka011.org.apache.kafka.common.network.DefaultAuthenticator;
import shaded.alink.kafka011.org.apache.kafka.common.network.KafkaChannel;
import shaded.alink.kafka011.org.apache.kafka.common.network.PlaintextTransportLayer;
import shaded.alink.kafka011.org.apache.kafka.common.security.auth.PrincipalBuilder;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private PrincipalBuilder principalBuilder;
    private Map<String, ?> configs;

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            PlaintextTransportLayer transportLayer = new PlaintextTransportLayer(key);
            DefaultAuthenticator authenticator = new DefaultAuthenticator();
            authenticator.configure(transportLayer, this.principalBuilder, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        this.principalBuilder.close();
    }
}

