/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import shaded.alink.kafka011.org.apache.kafka.common.Cluster;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;

public abstract class AbstractPartitionAssignor
implements PartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionAssignor.class);

    public abstract Map<String, List<TopicPartition>> assign(Map<String, Integer> var1, Map<String, PartitionAssignor.Subscription> var2);

    @Override
    public PartitionAssignor.Subscription subscription(Set<String> topics) {
        return new PartitionAssignor.Subscription(new ArrayList<String>(topics));
    }

    @Override
    public Map<String, PartitionAssignor.Assignment> assign(Cluster metadata, Map<String, PartitionAssignor.Subscription> subscriptions) {
        HashSet<String> allSubscribedTopics = new HashSet<String>();
        for (Map.Entry<String, PartitionAssignor.Subscription> subscriptionEntry : subscriptions.entrySet()) {
            allSubscribedTopics.addAll(subscriptionEntry.getValue().topics());
        }
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (String topic : allSubscribedTopics) {
            Integer numPartitions = metadata.partitionCountForTopic(topic);
            if (numPartitions != null && numPartitions > 0) {
                partitionsPerTopic.put(topic, numPartitions);
                continue;
            }
            log.debug("Skipping assignment for topic {} since no metadata is available", (Object)topic);
        }
        Map<String, List<TopicPartition>> rawAssignments = this.assign(partitionsPerTopic, subscriptions);
        HashMap<String, PartitionAssignor.Assignment> assignments = new HashMap<String, PartitionAssignor.Assignment>();
        for (Map.Entry<String, List<TopicPartition>> assignmentEntry : rawAssignments.entrySet()) {
            assignments.put(assignmentEntry.getKey(), new PartitionAssignor.Assignment(assignmentEntry.getValue()));
        }
        return assignments;
    }

    @Override
    public void onAssignment(PartitionAssignor.Assignment assignment) {
    }

    protected static <K, V> void put(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    protected static List<TopicPartition> partitions(String topic, int numPartitions) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(new TopicPartition(topic, i));
        }
        return partitions;
    }
}

