/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import shaded.alink.kafka011.org.apache.kafka.clients.ClientRequest;
import shaded.alink.kafka011.org.apache.kafka.clients.ClientResponse;
import shaded.alink.kafka011.org.apache.kafka.clients.KafkaClient;
import shaded.alink.kafka011.org.apache.kafka.common.Node;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Time;

public class NetworkClientUtils {
    public static boolean isReady(KafkaClient client, Node node, long currentTime) {
        client.poll(0L, currentTime);
        return client.isReady(node, currentTime);
    }

    public static boolean awaitReady(KafkaClient client, Node node, Time time, long timeoutMs) throws IOException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Timeout needs to be greater than 0");
        }
        long startTime = time.milliseconds();
        long expiryTime = startTime + timeoutMs;
        if (NetworkClientUtils.isReady(client, node, startTime) || client.ready(node, startTime)) {
            return true;
        }
        long attemptStartTime = time.milliseconds();
        while (!client.isReady(node, attemptStartTime) && attemptStartTime < expiryTime) {
            if (client.connectionFailed(node)) {
                throw new IOException("Connection to " + node + " failed.");
            }
            long pollTimeout = expiryTime - attemptStartTime;
            client.poll(pollTimeout, attemptStartTime);
            attemptStartTime = time.milliseconds();
        }
        return client.isReady(node, attemptStartTime);
    }

    public static ClientResponse sendAndReceive(KafkaClient client, ClientRequest request, Time time) throws IOException {
        ClientResponse response;
        client.send(request, time.milliseconds());
        block0: while (true) {
            List<ClientResponse> responses = client.poll(Long.MAX_VALUE, time.milliseconds());
            Iterator<ClientResponse> i$ = responses.iterator();
            do {
                if (!i$.hasNext()) continue block0;
            } while ((response = i$.next()).requestHeader().correlationId() != request.correlationId());
            break;
        }
        if (response.wasDisconnected()) {
            throw new IOException("Connection to " + response.destination() + " was disconnected before the response was read");
        }
        if (response.versionMismatch() != null) {
            throw response.versionMismatch();
        }
        return response;
    }
}

