/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka010.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka010.org.apache.kafka.common.security.JaasUtils;
import shaded.alink.kafka010.org.apache.kafka.common.security.authenticator.AbstractLogin;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Shell;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Time;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public class KerberosLogin
extends AbstractLogin {
    private static final Logger log = LoggerFactory.getLogger(KerberosLogin.class);
    private static final Random RNG = new Random();
    private final Time time = Time.SYSTEM;
    private Thread t;
    private boolean isKrbTicket;
    private boolean isUsingTicketCache;
    private String loginContextName;
    private String principal;
    private double ticketRenewWindowFactor;
    private double ticketRenewJitter;
    private long minTimeBeforeRelogin;
    private String kinitCmd;
    private volatile Subject subject;
    private LoginContext loginContext;
    private String serviceName;
    private long lastLogin;

    @Override
    public void configure(Map<String, ?> configs, Configuration jaasConfig, String loginContextName) {
        super.configure(configs, jaasConfig, loginContextName);
        this.loginContextName = loginContextName;
        this.ticketRenewWindowFactor = (Double)configs.get("sasl.kerberos.ticket.renew.window.factor");
        this.ticketRenewJitter = (Double)configs.get("sasl.kerberos.ticket.renew.jitter");
        this.minTimeBeforeRelogin = (Long)configs.get("sasl.kerberos.min.time.before.relogin");
        this.kinitCmd = (String)configs.get("sasl.kerberos.kinit.cmd");
        this.serviceName = this.getServiceName(jaasConfig, configs, loginContextName);
    }

    @Override
    public LoginContext login() throws LoginException {
        this.lastLogin = this.currentElapsedTime();
        this.loginContext = super.login();
        this.subject = this.loginContext.getSubject();
        this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        AppConfigurationEntry[] entries = this.jaasConfig().getAppConfigurationEntry(this.loginContextName);
        if (entries.length == 0) {
            this.isUsingTicketCache = false;
            this.principal = null;
        } else {
            AppConfigurationEntry entry = entries[0];
            if (entry.getOptions().get("useTicketCache") != null) {
                String val = (String)entry.getOptions().get("useTicketCache");
                this.isUsingTicketCache = val.equals("true");
            } else {
                this.isUsingTicketCache = false;
            }
            this.principal = entry.getOptions().get("principal") != null ? (String)entry.getOptions().get("principal") : null;
        }
        if (!this.isKrbTicket) {
            log.debug("[Principal={}]: It is not a Kerberos ticket", (Object)this.principal);
            this.t = null;
            return this.loginContext;
        }
        log.debug("[Principal={}]: It is a Kerberos ticket", (Object)this.principal);
        this.t = Utils.newThread(String.format("kafka-kerberos-refresh-thread-%s", this.principal), new Runnable(){

            @Override
            public void run() {
                log.info("[Principal={}]: TGT refresh thread started.", (Object)KerberosLogin.this.principal);
                block12: while (true) {
                    Date nextRefreshDate;
                    long nextRefresh;
                    KerberosTicket tgt = KerberosLogin.this.getTGT();
                    long now = KerberosLogin.this.currentWallTime();
                    if (tgt == null) {
                        nextRefresh = now + KerberosLogin.this.minTimeBeforeRelogin;
                        nextRefreshDate = new Date(nextRefresh);
                        log.warn("[Principal={}]: No TGT found: will try again at {}", (Object)KerberosLogin.this.principal, (Object)nextRefreshDate);
                    } else {
                        nextRefresh = KerberosLogin.this.getRefreshTime(tgt);
                        long expiry = tgt.getEndTime().getTime();
                        Date expiryDate = new Date(expiry);
                        if (KerberosLogin.this.isUsingTicketCache && tgt.getRenewTill() != null && tgt.getRenewTill().getTime() < expiry) {
                            log.warn("The TGT cannot be renewed beyond the next expiry date: {}.This process will not be able to authenticate new SASL connections after that time (for example, it will not be able to authenticate a new connection with a Kafka Broker).  Ask your system administrator to either increase the 'renew until' time by doing : 'modprinc -maxrenewlife {} ' within kadmin, or instead, to generate a keytab for {}. Because the TGT's expiry cannot be further extended by refreshing, exiting refresh thread now.", expiryDate, KerberosLogin.this.principal, KerberosLogin.this.principal);
                            return;
                        }
                        if (nextRefresh > expiry || now + KerberosLogin.this.minTimeBeforeRelogin > expiry) {
                            log.info("[Principal={}]: Refreshing now because expiry is before next scheduled refresh time.", (Object)KerberosLogin.this.principal);
                            nextRefresh = now;
                        } else {
                            if (nextRefresh < now + KerberosLogin.this.minTimeBeforeRelogin) {
                                Date until = new Date(nextRefresh);
                                Date newUntil = new Date(now + KerberosLogin.this.minTimeBeforeRelogin);
                                log.warn("[Principal={}]: TGT refresh thread time adjusted from {} to {} since the former is sooner than the minimum refresh interval ({} seconds) from now.", KerberosLogin.this.principal, until, newUntil, KerberosLogin.this.minTimeBeforeRelogin / 1000L);
                            }
                            nextRefresh = Math.max(nextRefresh, now + KerberosLogin.this.minTimeBeforeRelogin);
                        }
                        nextRefreshDate = new Date(nextRefresh);
                        if (nextRefresh > expiry) {
                            log.error("[Principal={}]: Next refresh: {} is later than expiry {}. This may indicate a clock skew problem.Check that this host and the KDC hosts' clocks are in sync. Exiting refresh thread.", KerberosLogin.this.principal, nextRefreshDate, expiryDate);
                            return;
                        }
                    }
                    if (now < nextRefresh) {
                        Date until = new Date(nextRefresh);
                        log.info("[Principal={}]: TGT refresh sleeping until: {}", (Object)KerberosLogin.this.principal, (Object)until);
                        try {
                            Thread.sleep(nextRefresh - now);
                        }
                        catch (InterruptedException ie) {
                            log.warn("[Principal={}]: TGT renewal thread has been interrupted and will exit.", (Object)KerberosLogin.this.principal);
                            return;
                        }
                    } else {
                        log.error("[Principal={}]: NextRefresh: {} is in the past: exiting refresh thread. Check clock sync between this host and KDC - (KDC's clock is likely ahead of this host). Manual intervention will be required for this client to successfully authenticate. Exiting refresh thread.", (Object)KerberosLogin.this.principal, (Object)nextRefreshDate);
                        return;
                    }
                    if (KerberosLogin.this.isUsingTicketCache) {
                        String kinitArgs = "-R";
                        for (int retry = 1; retry >= 0; --retry) {
                            try {
                                log.debug("[Principal={}]: Running ticket cache refresh command: {} {}", KerberosLogin.this.principal, KerberosLogin.this.kinitCmd, kinitArgs);
                                Shell.execCommand(KerberosLogin.this.kinitCmd, kinitArgs);
                                break;
                            }
                            catch (Exception e) {
                                if (retry > 0) {
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException ie) {
                                        log.error("[Principal={}]: Interrupted while renewing TGT, exiting Login thread", (Object)KerberosLogin.this.principal);
                                        return;
                                    }
                                }
                                log.warn("[Principal={}]: Could not renew TGT due to problem running shell command: '{} {}'; exception was: %s. Exiting refresh thread.", KerberosLogin.this.principal, KerberosLogin.this.kinitCmd, kinitArgs, e, e);
                                return;
                            }
                        }
                    }
                    try {
                        int retry = 1;
                        while (true) {
                            if (retry < 0) continue block12;
                            try {
                                KerberosLogin.this.reLogin();
                                continue block12;
                            }
                            catch (LoginException le) {
                                if (retry > 0) {
                                    --retry;
                                    try {
                                        Thread.sleep(10000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        log.error("[Principal={}]: Interrupted during login retry after LoginException:", (Object)KerberosLogin.this.principal, (Object)le);
                                        throw le;
                                    }
                                }
                                log.error("[Principal={}]: Could not refresh TGT.", (Object)KerberosLogin.this.principal, (Object)le);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (LoginException le) {
                        log.error("[Principal={}]: Failed to refresh TGT: refresh thread exiting now.", (Object)KerberosLogin.this.principal, (Object)le);
                        return;
                    }
                }
            }
        }, true);
        this.t.start();
        return this.loginContext;
    }

    @Override
    public void close() {
        if (this.t != null && this.t.isAlive()) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                log.warn("[Principal={}]: Error while waiting for Login thread to shutdown.", (Object)this.principal, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public Subject subject() {
        return this.subject;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    private String getServiceName(Configuration jaasConfig, Map<String, ?> configs, String loginContext) {
        String jaasServiceName;
        try {
            jaasServiceName = JaasUtils.jaasConfigOption(jaasConfig, loginContext, "serviceName", null);
        }
        catch (IOException e) {
            throw new KafkaException("JAAS configuration entry not found", e);
        }
        String configServiceName = (String)configs.get("sasl.kerberos.service.name");
        if (jaasServiceName != null && configServiceName != null && !jaasServiceName.equals(configServiceName)) {
            String message = String.format("Conflicting serviceName values found in JAAS and Kafka configs value in JAAS file %s, value in Kafka config %s", jaasServiceName, configServiceName);
            throw new IllegalArgumentException(message);
        }
        if (jaasServiceName != null) {
            return jaasServiceName;
        }
        if (configServiceName != null) {
            return configServiceName;
        }
        throw new IllegalArgumentException("No serviceName defined in either JAAS or Kafka config");
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long expires = tgt.getEndTime().getTime();
        log.info("[Principal={}]: TGT valid starting at: {}", (Object)this.principal, (Object)tgt.getStartTime());
        log.info("[Principal={}]: TGT expires: {}", (Object)this.principal, (Object)tgt.getEndTime());
        long proposedRefresh = start + (long)((double)(expires - start) * (this.ticketRenewWindowFactor + this.ticketRenewJitter * RNG.nextDouble()));
        if (proposedRefresh > expires) {
            return this.currentWallTime();
        }
        return proposedRefresh;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            log.debug("Found TGT with client principal '{}' and server principal '{}'.", (Object)ticket.getClient().getName(), (Object)ticket.getServer().getName());
            return ticket;
        }
        return null;
    }

    private boolean hasSufficientTimeElapsed() {
        long now = this.currentElapsedTime();
        if (now - this.lastLogin < this.minTimeBeforeRelogin) {
            log.warn("[Principal={}]: Not attempting to re-login since the last re-login was attempted less than {} seconds before.", (Object)this.principal, (Object)(this.minTimeBeforeRelogin / 1000L));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reLogin() throws LoginException {
        if (!this.isKrbTicket) {
            return;
        }
        if (this.loginContext == null) {
            throw new LoginException("Login must be done first");
        }
        if (!this.hasSufficientTimeElapsed()) {
            return;
        }
        log.info("Initiating logout for {}", (Object)this.principal);
        Class<KerberosLogin> clazz = KerberosLogin.class;
        synchronized (KerberosLogin.class) {
            this.lastLogin = this.currentElapsedTime();
            this.loginContext.logout();
            this.loginContext = new LoginContext(this.loginContextName, this.subject, null, this.jaasConfig());
            log.info("Initiating re-login for {}", (Object)this.principal);
            this.loginContext.login();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private long currentElapsedTime() {
        return this.time.hiResClockMs();
    }

    private long currentWallTime() {
        return this.time.milliseconds();
    }
}

